#!/usr/bin/env python

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#MyIpScreenlet (c) Whise <helder.fraga@hotmail.com>

import screenlets
from screenlets.options import FloatOption, BoolOption, StringOption, FontOption, ColorOption, IntOption
from screenlets import DefaultMenuItem
import cairo
import pango
import gobject
from urllib import urlopen
from screenlets import Plugins
proxy = Plugins.importAPI('Proxy')


#use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc
class MyIpScreenlet(screenlets.Screenlet):
	"""A Screenlet that displays Internet Ip"""
	
	# default meta-info for Screenlets
	__name__ = 'MyIpScreenlet'
	__version__ = '0.3.1'
	__author__ = 'Helder Fraga aka Whise (c) 2007'
	__desc__ = __doc__

	font_color = (1,1,1, 0.8)
	background_color = (0,0,0, 0.8)
	myip = ""
	def __init__(self, **keyword_args):
		screenlets.Screenlet.__init__(self, width=200, height=50,uses_theme=True, **keyword_args) 

		self.theme_name = "default"
		self.add_default_menuitems(DefaultMenuItem.XML)
                self.add_options_group(_('Options'),
                        _('The Options widget settings'))


		self.add_option(ColorOption(_('Options'),'font_color', 
			self.font_color, _('Text color'), 'font_color'))
		self.add_option(ColorOption(_('Options'),'background_color', 
			self.background_color, _('Back color(only with default theme)'), 'only works with default theme'))
	
		self.gen()
		self.__timeout = gobject.timeout_add(24 * 60 * 60 * 1000, self.update)

	def __setattr__(self, name, value):
		# call Screenlet.__setattr__ in baseclass (ESSENTIAL!!!!)
		screenlets.Screenlet.__setattr__(self, name, value)

	def on_init (self):
		print "Screenlet has been initialized."
		# add default menuitems
		self.add_default_menuitems()

	def update (self):
		self.gen()
		self.redraw_canvas()
		return True # keep running this event	

		

	def gen(self):
		try:
			proxies = proxy.Proxy().get_proxy()
			self.myip = str(urlopen("http://www.whatismyip.com/automation/n09230945.asp",proxies=proxies).read())

		except:
			from screenlets import sensors
			self.myip = str(sensors.net_get_ip())

	def on_draw(self, ctx):
		ctx.scale(self.scale, self.scale)
		ctx.set_operator(cairo.OPERATOR_OVER)
		if self.theme:
			self.theme.render(ctx,'background')

			ctx.set_source_rgba(*self.background_color)
			if self.theme_name == 'default':self.draw_rounded_rectangle(ctx,0,0,6,200,40)
			ctx.set_source_rgba(1, 1, 1, 1)
			ctx.set_source_rgba(*self.font_color)
                        text = 'IP - ' + self.myip
			size = 16
			while self.get_text_line_count(ctx,text,'FreeSans',size) > 1:
				size = size - 1

			self.draw_text(ctx,'IP - ' + self.myip,0,10, 'FreeSans',16, self.width,allignment = pango.ALIGN_CENTER)
			try:self.theme.render(ctx,'glass')
			except:pass

	def on_menuitem_select (self, id):
		"""handle MenuItem-events in right-click menu"""
		if id[:4] == "upda":
			self.gen()
			# TODO: use DBus-call for this
			#self.switch_hide_show()
			self.redraw_canvas()

	def on_draw_shape(self,ctx):
		ctx.rectangle(0,0,self.width,self.height)
		ctx.fill()
		self.on_draw(ctx)

if __name__ == "__main__":
	import screenlets.session
	screenlets.session.create_session(MyIpScreenlet)
