#include <xmms/plugin.h>
#include <xmms/configfile.h>

#include <SDL/SDL.h>
#include <SDL/SDL_thread.h>
#include <gtk/gtk.h>

#include "main.h"
#include "renderer.h"

int finished;
SDL_Thread *thread;
SDL_mutex  *synchro_mutex,*access_mutex;
short pcm_data[2][512];
static GtkWidget *configure_win = NULL;
t_config config={320,240,1,100,100};


VisPlugin *get_vplugin_info(void);
static void plug_init(void);
static void plug_cleanup(void);
static void plug_render_pcm(short data[2][512]);
static void plug_abort(void);
static void plug_configure(void);
static void plug_about(void);
static void ok_clicked(GtkWidget *w, GtkWidget *window);
static void adj_value_changed(GtkWidget *w, int *a);
static void about_closed(GtkWidget *w, GdkEvent *e, GtkWidget **window);
static void about_close_clicked(GtkWidget *w, GtkWidget **window);
static void plug_save_prefs(void);
static void plug_load_prefs(void);
static gboolean check_cfg_version(ConfigFile *f);    
static void ok_clicked(GtkWidget *w, GtkWidget *window);
static void cancel_clicked(GtkWidget *w, GtkWidget *window);
static void apply_clicked(GtkWidget *w, GtkWidget *window);


VisPlugin sdlblur_vp = {
	NULL,
	NULL,
	0, /* XMMS Session ID, filled in by XMMS */
	"Infinity", /* description */
	2, /* Number of PCM channels wanted */
	0, /* Number of freq channels wanted */
	plug_init, /* init */
	plug_cleanup, /* cleanup */
	plug_about, /* about */
	plug_configure, /* configure */
	NULL, /* disable_plugin */
	NULL, /* playback_start */
	NULL, /* playback_stop */
	plug_render_pcm, /* render_pcm */
	NULL,//plug_render_freq  /* render_freq */
};

VisPlugin *get_vplugin_info(void)
{
	return &sdlblur_vp;
}

static void plug_init(void)
{
    finished=FALSE;
    access_mutex=SDL_CreateMutex();
    plug_load_prefs();
    init_renderer();
    thread=SDL_CreateThread((void *) renderer,NULL);
}

static void plug_cleanup(void)
{
    SDL_mutexP(access_mutex);
    finished=TRUE; 
    SDL_mutexV(access_mutex);
    SDL_WaitThread(thread,NULL);
    close_renderer();
}

static void plug_render_pcm(short data[2][512])
{
	int i,j;
	
	SDL_mutexP(access_mutex);

	memcpy(pcm_data,data,2048);
	SDL_mutexV(access_mutex);
}

void plug_abort(void)
{
	sdlblur_vp.disable_plugin(&sdlblur_vp);
	finished=TRUE;
}

void plug_configure(void)
{
	GtkWidget *buttonbox,*ok,*cancel;
	static GtkWidget *vbox,*vbox2;
      
	GtkObject *xadj,*yadj,*sadj,*teadj,*tcadj;
	GtkWidget *label,*xhscale,*yhscale,*shscale;
	static GtkWidget *hbox,*frame;
	
	
        if(configure_win)
                return;

	plug_load_prefs();
	
        configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_set_usize(configure_win, 558, 280);

        gtk_container_set_border_width(GTK_CONTAINER(configure_win), 10);
        gtk_window_set_title(GTK_WINDOW(configure_win), "Infinity Configuration");
        gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
        gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
	gtk_signal_connect(GTK_OBJECT(configure_win), "destroy", 
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);

	vbox = gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(configure_win),vbox);

	frame = gtk_frame_new("Display:");
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,4);

	vbox2 = gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	
	hbox = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,TRUE,TRUE,4);

	label = gtk_label_new("X Resolution");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,4);
	gtk_widget_show(label);

	xadj=gtk_adjustment_new(config.xres, 0, 800, 160, 320, 0);
	xhscale=gtk_hscale_new(GTK_ADJUSTMENT(xadj));
	gtk_scale_set_draw_value(GTK_SCALE(xhscale), TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(xhscale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(xhscale), 0);
	gtk_widget_show(xhscale);
	gtk_box_pack_start(GTK_BOX(hbox), xhscale, TRUE, TRUE, 4);

	gtk_widget_show(hbox);

	hbox = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,TRUE,TRUE,4);

	label = gtk_label_new("Y Resolution");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,4);
	gtk_widget_show(label);

	yadj=gtk_adjustment_new(config.yres, 0, 600, 120, 240, 0);
	yhscale=gtk_hscale_new(GTK_ADJUSTMENT(yadj));
	gtk_scale_set_draw_value(GTK_SCALE(yhscale), TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(yhscale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(yhscale), 0);
	gtk_widget_show(yhscale);
	gtk_box_pack_start(GTK_BOX(hbox), yhscale, TRUE, TRUE, 4);
	
	gtk_widget_show(hbox);
	    
	hbox=gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,TRUE,TRUE,4);
	
	label=gtk_label_new("Scale Factor (Change it only if you cannot obtain low resolutions):");
	gtk_widget_show(label);		
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,FALSE, 4);
	
	sadj=gtk_adjustment_new(config.sres, 1, 2, 10, 20, 0);
	shscale=gtk_hscale_new(GTK_ADJUSTMENT(sadj));
	gtk_scale_set_draw_value(GTK_SCALE(shscale), TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(shscale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(shscale), 0);
	gtk_widget_show(shscale);
	gtk_box_pack_start(GTK_BOX(hbox), shscale, TRUE, TRUE, 4);

	gtk_signal_connect(GTK_OBJECT(xadj), "value-changed", 
			   GTK_SIGNAL_FUNC(adj_value_changed), &config.xres);
	gtk_signal_connect(GTK_OBJECT(yadj), "value-changed", 
			   GTK_SIGNAL_FUNC(adj_value_changed), &config.yres);	
	gtk_signal_connect(GTK_OBJECT(sadj), "value-changed", 
			   GTK_SIGNAL_FUNC(adj_value_changed), &config.sres);	
	
	gtk_widget_show(hbox);
	
	gtk_widget_show(vbox2);

	gtk_widget_show(frame);
	
	frame = gtk_frame_new("General:");
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,4);

	vbox2 = gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	
	hbox = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,TRUE,TRUE,4);

	label = gtk_label_new("Effect period:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,4);
	gtk_widget_show(label);

	teadj=gtk_adjustment_new(config.teff, 50, 400, 100, 100, 0);
	xhscale=gtk_hscale_new(GTK_ADJUSTMENT(teadj));
	gtk_scale_set_draw_value(GTK_SCALE(xhscale), TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(xhscale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(xhscale), 0);
	gtk_widget_show(xhscale);
	gtk_box_pack_start(GTK_BOX(hbox), xhscale, TRUE, TRUE, 4);

	gtk_widget_show(hbox);

	hbox = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,TRUE,TRUE,4);

	label = gtk_label_new("Palette period:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,4);
	gtk_widget_show(label);

	tcadj=gtk_adjustment_new(config.tcol, 50, 400, 100, 100, 0);
	yhscale=gtk_hscale_new(GTK_ADJUSTMENT(tcadj));
	gtk_scale_set_draw_value(GTK_SCALE(yhscale), TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(yhscale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(yhscale), 0);
	gtk_widget_show(yhscale);
	gtk_box_pack_start(GTK_BOX(hbox), yhscale, TRUE, TRUE, 4);

	gtk_signal_connect(GTK_OBJECT(teadj), "value-changed", 
			   GTK_SIGNAL_FUNC(adj_value_changed), &config.teff);
	gtk_signal_connect(GTK_OBJECT(tcadj), "value-changed", 
			   GTK_SIGNAL_FUNC(adj_value_changed), &config.tcol);	
		
		
	gtk_widget_show(hbox);
	    
	gtk_widget_show(vbox2);

	gtk_widget_show(frame);

	buttonbox=gtk_hbutton_box_new();
	gtk_box_pack_end(GTK_BOX(vbox), buttonbox, FALSE, FALSE, 8);
	gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
	gtk_widget_show(buttonbox);
	
	ok=gtk_button_new_with_label("Ok");
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_box_pack_end(GTK_BOX(buttonbox), ok, FALSE, FALSE, 8);
	gtk_widget_show(ok);

	cancel=gtk_button_new_with_label("Cancel");
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_end(GTK_BOX(buttonbox), cancel, FALSE, FALSE, 8);
	gtk_widget_show(cancel);
	
	gtk_widget_show(vbox);

	gtk_window_set_default(GTK_WINDOW(configure_win), ok);
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(cancel_clicked), configure_win);
	gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(ok_clicked), configure_win);
	
	gtk_widget_show(configure_win);


}

static void plug_about(void)
{
	static GtkWidget *window=NULL;
	GtkWidget *vbox, *buttonbox, *close, *label;

	if(window)
		return;

	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), NULL);
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);

	vbox=gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 8);
	gtk_widget_show(vbox);

	label=gtk_label_new("\n\
Infinity. v 0.2 \n\
Copyright (C) 2000, Julien Carme.\n\
\n\
Email: <julien.carme@acm.org> \n\
This program is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307\n\
USA");
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 8);
	gtk_widget_show(label);
	
	buttonbox=gtk_hbutton_box_new();
	gtk_box_pack_end(GTK_BOX(vbox), buttonbox, FALSE, FALSE,8);
	gtk_widget_show(buttonbox);
	
	close=gtk_button_new_with_label("Close");
	GTK_WIDGET_SET_FLAGS(close, GTK_CAN_DEFAULT);
	gtk_window_set_default(GTK_WINDOW(window), close);
	gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
	gtk_box_pack_end(GTK_BOX(buttonbox), close, FALSE, FALSE,8);
	gtk_widget_show(close);
	
	gtk_signal_connect(GTK_OBJECT(close), "clicked", GTK_SIGNAL_FUNC(about_close_clicked), &window);
	gtk_signal_connect(GTK_OBJECT(window), "delete-event", GTK_SIGNAL_FUNC(about_closed), &window);
		
	gtk_widget_show(window);

}


static void ok_clicked(GtkWidget *w, GtkWidget *window)
{
    plug_save_prefs();
    gtk_widget_destroy(window);
    configure_win=NULL;
}

static void adj_value_changed(GtkWidget *w, int *a)
{
	*a=(int) GTK_ADJUSTMENT(w)->value;
}

static void about_closed(GtkWidget *w, GdkEvent *e, GtkWidget **window)
{
	about_close_clicked(w,window);
}

static void about_close_clicked(GtkWidget *w, GtkWidget **window)
{
	gtk_widget_destroy(*window);
	*window=NULL;
}

void plug_save_prefs(void)
{
    char *name;
    ConfigFile *f;
    
    name=g_strdup_printf("%s%s",g_get_home_dir(), "/.xmms/config");
    
    if(!(f=xmms_cfg_open_file(name)))
	f=xmms_cfg_new();
    
    xmms_cfg_write_string(f, "infinity", "version", VERSION);	
    xmms_cfg_write_int(f, "infinity", "xres", config.xres);
    xmms_cfg_write_int(f, "infinity", "yres", config.yres);
    xmms_cfg_write_int(f, "infinity", "sres", config.sres);
    xmms_cfg_write_int(f, "infinity", "teff", config.teff);
    xmms_cfg_write_int(f, "infinity", "tcol", config.tcol);
    
    xmms_cfg_write_file(f, name);
    xmms_cfg_free(f);
    
    g_free(name);
}

void plug_load_prefs(void)
{
    char *name;
    ConfigFile *f;
    name=g_strdup_printf("%s%s",g_get_home_dir(), "/.xmms/config");

    if(f=xmms_cfg_open_file(name)) {
	if(check_cfg_version(f))
	{
	    xmms_cfg_read_int(f, "infinity", "xres", &config.xres);
	    xmms_cfg_read_int(f, "infinity", "yres", &config.yres);
	    xmms_cfg_read_int(f, "infinity", "sres", &config.sres);
	    xmms_cfg_read_int(f, "infinity", "teff", &config.teff);
	    xmms_cfg_read_int(f, "infinity", "tcol", &config.tcol);	    
	}
	xmms_cfg_free(f);
    }
    g_free(name);
}

static gboolean check_cfg_version(ConfigFile *f)
{
    char *vstr;
    
    if(xmms_cfg_read_string(f, "infinity", "version", &vstr))
	if(!strcmp(vstr, VERSION))
	    return TRUE;
    
    return FALSE;
}

static void apply_clicked(GtkWidget *w, GtkWidget *window)
{
	plug_save_prefs();
}

static void cancel_clicked(GtkWidget *w, GtkWidget *window)
{
	gtk_widget_destroy(window);
	configure_win=NULL;
}
