/***************************************************************************
                          i3dio.h  -  description
                             -------------------                                         
    begin                : Tue Oct 19 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef I3DIO_H
#define I3DIO_H

#include <vector>
#include <string>
#include <map>

#include <Plugins/fileplugin.h>

class Mesh;
class Line;
class Light;
class Bone;
class NurbsSurface;
class NurbsCurve;
class TextureMaterial;
class Entity;
class Spline;
class SubObject;
class Vertex;

/**I3DIO saves the modelling database to a file
that contains only static information.  No animation
channels are saved.
  *@author Jon Anderson
  */
enum {
    VERSION_006,
    VERSION_007,
    VERSION_008,
    VERSION_009,
    VERSION_010
};

class I3DIO : public FilePlugin {
public:
		void importData( ifstream & );
    void exportData( ofstream & );

    typedef map<string, Entity *, less<string> > EntityMap;
    typedef EntityMap::value_type EntityPair;

    typedef multimap<string, Entity *, less<string> > MultiEntityMap;
    typedef MultiEntityMap::value_type MultiEntityPair;

    typedef map<string, SubObject *, less<string> > SubObjectMap;
    typedef SubObjectMap::value_type SubObjectPair;

    typedef multimap<string, Bone *, less<string> > AffectedMap;
    typedef AffectedMap::value_type AffectedPair;


    I3DIO( );
    virtual ~I3DIO();

    void saveSurface(NurbsSurface *s, ofstream &out);
    void saveCurve(NurbsCurve *c, ofstream &out);
    void saveMesh(Mesh *o, ofstream &out);
    void saveLine(Spline *s, bool poly, ofstream &out);
    void saveLight(Light *l, ofstream &out);
    void saveBone(Bone *b, ofstream &out);
    void readMesh(ifstream &in );
    void readLine(bool poly,ifstream &in );
    void readLight(ifstream &in );
    void readCurve(ifstream &in );
    void readSurface(ifstream &in );
    void readBone(ifstream &in );

    void readMeta(Entity *,ifstream &in );
    void saveMeta(Entity *, ofstream &out );

protected:
    vector<TextureMaterial *> mats;

    EntityMap entity_map;

    MultiEntityMap entity_parentable;

    SubObjectMap subobject_map;

    AffectedMap affected_map;
		
		int version;

};



#endif







