/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/
#ifndef IGA_MODELS10_HPP
#define IGA_MODELS10_HPP

// ******************** DO NOT MODIFY DIRECTLY ********************
// Auto-generated by IGA project tools
#include "../Models.hpp"

namespace iga {
    static const iga::OpSpec MODEL_GEN10_OPSPECS[static_cast<unsigned int>(Op::TOTAL_OPS) + 1] = {
        /* Op::0 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::1 */ {Op::ADD, "add", "add", 0x40, "Addition",
            "The add instruction performs component-wise addition of src0 and src1 and stores the results in dst.\n"
            "Addition of two floating-point numbers follows rules in add (IEEE mode) or add (ALT mode).\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] add[.cmod] (exec_size) dst src0 src1\n"
            "\n"
            "\n"
            "Use a source modifier with add to implement subtraction.\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- UB,B,UW,W,UD,D
                {TYPE(Type::F),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // HF <- UB,B,UW,W,UD,D
                {TYPE(Type::HF),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)},
                // HF,F <- HF,F
                {TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::HF)|TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::2 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::3 */ {Op::ADDC, "addc", "addc", 0x4e, "Addition with Carry",
            "The addc instruction performs component-wise addition of src0 and src1 and stores the results in dst; it also stores the carry into acc.\n"
            "If the operation produces a carry out, 0x00000001 is stored in acc, else 0x00000000 is stored in acc.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] addc[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::4 */ {Op::AND, "and", "and", 0x5, "Logic And",
            "The and instruction performs component-wise logic AND operation between src0 and src1 and stores the results in dst.\n"
            "\n"
            "Register source operands can use source modifiers:\n"
            "\n"
            "[Pre-DevBDW]: Any source modifier is numeric, optionally changing a source value s to -s, abs(s), or -abs(s) before the AND operation.\n"
            "[DevBDW+]: Any source modifier is logical, optionally changing a source value s to ~s (inverting all source bits). This capability allows expressions like a AND (NOT b) to be calculated with one instruction.\n"
            "This operation does not produce sign or overflow conditions. Only the .e/.z or .ne/.nz conditional modifiers should be used.\n"
            "\n"
            "\n"
            "Format:\n"
            "Source modifier is not allowed if source is an accumulator.\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::5 */ {Op::ASR, "asr", "asr", 0xc, "Arithmetic Shift Right",
            "Perform component-wise arithmetic right shift of the bits in src0 by the shift count indicated in src1, storing the results in dst. If src0 has a signed type, insert copies of src0\'s sign bit in the number of MSBs indicated by the shift count. Otherwise insert 0 bits.\n"
            "\n"
            "[Pre-DevBDW]: The shift count is taken from the low five bits of src1, regardless of the src1 type and treated as an unsigned integer in the range 0 to 31.\n"
            "\n"
            "[DevBDW+]: In QWord mode, the shift count is taken from the low six bits of src1 regardless of the src1 type and treated as an unsigned integer in the range 0 to 63. Otherwise the shift count is taken from the low five bits of src1 regardless of the src1 type and treated as an unsigned integer in the range 0 to 31. The operation uses QWord mode if src0 or dst has the Q or UQ type but not if src1 is the only operand with the Q or UQ type.\n"
            "\n"
            "For positive values, this operation is src0 / 2shiftCount and for negative values, this operation is src0 / 2shiftCount - 1.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] asr[.cmod] (exec_size) dst src0 src1\n"
            "\n"
            "\n"
            "If src0 is -1, the result is -1 regardless of the shift count.\n"
            "\n"
            "\n"
            "For unsigned src0 types, asr and shr produce the same result.\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::6 */ {Op::AVG, "avg", "avg", 0x42, "Average",
            "The avg instruction performs component-wise integer average of src0 and src1 and stores the results in dst. An integer average uses integer upward rounding. It is equivalent to increment one to the addition of src0 and src1 and then apply an arithmetic right shift to this intermediate value.\n"
            "\n"
            "\n"
            "Format:\n"
            "The avg instruction performs component-wise integer average of src0 and src1 and stores the results in dst. An integer average uses integer upward rounding. It is equivalent to increment one to the addition of src0 and src1 and then apply an arithmetic right shift to this intermediate value.\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::7 */ {Op::BFE, "bfe", "bfe", 0x18, "Bit Field Extract",
            "Component-wise extract a bit field from src2 using the bit field width from src0 and the bit field offset from src1. Store the extracted bit field value in the low bits of dst and sign extend (if D type) or zero extend (if UD type).\n"
            "The width and offset values are from the low five bits of src0 and src1 respectively, or src0 & 0x1f and src1 & 0x1f.\n"
            "If width is zero, the result is zero.\n"
            "If offset + width > 32 then the extracted bit field is bits offset to 31 of src2, extracting only 32 - offset bits, less than width as the bit field cannot extend past the MSB of the source value. Otherwise extract width bits extending from bit positions offset to offset + width - 1.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] bfe (exec_size) dst src0 src1 src2\n",
            OpSpec::Format::TERNARY_REGIMM_REG_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::8 */ {Op::BFI1, "bfi1", "bfi1", 0x19, "Bit Field Insert 1",
            "The bfi1 instruction is the first instruction in a two-instruction macro for bfi (Bit Field Insert).\n"
            "\n"
            "The bfi1 instruction component-wise generates mask with control from src0 and src1 and stores the results in dst. The mask is used in the bfi2 instruction to generate the final result of bfi.\n"
            "\n"
            "Create a bit mask corresponding to the bit field width and offset in src0 and src1. Store the bit mask in dst. The mask has all bits in the bit field set to 1 and all other bits as 0.\n"
            "\n"
            "The width and offset values are from the low five bits of src0 and src1 respectively, or src0 & 0x1f and src1 & 0x1f.\n"
            "\n"
            "If width is zero, the result is zero.\n"
            "\n"
            "The bfi macro has four source operands: src0 - bit field width in low five bits, src1 - bit field offset/starting bit position in low five bits, src2 - bit field value to insert, using only the number of least significant bits given by width in src0, and src3 - overall value into which the bit field is inserted, providing all bits other than the inserted bits for the result value.\n"
            "\n"
            "bfi dst src0 src1 src2 src3\n"
            "\n"
            "// Translates to these two instructions:\n"
            "bfi1 dst src0 src1\n"
            "bfi2 dst dst src2 src3\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] bfi1 (exec_size) dst src0 src1\n"
            "\n"
            "\n"
            "No accumulator access, implicit or explicit.\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::9 */ {Op::BFI2, "bfi2", "bfi2", 0x1a, "Bit Field Insert 2",
            "The bfi2 instruction is the second instruction in a two-instruction macro for bfi (Bit Field Insert).\n"
            "\n"
            "The bfi2 instruction component-wise performs the bitfield insert operation on src1 and src2 based on the mask in src0.\n"
            "\n"
            "Use the mask in src0 to take a bit field value from the low bits of src1 and combine it with the value from src2 (so src2 provides all bits other than those masked out and replaced by the bit field value). Store the result in dst.\n"
            "\n"
            "The bfi macro has four source operands: src0 - bit field width in low five bits, src1 - bit field offset/starting bit position in low five bits, src2 - bit field value to insert, using only the number of least significant bits given by width in src0, and src3 - overall value into which the bit field is inserted, providing all bits other than the inserted bits for the result value.\n"
            "\n"
            "bfi dst src0 src1 src2 src3\n"
            "\n"
            "// Translates to these two instructions:\n"
            "bfi1 dst src0 src1\n"
            "bfi2 dst dst src2 src3\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] bfi2 (exec_size) dst src0 src1 src2\n",
            OpSpec::Format::TERNARY_REGIMM_REG_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::10 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::11 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::12 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::13 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::14 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::15 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::16 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::17 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::18 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::19 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::20 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::21 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::22 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::23 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::24 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::25 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::26 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::27 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::28 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::29 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::30 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::31 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::32 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::33 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::34 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::35 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::36 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::37 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::38 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::39 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::40 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::41 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::42 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::43 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::44 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::45 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::46 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::47 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::48 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::49 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::50 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::51 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::52 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::53 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::54 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::55 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::56 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::57 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::58 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::59 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::60 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::61 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::62 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::63 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::64 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::65 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::66 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::67 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::68 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::69 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::70 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::71 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::72 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::73 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::74 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::75 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::76 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::77 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::78 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::79 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::80 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::81 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::82 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::83 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::84 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::85 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::86 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::87 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::88 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::89 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::90 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::91 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::92 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::93 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::94 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::95 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::96 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::97 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::98 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::99 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::100 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::101 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::102 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::103 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::104 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::105 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::106 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::107 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::108 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::109 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::110 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::111 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::112 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::113 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::114 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::115 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::116 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::117 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::118 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::119 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::120 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::121 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::122 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::123 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::124 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::125 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::126 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::127 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::128 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::129 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::130 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::131 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::132 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::133 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::134 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::135 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::136 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::137 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::138 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::139 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::140 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::141 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::142 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::143 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::144 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::145 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::146 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::147 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::148 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::149 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::150 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::151 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::152 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::153 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::154 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::155 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::156 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::157 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::158 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::159 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::160 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::161 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::162 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::163 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::164 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::165 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::166 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::167 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::168 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::169 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::170 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::171 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::172 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::173 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::174 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::175 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::176 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::177 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::178 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::179 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::180 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::181 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::182 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::183 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::184 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::185 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::186 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::187 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::188 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::189 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::190 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::191 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::192 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::193 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::194 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::195 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::196 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::197 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::198 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::199 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::200 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::201 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::202 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::203 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::204 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::205 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::206 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::207 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::208 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::209 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::210 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::211 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::212 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::213 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::214 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::215 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::216 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::217 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::218 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::219 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::220 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::221 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::222 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::223 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::224 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::225 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::226 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::227 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::228 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::229 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::230 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::231 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::232 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::233 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::234 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::235 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::236 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::237 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::238 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::239 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::240 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::241 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::242 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::243 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::244 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::245 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::246 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::247 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::248 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::249 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::250 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::251 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::252 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::253 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::254 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::255 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::256 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::257 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::258 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::259 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::260 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::261 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::262 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::263 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::264 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::265 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::266 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::267 */ {Op::BFREV, "bfrev", "bfrev", 0x17, "Bit Field Reverse",
            "The bfrev instruction component-wise reverses all the bits in src0 and stores the results in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] bfrev (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::268 */ {Op::BRC, "brc", "brc", 0x23, "Branch Converging",
            "The brc instruction redirects the execution forward or backward to the instruction pointed by (current IP + offset). The jump will occur if all channels are branched away.\n"
            "\n"
            "UIP should reference the instruction where all channels are expected to come together. JIP should reference the end of the innermost conditional block.\n"
            "\n"
            "\n"
            "In GEN binary, JIP and UIP use locations src1 and src0 respectively when immediate and location src0 when reg64, where reg64 is accessed as paired DWord (regioning being <2;2,1>). dst must be IP. When the offsets are immediate, src0 regfile must be immediate.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] brc (exec_size) JIP UIP\n",
            OpSpec::Format::JUMP_BINARY_BRC, {
                //  <- D
                {ENUM_BITSET_EMPTY_VALUE,TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::269 */ {Op::BRD, "brd", "brd", 0x21, "Branch Diverging",
            "The brd instruction redirects the execution forward or backward to the instruction pointed by (current IP + offset). The jump will occur if any channels are branched away.\n"
            "\n"
            "\n"
            "In GEN binary, JIP is at location src1 when immediate and at location src0 when reg32, where reg32 is accessed as a scalar DWord. The ip register must be used (for example, by the assembler) as dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] brd (exec_size) JIP\n",
            OpSpec::Format::JUMP_UNARY_REGIMM, {
                //  <- D
                {ENUM_BITSET_EMPTY_VALUE,TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::270 */ {Op::BREAK, "break", "break", 0x28, "Break",
            "The break instruction is used to early-out from the inner most loop, or early out from the inner most switch block.\n"
            "\n"
            "When used in a loop, upon execution, the break instruction terminates the loop for all execution channels enabled. If all the enabled channels hit the break instruction, jump to the instruction referenced by JIP. JIP should be the offset to the end of the inner most conditional or loop block, UIP should be the offset to the while instruction of the loop block.\n"
            "\n"
            "If SPF is ON, the UIP must be used to update IP; JIP is not used in this case\n"
            "\n"
            "\n"
            "The following table describes the two 32-bit instruction pointer offsets. Both the JIP and UIP are signed 32-bit numbers, added to IP pre-increment. In GEN binary, JIP and UIP are at locations src0 and src1 and must be of type DW (signed DWord integer). When the offsets are immediate, src0 regfile must be immediate.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] break (exec_size) JIP UIP\n",
            OpSpec::Format::JUMP_BINARY_IMM_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::271 */ {Op::CALL, "call", "call", 0x2c, "Call",
            "The call instruction jumps to a subroutine. It can be predicated or non-predicated. If non-predicated, all enabled channels jump to the subroutine. If predicated, only the channels enabled by PMask jump to the subroutine; the rest of the channels move to the next instruction after the call instruction. If none of the channels jump into the subroutine, the call instruction is treated as a nop.\n"
            "\n"
            "In case of a jump, the call instruction stores the return IP onto the first DWord of the destination register and stores the CallMask in the second DWord of the destination register.\n"
            "\n"
            "When SPF is on, the predication control must be scalar.\n"
            "\n"
            "\n"
            "The following section describes JIP, the jump offset, for DevSKL+.\n"
            "\n"
            "\n"
            "JIP can be an immediate or register value. When a jump occurs, this value is added to IP pre-increment. In GEN binary, JIP is at location src1 and src0 must be null. The GRF register must be put (for example, by the assembler) at dst location.\n"
            "\n"
            "\n"
            "Format: [(pred)] call (exec_size) dst JIP\n"
            "\n"
            "\n"
            "Format: [(pred)] call (exec_size) dst JIP\n",
            OpSpec::Format::JUMP_UNARY_CALL_REGIMM, {
                // D,UD <-
                {TYPE(Type::D)|TYPE(Type::UD),ENUM_BITSET_EMPTY_VALUE}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::272 */ {Op::CALLA, "calla", "calla", 0x2b, "Call Absolute",
            "The calla instruction jumps to a subroutine. It can be predicated or non-predicated. If non-predicated, all enabled channels jump to the subroutine. If predicated, only the channels enabled by PMask jump to the subroutine; the rest of the channels move to the next instruction after the calla instruction. If none of the channels jump into the subroutine, the calla instruction is treated as a nop.\n"
            "\n"
            "In case of a jump, the call instruction stores the return IP onto the first DWord of the destination register and stores the CallMask in the second DWord of the destination register.\n"
            "\n"
            "If SPF is ON, none of the PcIP are updated.\n"
            "\n"
            "When SPF is on, the predication control must be scalar.\n"
            "\n"
            "The difference between calla and call is that calla uses JIP as the IP value rather than adding it to the IP value.\n"
            "\n"
            "\n"
            "Format: [(pred)] calla (exec_size) dst JIP\n",
            OpSpec::Format::JUMP_UNARY_CALL_REGIMM, {
                // D,UD <-
                {TYPE(Type::D)|TYPE(Type::UD),ENUM_BITSET_EMPTY_VALUE}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::273 */ {Op::CBIT, "cbit", "cbit", 0x4d, "Count Bits Set",
            "The cbit instruction counts component-wise the total bits set in src0 and stores the resulting counts in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] cbit (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UD <- UB,UW,UD
                {TYPE(Type::UD),TYPE(Type::UB)|TYPE(Type::UW)|TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::274 */ {Op::CMP, "cmp", "cmp", 0x10, "Compare",
            "The cmp instruction performs component-wise comparison of src0 and src1 and stores the results in the selected flag register and in dst. It takes component-wise subtraction of src0 and src1, evaluating the conditional code (excluding NS signal) based on the conditional modifier, and storing the conditional bits in bit-packed form in the destination flag register and all bits of dst channels. If the dst is not null, for the enabled channels, then all bits of the destination channel will contain the flag value for the channel. When the instruction operates on packed word format, one general register may store up to 16 such comparison results. In DWord format, one general register may store up to 8 results.\n"
            "\n"
            "A conditional modifier must be specified; the conditional modifier field cannot be 0000b. The comparison does not use the NS (NaN source) signals, as described in the Creating Conditional Flags section. Accordingly the conditional modifier should not be .u (unordered).\n"
            "\n"
            "For each enabled channel 0b or 1b is assigned to the appropriate flag bit and 0/all zeros or all ones (e.g, byte 0xFF, word 0xFFFF, DWord 0xFFFFFFFF) is assigned to dst.\n"
            "\n"
            "When any source type is floating-point, the cmp instruction obeys the rules described in the tables in the Floating Point Modes section of the Data Types chapter.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] cmp[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- UB,B,UW,W,UD,D
                {TYPE(Type::F),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // HF <- UB,B,UW,W,UD,D
                {TYPE(Type::HF),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)},
                // HF,F <- HF,F
                {TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::HF)|TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::275 */ {Op::CMPN, "cmpn", "cmpn", 0x11, "Compare NaN",
            "The cmpn instruction performs component-wise special-NaN comparison of src0 and src1 and stores the results in the selected flag register and in dst. It takes component-wise subtraction of src0 and src1, evaluating the conditional signals including NS based on the conditional modifier, and storing the conditional flag bits in bit-packed form in the destination flag register and all bits of dst channels. If the dst is not null, for the enabled channels, then all bits of the destination channel will contain the flag value for the channel. When the instruction operates on packed word format, one general register may store up to 16 such comparison results. In DWord format, one general register may store up to 8 results.\n"
            "\n"
            "A conditional modifier must be specified; the conditional modifier field cannot be 0000b. More information about the conditional signals used is in the Creating Conditional Flags section.\n"
            "\n"
            "For each enabled channel 0b or 1b is assigned to the appropriate flag bit and 0/all zeros or all ones (e.g, byte 0xFF, word 0xFFFF, DWord 0xFFFFFFFF) is assigned to dst.\n"
            "\n"
            "Min/Max instructions use cmpn to select the destination from the input sources (see the Min Max of Floating Point Numbers section for details).\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] cmpn[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- UB,B,UW,W,UD,D
                {TYPE(Type::F),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::276 */ {Op::CONT, "cont", "cont", 0x29, "Continue",
            "The cont instruction disables execution for the subset of channels for the remainder of the current loop iteration. Channels remain disabled until right before the while instuction or right before the condition check code block for the while instruction. If all enabled channels hit this instruction, jump to the instruction referenced by JIP where execution continues.\n"
            "\n"
            "UIP should always reference the loop\'s associated while instruction. JIP should point to the last instruction of the inner most conditional block if the cont instruction is inside a conditional block. In case of the break instruction directly under the loop, the JIP and the UIP are the same.\n"
            "\n"
            "If SPF is ON, the UIP must be used to update IP; JIP is not used in this case.\n"
            "\n"
            "\n"
            "The following table describes the two 32-bit instruction pointer offsets. Both the JIP and UIP are signed 32-bit numbers, added to IP pre-increment. In GEN binary, JIP and UIP are at locations src0 and src1 and must be of type DW (signed DWord integer). When the offsets are immediate, src0 regfile must be immediate.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] cont (exec_size) JIP UIP\n",
            OpSpec::Format::JUMP_BINARY_IMM_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::277 */ {Op::CSEL, "csel", "csel", 0x12, "Conditional Select",
            "The csel instruction selectively moves components in src0 or src1 to the dst based on the result of the compare of src2 with zero. If the channel condition is true, data in src0 is moved into dst. Otherwise, data in src1 is moved into dst. The csel instruction provides the function of a cmp followed by sel. The instruction must not be used if cmpn is required. The instruction does not update the flag register.\n"
            "\n"
            "\n"
            "The comparison follows the same rule as cmp instruction for that data type.\n"
            "\n"
            "\n"
            "When Access Mode is Align1, accumulator may be used as source or destination.\n"
            "\n"
            "\n"
            "Format:\n"
            "csel (exec_size) dst src0 src1 src2\n",
            OpSpec::Format::TERNARY_REGIMM_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // W <- W
                {TYPE(Type::W),TYPE(Type::W)}
            },
            OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::278 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::279 */ {Op::DP2, "dp2", "dp2", 0x57, "Dot Product 2",
            "The dp2 instruction performs a two-wide dot product on four-tuple vector basis and storing the same scalar result per four tuple to all four channels in dst. This instruction is similar to dp4 except that every third and fourth element of src0 (post-source-swizzle if present) are not involved in the computation.\n"
            "\n"
            "The dot product of two vectors of equal length is the sum of the products of each pair of corresponding elements.\n"
            "\n"
            "The dp4 instruction includes all four elements of each vector in the dot product. The dp3 instruction includes the first three elements of each vector in the dot product.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] dp2[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::280 */ {Op::DP3, "dp3", "dp3", 0x56, "Dot Product 3",
            "The dp3 instruction performs a three-wide dot product on four-tuple vector basis and storing the same scalar result per four tuple to all four channels in dst. This instruction is similar to dp4 except that every fourth element of src0 (post-source-swizzle if present) is not involved in the computation.\n"
            "\n"
            "The dot product of two vectors of equal length is the sum of the products of each pair of corresponding elements.\n"
            "\n"
            "The dp4 instruction includes all four elements of each vector in the dot product. The dp2 instruction includes the first two elements of each vector in the dot product.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] dp3[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::281 */ {Op::DP4, "dp4", "dp4", 0x54, "Dot Product 4",
            "The dp4 instruction performs a four-wide dot product on four-tuple vector basis and storing the same scalar result per four tuple to all four channels in dst.\n"
            "\n"
            "The dot product of two vectors of equal length is the sum of the products of each pair of corresponding elements.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] dp4[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::282 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::283 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::284 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::285 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::286 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::287 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::288 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::289 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::290 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::291 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::292 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::293 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::294 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::295 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::296 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::297 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::298 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::299 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::300 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::301 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::302 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::303 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::304 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::305 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::306 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::307 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::308 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::309 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::310 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::311 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::312 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::313 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::314 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::315 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::316 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::317 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::318 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::319 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::320 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::321 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::322 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::323 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::324 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::325 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::326 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::327 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::328 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::329 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::330 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::331 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::332 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::333 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::334 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::335 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::336 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::337 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::338 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::339 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::340 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::341 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::342 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::343 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::344 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::345 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::346 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::347 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::348 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::349 */ {Op::DPH, "dph", "dph", 0x55, "Dot Product Homogeneous",
            "The dph instruction performs a four-wide homogeneous dot product on four-tuple vector basis and storing the same scalar result per four tuple to all four channels in dst. This instruction is similar to dp4 except that every fourth element of src0 (post-source-swizzle if present) is forced to 1.0f.\n"
            "\n"
            "Use the dp4 instruction to do a four-wide dot product that includes all elements of src0 and src1.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] dph[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::350 */ {Op::ELSE, "else", "else", 0x24, "Else",
            "The else instruction is an optional statement within an if/else/endif block of code. It restricts execution within the else/endif portion to the opposite set of channels enabled under the if/else portion. Channels which were inactive prior to entering the if/endif block remain inactive throughout the entire block.\n"
            "\n"
            "All enabled channels upon arriving the else instruction will be redirected to the matching endif. If all channels are redirected (by else or before else), a relative jump is performed to the location specified by  <JIP>. The jump target should be the matching endif instruction for that conditional block.\n"
            "\n"
            "The following table describes the 32-bit <JIP>. In GEN binary, <JIP> is at location <src1> and must be of type D (signed dword integer). <JIP> must be an immediate operand, it is a signed 32-bit number and is intended to be forward referencing. This value is added to IP pre-increment.\n"
            "\n"
            "If the <branch_ctrl> bit is set, then the <JIP> points to the first join instruction within the else block and <UIP> points to the endif instruction. If the <branch_ctrl> bit is not set,  <JIP> and <UIP>, both point to endif.\n"
            "\n"
            "\n"
            "Format:\n"
            "else (exec_size) JIP  UIP  branch_ctrl\n"
            "\n"
            "\n"
            "An else instruction must not be followed by any instruction requiring register indirect access on source operands\n"
            "\n"
            "\n"
            "If all channels are redirected (by else or before else), relative jump is performed to the location specified by <JIP> + 1.\n",
            OpSpec::Format::JUMP_BINARY_IMM_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_BRCTL,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::351 */ {Op::ENDIF, "endif", "endif", 0x25, "End If",
            "The endif instruction terminates an if/else/endif block of code. It restores execution to the channels that were active prior to the if/else/endif block.\n"
            "\n"
            "The endif instruction is also used to hop out of nested conditionals by jumping to the end of the next outer conditional block when all channels are disabled.\n"
            "\n"
            "\n"
            "The following table describes the 32-bit JIP. In GEN binary, JIP is at location src1 and must be of type D (signed DWord integer). JIP must be an immediate operand, it is a signed 32-bit number. This value is added to IP pre-increment.\n"
            "\n"
            "\n"
            "Format:\n"
            "endif JIP\n",
            OpSpec::Format::JUMP_UNARY_IMM, { }, // no type mappings
            OpSpec::Attr::NONE,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::352 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::353 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::354 */ {Op::FBH, "fbh", "fbh", 0x4b, "Find First Bit from MSB Side",
            "If src0 is unsigned, the fbh instruction counts component-wise the leading zeros from src0 and stores the resulting counts in dst.\n"
            "\n"
            "If src0 is signed and positive, the fbh instruction counts component-wise the leading zeros from src0 and stores the resulting counts in dst.\n"
            "\n"
            "If src0 is signed and negative, the fbh instruction counts component-wise the leading ones from src0 and stores the resulting counts in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] fbh (exec_size) dst src0\n"
            "\n"
            "\n"
            "If src0 is zero, store 0xFFFFFFFF in dst.\n"
            "\n"
            "\n"
            "If src0 is signed and is -1 (0xFFFFFFFF), store 0xFFFFFFFF in dst.\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UD <- D,UD
                {TYPE(Type::UD),TYPE(Type::D)|TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::355 */ {Op::FBL, "fbl", "fbl", 0x4c, "Find First Bit from LSB Side",
            "The fbl instruction counts component-wise the number of LSB 0 bits before the first 1 bit in src0, storing that number in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] fbl (exec_size) dst src0\n"
            "\n"
            "\n"
            "If src0 contains no 1 bits, store 0xFFFFFFFF in dst.\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::356 */ {Op::FRC, "frc", "frc", 0x43, "Fraction",
            "The frc instruction computes, component-wise, the truncate-to-minus-infinity fractional values of src0 and stores the results in dst. The results, in the range of [0.0, 1.0], are the fractional portion of the source data. The result is in the range [0.0, 1.0] irrespective of the rounding mode. Floating-point fraction computation follows the rules in the following tables, based on the current floating-point mode.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] frc[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::357 */ {Op::GOTO, "goto", "goto", 0x2e, "Goto",
            "The goto instruction directs the instruction pointer to the offset specified by the UIP offset or to the next IP based on the BranchCtrl bit in the instruction. The active channels that are predicated on this instruction will take the IP + UIP path when BranchCtrl is set else the channels take IP + 1. The active channels that are not predicated on this instruction will be made inactive and waiting to be joined at the join IP. The join IP is IP + UIP when BranchCtrl is clear else it is the next IP.\n"
            "\n"
            "\n"
            "When there are no active channels the instruction pointer will move to IP + JIP.\n"
            "\n"
            "\n"
            "The goto instruction is used in conjunction with a join instruction. A goto deactivates some channels that are reactivated at some program-specified join instruction. See the join instruction for the activation rules.\n"
            "\n"
            "\n"
            "The goto and join instructions enable unstructured program control flow. These instructions must be used with additional care where dangling channels can result without proper compiler checks, meaning that it is expected that programs will navigate through these paths to reactivate the channels. Hardware does not provide native checks or reconvergence.\n"
            "\n"
            "\n"
            "The following table describes the two 32-bit instruction pointer offsets. Both the JIP and UIP are signed 32-bit numbers, added to IP pre-increment. In GEN binary, JIP and UIP are at locations src0 and src1 and must be of type DW (signed DWord integer).\n"
            "\n"
            "\n"
            "If SPF is ON, none of the PcIP are updated.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] goto (exec_size) JIP UIP branch_ctrl\n",
            OpSpec::Format::JUMP_BINARY_IMM_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_BRCTL|OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::358 */ {Op::HALT, "halt", "halt", 0x2a, "Halt",
            "The halt instruction temporarily suspends execution for all enabled compute channels. Upon execution, the enabled channels are sent to the instruction at (IP + UIP), if all channels are enabled at HALT, jump to the instruction at (IP + JIP).\n"
            "\n"
            "If the halt instruction is not inside any conditional code block, the values of JIP and UIP should be the same. If the halt instruction is inside a conditional code block, the UIP should be the end of the program and the JIP should be the end of the inner most conditional code block.\n"
            "\n"
            "The UIP must point to a HALT Instruction.\n"
            "\n"
            "If SPF is ON, the UIP must be used to update IP; JIP is not used in this case.\n"
            "\n"
            "\n"
            "The following table describes the two 32-bit instruction pointer offsets. Both the JIP and UIP are signed 32-bit numbers, added to IP pre-increment. In GEN binary, JIP and UIP are at locations src0 and src1 and must be of type DW (signed DWord integer). When the offsets are immediate, src0 regfile must be immediate and dst must be null.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] halt (exec_size) JIP UIP\n",
            OpSpec::Format::JUMP_BINARY_IMM_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::359 */ {Op::IF, "if", "if", 0x22, "If",
            "An if instruction starts an if/endif or an if/else/endif block of code. It restricts execution within the conditional block to only those channels that were enabled via the predicate control.\n"
            "\n"
            "Each if instruction must have a matching endif instruction and may have up to one matching else instruction before the matching endif.\n"
            "\n"
            "If all channels are inactive (for the if/endif or if/else/endif block), a jump is performed to the instruction referenced by JIP. This jump must be to right after the matching else instruction when present, or otherwise to the matching endif instruction of the conditional block.\n"
            "\n"
            "If SPF is ON, the UIP must be used to update IP; JIP is not used in this case.\n"
            "\n"
            "\n"
            "The following table describes the 32-bit exit code <JIP> and <UIP>. If <branch_ctrl> is set, then the JIP points to the first join instruction within the if block. If <branch_ctrl> is not set, <JIP> should point to the instruction right after the matching else instruction if it exsits, otherwise <JIP> should point to the endif instruction. <UIP> should always point to the endif instruction. When a jump occurs, this value is added to IP pre-increment. In GEN instruction binary, <JIP> and <UIP> are at location <src0> & <src1> and must be of type D (signed dword integer).\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] if (exec_size JIP UIP <branch_ctrl>\n",
            OpSpec::Format::JUMP_BINARY_IMM_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_BRCTL|OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::360 */ {Op::ILLEGAL, "illegal", "illegal", 0x0, "Illegal",
            "The Illegal Opcode Exception Enable flag in cr0.1 is normally set so the normal processing of an illegal opcode is to transfer control to the System Routine.\n"
            "\n"
            "Instruction dispatch treats any unused 8-bit opcode (including bit 7 of the instruction, reserved for future opcode expansion) as if it is the illegal opcode.\n"
            "\n"
            "The illegal opcode is zero because that byte value is more likely than most to be read via a wayward instruction pointer.\n"
            "\n"
            "The illegal instruction is an instruction only in the same way that a NULL pointer in software is a pointer. Both are special values indicating invalid instances.\n"
            "\n"
            "\n"
            "Format:\n"
            "illegal\n",
            OpSpec::Format::NULLARY, { }, // no type mappings
            OpSpec::Attr::NONE,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::361 */ {Op::JMPI, "jmpi", "jmpi", 0x20, "Jump Indexed",
            "The jmpi instruction redirects program execution to an index offset relative to the post-incremented instruction pointer. The index is a signed integer value, with positive or zero integers for forward jumps, and negative integers for backward jumps. In GEN binary, index is at location src1. The ip register must be put (for example, by the assembler) at the dst and src0 locations. Predication is allowed to provide conditional jump with a scalar condition. As the execution size is 1, the first channel of PMASK (flags post prediction control and negate) is used to determine whether the jump is taken or not. If the condition is false, the jump is not taken and execution continues with the next instruction.\n"
            "\n"
            "\n"
            "Note: Unlike other flow control instructions, the offset used by jmpi is relative to the incremented instruction pointer rather than the IP value for the instruction itself.\n"
            "\n"
            "\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] jmpi (1) index {NoMask}\n"
            "\n"
            "\n"
            "An index of 0 does nothing, continuing execution with the next instruction.\n"
            "\n"
            "\n"
            "An index of -16 (if the jmpi instruction is in native format) or -8 (if the jmpi instruction is in compact format) is an infinite loop on the jmpi instruction.\n",
            OpSpec::Format::JUMP_UNARY_REGIMM, {
                //  <- D
                {ENUM_BITSET_EMPTY_VALUE,TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::362 */ {Op::JOIN, "join", "join", 0x2f, "Join",
            "The join instruction makes the inactive channels active at the join IP if those channels are predicated. Any deactivated channels due to a goto instruction match the join IP are activated (qualified with predicates at join). If no IP is matched at this join, the program goes to the next IP with the active channels which followed the program path up to the join instruction. If no active channels are present after executing the join instruction, the program jumps to the offset specified by JIP instead of next IP.\n"
            "\n"
            "The join instruction is used in conjunction with a goto instruction. The join activates channels that are deactivated by the goto instruction. See the goto instruction for the deactivation rules.\n"
            "\n"
            "The goto and join instructions enable unstructured program control flow. These instructions must be used with additional care where dangling channels can result without proper compiler checks, meaning that it is expected that programs will navigate through these paths to reactivate the channels. Hardware does not provide native checks or reconvergence.\n"
            "\n"
            "The following table describes the 32-bit JIP. In GEN binary, JIP is at location src1 and must be of type D (signed DWord integer). JIP must be an immediate operand and is a signed 32-bit number. This value is added to IP pre-increment.\n"
            "\n"
            "If SPF is ON, none of the PcIP are updated.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] join (exec_size) JIP\n"
            "\n"
            "\n"
            "An index of 0 is an infinite loop.\n",
            OpSpec::Format::JUMP_UNARY_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::363 */ {Op::LINE, "line", "line", 0x59, "Line",
            "The line instruction computes a component-wise line equation (v = p * u + q where u, v are vectors and p, q are scalars) of src0 and src1 and stores the results in dst. src1 is the input vector u. src0 provides input scalars p and q, where p is the scalar value based on the region description of src0 and q is the scalar value implied from src0 region. Specifically, q is the fourth component of the 4-tuple (128-bit aligned) that p belongs to.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] line[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::364 */ {Op::LRP, "lrp", "lrp", 0x5c, "Linear Interpolation",
            "The lrp instruction takes component-wise multiplication of src0 and src1, and adds the result to the component-wise multiplication of src2 and (1 - src0), and then stores the final results in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] lrp[.cmod] (exec_size) dst src0 src1 src2\n",
            OpSpec::Format::TERNARY_REGIMM_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::365 */ {Op::LZD, "lzd", "lzd", 0x4a, "Leading Zero Detection",
            "The lzd instruction counts component-wise the leading zeros from src0 and stores the resulting counts in dst.\n"
            "\n"
            "If src0 is zero, store 32 in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] lzd[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UD <- D,UD
                {TYPE(Type::UD),TYPE(Type::D)|TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::366 */ {Op::MAC, "mac", "mac", 0x48, "Multiply Accumulate",
            "The mac instruction takes component-wise multiplication of src0 and src1, adds the results with the corresponding accumulator values, and then stores the final results in dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] mac[.cmod] (exec_size) dst src0 src1\n"
            "\n"
            "\n"
            "When source and destination datatypes are different, the implied datatype for the accumulator operand is always the destination datatype.\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // HF,F <- HF,F
                {TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::HF)|TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::367 */ {Op::MACH, "mach", "mach", 0x49, "Multiply Accumulate High",
            "The mach instruction performs DWord integer multiply-accumulate operation and outputs the high DWord (bits 63:32). For each enabled channel, this instruction multiplies the DWord in src0 with the high word of the DWord in src1, left shifts the result by 16 bits, adds it with the corresponding accumulator values, and keeps the whole 64-bit result in the accumulator. It then stores the high DWord (bits 63:32) of the results in dst. This instruction is intended to be used to emulate 32-bit DWord integer multiplication by using the large number of bits available in the accumulator. For example, the following instructions perform vector multiplication of two 32-bit signed integer sources from r2 and r3 and store the resulting vectors with the high 32 bits in r5 and the low 32 bits in r6.\n"
            "\n"
            "mul (8) acc0:d r2.0<8;8,1>:d r3.0<16;8,2>:uw\n"
            "mach (8) r5.0<1>:d r2.0<8;8,1>:d r3.0<8;8,1>:d\n"
            "mov (8) r6.0<1>:d acc0:d // Low 32 bits.\n"
            "\n"
            "\n"
            "\n"
            "Here is a different example including negation. An added preliminary mov is required for source modification on src1.\n"
            "\n"
            "\n"
            "mov (8) r3.0<1>:d -r3<8;8,1>:d\n"
            "mul (8) acc0:d r2.0<8;8,1>:d r3.0<16;8,2>:uw\n"
            "mach (8) r5.0<1>:d r2.0<8;8,1>:d r3.0<8;8,1>:d // High 32 bits\n"
            "mov (8) r6.0<1>:d acc0:d // Low 32 bits.\n"
            "\n"
            "\n"
            "\n"
            "The mach should have channel enable from the destHI of IMUL, the mov should have the channel enable from the destLO of IMUL. As mach is used to generate part of the 64-bit DWord integer results, saturation modifier should not be used. In fact, saturation modifier should not be used for any of these four instructions. Source and destination operands must be DWord integers. Source and destination must be of the same type, signed integer or unsigned integer. If dst is UD, src0 and src1 may be UD and/or D. However, if any of src0 and src1 is D, source modifier (abs) must be present to convert it to match with dst. If dst is D, src0 and src1 must also be D. They cannot be UD as it may cause unexpected overflow because the computed results are limited to 64 bits.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] mach[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::368 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::369 */ {Op::MAD, "mad", "mad", 0x5b, "Multiply Add",
            "The mad instruction takes component-wise multiplication of src1 and src2, adds the results with the corresponding src0 values, and then stores the final results in dst.\n"
            "\n"
            "\n"
            "The conditional modifier and saturation (.sat) must not be used when src1 or src2 are dwords.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] mad[.cmod] (exec_size) dst src0 src1 src2\n",
            OpSpec::Format::TERNARY_REGIMM_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // HF,F <- HF,F
                {TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::HF)|TYPE(Type::F)},
                // W <- B
                {TYPE(Type::W),TYPE(Type::B)},
                // W,D <- W,D
                {TYPE(Type::W)|TYPE(Type::D),TYPE(Type::W)|TYPE(Type::D)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::370 */ {Op::MADM, "madm", "madm", 0x5d, "Multiply Add for Macro",
            "The madm instruction takes component-wise multiplication of src1 and src2, adds the results with the corresponding src0 values, and then stores the final results in dst.\n"
            "\n"
            "The source and destination operands have a higher precision carried in the exponent for this operation. The madm instruction is used for macro operations, where precision is accumulated over several instructions. This accumulation requires the exponent to increase by 2 extra bits across multiple madm operations.\n"
            "\n"
            "Refer to Macros Defined in \'Math\' Section for usage and restrictions of this operation.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] madm[.cmod] (exec_size) dst src0 src1 src2\n",
            OpSpec::Format::TERNARY_MACRO_REG_REG_REG, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::371 */ {Op::MATH, "math", "math", 0x38, "Extended Math Function",
            "The math instruction performs extended math function on the components in src0, or src0 and src1, and write the output to the channels of dst. The type of extended math function are based on the FC[3:0] encoding in the table below.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] math (exec_size) dst src0 src1 <FC>\n",
            OpSpec::Format::GROUP, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::MATH_COS /* subopsStart */,
            14 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            /* MathFC */ {{"MathFC[3:0]",24,4}} /* functionControlFields */},
        /* Op::372 */ {Op::MATH_COS, "cos", "math.cos", 0x38, "COS",
            "Cosine function. cos(src0)\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            7 /* functionControlValue = MathFC::COS */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::373 */ {Op::MATH_EXP, "exp", "math.exp", 0x38, "EXP",
            "Exponential (E^src0)\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            3 /* functionControlValue = MathFC::EXP */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::374 */ {Op::MATH_FDIV, "fdiv", "math.fdiv", 0x38, "FDIV",
            "Floating-Point Divide function. src0/src1\n",
            OpSpec::Format::MATH_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            9 /* functionControlValue = MathFC::FDIV */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::375 */ {Op::MATH_IDIV, "idiv", "math.idiv", 0x38, "IDIV",
            "Integer Divide with Quotient and Remainder. The quotient goes in the destination register; the remainder goes in the following register.\n",
            OpSpec::Format::MATH_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            11 /* functionControlValue = MathFC::IDIV */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::376 */ {Op::MATH_INV, "inv", "math.inv", 0x38, "INV",
            "Reciprocal (Multiplicative Inverse): 1/src0\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            1 /* functionControlValue = MathFC::INV */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::377 */ {Op::MATH_INVM, "invm", "math.invm", 0x38, "INVM",
            "Reciprocal Macro for IEEE754-compliant fdiv\n",
            OpSpec::Format::MATH_MACRO_BINARY_REG_REG, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            14 /* functionControlValue = MathFC::INVM */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::378 */ {Op::MATH_IQOT, "iqot", "math.iqot", 0x38, "IQOT",
            "Integer Quotient only\n",
            OpSpec::Format::MATH_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            12 /* functionControlValue = MathFC::IQOT */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::379 */ {Op::MATH_IREM, "irem", "math.irem", 0x38, "IREM",
            "Integer Remainder only\n",
            OpSpec::Format::MATH_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            13 /* functionControlValue = MathFC::IREM */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::380 */ {Op::MATH_LOG, "log", "math.log", 0x38, "LOG",
            "Natural log: ln(src0)\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            2 /* functionControlValue = MathFC::LOG */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::381 */ {Op::MATH_POW, "pow", "math.pow", 0x38, "POW",
            "src0^src1\n",
            OpSpec::Format::MATH_BINARY_REG_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            10 /* functionControlValue = MathFC::POW */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::382 */ {Op::MATH_RSQT, "rsqt", "math.rsqt", 0x38, "RSQT",
            "Reciprocal Square Root: 1/sqt(src)\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            5 /* functionControlValue = MathFC::RSQT */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::383 */ {Op::MATH_RSQTM, "rsqtm", "math.rsqtm", 0x38, "RSQTM",
            "Reciprocal Square Root Macro for IEEE754-compliant rsqt\n",
            OpSpec::Format::MATH_MACRO_UNARY_REG, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            15 /* functionControlValue = MathFC::RSQTM */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::384 */ {Op::MATH_SIN, "sin", "math.sin", 0x38, "SIN",
            "Sine function. sin(src0)\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            6 /* functionControlValue = MathFC::SIN */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::385 */ {Op::MATH_SQT, "sqt", "math.sqt", 0x38, "SQT",
            "Square Root\n",
            OpSpec::Format::MATH_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F,HF <- F,HF
                {TYPE(Type::F)|TYPE(Type::HF),TYPE(Type::F)|TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::MATH /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            4 /* functionControlValue = MathFC::SQT */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::386 */ {Op::MOV, "mov", "mov", 0x1, "Move",
            "The mov instruction moves the components in src0 into the channels of dst. If src0 and dst are of different types, format conversion is performed. If src0 is a scalar immediate, the immediate value is loaded into enabled channels of dst.\n"
            "\n"
            "A mov with the same source and destination type, no source modifier, and no saturation is a raw move. A packed byte destination region (B or UB type with HorzStride == 1 and ExecSize > 1) can only be written using raw move.\n"
            "\n"
            "\n"
            "When denorm mode is flush to zero, a raw mov instruction with saturation modifier will not flush the denorm input or output to zero (Denorm is preserved).\n"
            "\n"
            "\n"
            "Format: [(pred)] mov[.cmod] (exec_size) dst src0\n"
            "\n"
            "\n"
            "A mov instruction with a source modifier always copies a denorm source value to a denorm destination value\n"
            "(in the manner of a raw move).\n"
            "\n"
            "\n"
            "There is no direct conversion from B/UB to DF or DF to B/UB. Use two instructions and a word or DWord intermediate type.\n"
            "\n"
            "\n"
            "There is no direct conversion from B/UB to Q/UQ or Q/UQ to B/UB. Use two instructions and a word or DWord intermediate integer type.\n"
            "\n"
            "\n"
            "There is no direct conversion from HF to DF or DF to HF. Use two instructions and F (Float) as an intermediate type.\n"
            "\n"
            "\n"
            "There is no direct conversion from HF to Q/UQ or Q/UQ to HF. Use two instructions and F (Float) or a word integer type or a DWord integer type as an intermediate type.\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- UB,B,UW,W,UD,D
                {TYPE(Type::F),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UB,B,UW,W,UD,D <- F
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::F)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- UW,W,UD,D
                {TYPE(Type::DF),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // DF <- F
                {TYPE(Type::DF),TYPE(Type::F)},
                // UW,W,UD,D <- DF
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::DF)},
                // F <- DF
                {TYPE(Type::F),TYPE(Type::DF)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- F
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::F)},
                // UQ,Q <- DF
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::DF)},
                // F <- UQ,Q
                {TYPE(Type::F),TYPE(Type::UQ)|TYPE(Type::Q)},
                // DF <- UQ,Q
                {TYPE(Type::DF),TYPE(Type::UQ)|TYPE(Type::Q)},
                // HF <- UB,B,UW,W,UD,D
                {TYPE(Type::HF),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // HF <- F
                {TYPE(Type::HF),TYPE(Type::F)},
                // UB,B,UW,W,UD,D <- HF
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::HF)},
                // F <- HF
                {TYPE(Type::F),TYPE(Type::HF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::387 */ {Op::MOVI, "movi", "movi", 0x3, "Move Indexed",
            "The movi instruction performs a fast component-wise indexed move for subfields from src0 to dst. The source\n"
            "operand must be an indirectly-addressed register. All channels of the source operand share the same register\n"
            "number, which is provided by the register field of the first address subregister, with a possible immediate\n"
            "register offset. The register fields of the subsequent address subregisters are ignored by hardware. The\n"
            "subregister number of a source channel is provided by the subregister field of the corresponding address\n"
            "subregister, with a possible immediate subregister offset.\n"
            "\n"
            "\n"
            "\n"
            "The destination register may be either a directly-addressed or an indirectly-addressed register.\n"
            "\n"
            "\n"
            "\n"
            "This instruction effectively performs a subfield shuffling from one register to another. Up to eight\n"
            "subfields can be selected by an instruction.\n"
            "\n"
            "\n"
            "Format: [(pred)] movi (exec_size) dst src0\n"
            "\n"
            "\n"
            "HW Implementation Details:\n"
            "\n"
            "\n"
            "\n"
            "The source register is calculated by adding the register portion of the first index register with the\n"
            "register portion of the address immediate, a0.0[11:5] + addr_imm[9:5]\n"
            "\n"
            "\n"
            "\n"
            "For byte movi, byte0 of the destination is selected by (a0.0[4:0]), byte1 is selected by (a0.1[4:0]), ...,\n"
            "and byte7 is selected by (a0.7[4:0]). The rest of the bytes are undefined.\n"
            "\n"
            "\n"
            "\n"
            "For word movi, byte0 of the destination is selected by (a0.0[4:1] & 0), byte1 is selected by (a0.0[4:1]\n"
            "& 1), byte2 is selected by (a0.1[4:1] & 0), byte3 is selected by (a0.1[4:1] & 1), ..., and byte15\n"
            "is selected by (a0.7[4:1] & 1). The rest of the bytes are undefined.\n"
            "\n"
            "\n"
            "\n"
            "For DWord or float movi, byte0 of the destination is selected by (a0.0[4:2] & 00b), byte1 is selected\n"
            "by (a0.0[4:2] & 01b), byte2 is selected by (a0.0[4:2] & 10b), byte3 is selected by (a0.0[4:2] &\n"
            "11b), byte4 is selected by (a0.1[4:2] & 00b), byte5 is selected by (a0.1[4:2] & 01b), ..., byte31\n"
            "is selected by (a0.7[4:2] & 11b).\n"
            "\n"
            "\n"
            "\n"
            "For all 3 conditions above, a0.n[4:0] = a0.n[4:0] + addr_imm[4:0].\n",
            OpSpec::Format::BASIC_BINARY_REG_IMM, {
                // B <- B
                {TYPE(Type::B),TYPE(Type::B)},
                // UB <- UB
                {TYPE(Type::UB),TYPE(Type::UB)},
                // W <- W
                {TYPE(Type::W),TYPE(Type::W)},
                // UW <- UW
                {TYPE(Type::UW),TYPE(Type::UW)},
                // D <- D
                {TYPE(Type::D),TYPE(Type::D)},
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::388 */ {Op::MUL, "mul", "mul", 0x41, "Multiply",
            "The mul instruction performs component-wise multiplication of src0 and src1 and stores the results in dst. When multiplying integer datatypes, if src0 is DW and src1 is W, irrespective of the destination datatype, the accumulator maintains full 48-bit precision. This is required to handle the macro for 32x32 multiplication. The macro described in the mach instruction should be used to obtain the full precision 64-bit multiplication results.\n"
            "\n"
            "\n"
            "Note: A 32x32 multiply operation is handled natively, without a macro. When operating in this mode, the resulting 64-bit data is packed, unlike the macro, where the lower and upper 32 bits of the result are written to different general registers by two separate instructions. Refer to the macro description for details.\n"
            "\n"
            "\n"
            "When multiplying integer data types, if one of the sources is a DW, the resulting full precision data is stored in the accumulator. However, if the destination data type is either W or DW, the low bits of the result are written to the destination register and the remaining high bits are discarded. This results in undefined Overflow and Sign flags. Therefore, conditional modifiers and saturation (.sat) cannot be used in this case.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] mul[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B <- UB,B
                {TYPE(Type::UB)|TYPE(Type::B),TYPE(Type::UB)|TYPE(Type::B)},
                // UW,W <- UB,B
                {TYPE(Type::UW)|TYPE(Type::W),TYPE(Type::UB)|TYPE(Type::B)},
                // UD,D <- UB,B
                {TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)},
                // UW,W <- UW,W
                {TYPE(Type::UW)|TYPE(Type::W),TYPE(Type::UW)|TYPE(Type::W)},
                // UD,D <- UW,W
                {TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)},
                // UD,D <- UD,D
                {TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UD)|TYPE(Type::D)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // HF,F <- HF,F
                {TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::HF)|TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::389 */ {Op::NOP, "nop", "nop", 0x7e, "No Operation",
            "Do nothing. The nop instruction takes an instruction dispatch but performs no operation. It can be used for assembly patching in memory, or to insert a delay in the program sequence.\n"
            "\n"
            "\n"
            "Format:\n"
            "nop\n",
            OpSpec::Format::NULLARY, { }, // no type mappings
            OpSpec::Attr::NONE,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::390 */ {Op::NOT, "not", "not", 0x4, "Logic Not",
            "The not instruction performs logical NOT operation (or one\'s complement) of src0 and storing the results in dst.\n"
            "\n"
            "This operation does not produce sign or overflow conditions. Only the .e/.z or .ne/.nz conditional modifiers should be used.\n"
            "\n"
            "\n"
            "A register source operand can use a source modifier:\n"
            "Any source modifier is logical, optionally changing a source value s to ~s (inverting all source bits). Such a source modifier is not particularly useful with the not instruction, as it changes the effect of not to just copying bits.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] not[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::391 */ {Op::OR, "or", "or", 0x6, "Logic Or",
            "The or instruction performs component-wise logic OR operation between src0 and src1 and stores the results in dst.\n"
            "\n"
            "This operation does not produce sign or overflow conditions. Only the .e/.z or .ne/.nz conditional modifiers should be used.\n"
            "\n"
            "\n"
            "Register source operands can use source modifiers:\n"
            "Any source modifier is logical, optionally changing a source value s to ~s (inverting all source bits). This capability allows expressions like a OR (NOT b) to be calculated with one instruction.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] or[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::392 */ {Op::PLN, "pln", "pln", 0x5a, "Plane",
            "The pln instruction computes a component-wise plane equation (w = p*u+q*v+r where u/v/w are vectors and p/q/r are scalars) of src0 and src1 and stores the results in dst. src1 is the input vector u.\n"
            "\n"
            "src0 provides input scalars p, q, and r, where p is the scalar value based on the region description of src0 and q and r are the scalar values implied from the src0 region. Specifically, q is the second component and r is the fourth component of the 4-tuple (128-bit aligned) that p belongs to.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] pln[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REG, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::393 */ {Op::RET, "ret", "ret", 0x2d, "Return",
            "Return execution to the code sequence that called a subroutine.\n"
            "\n"
            "The ret instruction can be predicated or non-predicated. If non-predicated, all channels jump to the return IP in the first channel of src0 and restore CallMask from the second channel of src0. If predicated, the enabled channels jump to the return IP from the first channel of src0 and the corresponding bits in the CallMask are cleared to zero; if all CallMask bits are zero after the ret instruction, then execution jumps to the return IP from the first channel of src0.\n"
            "\n"
            "When SPF is on, the predication control must be scalar.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] ret (exec_size) null src0\n",
            OpSpec::Format::JUMP_UNARY_REG, {
                //  <- D,UD
                {ENUM_BITSET_EMPTY_VALUE,TYPE(Type::D)|TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::394 */ {Op::RNDD, "rndd", "rndd", 0x45, "Round Down",
            "The rndd instruction takes component-wise floating point downward rounding (to the integral float number closer to negative infinity) of src0 and storing the rounded integral float results in dst. This is commonly referred to as the floor() function.\n"
            "\n"
            "Each result follows the rules in the following tables based on the floating-point mode.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] rndd[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::395 */ {Op::RNDE, "rnde", "rnde", 0x46, "Round to Nearest or Even",
            "The rnde instruction takes component-wise floating point round-to-even operation of src0 with results in two pieces - a downward rounded integral float results stored in dst and the round-to-even increments stored in the rounding increment bits. The round-to-even increment must be added to the results in dst to create the final round-to-even values to emulate the round-to-even operation, commonly known as the round() function. The final results are the one of the two integral float values that is nearer to the input values. If the neither possibility is nearer, the even alternative is chosen.\n"
            "\n"
            "Each result follows the rules in the following tables based on the floating-point mode.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] rnde[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::396 */ {Op::RNDU, "rndu", "rndu", 0x44, "Round Up",
            "The rndu instruction takes component-wise floating point upward rounding (to the integral float number closer to positive infinity) of src0, commonly known as the ceiling() function.\n"
            "\n"
            "Each result follows the rules in the following tables based on the floating-point mode.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] rndu[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::397 */ {Op::RNDZ, "rndz", "rndz", 0x47, "Round to Zero",
            "The rndz instruction takes component-wise floating point round-to-zero operation of src0 with results in two pieces - a downward rounded integral float results stored in dst and the round-to-zero increments stored in the rounding increment bits. The round-to-zero increment must be added to the results in dst to create the final round-to-zero values to emulate the round-to-zero operation, commonly known as the truncate() function. The final results are the one of the two closest integral float values to the input values that is nearer to zero.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] rndz[.cmod] (exec_size) dst src0\n",
            OpSpec::Format::BASIC_UNARY_REGIMM, {
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::398 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::399 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::400 */ {Op::SAD2, "sad2", "sad2", 0x50, "Sum of Absolute Difference 2",
            "The sad2 instruction takes source data channels from src0 and src1 in groups of 2-tuples. For each 2-tuple, it computes the sum-of-absolute-difference (SAD) between src0 and src1 and stores the scalar result in the first channel of the 2-tuple in dst.\n"
            "\n"
            "The results are also stored in the accumulator register. The destination operand and the accumulator maintain 16 bits per channel precision.\n"
            "\n"
            "The destination register must be aligned to even word (DWord). The even words in the destination region will contain the correct data. The odd words are also written but with undefined values.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] sad2[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // W,UW <- B,UB
                {TYPE(Type::W)|TYPE(Type::UW),TYPE(Type::B)|TYPE(Type::UB)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::401 */ {Op::SADA2, "sada2", "sada2", 0x51, "Sum of Absolute Difference Accumulate 2",
            "The sada2 instruction takes source data channels from src0 and src1 in groups of 2-tuples. For each 2-tuple, it computes the sum-of-absolute-difference (SAD) between src0 and src1, adds the intermediate result with the accumulator value corresponding to the first channel, and stores the scalar result in the first channel of the 2-tuple in dst.\n"
            "\n"
            "The destination operand and the accumulator maintain 16 bits per channel precision. Higher precision (guide bits) stored in the accumulator allows up to 64 rounds of sada2 instructions to be issued back to back without overflowing the accumulator.\n"
            "\n"
            "The destination register must be aligned to even word (DWord). The even words in the destination region will contain the correct data. The odd words are also written but with undefined values.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] sada2[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // W,UW <- B,UB
                {TYPE(Type::W)|TYPE(Type::UW),TYPE(Type::B)|TYPE(Type::UB)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::402 */ {Op::SEL, "sel", "sel", 0x2, "Select",
            "The sel instruction selectively moves the components in src0 or src1 into the channels of dst based on the predication. On a channel by channel basis, if the channel condition is true, data in src0 is moved into dst. Otherwise, data in src1 is moved into dst.\n"
            "\n"
            "\n"
            "As the predication is used to select the two sources, it is not included in the evaluation of WrEn. The predicate clause is mandatory if cmod is omitted/0000b. If both predication and the conditional modifier are omitted, the results are undefined.\n"
            "\n"
            "\n"
            "If the conditional modifier is specified (not 0000b, a compare is performed and the resulting condition flag is used for the sel instruction. Conditional modifiers .ge and .l follow the cmpn rules, and all other conditional modifiers follow the cmp rules. Predication is not allowed in this mode.\n"
            "\n"
            "\n"
            "A sel instruction with cmod .l is used to emulate a MIN instruction.\n"
            "\n"
            "\n"
            "A sel instruction with cmod .ge is used to emulate a MAX instruction.\n"
            "\n"
            "\n"
            "For a sel instruction with a .l or .ge conditional modifier, if one source is NaN and the other not NaN, the non-NaN source is the result. If both sources are NaNs, the result is NaN. For all other conditional modifiers, if either source is NaN then src1 is selected.\n"
            "\n"
            "\n"
            "A sel instruction without a conditional modifier always copies a denorm source value to a denorm destination value (in the manner of a raw move). This applies even if the source modifies are set on the sel instruction sources.\n"
            "\n"
            "\n"
            "The sel instruction uses any conditional modifier internally and does not update the flag register if a conditional modifier is used.\n"
            "\n"
            "\n"
            "A sel instruction with cmod or source modifier will flush denorm to zero, depending on the denorm mode bit; a sel instruction without cmod and source modifier will retain denorm.\n"
            "\n"
            "\n"
            "Format:\n"
            "(pred) sel[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // F <- F
                {TYPE(Type::F),TYPE(Type::F)},
                // DF <- DF
                {TYPE(Type::DF),TYPE(Type::DF)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)},
                // HF <- HF
                {TYPE(Type::HF),TYPE(Type::HF)},
                // HF,F <- HF,F
                {TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::HF)|TYPE(Type::F)}
            },
            OpSpec::Attr::IS_SELECT|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::403 */ {Op::SEND, "send", "send", 0x31, "Send Message",
            "Send a message stored in GRF starting at <src> to a shared function identified by <ex_desc> along with control from <desc> with a GRF writeback location at <dest>.\n"
            "\n"
            "\n"
            "The send instruction performs data communication between a thread and external function units, including shared functions (Sampler, Data Port Read, Data Port Write, URB, and Message Gateway) and some fixed functions (e.g. Thread Spawner, who also have an unique Shared Function ID). The send instruction adds an entry to the EU\'s message request queue. The request message is stored in a block of contiguous GRF registers. The response message, if present, will be returned to a block of contiguous GRF registers. The return GRF writes may be in any order depending on the external function units. <src> is the lead GRF register for request. <dest> is the lead GRF register for response. The message descriptor field <desc> contains the Message Length (the number of consecutive GRF registers) and the Response Length (the number of consecutive GRF registers). It also contains the header present bit, and the function control signals. The extend mesage descriptor field <ex_desc> contains the target function ID. WrEn is forwarded to the target function in the message sideband.\n"
            "\n"
            "\n"
            "The extended message descriptor field <ex_desc> also contains the extended function control field to be sent to the Target Shared Function over message sideband.\n"
            "\n"
            "\n"
            "The send instruction is the only way to terminate a thread. When the EOT (End of Thread) bit of <ex_desc> is set, it indicates the end of thread to the EU, the Thread Dispatcher and, in most cases, the parent fixed function.\n"
            "Message descriptor field <desc> can be a 32-bit immediate, imm32, or a 32-bit scalar register, <reg32a>. GEN restricts that the 32-bit scalar register <reg32a> must be the leading dword of the address register. It should be in the form of a0.0<0;1,0>:ud. When <desc> is a register operand, only the lower 29 bits of <reg32a> are used.\n"
            "\n"
            "\n"
            "<ex_desc> is a 32-bit immediate, imm32. The lower 4bits of the <ex_desc> specifies the SFID for the message. The bit5 of the extended message descriptor, the EOT field, always comes from bit 127 of the instruction word. A thread must terminate with a send instruction with EOT turned on. The higher 16bits, bit31:16 specify the 16bit extended function control field. Interpretation of the extended function control signals is subject to the target external function.\n"
            "\n"
            "\n"
            "<src> is a 256-bit aligned GRF register. It serves as the leading GRF register of the request.\n"
            "\n"
            "\n"
            "The source dependency control, {NoSrcDepSet} is used to control the setting of source dependency for the source.\n"
            "\n"
            "\n"
            "<dest> serves for two purposes: to provide the leading GRF register location for the response message if present, and to provide parameters to form the channel enable sideband signals. <dest> signals whether there is a response to the message request. It can be either a null register, a direct-addressed GRF register or a register-indirect GRF register. Otherwise, hardware behavior is undefined. If <dest> is null, there is no response to the request. Meanwhile, the Response Length field in <desc> must be 0. Certain types of message requests, such as memory write (store) through the Data Port, do not want response data from the function unit. If so, the posted destination operand can be null. If <dest> is a GRF register, the register number is forwarded to the shared function. In this case, the target function unit must send one or more response message phases back to the requesting thread. The number of response message phases must match the Response Length field in <desc>, which of course cannot be zero. For some cases, it could be an empty return message. An empty return message is defined as a single phase message with all channel enables turned off. The subregister number, horizontal stride, destination mask and type fields of <dest> are always valid and are used in part to generate on the WrEn. This is true even if <dest> is a null register (this is an exception for null as for most cases these fields are ignored by hardware). The 16-bit channel enables of the message sideband are formed based on the WrEn. Interpretation of the channel enable sideband signals is subject to the target external function. In general for a \'send\' instruction with return messages, they are used as the destination dword write mask for the GRF registers starting at <dest>. For a message that has multiple return phases, the same set of channel enable signals applies to all the return phases. The destination dependency control, {NoDDClr}, can be used in this instruction. This allows software to control the destination dependencies for multiple \'read\'-type messages similar to that for multiple instructions using EU execution pipeline. As send does not check register dependencies for the post destination, {NoDDChk} should not be used for this instruction.\n",
            OpSpec::Format::SEND_UNARY, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::404 */ {Op::SENDC, "sendc", "sendc", 0x32, "Conditional Send Message",
            "The sendc instruction has the same behavior as the send instruction except the following.\n"
            "sendc first checks the dependent threads inside the Thread Dependency Register. There are up to 8 dependent threads in the TDR register. The sendc instruction executes only when all the dependent threads in the TDR register are retired.\n"
            "Wait for dependencies in the TDR Register to clear, then send a message stored in registers starting at src to a shared function identified by exdesc along with control from desc with a general register writeback location at dst.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] sendc (exec_size) dst src0 exdesc desc\n",
            OpSpec::Format::SEND_UNARY, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::405 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::406 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::407 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::408 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::409 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::410 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::411 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::412 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::413 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::414 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::415 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::416 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::417 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::418 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::419 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::420 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::421 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::422 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::423 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::424 */ {Op::SENDS, "sends", "sends", 0x33, "Split Send Message",
            "The sends instruction performs data communication between a thread and external function units, including shared functions (Sampler, Data Port Read, Data Port Write, URB, and Message Gateway) and some fixed functions (e.g. Thread Spawner, who also have an unique Shared Function ID). The sends instruction adds an entry to the EU\'s message request queue. The request message is stored in a block of contiguous GRF registers. The response message, if present, will be returned to a block of contiguous GRF registers. The return GRF writes may be in any order depending on the external function units. <src0> and <src1> are the lead GRF registers for the first and second block of the request respectively. <dest> is the lead GRF register for response. The message descriptor field <desc> contains the Message Length (the number of consecutive GRF registers corresponding to src0) and the Response Length (the number of consecutive GRF registers). It also contains the header present bit, and the function control signals. The extend message descriptor field <ex_desc> contains the target function ID, the Extended Message Length (the number of consecutive GRF registers corresponding to src1) and the extended function control signals. WrEn is forwarded to the target function in the message sideband.\n"
            "The sends instruction is the only way to terminate a thread. When the EOT (End of Thread) bit of <ex_desc> is set, it indicates the end of thread to the EU, the Thread Dispatcher and, in most cases, the parent fixed function.\n"
            "\n"
            "\n"
            "Message descriptor field <desc> can be a 32-bit immediate, imm32, or a 32-bit scalar register, <reg32a>. GEN restricts that the 32-bit scalar register <reg32a> must be the leading dword of the address register. It should be in the form of a0.0<0;1,0>:ud. When <desc> is a register operand, only the lower 31 bits of <reg32a> are used.\n"
            "\n"
            "\n"
            "Extended Message descriptor field <ex_desc> can be a 32-bit immediate, imm32 only. The bits3:0 of the <ex_desc> specifies the SFID for the message.The EOT field always comes from bit127 of the instruction word, which is the bit5 of <ex_desc>. A thread must terminate with a sends instruction with EOT turned on. The bits9:6 of <ex_desc> specify the extended message length and bits31:16 specify the 16bit extended function control. Interpretation of the extended function control signals is subject to the target external function.</ex_desc></ex_desc></ex_desc></ex_desc>\n"
            "\n"
            "\n"
            "Extended Message descriptor field <ex_desc> can be a 32-bit immediate, imm32 or a 32bit scalar register, <reg32a>. The bits3:0 of the <ex_desc> specifies the SFID for the message.The EOT field always comes from bit127 of the instruction word, which is the bit5 of <ex_desc>. A thread must terminate with a sends instruction with EOT turned on. The bits9:6 of <ex_desc> specify the extended message length and bits31:12 specify the 20bit extended function control. Interpretation of the extended function control signals is subject to the target external function. The scalar register <reg32a> is selected when SelReg32ExDesc is set, ExDesc.RegNum[3:0] provides the addressing for reg32a for extended message descriptor. This selects one of the index sub registers. Subregisters selected are always aligned to dword. This implies, the even index subregisters must be used.</reg32a></ex_desc></ex_desc></ex_desc></reg32a></ex_desc>\n"
            "\n"
            "\n"
            "Function control is now extended to 20 bits as specified in the below definition.\n"
            "\n"
            "\n"
            "Function control is now extended to 20 bits as specified in the below definition.\n"
            "\n"
            "\n"
            "The sum of Message Length and Extended Message Length must not be greater than 31.\n"
            "\n"
            "\n"
            "<src0> is a 256-bit aligned GRF register. It serves as the leading GRF register of the request.\n"
            "\n"
            "\n"
            "<src1> is a 256-bit aligned GRF register or a null register. It serves as the leading GRF register for the second block of the request when it is not a null register. It is required that the second block of GRFs does not overlap with the first block. If it is a null register the Extended Message Length must be 0. The sum of Message Length and Extended Message Length must not be greater than 15 on SKL.\n"
            "\n"
            "\n"
            "The source dependency control, {NoSrcDepSet} is used to control the setting of source dependency for both the sources.\n"
            "\n"
            "\n"
            "<dest> serves for two purposes: to provide the leading GRF register location for the response message if present, and to provide parameters to form the channel enable sideband signals.\n"
            "\n"
            "\n"
            "<dest> signals whether there is a response to the message request. It can be either a null register, a direct-addressed GRF register or a register-indirect GRF register. Otherwise, hardware behavior is undefined.\n"
            "\n"
            "\n"
            "If <dest> is null, there is no response to the request. Meanwhile, the Response Length field in <desc> must be 0. Certain types of message requests, such as memory write (store) through the Data Port, do not want response data from the function unit. If so, the posted destination operand can be null.\n"
            "\n"
            "\n"
            "If <dest> is a GRF register, the register number is forwarded to the shared function. In this case, the target function unit must send one or more response message phases back to the requesting thread. The number of response message phases must match the Response Length field in <desc>, which of course cannot be zero. For some cases, it could be an empty return message. An empty return message is defined as a single phase message with all channel enables turned off.\n"
            "\n"
            "\n"
            "The destination type field is always valid and is used to generate the WrEn. This is true even if <dest> is a null register (this is an exception for null as for most cases these fields are ignored by hardware).\n"
            "\n"
            "\n"
            "The address immediates for indirect sources and destination must be oword aligned.\n"
            "\n"
            "\n"
            "The 16-bit channel enables of the message sideband are formed based on the WrEn. Interpretation of the channel enable sideband signals is subject to the target external function. In general for a \'sends\' instruction with return messages, they are used as the destination dword write mask for the GRF registers starting at <dest>. For a message that has multiple return phases, the same set of channel enable signals applies to all the return phases.\n"
            "\n"
            "\n"
            "NoDDClr and NoDDChk must not be used for send instruction.\n"
            "\n"
            "\n"
            "Send a message stored in GRF locations starting at <src0> followed by <src1> to a shared function identified by <ex_desc> along with control from <desc> and <ex_desc> with a GRF writeback location at <dest>.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] sends (exec_size) <dest> <src0> <src1> <ex_desc> <desc>\n",
            OpSpec::Format::SEND_BINARY, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::425 */ {Op::SENDSC, "sendsc", "sendsc", 0x34, "Conditional Split Send Message",
            "The sendsc instruction has the same behavior as the sends instruction except the following.\n"
            "sendsc first checks the dependent threads inside the Thread Dependency Register. There are up to 8 dependent threads in the TDR register. The sendsc instruction executes only when all the dependent threads in the TDR register are retired.\n"
            "\n"
            "\n"
            "Wait for dependencies in the TDR Register to clear, then send a message stored in GRF locations starting at <src0> followed by <src1> to a shared function identified by <ex_desc> along with control from <desc> and <ex_desc> with a GRF writeback location at <dest>.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] sendsc (exec_size) <dest> <src0> <src1> <ex_desc> <desc>\n",
            OpSpec::Format::SEND_BINARY, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::426 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::427 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::428 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::429 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::430 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::431 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::432 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::433 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::434 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::435 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::436 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::437 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::438 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::439 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::440 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::441 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::442 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::443 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::444 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::445 */ {Op::SHL, "shl", "shl", 0x9, "Shift Left",
            "Perform component-wise logical left shift of the bits in src0 by the shift count indicated in src1, storing the results in dst, inserting zero bits in the number of LSBs indicated by the shift count.\n"
            "\n"
            "Hardware detects overflow properly and uses it to perform any saturation operation on the result, as long as the shifted result is within 33 bits. Otherwise, the result is undefined.\n"
            "\n"
            "Note: For word and DWord operands, the accumulators have 33 bits.\n"
            "\n"
            "\n"
            "In QWord mode, the shift count is taken from the low six bits of src1 regardless of the src1 type and treated as an unsigned integer in the range 0 to 63. Otherwise the shift count is taken from the low five bits of src1 regardless of the src1 type and treated as an unsigned integer in the range 0 to 31. The operation uses QWord mode if src0 or dst has the Q or UQ type but not if src1 is the only operand with the Q or UQ type.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] shl[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::446 */ {Op::SHR, "shr", "shr", 0x8, "Shift Right",
            "Perform component-wise logical right shift with zero insertion of the bits in src0 by the shift count indicated in src1, storing the results in dst. Insert zero bits in the number of MSBs indicated by the shift count.\n"
            "\n"
            "src0 and dst can have different types and can be signed or unsigned.\n"
            "\n"
            "Note: For word and DWord operands, the accumulators have 33 bits.\n"
            "\n"
            "Note: For unsigned src0 types, shr and asr produce the same result.\n"
            "\n"
            "\n"
            "In QWord mode, the shift count is taken from the low six bits of src1 regardless of the src1 type and treated as an unsigned integer in the range 0 to 63. Otherwise the shift count is taken from the low five bits of src1 regardless of the src1 type and treated as an unsigned integer in the range 0 to 31. The operation uses QWord mode if src0 or dst has the Q or UQ type but not if src1 is the only operand with the Q or UQ type.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] shr[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,UW,UD <- UB,UW,UD
                {TYPE(Type::UB)|TYPE(Type::UW)|TYPE(Type::UD),TYPE(Type::UB)|TYPE(Type::UW)|TYPE(Type::UD)},
                // UW,UD <- UW,UD
                {TYPE(Type::UW)|TYPE(Type::UD),TYPE(Type::UW)|TYPE(Type::UD)},
                // UQ <- UW,UD
                {TYPE(Type::UQ),TYPE(Type::UW)|TYPE(Type::UD)},
                // UW,UD <- UQ
                {TYPE(Type::UW)|TYPE(Type::UD),TYPE(Type::UQ)},
                // UQ <- UQ
                {TYPE(Type::UQ),TYPE(Type::UQ)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::447 */ {Op::SMOV, "smov", "smov", 0xa, "Scattered Move",
            "The smov instruction moves the components in src0 into dst.\n"
            "\n"
            "For each enabled channel, copy src0 to dst. The immediate is used to selectively enable channels without using flags.\n"
            "\n"
            "When predication is enabled, the predicate mask is not generated from the flags. Instead, the immediate is used to mask the execution mask. If any channel is enabled as a result of this masking, the instruction is executed.\n"
            "\n"
            "When predication is not enabled, the immediate masks the execution mask. This provides flexibility to mask out any channel with an immediate.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] smov[.cmod] (exec_size) dst src0 src1\n"
            "\n"
            "\n"
            "When predication is disabled, the immediate provides the flexibility to perform a select operation without the use of flags.\n"
            "\n"
            "\n"
            "When predication is enabled, the usage model provides flexibility to select any bit in the flag registers for predication for execution size of 1.\n",
            OpSpec::Format::BASIC_BINARY_REG_IMM, {
                // UW,W,UD,D,HF,F <- UW,W,UD,D,HF,F
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)|TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)|TYPE(Type::HF)|TYPE(Type::F)},
                // UQ,Q,DF <- UW,W,UD,D,HF,F
                {TYPE(Type::UQ)|TYPE(Type::Q)|TYPE(Type::DF),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)|TYPE(Type::HF)|TYPE(Type::F)},
                // UW,W,UD,D,HF,F <- UQ,Q,DF
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)|TYPE(Type::HF)|TYPE(Type::F),TYPE(Type::UQ)|TYPE(Type::Q)|TYPE(Type::DF)},
                // UQ,Q,DF <- UQ,Q,DF
                {TYPE(Type::UQ)|TYPE(Type::Q)|TYPE(Type::DF),TYPE(Type::UQ)|TYPE(Type::Q)|TYPE(Type::DF)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::448 */ {Op::SUBB, "subb", "subb", 0x4f, "Integer Subtraction with Borrow",
            "The subb instruction performs component-wise subtraction of src0 and src1 and stores the results in dst, it also stores the borrow into acc.\n"
            "\n"
            "If the operation produces a borrow (src0 < src1), write 0x00000001 to acc, else write 0x00000000 to acc.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] subb[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)}
            },
            OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SATURATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::449 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::450 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::451 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::452 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::453 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::454 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::455 */ {Op::INVALID, nullptr, nullptr, 0x0, nullptr, nullptr, OpSpec::Format::INVALID, {}, OpSpec::Attr::NONE, Op::INVALID, Op::INVALID, 0, -1, {{nullptr,0,0},{nullptr,0,0}}},
        /* Op::456 */ {Op::WAIT, "wait", "wait", 0x30, "Wait Notification",
            "The wait instruction evaluates the value of the notification count register nreg. If nreg is zero, thread execution is suspended and the thread is put in \'wait_for_notification\' state. If nreg is not zero (i.e., one or more notifications have been received), nreg is decremented by one and the thread continues executing on the next instruction. If a thread is in the \'wait_for_notification\' state, when a notification arrives, the notification count register is incremented by one. As the notification count register becomes nonzero, the thread wakes up to continue execution and at the same time the notification register is decremented by one. If only one notification arrived, the notification register value becomes zero. However, during the above mentioned time period, it is possible that more notifications may arrive, making the notification register nonzero again.\n"
            "\n"
            "When multiple notifications are received, software must use wait instructions to decrement notification count registers for each notification.\n"
            "\n"
            "Notification register n0.0:ud is for thread to thread communication (via the Message Gateway shared function) and n0.1:ud for host to thread communication (through MMIO registers). See the Message Gateway chapter for thread-thread communication and the Debug chapter for host-to-thread communication.\n"
            "\n"
            "\n"
            "Format:\n"
            "wait (exec_size) nreg\n",
            OpSpec::Format::SYNC_UNARY, {
                // UD <- UD
                {TYPE(Type::UD),TYPE(Type::UD)}
            },
            OpSpec::Attr::NONE,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::457 */ {Op::WHILE, "while", "while", 0x27, "While",
            "The while instruction marks the end of a do-while block. The instruction first evaluates the loop termination condition for each channel based on the current channel enables and the predication flags specified in the instruction. If any channel has not terminated, a branch is taken to a destination address specified in the instruction, and the loop continues for those channels. Otherwise, execution continues to the next instruction.ld point to the first instruction with the do label of the do-while block of code. It should be a negative number for the backward referencing.\n"
            "\n"
            "If SPF is ON, none of the PcIP are updated.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] while (exec_size) JIP\n",
            OpSpec::Format::JUMP_UNARY_IMM, { }, // no type mappings
            OpSpec::Attr::SUPPORTS_PREDICATION,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */},
        /* Op::458 */ {Op::XOR, "xor", "xor", 0x7, "Logic Xor",
            "The xor instruction performs component-wise logic XOR operation between src0 and src1 and stores the results in dst.\n"
            "\n"
            "This operation does not produce sign or overflow conditions. Only the .e/.z or .ne/.nz conditional modifiers should be used.\n"
            "\n"
            "\n"
            "Register source operands can use source modifiers:\n"
            "Any source modifier is logical, optionally changing a source value s to ~s (inverting all source bits). This capability allows expressions like a XOR (NOT b) to be calculated with one instruction.\n"
            "\n"
            "\n"
            "Format:\n"
            "[(pred)] xor[.cmod] (exec_size) dst src0 src1\n",
            OpSpec::Format::BASIC_BINARY_REG_REGIMM, {
                // UB,B,UW,W,UD,D <- UB,B,UW,W,UD,D
                {TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UB)|TYPE(Type::B)|TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UW,W,UD,D
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UQ,Q <- UW,W,UD,D
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D)},
                // UW,W,UD,D <- UQ,Q
                {TYPE(Type::UW)|TYPE(Type::W)|TYPE(Type::UD)|TYPE(Type::D),TYPE(Type::UQ)|TYPE(Type::Q)},
                // UQ,Q <- UQ,Q
                {TYPE(Type::UQ)|TYPE(Type::Q),TYPE(Type::UQ)|TYPE(Type::Q)}
            },
            OpSpec::Attr::IS_BITWISE|OpSpec::Attr::SUPPORTS_PREDICATION|OpSpec::Attr::SUPPORTS_FLAGMODIFIER|OpSpec::Attr::SUPPORTS_SRCMODS,
            Op::INVALID /* groupOp */,
            Op::INVALID /* subopsStart */,
            0 /*subopsLength */,
            -1 /* functionControlValue = N/A */,
            {{nullptr,0,0},{nullptr,0,0}} /* functionControlFields */}
    };

    static const iga::Model MODEL_GEN10 = {
        iga::Platform::GEN10, "10", "CNL", &MODEL_GEN10_OPSPECS[0]
    }; // end GEN10 initializer
} // namespace iga


#endif // IGA_MODELS10_HPP

