// Copyright (c) 2018 Intel Corporation
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <stddef.h>

#include "mfxstructures.h"
#include "mfxplugin.h"
#include "mfxenc.h"
#include "mfxpak.h"
#include "mfxfei.h"
#include "mfxjpeg.h"
#include "mfxla.h"
#include "mfxmvc.h"
#include "mfxvp8.h"
#include "mfxvideo.h"


/* .cpp instead of .h to avoid changing of include files dependencies graph
    and not to include unnecessary includes into libmfx library             */

/*  VC's IntelliSense calculates sizeof(object*) wrongly and marks several expressions by red lines. This is IntelliSense bug not ours*/

#define MSDK_STATIC_ASSERT(COND, MSG)  static_assert(COND, MSG);
#define MSDK_STATIC_ASSERT_STRUCT_SIZE(STRUCT, SIZE) MSDK_STATIC_ASSERT(sizeof(STRUCT) == SIZE, "size_of_"#STRUCT"_is_fixed");
#define MSDK_STATIC_ASSERT_STRUCT_OFFSET(STRUCT, FIELD, OFFSET) MSDK_STATIC_ASSERT(offsetof(STRUCT, FIELD) == OFFSET,"offset_of_"#FIELD"_of_"#STRUCT"_is_fixed");
//mfxastructures.h
#if defined (__MFXASTRUCTURES_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioInfoMFX           ,192  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioParam             ,240  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioAllocRequest      ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioFrame             ,64   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioInfoMFX           ,192  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioParam             ,232  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioAllocRequest      ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioFrame             ,56   )
    #endif
#endif //defined (__MFXASTRUCTURES_H__)


//mfxcommon.h
#if defined (__MFXCOMMON_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtBuffer              ,8    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVersion                ,4    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBitstream              ,72   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInitParam              ,80   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtThreadsParam        ,132  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPlatform               ,32   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtBuffer              ,8    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVersion                ,4    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBitstream              ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInitParam              ,68   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtThreadsParam        ,132  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPlatform               ,32   )
    #endif
#endif //defined (__MFXCOMMON_H__)

//mfxdefs.h
#if defined (__MFXDEFS_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxI16Pair                ,4    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxHDLPair                ,16   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxStatus                 ,4    )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxI16Pair                ,4    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxHDLPair                ,8    )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxStatus                 ,4    )
    #endif
#endif //defined (__MFXCOMMON_H__)

//mfxenc.h
#if defined (__MFXENC_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(_mfxENCInput               ,184)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(_mfxENCOutput              ,152)
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(_mfxENCInput               ,156)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(_mfxENCOutput              ,140)
    #endif
#endif //defined (__MFXENC_H__)

//mfxfei.h
#if defined (__MFXFEI_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncCtrl        ,128)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncMVPredictors,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncQP             ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncMV          ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncMBStat      ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncFrameCtrl      ,128)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMVPredictors   ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMBCtrl         ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMV             ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMBStat         ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFeiPakMBCtrl            ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPakMBCtrl         ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiRepackCtrl        ,40 )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiRepackStat        ,128)
#endif
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFeiDecStreamOutMBCtrl   ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiDecStreamOut      ,72 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiSPS               ,256)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPPS               ,768)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiSliceHeader       ,40 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiCodingOption      ,128)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFeiFunction             ,4  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiParam             ,128)
#if (MFX_VERSION >= 1023)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKInput                ,136)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKOutput               ,96)
#else
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKInput                ,184)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKOutput               ,32)
#endif
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncCtrl        ,120)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncMVPredictors,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncQP             ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncMV          ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPreEncMBStat      ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncFrameCtrl      ,128)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMVPredictors   ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMBCtrl         ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMV             ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiEncMBStat         ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFeiPakMBCtrl            ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPakMBCtrl         ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiRepackCtrl        ,40 )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiRepackStat        ,128)
#endif
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFeiDecStreamOutMBCtrl   ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiDecStreamOut      ,68 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiSPS               ,256)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiPPS               ,768)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiSliceHeader       ,36 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiCodingOption      ,128)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFeiFunction             ,4  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtFeiParam             ,128)
#if (MFX_VERSION >= 1023)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKInput                ,100)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKOutput               ,80 )
#else
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKInput                ,156)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPAKOutput               ,16 )
#endif
    #endif
#endif //defined (__MFXFEI_H__)

//mfxjpeg.h
#if defined (__MFX_JPEG_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGQuantTables      ,536  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGHuffmanTables    ,840  )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGQuantTables      ,536  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGHuffmanTables    ,840  )
    #endif
#endif //defined (__MFX_JPEG_H__)

//mfxla.h
#if defined (__MFXLA_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtLAControl            ,576  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxLAFrameInfo             ,496  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtLAFrameStatistics    ,72   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtLAControl            ,576  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxLAFrameInfo             ,496  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtLAFrameStatistics    ,64   )
    #endif
#endif //defined (__MFXLA_H__)

//mfxmvc.h
#if defined (__MFXMVC_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCViewDependency       ,138  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCOperationPoint       ,16   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCSeqDesc           ,128  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCTargetViews       ,2064 )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCViewDependency       ,138  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCOperationPoint       ,12   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCSeqDesc           ,112  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCTargetViews       ,2064 )
    #endif
#endif //defined (__MFXMVC_H__)


//mfxplugin.h
#if defined (__MFXPLUGIN_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPluginParam      ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPluginUID        ,16 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPluginType       ,4  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxThreadPolicy     ,4  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCoreParam        ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCoreInterface    ,256)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoCodecPlugin ,160)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioCodecPlugin ,152)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPlugin           ,128)
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPluginParam      ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPluginUID        ,16 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPluginType       ,4  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxThreadPolicy     ,4  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCoreParam        ,64 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCoreInterface    ,144)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoCodecPlugin ,96 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAudioCodecPlugin, 92 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPlugin           ,64 )
    #endif
#endif //defined (__MFXPLUGIN_H__)


//mfxstructures.h
#if defined (__MFXSTRUCTURES_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameId                   ,8   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameInfo                 ,68  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameData                 ,96  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameSurface1             ,184 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoMFX                   ,136 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoVPP                   ,168 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoParam                ,208 ) //IntelliSense wrongly marks this line
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption           ,64  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption2          ,68  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption3          ,512 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoNotUse            ,24  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDenoise             ,12  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDetail              ,12  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPProcAmp             ,40  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeStat                ,88  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecodeStat                ,80  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPStat                   ,72  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppAuxData             ,20  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPayload                   ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeCtrl                ,56  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocRequest         ,92  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocResponse        ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOptionSPSPPS     ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVideoSignalInfo        ,20  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoUse               ,24  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtOpaqueSurfaceAlloc     ,80  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefListCtrl         ,1068)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFrameRateConversion ,72  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPImageStab           ,32  )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMasteringDisplayColourVolume,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtContentLightLevelInfo       ,32   )
#endif
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPictureTimingSEI       ,160 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAvcTemporalLayers      ,92  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderCapability      ,128 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderResetOption     ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCEncodedFrameInfo    ,1056)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPCompInputStream        ,64  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPComposite           ,72   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPVideoSignalInfo     ,48  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderROI             ,8224)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDeinterlacing       ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefLists            ,1040 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFieldProcessing     ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecVideoProcessing     ,132  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtChromaLocInfo          ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBQP                   ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBForceIntra           ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCTiles              ,160  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBDisableSkipMap       ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCParam              ,256  )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodeErrorReport      ,32   )
#endif
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodedFrameInfo       ,128  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTimeCode               ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCRegion             ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPredWeightTable        ,1152 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDirtyRect              ,8224 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMoveRect               ,8224 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPRotation            ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedSlicesInfo      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPScaling             ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPMirroring           ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVOverPicBoundaries    ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPColorFill           ,32   )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtColorConversion        ,64   )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9SegmentParam           ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Segmentation        ,384  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9TemporalLayer          ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9TemporalLayers      ,384  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Param               ,256  )
#endif
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMultiFrameParam        ,128  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMultiFrameControl      ,128  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodedUnitInfo           ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedUnitsInfo       ,64  )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppMctf                ,64   )
#endif
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameId                   ,8   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameInfo                 ,68  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameData                 ,72  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameSurface1             ,160 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoMFX                   ,136 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoVPP                   ,168 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoParam                ,196 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption           ,64  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption2          ,68  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption3          ,512 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoNotUse            ,16  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDenoise             ,12  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDetail              ,12  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPProcAmp             ,40  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeStat                ,88  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecodeStat                ,80  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPStat                   ,72  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppAuxData             ,20  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPayload                   ,28  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeCtrl                ,48  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocRequest         ,92  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocResponse        ,24  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOptionSPSPPS     ,24  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVideoSignalInfo        ,20  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoUse               ,16  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtOpaqueSurfaceAlloc     ,72  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefListCtrl         ,1068)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFrameRateConversion ,72  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPImageStab           ,32  )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMasteringDisplayColourVolume ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtContentLightLevelInfo        ,32   )
#endif
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPictureTimingSEI       ,160 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAvcTemporalLayers      ,92  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderCapability      ,128 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderResetOption     ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCEncodedFrameInfo    ,1056)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPCompInputStream        ,64  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPComposite           ,68   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPVideoSignalInfo     ,48  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderROI             ,8224)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDeinterlacing       ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefLists            ,1040 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFieldProcessing     ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecVideoProcessing     ,132  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtChromaLocInfo          ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBQP                   ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBForceIntra           ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCTiles              ,160  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBDisableSkipMap       ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCParam              ,256  )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodeErrorReport      ,32   )
#endif
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodedFrameInfo       ,128  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTimeCode               ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCRegion             ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPredWeightTable        ,1152 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDirtyRect              ,8224 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMoveRect               ,8224 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPRotation            ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedSlicesInfo      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPScaling             ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPMirroring           ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVOverPicBoundaries    ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPColorFill           ,32   )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtColorConversion        ,64   )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9SegmentParam           ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Segmentation        ,384  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9TemporalLayer          ,32   )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9TemporalLayers      ,384  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Param               ,256  )
#endif
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMultiFrameParam        ,128 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMultiFrameControl      ,128 )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodedUnitInfo           ,32  )
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedUnitsInfo       ,64  )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppMctf                ,64  )
#endif
    #endif
#endif //defined (__MFXSTRUCTURES_H__)

//mfxvideo.h
#if defined (__MFXVIDEO_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBufferAllocator ,56)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocator  ,64)
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBufferAllocator ,36)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocator  ,40)
    #endif
#endif //defined (__MFXVIDEO_H__)

//mfxvp8.h
#if defined (__MFXVP8_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP8CodingOption        ,516  )

    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP8CodingOption        ,516  )
    #endif
#endif //defined (__MFXVP8_H__)


// Offsets
//mfxastructures.h
#if defined (__MFXASTRUCTURES_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,CodecId                    ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,CodecProfile               ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,CodecLevel                 ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,Bitrate                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,SampleFrequency            ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,NumChannel                 ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,BitPerSample               ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,FlagPSSupportLev           ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,Layer                      ,66   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,AACHeaderDataSize          ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,AACHeaderData              ,70   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,OutputFormat               ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,StereoMode                 ,66   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,AsyncDepth                 ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,Protected                  ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,mfx                        ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,ExtParam                   ,224  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,NumExtParam                ,232  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioAllocRequest                  ,SuggestedInputSize         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioAllocRequest                  ,SuggestedOutputSize        ,4    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,TimeStamp                  ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,Locked                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,NumChannels                ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,SampleFrequency            ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,BitPerSample               ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,Data                       ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,DataLength                 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,MaxLength                  ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,NumExtParam                ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,ExtParam                   ,56   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,CodecId                    ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,CodecProfile               ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,CodecLevel                 ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,Bitrate                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,SampleFrequency            ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,NumChannel                 ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,BitPerSample               ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,FlagPSSupportLev           ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,Layer                      ,66   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,AACHeaderDataSize          ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,AACHeaderData              ,70   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,OutputFormat               ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioInfoMFX                       ,StereoMode                 ,66   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,AsyncDepth                 ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,Protected                  ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,mfx                        ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,ExtParam                   ,224  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioParam                         ,NumExtParam                ,228  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioAllocRequest                  ,SuggestedInputSize         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioAllocRequest                  ,SuggestedOutputSize        ,4    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,TimeStamp                  ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,Locked                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,NumChannels                ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,SampleFrequency            ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,BitPerSample               ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,Data                       ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,DataLength                 ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,MaxLength                  ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,NumExtParam                ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAudioFrame                         ,ExtParam                   ,52   )
    #endif
#endif //defined (__MFXASTRUCTURES_H__)


//mfxcommon.h
#if defined (__MFXCOMMON_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferId                      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferSz                      ,4    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Minor                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Major                         ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Version                       ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,EncryptedData                 ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,ExtParam                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,NumExtParam                   ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DecodeTimeStamp               ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,TimeStamp                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,Data                          ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataOffset                    ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataLength                    ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,MaxLength                     ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,PicStruct                     ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,FrameType                     ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataFlag                      ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Implementation                ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Version                       ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExternalThreads               ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExtParam                      ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,NumExtParam                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,GPUCopy                       ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,NumThread                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,SchedulingType                ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Priority                      ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,CodeName                      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,DeviceId                      ,2    )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferId                      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferSz                      ,4    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Minor                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Major                         ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Version                       ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,EncryptedData                 ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,ExtParam                      ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,NumExtParam                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DecodeTimeStamp               ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,TimeStamp                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,Data                          ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataOffset                    ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataLength                    ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,MaxLength                     ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,PicStruct                     ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,FrameType                     ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataFlag                      ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Implementation                ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Version                       ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExternalThreads               ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExtParam                      ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,NumExtParam                   ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,GPUCopy                       ,24   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,NumThread                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,SchedulingType                ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Priority                      ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,CodeName                      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,DeviceId                      ,2    )
    #endif
#endif //defined (__MFXCOMMON_H__)

//mfxdefs.h
#if defined (__MFXDEFS_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,x                             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,y                             ,2    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,first                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,second                        ,8    )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,x                             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,y                             ,2    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,first                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,second                        ,4    )
    #endif
#endif //defined (__MFXDEFS_H__)

//mfxstructures.h
#if defined (__MFXSTRUCTURES_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,TemporalId                    ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,PriorityId                    ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,DependencyId                  ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,QualityId                     ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,ViewId                        ,4    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameId                       ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthLuma                  ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthChroma                ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Shift                         ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FourCC                        ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Width                         ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Height                        ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropX                         ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropY                         ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropW                         ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropH                         ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BufferSize                    ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtN                 ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtD                 ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioW                  ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioH                  ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,PicStruct                     ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,ChromaFormat                  ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,ExtParam                      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,NumExtParam                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemType                       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchHigh                     ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,TimeStamp                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,FrameOrder                    ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Locked                        ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Pitch                         ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchLow                      ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y                             ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y16                           ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,R                             ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,UV                            ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,VU                            ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CbCr                          ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CrCb                          ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cb                            ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U                             ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U16                           ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,G                             ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cr                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V                             ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V16                           ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,B                             ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,A                             ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemId                         ,80   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Corrupted                     ,88   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,DataFlag                      ,90   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Info                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Data                          ,88   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,LowPower                      ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BRCParamMultiplier            ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,FrameInfo                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecId                       ,100  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecProfile                  ,104  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecLevel                    ,106  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumThread                     ,108  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetUsage                   ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopPicSize                    ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopRefDist                    ,114  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopOptFlag                    ,116  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,IdrInterval                   ,118  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RateControlMethod             ,120  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InitialDelayInKB              ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPI                           ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Accuracy                      ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BufferSizeInKB                ,124  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetKbps                    ,126  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPP                           ,126  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ICQQuality                    ,126  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxKbps                       ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPB                           ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Convergence                   ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumSlice                      ,130  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumRefFrame                   ,132  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EncodedOrder                  ,134  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,DecodedOrder                  ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ExtendedPicStruct             ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TimeStampCalc                 ,114  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SliceGroupsPresent            ,116  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxDecFrameBuffering          ,118  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EnableReallocRequest          ,120  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGChromaFormat              ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Rotation                      ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGColorFormat               ,114  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InterleavedDec                ,116  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorH               ,118  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorV               ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Interleaved                   ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Quality                       ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RestartInterval               ,114  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,In                            ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,Out                           ,100  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AllocId                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,mfx                           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,vpp                           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AsyncDepth                    ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,Protected                     ,184  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,IOPattern                     ,186  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,ExtParam                      ,192  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,NumExtParam                   ,200  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RateDistortionOpt             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MECostType                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MESearchType                  ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVSearchWindow                ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfSequence                 ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FramePicture                  ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,CAVLC                         ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RecoveryPointSEI              ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ViewOutput                    ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,NalHrdConformance             ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,SingleSeiNalUnit              ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiVclHrdParameters           ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicListReordering          ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ResetRefList                  ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicMarkRep                 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FieldOutput                   ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,IntraPredBlockSize            ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,InterPredBlockSize            ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVPrecision                   ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MaxDecFrameBuffering          ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,AUDelimiter                   ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfStream                   ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,PicTimingSEI                  ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiNalHrdParameters           ,62   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefType                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefCycleSize               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefQPDelta                 ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxFrameSize                  ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxSliceSize                  ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BitrateLimit                  ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MBBRC                         ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,ExtBRC                        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDepth                ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Trellis                       ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,RepeatPPS                     ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BRefType                      ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveI                     ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveB                     ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDS                   ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,NumMbPerSlice                 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,SkipFrame                     ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPI                        ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPI                        ,49   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPP                        ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPP                        ,51   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPB                        ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPB                        ,53   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,FixedFrameRate                ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableDeblockingIdc          ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableVUI                    ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BufferingPeriodSEI            ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,EnableMAD                     ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,UseRawRef                     ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceI                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceP                     ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceB                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCMaxAvgKbps              ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCSize                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QVBRQuality                   ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBQP                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,IntRefCycleDist               ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,DirectBiasAdjustment          ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GlobalMotionBiasAdjustment    ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MVCostScalingFactor           ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MBDisableSkipMap              ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedPred                  ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedBiPred                ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AspectRatioInfoPresent        ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanInfoPresent           ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanAppropriate           ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TimingInfoPresent             ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BitstreamRestriction          ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayHrd                   ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MotionVectorsOverPicBoundaries,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ScenarioInfo                  ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ContentInfo                   ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,PRefType                      ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,FadeDetection                 ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GPB                           ,66   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeI                 ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeP                 ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableQPOffset                ,88   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QPOffset                      ,90   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveP                 ,106  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL0               ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL1               ,138  )
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TransformSkip                 ,156  )
#endif
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BRCPanicMode                  ,164  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayBRC                   ,166  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBForceIntra            ,168  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveMaxFrameSize          ,170  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,RepartitionCheckEnable        ,172  )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EncodedUnitsInfo              ,180  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableNalUnitType             ,182  )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ExtBrcAdaptiveLTR             ,184  )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,NumAlg                        ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,AlgList                       ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,DenoiseFactor                 ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,DetailFactor                  ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Brightness                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Contrast                      ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Hue                           ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Saturation                    ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumFrame                      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumBit                        ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumCachedFrame                ,80   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumFrame                      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumSkippedFrame               ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumError                      ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumCachedFrame                ,76   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumFrame                      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumCachedFrame                ,68   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SpatialComplexity             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,TemporalComplexity            ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,PicStruct                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SceneChangeRate               ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,RepeatedFrame                 ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,CtrlFlags                     ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Data                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,NumBit                        ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Type                          ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,BufSize                       ,30   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,SkipFrame                     ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,QP                            ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,FrameType                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumExtParam                   ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumPayload                    ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,ExtParam                      ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Payload                       ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,AllocId                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Info                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Type                          ,84   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameMin                   ,86   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameSuggested             ,88   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,AllocId                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,mids                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,NumFrameActual                ,24   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBuffer                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBuffer                     ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBufSize                    ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBufSize                    ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSId                         ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSId                         ,30   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS           ,VPSBuffer                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS           ,VPSBufSize                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS           ,VPSId                         ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFormat                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFullRange                ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourDescriptionPresent      ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourPrimaries               ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,TransferCharacteristics       ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,MatrixCoefficients            ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,NumAlg                        ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,AlgList                       ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In                            ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In.Surfaces                   ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In.Type                       ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In.NumSurface                 ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out                           ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out.Surfaces                  ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out.Type                      ,76   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out.NumSurface                ,78   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,Header                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL0Active              ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL1Active              ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList               ,12   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].FrameOrder ,12   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].PicStruct  ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].ViewId     ,18   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].LongTermIdx,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList                ,524  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].FrameOrder  ,524  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].PicStruct   ,528  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].ViewId      ,530  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].LongTermIdx ,532  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList                ,780  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].FrameOrder  ,780  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].PicStruct   ,784  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].ViewId      ,786  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].LongTermIdx ,788  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,ApplyLongTermIdx               ,1036 )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Algorithm                     ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Mode                          ,8    )

#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,Header                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,InsertPayloadToggle          ,38   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesX[0]            ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesY[0]            ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointX                  ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointY                  ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MaxDisplayMasteringLuminance ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MinDisplayMasteringLuminance ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,Header                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,InsertPayloadToggle          ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxContentLightLevel         ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxPicAverageLightLevel      ,30   )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,Header                          ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp                       ,64   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].ClockTimestampFlag ,64   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CtType             ,66   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NuitFieldBasedFlag ,68   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CountingType       ,70   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].FullTimestampFlag  ,72   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].DiscontinuityFlag  ,74   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CntDroppedFlag     ,76   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NFrames            ,78   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsFlag        ,80   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesFlag        ,82   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursFlag          ,84   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsValue       ,86   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesValue       ,88   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursValue         ,90   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].TimeOffset         ,92   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,BaseLayerPID                  ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer                         ,28   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer[0].Scale                ,28   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,MBPerSec                      ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,StartNewSequence              ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,FrameOrder                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,PicStruct                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,LongTermIdx                   ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,MAD                           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,BRCPanicMode                  ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,QP                            ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,SecondFieldOffset             ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0                 ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].FrameOrder   ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].PicStruct    ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].LongTermIdx  ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1                 ,544  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].FrameOrder   ,544  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].PicStruct    ,548  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].LongTermIdx  ,550  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstX                          ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstY                          ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstW                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstH                          ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyEnable                 ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMin                    ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMax                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlphaEnable             ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlpha                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,PixelAlphaEnable              ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,TileId                        ,28   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Y                             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,U                             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,V                             ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,R                             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,G                             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,B                             ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumTiles                      ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumInputStream                ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,InputStream                   ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In                            ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.TransferMatrix             ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.NominalRange               ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out                           ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.TransferMatrix            ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.NominalRange              ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,TransferMatrix                ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,NominalRange                  ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,NumROI                        ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROIMode                       ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI                           ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Left                   ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Top                    ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Right                  ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Bottom                 ,44   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Priority               ,48   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].DeltaQP                ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Mode                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecinePattern               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecineLocation              ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL0Active             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL1Active             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0                   ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].FrameOrder     ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].PicStruct      ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1                   ,528  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].FrameOrder     ,528  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].PicStruct      ,532  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Mode                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,InField                       ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,OutField                      ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropX                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropY                      ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropW                      ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropH                      ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.FourCC                    ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.ChromaFormat              ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Width                     ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Height                    ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropX                     ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropY                     ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropW                     ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropH                     ,58   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaLocInfoPresentFlag      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeTopField   ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeBottomField,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,NumQPAlloc                    ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,QP                            ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,MapSize                       ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Map                           ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileRows                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileColumns                ,10   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,MapSize                       ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Map                           ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicWidthInLumaSamples         ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicHeightInLumaSamples        ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,GeneralConstraintFlags        ,12   )
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,SampleAdaptiveOffset          ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,LCUSize                       ,22   )
#endif

#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,ErrorTypes                    ,8    )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,FrameType                     ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,DropFrameFlag                 ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeHours                 ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeMinutes               ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeSeconds               ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodePictures              ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionId                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionType                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionEncoding                ,14   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaLog2WeightDenom           ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaLog2WeightDenom         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaWeightFlag                ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaWeightFlag              ,140  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Weights                       ,268  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,NumRect                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect                          ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Left                  ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Top                   ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Right                 ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Bottom                ,44   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,NumRect                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect                          ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestLeft              ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestTop               ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestRight             ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestBottom            ,44   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceLeft            ,48   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceTop             ,52   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Angle                         ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSizeOverflow             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceNonCopliant           ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumEncodedSlice               ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceSizeAlloc             ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSize                     ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,ScalingMode                   ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Type                          ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickTop                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickBottom                   ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickLeft                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickRight                    ,14   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Enable                        ,8    )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,ChromaSiting                  ,8    )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,FeatureEnabled                ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,QIndexDelta                   ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,LoopFilterLevelDelta          ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,ReferenceFrame                ,6    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegments                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Segment                       ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentIdBlockSize            ,266  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegmentIdAlloc             ,268  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentId                     ,272  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,FrameRateScale                ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,TargetKbps                    ,2    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Layer                         ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameWidth                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameHeight                   ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,WriteIVFHeaders               ,12   )
#if (MFX_VERSION >= MFX_VERSION_NEXT)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,LoopFilterRefDelta            ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,LoopFilterModeDelta           ,22   )
#endif
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaLumaDC             ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaAC           ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaDC           ,30   )
#if (MFX_VERSION >= MFX_VERSION_NEXT)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileRows                   ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileColumns                ,34   )
#endif
#endif
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameParam        ,Header       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameParam        ,MFMode       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameParam        ,MaxNumFrames ,10   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameControl      ,Header       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameControl      ,Timeout      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameControl      ,Flush        ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo           ,Type         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo           ,Offset       ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo           ,Size         ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,Header         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,UnitInfo       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,NumUnitsAlloc  ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,NumUnitsEncoded,18   )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                ,Header         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                ,FilterStrength ,8    )
#endif
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,TemporalId                    ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,PriorityId                    ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,DependencyId                  ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,QualityId                     ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,ViewId                        ,4    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameId                       ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthLuma                  ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthChroma                ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Shift                         ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FourCC                        ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Width                         ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Height                        ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropX                         ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropY                         ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropW                         ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropH                         ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BufferSize                    ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtN                 ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtD                 ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioW                  ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioH                  ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,PicStruct                     ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,ChromaFormat                  ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,ExtParam                      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,NumExtParam                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemType                       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchHigh                     ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,TimeStamp                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,FrameOrder                    ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Locked                        ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Pitch                         ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchLow                      ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y                             ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y16                           ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,R                             ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,UV                            ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,VU                            ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CbCr                          ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CrCb                          ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cb                            ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U                             ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U16                           ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,G                             ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cr                            ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V                             ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V16                           ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,B                             ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,A                             ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemId                         ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Corrupted                     ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,DataFlag                      ,70   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Info                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Data                          ,88   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,LowPower                      ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BRCParamMultiplier            ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,FrameInfo                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecId                       ,100  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecProfile                  ,104  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecLevel                    ,106  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumThread                     ,108  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetUsage                   ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopPicSize                    ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopRefDist                    ,114  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopOptFlag                    ,116  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,IdrInterval                   ,118  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RateControlMethod             ,120  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InitialDelayInKB              ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPI                           ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Accuracy                      ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BufferSizeInKB                ,124  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetKbps                    ,126  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPP                           ,126  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ICQQuality                    ,126  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxKbps                       ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPB                           ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Convergence                   ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumSlice                      ,130  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumRefFrame                   ,132  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EncodedOrder                  ,134  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,DecodedOrder                  ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ExtendedPicStruct             ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TimeStampCalc                 ,114  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SliceGroupsPresent            ,116  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxDecFrameBuffering          ,118  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EnableReallocRequest          ,120  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGChromaFormat              ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Rotation                      ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGColorFormat               ,114  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InterleavedDec                ,116  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorH               ,118  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorV               ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Interleaved                   ,110  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Quality                       ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RestartInterval               ,114  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,In                            ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,Out                           ,100  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AllocId                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,mfx                           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,vpp                           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AsyncDepth                    ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,Protected                     ,184  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,IOPattern                     ,186  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,ExtParam                      ,188  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,NumExtParam                   ,192  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RateDistortionOpt             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MECostType                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MESearchType                  ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVSearchWindow                ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfSequence                 ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FramePicture                  ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,CAVLC                         ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RecoveryPointSEI              ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ViewOutput                    ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,NalHrdConformance             ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,SingleSeiNalUnit              ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiVclHrdParameters           ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicListReordering          ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ResetRefList                  ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicMarkRep                 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FieldOutput                   ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,IntraPredBlockSize            ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,InterPredBlockSize            ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVPrecision                   ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MaxDecFrameBuffering          ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,AUDelimiter                   ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfStream                   ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,PicTimingSEI                  ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiNalHrdParameters           ,62   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefType                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefCycleSize               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefQPDelta                 ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxFrameSize                  ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxSliceSize                  ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BitrateLimit                  ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MBBRC                         ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,ExtBRC                        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDepth                ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Trellis                       ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,RepeatPPS                     ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BRefType                      ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveI                     ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveB                     ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDS                   ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,NumMbPerSlice                 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,SkipFrame                     ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPI                        ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPI                        ,49   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPP                        ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPP                        ,51   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPB                        ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPB                        ,53   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,FixedFrameRate                ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableDeblockingIdc          ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableVUI                    ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BufferingPeriodSEI            ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,EnableMAD                     ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,UseRawRef                     ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceI                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceP                     ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceB                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCMaxAvgKbps              ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCSize                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QVBRQuality                   ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBQP                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,IntRefCycleDist               ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,DirectBiasAdjustment          ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GlobalMotionBiasAdjustment    ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MVCostScalingFactor           ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MBDisableSkipMap              ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedPred                  ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedBiPred                ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AspectRatioInfoPresent        ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanInfoPresent           ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanAppropriate           ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TimingInfoPresent             ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BitstreamRestriction          ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayHrd                   ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MotionVectorsOverPicBoundaries,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ScenarioInfo                  ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ContentInfo                   ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,PRefType                      ,58   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,FadeDetection                 ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GPB                           ,66   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeI                 ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeP                 ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableQPOffset                ,88   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QPOffset                      ,90   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveP                 ,106  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL0               ,122  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL1               ,138  )
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TransformSkip                 ,156  )
#endif
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BRCPanicMode                  ,164  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayBRC                   ,166  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBForceIntra            ,168  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveMaxFrameSize          ,170  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,RepartitionCheckEnable        ,172  )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EncodedUnitsInfo              ,180  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableNalUnitType             ,182  )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ExtBrcAdaptiveLTR             ,184  )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,NumAlg                        ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,AlgList                       ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,DenoiseFactor                 ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,DetailFactor                  ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Brightness                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Contrast                      ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Hue                           ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Saturation                    ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumFrame                      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumBit                        ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumCachedFrame                ,80   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumFrame                      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumSkippedFrame               ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumError                      ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumCachedFrame                ,76   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumFrame                      ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumCachedFrame                ,68   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SpatialComplexity             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,TemporalComplexity            ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,PicStruct                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SceneChangeRate               ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,RepeatedFrame                 ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,CtrlFlags                     ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Data                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,NumBit                        ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Type                          ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,BufSize                       ,26   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,SkipFrame                     ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,QP                            ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,FrameType                     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumExtParam                   ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumPayload                    ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,ExtParam                      ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Payload                       ,44   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,AllocId                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Info                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Type                          ,84   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameMin                   ,86   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameSuggested             ,88   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,AllocId                       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,mids                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,NumFrameActual                ,20   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBuffer                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBuffer                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBufSize                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBufSize                    ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSId                         ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSId                         ,22   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSBuffer                     ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSBufSize                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSId                         ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFormat                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFullRange                ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourDescriptionPresent      ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourPrimaries               ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,TransferCharacteristics       ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,MatrixCoefficients            ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,NumAlg                        ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,AlgList                       ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In                            ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In.Surfaces                   ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In.Type                       ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,In.NumSurface                 ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out                           ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out.Surfaces                  ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out.Type                      ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtOpaqueSurfaceAlloc           ,Out.NumSurface                ,70   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,Header                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL0Active              ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL1Active              ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList               ,12   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].FrameOrder ,12   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].PicStruct  ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].ViewId     ,18   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].LongTermIdx,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList                ,524  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].FrameOrder  ,524  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].PicStruct   ,528  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].ViewId      ,530  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].LongTermIdx ,532  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList                ,780  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].FrameOrder  ,780  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].PicStruct   ,784  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].ViewId      ,786  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].LongTermIdx ,788  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,ApplyLongTermIdx               ,1036 )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Algorithm                     ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Mode                          ,8    )

#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,InsertPayloadToggle           ,38   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesX[0]            ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesY[0]            ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointX                   ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointY                   ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MaxDisplayMasteringLuminance  ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MinDisplayMasteringLuminance  ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,InsertPayloadToggle           ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxContentLightLevel          ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxPicAverageLightLevel       ,30   )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,Header                          ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp                       ,64   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].ClockTimestampFlag ,64   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CtType             ,66   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NuitFieldBasedFlag ,68   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CountingType       ,70   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].FullTimestampFlag  ,72   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].DiscontinuityFlag  ,74   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CntDroppedFlag     ,76   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NFrames            ,78   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsFlag        ,80   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesFlag        ,82   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursFlag          ,84   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsValue       ,86   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesValue       ,88   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursValue         ,90   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].TimeOffset         ,92   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,BaseLayerPID                  ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer                         ,28   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer[0].Scale                ,28   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,MBPerSec                      ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,StartNewSequence              ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,FrameOrder                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,PicStruct                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,LongTermIdx                   ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,MAD                           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,BRCPanicMode                  ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,QP                            ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,SecondFieldOffset             ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0                 ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].FrameOrder   ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].PicStruct    ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].LongTermIdx  ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1                 ,544  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].FrameOrder   ,544  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].PicStruct    ,548  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].LongTermIdx  ,550  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstX                          ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstY                          ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstW                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstH                          ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyEnable                 ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMin                    ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMax                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlphaEnable             ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlpha                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,PixelAlphaEnable              ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,TileId                        ,28   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Y                             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,U                             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,V                             ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,R                             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,G                             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,B                             ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumTiles                      ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumInputStream                ,62   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,InputStream                   ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In                            ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.TransferMatrix             ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.NominalRange               ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out                           ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.TransferMatrix            ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.NominalRange              ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,TransferMatrix                ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,NominalRange                  ,18   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,NumROI                        ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROIMode                       ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI                           ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Left                   ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Top                    ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Right                  ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Bottom                 ,44   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Priority               ,48   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].DeltaQP                ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Mode                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecinePattern               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecineLocation              ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL0Active             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL1Active             ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0                   ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].FrameOrder     ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].PicStruct      ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1                   ,528  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].FrameOrder     ,528  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].PicStruct      ,532  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Mode                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,InField                       ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,OutField                      ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropX                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropY                      ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropW                      ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropH                      ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.FourCC                    ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.ChromaFormat              ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Width                     ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Height                    ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropX                     ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropY                     ,54   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropW                     ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropH                     ,58   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaLocInfoPresentFlag      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeTopField   ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeBottomField,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,NumQPAlloc                    ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,QP                            ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,MapSize                       ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Map                           ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileRows                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileColumns                ,10   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,MapSize                       ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Map                           ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicWidthInLumaSamples         ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicHeightInLumaSamples        ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,GeneralConstraintFlags        ,12   )
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,SampleAdaptiveOffset          ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,LCUSize                       ,22   )
#endif

#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,ErrorTypes                    ,8    )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,FrameType                     ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,DropFrameFlag                 ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeHours                 ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeMinutes               ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeSeconds               ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodePictures              ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionId                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionType                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionEncoding                ,14   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaLog2WeightDenom           ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaLog2WeightDenom         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaWeightFlag                ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaWeightFlag              ,140  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Weights                       ,268  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,NumRect                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect                          ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Left                  ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Top                   ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Right                 ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Bottom                ,44   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,NumRect                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect                          ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestLeft              ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestTop               ,36   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestRight             ,40   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestBottom            ,44   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceLeft            ,48   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceTop             ,52   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Angle                         ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSizeOverflow             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceNonCopliant           ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumEncodedSlice               ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceSizeAlloc             ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSize                     ,16   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,ScalingMode                   ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Type                          ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickTop                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickBottom                   ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickLeft                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickRight                    ,14   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Enable                        ,8    )
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,ChromaSiting                  ,8    )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,FeatureEnabled                ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,QIndexDelta                   ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,LoopFilterLevelDelta          ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,ReferenceFrame                ,6    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegments                   ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Segment                       ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentIdBlockSize            ,266  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegmentIdAlloc             ,268  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentId                     ,272  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,FrameRateScale                ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,TargetKbps                    ,2    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Layer                         ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameWidth                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameHeight                   ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,WriteIVFHeaders               ,12   )
#if (MFX_VERSION >= MFX_VERSION_NEXT)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,LoopFilterRefDelta            ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,LoopFilterModeDelta           ,22   )
#endif
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaLumaDC             ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaAC           ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaDC           ,30   )
#if (MFX_VERSION >= MFX_VERSION_NEXT)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileRows                   ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileColumns                ,34   )
#endif
#endif
#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameParam        ,Header       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameParam        ,MFMode       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameParam        ,MaxNumFrames ,10   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameControl      ,Header       ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameControl      ,Timeout      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMultiFrameControl      ,Flush        ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo           ,Type         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo           ,Offset       ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo           ,Size         ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,Header         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,UnitInfo       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,NumUnitsAlloc  ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo       ,NumUnitsEncoded,18   )
#endif
#if (MFX_VERSION >= 1026)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                ,Header         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                ,FilterStrength ,8    )
#endif
    #endif
#endif //defined (__MFXSTRUCTURES_H__)

//mfxvideo.h
#if defined (__MFXVIDEO_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBufferAllocator                 ,pthis                        ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,pthis                        ,16   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBufferAllocator                 ,pthis                        ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,pthis                        ,16   )
    #endif
#endif //defined (__MFXVIDEO_H__)

//mfxplugin.h
#if defined (__MFXPLUGIN_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,PluginVersion                     ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,APIVersion                        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,PluginUID                         ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,Type                              ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,CodecId                           ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,ThreadPolicy                      ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,MaxThreadNum                      ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginUID                   ,Data                              ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreParam                   ,Impl                              ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreParam                   ,Version                           ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreParam                   ,NumWorkingThread                  ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreInterface               ,pthis                             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreInterface               ,FrameAllocator                    ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlugin                      ,pthis                             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlugin                      ,Video                             ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlugin                      ,Audio                             ,56   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,PluginVersion                     ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,APIVersion                        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,PluginUID                         ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,Type                              ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,CodecId                           ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,ThreadPolicy                      ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginParam                 ,MaxThreadNum                      ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPluginUID                   ,Data                              ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreParam                   ,Impl                              ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreParam                   ,Version                           ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreParam                   ,NumWorkingThread                  ,60   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreInterface               ,pthis                             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCoreInterface               ,FrameAllocator                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlugin                      ,pthis                             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlugin                      ,Video                             ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlugin                      ,Audio                             ,28   )
    #endif
#endif //defined (__MFXPLUGIN_H__)

//mfxenc.h
#if defined (__MFXENC_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,InSurface                             ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,NumFrameL0                            ,136  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,L0Surface                             ,144  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,NumFrameL1                            ,152  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,L1Surface                             ,160  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,NumExtParam                           ,168  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,ExtParam                              ,176  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCOutput                     ,OutSurface                            ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCOutput                     ,NumExtParam                           ,136  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCOutput                     ,ExtParam                              ,144  )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,InSurface                             ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,NumFrameL0                            ,132  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,L0Surface                             ,136  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,NumFrameL1                            ,140  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,L1Surface                             ,144  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,NumExtParam                           ,148  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCInput                      ,ExtParam                              ,152  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCOutput                     ,OutSurface                            ,128  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCOutput                     ,NumExtParam                           ,132  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(_mfxENCOutput                     ,ExtParam                              ,136  )
    #endif
#endif //defined (__MFXENC_H__)

//mfxfei.h
#if defined (__MFXFEI_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,Qp                            ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,LenSP                         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SearchPath                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SubMBPartMask                 ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SubPelMode                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,InterSAD                      ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,IntraSAD                      ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,AdaptiveSearch                ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,MVPredictor                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,MBQp                          ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,FTEnable                      ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,IntraPartMask                 ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefWidth                      ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefHeight                     ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SearchWindow                  ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DisableMVOutput               ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DisableStatisticsOutput       ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,Enable8x8Stat                 ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,PictureType                   ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DownsampleInput               ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefPictureType                ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DownsampleReference           ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefFrame                      ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors        ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors        ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors        ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors::mfxExtFeiPreEncMVPredictorsMB ,MV    ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncQP                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncQP                     ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncQP                     ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV                  ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV                  ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV::mfxExtFeiPreEncMVMB ,MV                        ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat              ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat              ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,Inter             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,BestIntraDistortion ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,IntraMode         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,NumOfNonZeroCoef  ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,SumOfCoef         ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,Variance16x16     ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,Variance8x8       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,PixelAverage16x16 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,PixelAverage8x8   ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SearchPath                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,LenSP                         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SubMBPartMask                 ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,IntraPartMask                 ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MultiPredL0                   ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MultiPredL1                   ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SubPelMode                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,InterSAD                      ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,IntraSAD                      ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,DistortionType                ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,RepartitionCheckEnable        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,AdaptiveSearch                ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MVPredictor                   ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,NumMVPredictors               ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,PerMBQp                       ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,PerMBInput                    ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MBSizeCtrl                    ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,RefWidth                      ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,RefHeight                     ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SearchWindow                  ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors           ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors           ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors::mfxExtFeiEncMVPredictorsMB ,RefIdx      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors::mfxExtFeiEncMVPredictorsMB ,MV          ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBCtrl                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBCtrl                 ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBCtrl                 ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV                     ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV                     ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV::mfxExtFeiEncMVMB   ,MV                            ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat                 ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat                 ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,InterDistortion         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,BestInterDistortion     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,BestIntraDistortion     ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,ColocatedMbDistortion   ,36   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,MVDataLength                  ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,MVDataOffset                  ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,HorzOrigin                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,VertOrigin                    ,17   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,CbpY                          ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,CbpCb                         ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,CbpCr                         ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,IntraMB                       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,IntraMB.LumaIntraPredModes    ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB                       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB.SubMbShapes           ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB.SubMbPredModes        ,29   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB.RefIdx                ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,TargetSizeInWord              ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,MaxSizeInWord                 ,43   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPakMBCtrl                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPakMBCtrl                 ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPakMBCtrl                 ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,MaxFrameSize                  ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,NumPasses                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,DeltaQP                       ,32   )

#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackStat                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackStat                ,NumPasses                     ,8    )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,HorzOrigin                    ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,VertOrigin                    ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,IntraMB.LumaIntraPredModes    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB                       ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB.SubMbShapes           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB.SubMbPredModes        ,17   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB.RefIdx                ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,MV                            ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,RemapRefIdx                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,PicStruct                     ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,SPSId                         ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,PicOrderCntType               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,Log2MaxPicOrderCntLsb         ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,SPSId                         ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,PPSId                         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,PictureType                   ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,PicInitQP                     ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,NumRefIdxL0Active             ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,NumRefIdxL1Active             ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,ChromaQPIndexOffset           ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,SecondChromaQPIndexOffset     ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,Transform8x8ModeFlag          ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore                     ,256  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].Index            ,256  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].PicType          ,258  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].FrameNumWrap     ,260  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].LongTermFrameIdx ,264  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter                      ,512  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].Index             ,512  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].PicType           ,514  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].FrameNumWrap      ,516  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].LongTermFrameIdx  ,520  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSliceHeader               ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSliceHeader               ,NumSlice                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSliceHeader               ,Slice                         ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,DisableHME                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,DisableSuperHME               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,DisableUltraHME               ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiParam                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiParam                     ,Func                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiParam                     ,SingleFieldProcessing         ,12   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,Qp                            ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,LenSP                         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SearchPath                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SubMBPartMask                 ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SubPelMode                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,InterSAD                      ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,IntraSAD                      ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,AdaptiveSearch                ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,MVPredictor                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,MBQp                          ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,FTEnable                      ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,IntraPartMask                 ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefWidth                      ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefHeight                     ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,SearchWindow                  ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DisableMVOutput               ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DisableStatisticsOutput       ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,Enable8x8Stat                 ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,PictureType                   ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DownsampleInput               ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefPictureType                ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,DownsampleReference           ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncCtrl                ,RefFrame                      ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors        ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors        ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors        ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMVPredictors::mfxExtFeiPreEncMVPredictorsMB ,MV    ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncQP                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncQP                     ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncQP                     ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV                  ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV                  ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV                  ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMV::mfxExtFeiPreEncMVMB ,MV                        ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat              ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat              ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,Inter             ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,BestIntraDistortion ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,IntraMode         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,NumOfNonZeroCoef  ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,SumOfCoef         ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,Variance16x16     ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,Variance8x8       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,PixelAverage16x16 ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPreEncMBStat::mfxExtFeiPreEncMBStatMB ,PixelAverage8x8   ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SearchPath                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,LenSP                         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SubMBPartMask                 ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,IntraPartMask                 ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MultiPredL0                   ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MultiPredL1                   ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SubPelMode                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,InterSAD                      ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,IntraSAD                      ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,DistortionType                ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,RepartitionCheckEnable        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,AdaptiveSearch                ,30   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MVPredictor                   ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,NumMVPredictors               ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,PerMBQp                       ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,PerMBInput                    ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,MBSizeCtrl                    ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,RefWidth                      ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,RefHeight                     ,46   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncFrameCtrl              ,SearchWindow                  ,48   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors           ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors           ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors           ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors::mfxExtFeiEncMVPredictorsMB ,RefIdx      ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMVPredictors::mfxExtFeiEncMVPredictorsMB ,MV          ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBCtrl                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBCtrl                 ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBCtrl                 ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV                     ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV                     ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMV::mfxExtFeiEncMVMB   ,MV                            ,0    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat                 ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat                 ,MB                            ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,InterDistortion         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,BestInterDistortion     ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,BestIntraDistortion     ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiEncMBStat::mfxExtFeiEncMBStatMB ,ColocatedMbDistortion   ,36   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,MVDataLength                  ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,MVDataOffset                  ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,HorzOrigin                    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,VertOrigin                    ,17   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,CbpY                          ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,CbpCb                         ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,CbpCr                         ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,IntraMB                       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,IntraMB.LumaIntraPredModes    ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB                       ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB.SubMbShapes           ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB.SubMbPredModes        ,29   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,InterMB.RefIdx                ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,TargetSizeInWord              ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiPakMBCtrl                    ,MaxSizeInWord                 ,43   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPakMBCtrl                 ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPakMBCtrl                 ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPakMBCtrl                 ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,MaxFrameSize                  ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,NumPasses                     ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackCtrl                ,DeltaQP                       ,32   )

#if (MFX_VERSION >= 1025)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackStat                ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiRepackStat                ,NumPasses                     ,8    )
#endif

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,HorzOrigin                    ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,VertOrigin                    ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,IntraMB.LumaIntraPredModes    ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB                       ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB.SubMbShapes           ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB.SubMbPredModes        ,17   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,InterMB.RefIdx                ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFeiDecStreamOutMBCtrl           ,MV                            ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,NumMBAlloc                    ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,RemapRefIdx                   ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,PicStruct                     ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiDecStreamOut              ,MB                            ,64   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,SPSId                         ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,PicOrderCntType               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSPS                       ,Log2MaxPicOrderCntLsb         ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,SPSId                         ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,PPSId                         ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,PictureType                   ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,PicInitQP                     ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,NumRefIdxL0Active             ,18   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,NumRefIdxL1Active             ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,ChromaQPIndexOffset           ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,SecondChromaQPIndexOffset     ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,Transform8x8ModeFlag          ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore                     ,256  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].Index            ,256  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].PicType          ,258  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].FrameNumWrap     ,260  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbBefore[0].LongTermFrameIdx ,264  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter                      ,512  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].Index             ,512  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].PicType           ,514  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].FrameNumWrap      ,516  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiPPS                       ,DpbAfter[0].LongTermFrameIdx  ,520  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSliceHeader               ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSliceHeader               ,NumSlice                      ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiSliceHeader               ,Slice                         ,32   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,DisableHME                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,DisableSuperHME               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiCodingOption              ,DisableUltraHME               ,12   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiParam                     ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiParam                     ,Func                          ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtFeiParam                     ,SingleFieldProcessing         ,12   )
    #endif
#endif //defined (__MFXFEI_H__)

//mfxjpeg.h
#if defined (__MFX_JPEG_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,NumTable                      ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Qm                            ,24   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumDCTable                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumACTable                    ,14   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Bits              ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Values            ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Bits              ,128  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Values            ,144  )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,NumTable                      ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Qm                            ,24   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumDCTable                    ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumACTable                    ,14   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Bits              ,16   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Values            ,32   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Bits              ,128  )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Values            ,144  )
    #endif
#endif //defined (__MFX_JPEG_H__)

//mfxla.h
#if defined (__MFXLA_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,LookAheadDepth                ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,DependencyDepth               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,DownScaleFactor               ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,BPyramid                      ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,NumOutStream                  ,62   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,OutStream[0].Width            ,64   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,OutStream[0].Height           ,66   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,Width                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,Height                        ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,FrameType                     ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,FrameDisplayOrder             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,FrameEncodeOrder              ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,IntraCost                     ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,InterCost                     ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,DependencyCost                ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,Layer                         ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,EstimatedRate                 ,80   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,NumAlloc                      ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,NumStream                     ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,NumFrame                      ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,FrameStat                     ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,OutSurface                    ,64   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,LookAheadDepth                ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,DependencyDepth               ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,DownScaleFactor               ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,BPyramid                      ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,NumOutStream                  ,62   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,OutStream[0].Width            ,64   )
        //MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAControl                    ,OutStream[0].Height           ,66   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,Width                         ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,Height                        ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,FrameType                     ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,FrameDisplayOrder             ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,FrameEncodeOrder              ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,IntraCost                     ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,InterCost                     ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,DependencyCost                ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,Layer                         ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxLAFrameInfo                     ,EstimatedRate                 ,80   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,NumAlloc                      ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,NumStream                     ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,NumFrame                      ,52   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,FrameStat                     ,56   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtLAFrameStatistics            ,OutSurface                    ,60   )
    #endif
#endif //defined (__MFXLA_H__)

//mfxmvc.h
#if defined (__MFXMVC_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,ViewId                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL0               ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL1               ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL0                   ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL1                   ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL0            ,70   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL1            ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL0                ,74   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL1                ,106  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TemporalId                    ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,LevelIdc                      ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumViews                      ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumTargetViews                ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TargetViewId                  ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumView                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewAlloc                  ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,View                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewId                     ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewIdAlloc                ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,ViewId                        ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOP                         ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOPAlloc                    ,44   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,OP                            ,48   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumRefsTotal                  ,56   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,TemporalId                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,NumView                       ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,ViewId                        ,16   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,ViewId                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL0               ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL1               ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL0                   ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL1                   ,38   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL0            ,70   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL1            ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL0                ,74   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL1                ,106  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TemporalId                    ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,LevelIdc                      ,2    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumViews                      ,4    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumTargetViews                ,6    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TargetViewId                  ,8    )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumView                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewAlloc                  ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,View                          ,16   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewId                     ,20   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewIdAlloc                ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,ViewId                        ,28   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOP                         ,32   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOPAlloc                    ,36   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,OP                            ,40   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumRefsTotal                  ,44   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,TemporalId                    ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,NumView                       ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,ViewId                        ,16   )
    #endif
#endif //defined (__MFXMVC_H__)

//mfxpak.h
#if defined (__MFXPAK_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,InSurface                             ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumFrameL0                            ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,L0Surface                             ,80   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumFrameL1                            ,88   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,L1Surface                             ,96   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumExtParam                           ,104  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,ExtParam                              ,112  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumPayload                            ,120  )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,Payload                               ,128  )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,Bs                                    ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,OutSurface                            ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,NumExtParam                           ,80   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,ExtParam                              ,88   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,InSurface                             ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumFrameL0                            ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,L0Surface                             ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumFrameL1                            ,76   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,L1Surface                             ,80   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumExtParam                           ,84   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,ExtParam                              ,88   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,NumPayload                            ,92   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKInput                      ,Payload                               ,96   )

        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,Bs                                    ,64   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,OutSurface                            ,68   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,NumExtParam                           ,72   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPAKOutput                     ,ExtParam                              ,76   )
    #endif
#endif //defined (__MFXPAK_H__)


//mfxvp8.h
#if defined (__MFXVP8_H__)
    #if defined(LINUX64)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Version                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,EnableMultipleSegments        ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterType                ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterLevel               ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SharpnessLevel                ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumTokenPartitions            ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterRefTypeDelta        ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterMbModeDelta         ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SegmentQPDelta                ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,CoeffTypeQPDelta              ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,WriteIVFHeaders               ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumFramesForIVFHeader         ,64   )
    #elif defined(LINUX32)
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Header                        ,0    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Version                       ,8    )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,EnableMultipleSegments        ,10   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterType                ,12   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterLevel               ,14   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SharpnessLevel                ,22   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumTokenPartitions            ,24   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterRefTypeDelta        ,26   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterMbModeDelta         ,34   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SegmentQPDelta                ,42   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,CoeffTypeQPDelta              ,50   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,WriteIVFHeaders               ,60   )
        MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumFramesForIVFHeader         ,64   )
    #endif
#endif //defined (__MFXVP8_H__)



