/*
 * Copyright (C) 2017-2018 Intel Corporation.  All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * File Name: device_info.h
 *
 */

/* Source file content was taken from Intel GPU Tools */

#ifndef __DEVICE_INFO_H__
#define __DEVICE_INFO_H__

#define BIT(x) (1<<(x))

struct intel_device_info {
    unsigned gen;
    bool is_mobile : 1;
    bool is_whitney : 1;
    bool is_almador : 1;
    bool is_brookdale : 1;
    bool is_montara : 1;
    bool is_springdale : 1;
    bool is_grantsdale : 1;
    bool is_alviso : 1;
    bool is_lakeport : 1;
    bool is_calistoga : 1;
    bool is_bearlake : 1;
    bool is_pineview : 1;
    bool is_broadwater : 1;
    bool is_crestline : 1;
    bool is_eaglelake : 1;
    bool is_cantiga : 1;
    bool is_ironlake : 1;
    bool is_arrandale : 1;
    bool is_sandybridge : 1;
    bool is_ivybridge : 1;
    bool is_valleyview : 1;
    bool is_haswell : 1;
    bool is_broadwell : 1;
    bool is_cherryview : 1;
    bool is_skylake : 1;
    bool is_broxton : 1;
    bool is_kabylake : 1;
    bool is_geminilake : 1;
    bool is_coffeelake : 1;
    bool is_cannonlake : 1;
    const char *codename;
};

const struct intel_device_info intel_generic_info = {
    .gen = 0,
};

const struct intel_device_info intel_i810_info = {
    .gen = BIT(0),
    .is_mobile = false,
    .is_whitney = true,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "solano"
};

const struct intel_device_info intel_i815_info = {
    .gen = BIT(0),
    .is_mobile = false,
    .is_whitney = true,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "whitney"
};

const struct intel_device_info intel_i830_info = {
    .gen = BIT(1),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = true,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "almador"
};

const struct intel_device_info intel_i845_info = {
    .gen = BIT(1),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = true,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "brookdale"
};

const struct intel_device_info intel_i855_info = {
    .gen = BIT(1),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = true,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "montara"
};

const struct intel_device_info intel_i865_info = {
    .gen = BIT(1),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = true,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "spingdale"
};

const struct intel_device_info intel_i915_info = {
    .gen = BIT(2),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = true,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "grantsdale"
};

const struct intel_device_info intel_i915m_info = {
    .gen = BIT(2),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = true,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "alviso"
};

const struct intel_device_info intel_i945_info = {
    .gen = BIT(2),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = true,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "lakeport"
};

const struct intel_device_info intel_i945m_info = {
    .gen = BIT(2),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = true,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "calistoga"
};

const struct intel_device_info intel_g33_info = {
    .gen = BIT(2),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = true,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "bearlake"
};

const struct intel_device_info intel_pineview_info = {
    .gen = BIT(2),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = true,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "pineview"
};

const struct intel_device_info intel_i965_info = {
    .gen = BIT(3),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = true,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "broadwater"
};

const struct intel_device_info intel_i965m_info = {
    .gen = BIT(3),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = true,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "crestline"
};

const struct intel_device_info intel_g45_info = {
    .gen = BIT(3),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = true,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "eaglelake"
};

const struct intel_device_info intel_gm45_info = {
    .gen = BIT(3),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = true,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "cantiga"
};

const struct intel_device_info intel_ironlake_info = {
    .gen = BIT(4),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = true,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "ironlake" /* clarkdale? */
};

const struct intel_device_info intel_ironlake_m_info = {
    .gen = BIT(4),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = true,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "arrandale"
};

const struct intel_device_info intel_sandybridge_info = {
    .gen = BIT(5),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = true,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "sandybridge"
};

const struct intel_device_info intel_sandybridge_m_info = {
    .gen = BIT(5),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = true,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "sandybridge"
};

const struct intel_device_info intel_ivybridge_info = {
    .gen = BIT(6),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = true,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "ivybridge"
};

const struct intel_device_info intel_ivybridge_m_info = {
    .gen = BIT(6),
    .is_mobile = true,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = true,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "ivybridge"
};

const struct intel_device_info intel_valleyview_info = {
    .gen = BIT(6),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = true,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "valleyview"
};

const struct intel_device_info intel_haswell_info = {
    .gen = BIT(6),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = true,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "haswell"
};

const struct intel_device_info intel_broadwell_info = {
    .gen = BIT(7),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = true,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "broadwell"
};

const struct intel_device_info intel_cherryview_info = {
    .gen = BIT(7),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = true,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "cherryview"
};

const struct intel_device_info intel_skylake_info = {
    .gen = BIT(8),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = true,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "skylake"
};

const struct intel_device_info intel_broxton_info = {
    .gen = BIT(8),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = true,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "broxton"
};

const struct intel_device_info intel_kabylake_info = {
    .gen = BIT(8),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = true,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "kabylake"
};

const struct intel_device_info intel_geminilake_info = {
    .gen = BIT(8),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = true,
    .is_coffeelake = false,
    .is_cannonlake = false,
    .codename = "geminilake"
};

const struct intel_device_info intel_coffeelake_info = {
    .gen = BIT(8),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = true,
    .is_cannonlake = false,
    .codename = "coffeelake"
};

const struct intel_device_info intel_cannonlake_info = {
    .gen = BIT(9),
    .is_mobile = false,
    .is_whitney = false,
    .is_almador = false,
    .is_brookdale = false,
    .is_montara = false,
    .is_springdale = false,
    .is_grantsdale = false,
    .is_alviso = false,
    .is_lakeport = false,
    .is_calistoga = false,
    .is_bearlake = false,
    .is_pineview = false,
    .is_broadwater = false,
    .is_crestline = false,
    .is_eaglelake = false,
    .is_cantiga = false,
    .is_ironlake = false,
    .is_arrandale = false,
    .is_sandybridge = false,
    .is_ivybridge = false,
    .is_valleyview = false,
    .is_haswell = false,
    .is_broadwell = false,
    .is_cherryview = false,
    .is_skylake = false,
    .is_broxton = false,
    .is_kabylake = false,
    .is_geminilake = false,
    .is_coffeelake = false,
    .is_cannonlake = true,
    .codename = "cannonlake"
};

const struct pci_id_match intel_device_match [] = {
    INTEL_I810_IDS(&intel_i810_info),
    INTEL_I815_IDS(&intel_i815_info),

    INTEL_I830_IDS(&intel_i830_info),
    INTEL_I845G_IDS(&intel_i845_info),
    INTEL_I85X_IDS(&intel_i855_info),
    INTEL_I865G_IDS(&intel_i865_info),

    INTEL_I915G_IDS(&intel_i915_info),
    INTEL_I915GM_IDS(&intel_i915m_info),
    INTEL_I945G_IDS(&intel_i945_info),
    INTEL_I945GM_IDS(&intel_i945m_info),

    INTEL_G33_IDS(&intel_g33_info),
    INTEL_PINEVIEW_IDS(&intel_pineview_info),

    INTEL_I965G_IDS(&intel_i965_info),
    INTEL_I965GM_IDS(&intel_i965m_info),

    INTEL_G45_IDS(&intel_g45_info),
    INTEL_GM45_IDS(&intel_gm45_info),

    INTEL_IRONLAKE_D_IDS(&intel_ironlake_info),
    INTEL_IRONLAKE_M_IDS(&intel_ironlake_m_info),

    INTEL_SNB_D_IDS(&intel_sandybridge_info),
    INTEL_SNB_M_IDS(&intel_sandybridge_m_info),

    INTEL_IVB_D_IDS(&intel_ivybridge_info),
    INTEL_IVB_M_IDS(&intel_ivybridge_m_info),

    INTEL_HSW_IDS(&intel_haswell_info),

    INTEL_VLV_IDS(&intel_valleyview_info),

    INTEL_BDW_IDS(&intel_broadwell_info),

    INTEL_CHV_IDS(&intel_cherryview_info),

    INTEL_SKL_IDS(&intel_skylake_info),

    INTEL_BXT_IDS(&intel_broxton_info),

    INTEL_KBL_IDS(&intel_kabylake_info),

    INTEL_GLK_IDS(&intel_geminilake_info),

    INTEL_CFL_IDS(&intel_coffeelake_info),

    INTEL_CNL_IDS(&intel_cannonlake_info),

    INTEL_VGA_DEVICE(PCI_MATCH_ANY, &intel_generic_info),
};

#endif /* __DEVICE_INFO_H__ */