--
-- By Jeremy Hankins <nowan@nowan.org>
--
-- Time-stamp: <2005-03-06 21:10:00 nowan>
--
-- With these functions you can bind a key to start an application if
-- it's not already running, or go to it if it is.  You can use it by
-- doing something like this in your bindings file:
--
-- kpress(MOD1.."C", "app.byname('xterm -title shell', 'shell')"),
-- kpress(MOD1.."T", "app.byclass('emacs', 'Emacs')"),
--
-- The byname function expects an executable and a window title, the
-- byclass expects a class.
--
-- if you use a mulithead setup you can use something like this to start
-- applictions on your current screen
--
-- kpress(MOD1.."C", "app.byname('xterm -title shell', 'shell', _)"),
-- kpress(MOD1.."T", "app.byclass('emacs', 'Emacs', _)"),
--
-- For emacs users there's also app.emacs_eval, and app.query_editfile,
-- which interacts with any currently running emacs process (using
-- gnuclient), or starts emacs to run the given command.
-- app.query_editfile is a replacement for query_lib.query_editfile to
-- use the currently running emacs rather than ion-edit.
--

if _LOADED["app"] then return end

app={}

function app.match_class(class)
   local wins = ioncore.clientwin_list()
   local result = {}
   for i, win in wins do
      if class == win:get_ident().class then
	 table.insert(result, win)
      end
   end
   return result
end

function app.byname(prog, name, where)
   local win = ioncore.lookup_clientwin(name)
   if win then
      win:goto()
   else
      if where then
          ioncore.exec_on(where,prog)
      else
          ioncore.exec(prog)
      end
   end
end

function app.byclass(prog, class, where)
   local win = app.match_class(class)[1]
   if win then
      win:goto()
   else
      if where then
          ioncore.exec_on(where,prog)
      else
          ioncore.exec(prog)
      end
   end
end

function app.emacs_eval(expr)
   local emacswin = app.match_class("Emacs")[1]
   if emacswin then
      ioncore.exec("gnuclient -batch -eval '"..expr.."'")
      emacswin:goto()
   else
      ioncore.exec("emacs -eval '"..expr.."'")
   end
end

function app.query_editfile(mplex) 
   local function handler(file)
      app.emacs_eval("(find-file \""..file.."\")")
   end

   mod_query.do_query(mplex,
		     'Edit file:',
		     mod_query.get_initdir(),
		     handler,
		     mod_query.file_completor)
end


_LOADED["app"]=true

