--lua code to auto show/hide tabs as the number of windows in an ion frame
--changes from/to 1
--this affects windows on WIonWS and WPaneWS workspaces but leave
--windows on WFloatWS's alone
--
--Originally created by David Tweed
--
--11 Feb 2005 David Tweed: modified to work with ion3 svn versions
--15 Feb 2005 Cas Cremers: only frames with one window hide the tabbar
--(as opposed to <= 2)
--07 Mar 2005 Jeremy Hankins: Modified to work with restricted mode
--functions and isolated the namespace.
--21 March 2005 Cas Cremers: Rewrite because toggle conventions changed,
--general cleanup.
--
--(i) easier to work with using a style with slightly wider frame borders
--     and more vivid "active frame" colours 
--
--one way to enable this is by adding
--dopath("min_tabs")
--to cfg_ion.lua

-- This is a slight abuse of the _LOADED variable perhaps, but library-like
-- packages should handle checking if they're loaded instead of confusing
-- the user with require/include differences.
if _LOADED["minimalTabs"] then return end

min_tabs={}


function min_tabs.update_tabs(f)
   local fp=f.reg
   if f.mode == "remove" or f.mode == "add" then
      if obj_typename(fp)=="WFrame" then
	 ioncore.defer(function()
			  if fp:lcount(1) == 1 then
			     fp:set_tabbar("unset")
			  else
			     fp:set_tabbar("set")
			  end
		       end)
      end
   end
end


function min_tabs.setup_hook()
    local hk=ioncore.get_hook("frame_managed_changed_hook")
    hk:add(min_tabs.update_tabs)
end

min_tabs.setup_hook()

_LOADED["minimalTabs"]=true
