-- document_menus.lua
-- 
-- Canaan Hadley-Voth, 2005-08-26
--
-- Navigate the filesystem by way of ion menu.
--
-- One way to implement this is to define a menu containing useful folders,
-- and use that as a starting point for binding to (see below).
--
-- Other adjustments that may be desired before continuing:
--
-- * change ls options used in lscommand
-- * set scroll_delay and scroll_amount to speed up pmenus (uncomment line 44)
-- * set action to be performed on selected file (near the bottom)
--
-- * By default there's a key binding to show the useful folders menu
--   as a (non-big) menu within the frame.  You might prefer to have it 
--   in WScreen; that way it works on an empty floating workspace.
--

defmenu("useful folders", {
    -- Define commonly used locations here.
    -- Or skip this defmenu and put something like the following under mainmenu...
    
    submenu("/", function() return docmenus.getfiletable("/") end),
    submenu("~", function() return docmenus.getfiletable(os.getenv("HOME")) end),
    submenu(".ion3/", function() return docmenus.getfiletable(ioncore.get_paths().userdir) end),
})

defbindings("WFrame", { 
    kpress(MOD1.."minus", "mod_menu.menu(_, _sub, 'useful folders')"),
})
    
defbindings("WScreen", {
    submap(MOD1.."K", {
        kpress("minus", "docmenus.toggle_dotfiles()"),
    }),
})

-- This script creates menus far larger than Ion would
-- normally handle.  The default scroll behavior is going to seem
-- inadequate, and this is how you would speed it up:

--mod_menu.set({ scroll_delay=5, scroll_amount=6 })

if not docmenus then
  docmenus={
      show_dotfiles = true,
      exec = "xterm -e vi"
  }
end

function docmenus.getfiletable(dirpath)
    local filetable = {}
    local listfilename
    local menufile
    local lnstring
    -- os shell is used for the menu's directory listing.
    --
    -- lscommand can be customized, to a point.  
    -- Scrap the -L to keep from following symbolic links.
    -- Just don't remove -p.
    local lscommand = "ls -Lp"
    if docmenus.show_dotfiles then lscommand = lscommand.." -a" end

    if string.sub(dirpath, -1) ~= "/" then
	dirpath = dirpath.."/"
    end
    
    listfilename = ioncore.get_paths().sessiondir.."/docmenus.listfile"
    os.execute(lscommand.." '"..dirpath.."' > "..listfilename)
    
    for menufile in io.lines(listfilename) do
	if menufile == "./" then menufile = "." end

	if string.sub(menufile, 3) == "ls:" then
	    -- ls error message on broken link. skip it
	elseif menufile == "../" then
	    -- I'd prefer not to show parent directory as a folder.
	elseif string.sub(menufile, -1) == "/" then
	    table.insert(filetable, docmenus.subdir(menufile, dirpath..menufile))
    	else
	    table.insert(filetable, docmenus.file(menufile, dirpath..menufile))
    	end
    end
    
    return filetable
end

function docmenus.file(menustr,path)
    return menuentry(menustr, 
	-- Specify something other than run-mailcap if necessary.
	-- Mine just opens everything in vim:
	"ioncore.exec_on(_, '"..docmenus.exec.." \""..path.."\"')"

	--"ioncore.exec_on(_, 'run-mailcap --action=edit \""..dirpath..menufile.."\"')"
    )
end

function docmenus.subdir(menustr,path)
    return submenu(menustr, function() return docmenus.getfiletable(path) end)
end


function docmenus.toggle_dotfiles()
    docmenus.show_dotfiles=not docmenus.show_dotfiles
end


