--
-- Selected TOC Entries:
--
\connect - postgres

--
-- TOC Entry ID 2 (OID 17723)
--
-- Name: id Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "id" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 4 (OID 17723)
--
-- Name: id Type: ACL Owner: 
--

REVOKE ALL on "id" from PUBLIC;
GRANT ALL on "id" to "postgres";
GRANT ALL on "id" to "apache";
GRANT ALL on "id" to "root";

--
-- TOC Entry ID 5 (OID 17725)
--
-- Name: tariffs_names Type: TABLE Owner: postgres
--

CREATE TABLE "tariffs_names" (
	"tariff_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"tariff_name" text,
	Constraint "tariffs_names_pkey" Primary Key ("tariff_id")
);

--
-- TOC Entry ID 6 (OID 17725)
--
-- Name: tariffs_names Type: ACL Owner: 
--

REVOKE ALL on "tariffs_names" from PUBLIC;
GRANT ALL on "tariffs_names" to "postgres";
GRANT ALL on "tariffs_names" to "apache";
GRANT ALL on "tariffs_names" to "root";

--
-- TOC Entry ID 7 (OID 17731)
--
-- Name: nets_names Type: TABLE Owner: postgres
--

CREATE TABLE "nets_names" (
	"net_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"net_name" text,
	"glob" integer DEFAULT 100,
	Constraint "nets_names_pkey" Primary Key ("net_id")
);

--
-- TOC Entry ID 8 (OID 17731)
--
-- Name: nets_names Type: ACL Owner: 
--

REVOKE ALL on "nets_names" from PUBLIC;
GRANT ALL on "nets_names" to "postgres";
GRANT ALL on "nets_names" to "apache";
GRANT ALL on "nets_names" to "root";

--
-- TOC Entry ID 9 (OID 17737)
--
-- Name: services_names Type: TABLE Owner: postgres
--

CREATE TABLE "services_names" (
	"serv_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"serv_name" text,
	Constraint "services_names_pkey" Primary Key ("serv_id")
);

--
-- TOC Entry ID 10 (OID 17737)
--
-- Name: services_names Type: ACL Owner: 
--

REVOKE ALL on "services_names" from PUBLIC;
GRANT ALL on "services_names" to "postgres";
GRANT ALL on "services_names" to "apache";
GRANT ALL on "services_names" to "root";

--
-- TOC Entry ID 11 (OID 17743)
--
-- Name: customers Type: TABLE Owner: postgres
--

CREATE TABLE "customers" (
	"cust_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"login" text NOT NULL,
	"ip_addr" text NOT NULL,
	"name" text,
	"sname" text,
	"phone" text,
	"e_mail" text,
	"address" text,
	"comment" text,
	"pause" boolean DEFAULT 'f',
	"detailed" boolean DEFAULT 'f',
	Constraint "customers_pkey" Primary Key ("cust_id")
);

--
-- TOC Entry ID 12 (OID 17743)
--
-- Name: customers Type: ACL Owner: 
--

REVOKE ALL on "customers" from PUBLIC;
GRANT ALL on "customers" to "postgres";
GRANT ALL on "customers" to "apache";
GRANT ALL on "customers" to "root";

--
-- TOC Entry ID 13 (OID 17750)
--
-- Name: services Type: TABLE Owner: postgres
--

CREATE TABLE "services" (
	"serv_id" integer NOT NULL,
	"dest" text,
	"proto" text,
	"tariff_id" integer,
	"net_id" integer,
	"agent" text,
	"sport" text,
	"dport" text,
	"iface" text
);

--
-- TOC Entry ID 14 (OID 17750)
--
-- Name: services Type: ACL Owner: 
--

REVOKE ALL on "services" from PUBLIC;
GRANT ALL on "services" to "postgres";
GRANT ALL on "services" to "apache";
GRANT ALL on "services" to "root";

--
-- TOC Entry ID 15 (OID 17761)
--
-- Name: cash Type: TABLE Owner: postgres
--

CREATE TABLE "cash" (
	"cust_id" integer NOT NULL,
	"cash" double precision DEFAULT 0,
	"kredit" double precision DEFAULT 0
);

--
-- TOC Entry ID 16 (OID 17761)
--
-- Name: cash Type: ACL Owner: 
--

REVOKE ALL on "cash" from PUBLIC;
GRANT ALL on "cash" to "postgres";
GRANT ALL on "cash" to "apache";
GRANT ALL on "cash" to "root";

--
-- TOC Entry ID 17 (OID 17770)
--
-- Name: nets Type: TABLE Owner: postgres
--

CREATE TABLE "nets" (
	"net_id" integer NOT NULL,
	"ip_net" text
);

--
-- TOC Entry ID 18 (OID 17770)
--
-- Name: nets Type: ACL Owner: 
--

REVOKE ALL on "nets" from PUBLIC;
GRANT ALL on "nets" to "postgres";
GRANT ALL on "nets" to "apache";
GRANT ALL on "nets" to "root";

--
-- TOC Entry ID 19 (OID 17775)
--
-- Name: logs Type: TABLE Owner: postgres
--

CREATE TABLE "logs" (
	"rule_name" text NOT NULL,
	"bytes" bigint NOT NULL,
	"pkts" bigint NOT NULL,
	"that_time" bigint NOT NULL,
	Constraint "logs_pkey" Primary Key ("that_time", "rule_name")
);

--
-- TOC Entry ID 20 (OID 17775)
--
-- Name: logs Type: ACL Owner: 
--

REVOKE ALL on "logs" from PUBLIC;
GRANT ALL on "logs" to "postgres";
GRANT ALL on "logs" to "apache";
GRANT ALL on "logs" to "root";

--
-- TOC Entry ID 21 (OID 17781)
--
-- Name: tariffs Type: TABLE Owner: postgres
--

CREATE TABLE "tariffs" (
	"cust_id" integer NOT NULL,
	"tariff_id" integer NOT NULL,
	"price" double precision,
	"pr_type" integer,
	"last_paid" timestamp with time zone DEFAULT now(),
	"active_nocash" integer,
	"detailed" boolean DEFAULT 'f'::bool
);

--
-- TOC Entry ID 22 (OID 17781)
--
-- Name: tariffs Type: ACL Owner: 
--

REVOKE ALL on "tariffs" from PUBLIC;
GRANT ALL on "tariffs" to "postgres";
GRANT ALL on "tariffs" to "apache";
GRANT ALL on "tariffs" to "root";

--
-- TOC Entry ID 23 (OID 17795)
--
-- Name: raw_logs Type: TABLE Owner: postgres
--

CREATE TABLE "raw_logs" (
	"source" text,
	"destination" text,
	"proto" text,
	"sport" text,
	"dport" text,
	"time" text NOT NULL,
	"len" text
);

--
-- TOC Entry ID 24 (OID 17795)
--
-- Name: raw_logs Type: ACL Owner: 
--

REVOKE ALL on "raw_logs" from PUBLIC;
GRANT ALL on "raw_logs" to "postgres";
GRANT ALL on "raw_logs" to "apache";
GRANT ALL on "raw_logs" to "root";

--
-- Data for TOC Entry ID 27 (OID 17725)
--
-- Name: tariffs_names Type: TABLE DATA Owner: postgres
--


COPY "tariffs_names" FROM stdin;
12	empty
8	internet incoming
3	Tomsk only
38	test
9	internet outgoing
58	local
\.
--
-- Data for TOC Entry ID 28 (OID 17731)
--
-- Name: nets_names Type: TABLE DATA Owner: postgres
--


COPY "nets_names" FROM stdin;
1	tomsknet	40
7	internet	100
40	localnet	20
\.
--
-- Data for TOC Entry ID 29 (OID 17737)
--
-- Name: services_names Type: TABLE DATA Owner: postgres
--


COPY "services_names" FROM stdin;
4	incoming Tomsk
6	outgoing Tomsk
10	incoming internet
11	outgoing internet
13	incoming Tomsk (smtp only)
14	outgoing Tomsk (smpt only)
59	incoming local
60	outgoing local
\.
--
-- Data for TOC Entry ID 30 (OID 17743)
--
-- Name: customers Type: TABLE DATA Owner: postgres
--


COPY "customers" FROM stdin;
79	nsnsns	192.168.1.16	Oleg		548-724				f	f
81	dmitriy	192.168.1.17							f	f
85	dreamer	192.168.1.18							f	f
87	dracon	192.168.1.19							f	f
70	second	192.168.1.12	Nikolay	Nikolaevich	21-05-34				f	f
72	kekoz	80.89.135.75	kaiser		55-03-19				f	f
2	admin	0/0	Kaiser			kaiser13@mail2000.ru		\N	f	f
57	dream	192.168.1.11	Alexander	_!_	266370	sibdream@mail2000.ru			f	f
69	pppuser	192.168.1.250							f	f
71	setka1	192.168.200.0/24							f	f
74	pepsi	192.168.1.14							f	f
76	stubble	192.168.1.249	John	Susov					f	f
99	svetlana	192.168.1.20							f	f
100	pacifist	192.168.1.248	Anton	Zheltov	26-27-40				f	f
78	sev33	80.89.135.74	John		54-95-35	sev@mail.tomsknet.ru			f	f
\.
--
-- Data for TOC Entry ID 31 (OID 17750)
--
-- Name: services Type: TABLE DATA Owner: postgres
--


COPY "services" FROM stdin;
4	in	all	3	1	iptables			eth4
6	out	all	3	1	iptables			eth4
10	in	all	8	7	iptables			eth4
11	out	all	9	7	iptables			eth4
59	in	all	58	40	iptables			!eth4
60	out	all	58	40	iptables			!eth4
10	in	all	12	7	iptables			eth4
11	out	all	12	7	iptables			eth4
13	in	tcp	12	1	iptables	25	\N	\N
14	out	tcp	12	1	iptables		25	
\.
--
-- Data for TOC Entry ID 32 (OID 17761)
--
-- Name: cash Type: TABLE DATA Owner: postgres
--


COPY "cash" FROM stdin;
2	0	0
69	0	0
57	0	0
81	17.51405	0
87	-1.083773	0
85	-0.618056	0
74	-1.325953	0
70	250	0
99	700	0
100	0	0
71	1500	0
79	39.850136	0
76	100.919595	0
72	538.151391	250
78	-270.149135	500
\.
--
-- Data for TOC Entry ID 33 (OID 17770)
--
-- Name: nets Type: TABLE DATA Owner: postgres
--


COPY "nets" FROM stdin;
1	213.59.236.0/23
1	212.192.100.128/27
1	217.106.40.0/23
1	194.58.123.0/24
40	127.0.0.0/8
40	172.16.0.0/12
1	213.210.64.0/18
1	217.18.128.0/19
1	217.106.36.0/22
7	0/0
1	195.208.160.0/19
40	192.168.0.0/16
40	10.0.0.0/8
1	217.106.120.0/21
1	217.106.32.0/22
1	212.192.197.0/24
1	213.59.238.0/23
1	212.192.96.0/19
1	80.89.132.0/22
\.
--
-- Data for TOC Entry ID 34 (OID 17775)
--
-- Name: logs Type: TABLE DATA Owner: postgres
--


COPY "logs" FROM stdin;
\.
--
-- Data for TOC Entry ID 35 (OID 17781)
--
-- Name: tariffs Type: TABLE DATA Owner: postgres
--


COPY "tariffs" FROM stdin;
72	9	0	1	2002-01-13 20:14:43+07	0	f
79	8	3.6e-06	1	\N	0	f
79	9	0	1	\N	0	f
81	58	0	0	\N	0	f
2	9	0	0	\N	1	f
81	8	3.6e-06	1	\N	0	f
2	58	0	0	\N	1	f
81	9	0	1	\N	0	f
85	58	0	0	\N	0	f
85	8	3.6e-06	1	\N	0	f
85	9	0	1	\N	0	f
87	58	0	0	\N	0	f
87	8	3.6e-06	1	\N	0	f
87	9	0	1	\N	0	f
79	58	0	0	\N	0	f
71	58	0	0	2002-01-14 22:18:07+07	1	f
70	58	0	0	2002-01-07 14:46:02+07	1	f
72	8	3.6e-06	1	2002-01-13 20:14:43+07	0	f
57	58	0	0	\N	1	f
79	3	0	0	2002-02-07 14:46:02+07	0	f
81	3	0	0	2002-02-07 14:46:02+07	0	f
2	3	0	0	2002-02-07 14:46:02+07	1	f
85	3	0	15	2002-02-07 14:46:02+07	0	f
87	3	0	0	2002-02-07 14:46:02+07	0	f
57	3	0	0	2002-02-07 14:46:02+07	1	f
69	3	0	0	2002-02-07 14:46:02+07	1	f
74	3	0	0	2002-02-07 14:46:02+07	1	f
76	3	0	0	2002-02-07 14:46:02+07	1	f
70	3	250	15	2002-02-07 14:46:02+07	0	f
69	58	0	0	\N	1	f
2	8	0	0	\N	1	f
74	8	3.6e-06	1	\N	0	f
74	9	0	1	\N	0	f
74	58	0	0	\N	1	f
76	58	0	0	\N	1	f
76	8	3.6e-06	1	\N	0	f
76	9	0	1	\N	0	f
99	58	0	0	2002-02-25 23:58:59.336021+07	0	f
99	3	0	0	2002-02-25 23:59:19.646436+07	0	f
99	8	3.6e-06	1	2002-02-25 23:59:33.49003+07	0	f
99	9	0	0	2002-02-25 23:59:57.519486+07	0	f
100	58	0	0	2002-02-26 00:01:35.867934+07	0	f
100	3	0	0	2002-02-26 00:01:51.490118+07	0	f
78	8	3.6e-06	1	2002-01-20 22:16:34+07	1	f
78	9	0	1	2002-01-20 22:16:34+07	1	f
78	58	0	0	2002-01-20 22:16:34+07	1	f
78	3	250	15	2002-02-20 22:16:34+07	1	f
71	3	1500	15	2002-02-14 22:18:07+07	0	f
72	58	0	0	2002-01-13 20:14:43+07	1	f
72	3	250	15	2002-02-07 14:46:02+07	1	f
\.
--
-- Data for TOC Entry ID 36 (OID 17795)
--
-- Name: raw_logs Type: TABLE DATA Owner: postgres
--


COPY "raw_logs" FROM stdin;
\.
--
-- TOC Entry ID 25 (OID 17749)
--
-- Name: "customers_login_key" Type: INDEX Owner: postgres
--

CREATE UNIQUE INDEX customers_login_key ON customers USING btree (login);

--
-- TOC Entry ID 26 (OID 17763)
--
-- Name: "cash_cust_id_key" Type: INDEX Owner: postgres
--

CREATE UNIQUE INDEX cash_cust_id_key ON cash USING btree (cust_id);

--
-- TOC Entry ID 45 (OID 17756)
--
-- Name: "RI_ConstraintTrigger_17755" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "services"  FROM "nets_names" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'services', 'nets_names', 'UNSPECIFIED', 'net_id', 'net_id');

--
-- TOC Entry ID 39 (OID 17758)
--
-- Name: "RI_ConstraintTrigger_17757" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "nets_names"  FROM "services" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'services', 'nets_names', 'UNSPECIFIED', 'net_id', 'net_id');

--
-- TOC Entry ID 40 (OID 17760)
--
-- Name: "RI_ConstraintTrigger_17759" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "nets_names"  FROM "services" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'services', 'nets_names', 'UNSPECIFIED', 'net_id', 'net_id');

--
-- TOC Entry ID 46 (OID 17765)
--
-- Name: "RI_ConstraintTrigger_17764" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "cash"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'cash', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 41 (OID 17767)
--
-- Name: "RI_ConstraintTrigger_17766" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "customers"  FROM "cash" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'cash', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 42 (OID 17769)
--
-- Name: "RI_ConstraintTrigger_17768" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "customers"  FROM "cash" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'cash', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 47 (OID 17784)
--
-- Name: "RI_ConstraintTrigger_17783" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "tariffs"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'tariffs', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 43 (OID 17786)
--
-- Name: "RI_ConstraintTrigger_17785" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "customers"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'tariffs', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 44 (OID 17788)
--
-- Name: "RI_ConstraintTrigger_17787" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "customers"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'tariffs', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 48 (OID 17790)
--
-- Name: "RI_ConstraintTrigger_17789" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "tariffs"  FROM "tariffs_names" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'tariffs', 'tariffs_names', 'UNSPECIFIED', 'tariff_id', 'tariff_id');

--
-- TOC Entry ID 37 (OID 17792)
--
-- Name: "RI_ConstraintTrigger_17791" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "tariffs_names"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'tariffs', 'tariffs_names', 'UNSPECIFIED', 'tariff_id', 'tariff_id');

--
-- TOC Entry ID 38 (OID 17794)
--
-- Name: "RI_ConstraintTrigger_17793" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "tariffs_names"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'tariffs', 'tariffs_names', 'UNSPECIFIED', 'tariff_id', 'tariff_id');

--
-- TOC Entry ID 3 (OID 17723)
--
-- Name: id Type: SEQUENCE SET Owner: 
--

SELECT setval ('"id"', 101, true);

