// --------------------------------------------------------------------
// Standard Ipe styles (embedded in Ipelib)
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipebase.h"
#include "ipestyle.h"
#include "ipeiml.h"

const char *StyleStandard[] = {
  "<ipestyle>",
  "<color name=\"red\" value=\"1 0 0\"/>",
  "<color name=\"green\" value=\"0 1 0\"/>",
  "<color name=\"blue\" value=\"0 0 1\"/>",
  "<color name=\"yellow\" value=\"1 1 0\"/>",
  "<color name=\"gray1\" value=\"0.125\"/>",
  "<color name=\"gray2\" value=\"0.25\"/>",
  "<color name=\"gray3\" value=\"0.375\"/>",
  "<color name=\"gray4\" value=\"0.5\"/>",
  "<color name=\"gray5\" value=\"0.625\"/>",
  "<color name=\"gray6\" value=\"0.75\"/>",
  "<color name=\"gray7\" value=\"0.875\"/>",
  "<dashstyle name=\"dashed\" value=\"[4] 0\"/>",
  "<dashstyle name=\"dotted\" value=\"[1 3] 0\"/>",
  "<dashstyle name=\"dash dotted\" value=\"[4 2 1 2] 0\"/>",
  "<dashstyle name=\"dash dot dotted\" value=\"[4 2 1 2 1 2] 0\"/>",
  "<linewidth name=\"normal\" value=\"0.4\"/>",
  "<linewidth name=\"heavier\" value=\"0.8\"/>",
  "<linewidth name=\"fat\" value=\"1.2\"/>",
  "<linewidth name=\"ultrafat\" value=\"2\"/>",
  "<textsize name=\"normal\" value=\"\\normalsize\"/>",
  "<textsize name=\"large\" value=\"\\large\"/>",
  "<textsize name=\"Large\" value=\"\\Large\"/>",
  "<textsize name=\"LARGE\" value=\"\\LARGE\"/>",
  "<textsize name=\"huge\" value=\"\\huge\"/>",
  "<textsize name=\"Huge\" value=\"\\Huge\"/>",
  "<textsize name=\"small\" value=\"\\small\"/>",
  "<textsize name=\"footnote\" value=\"\\footnotesize\"/>",
  "<textsize name=\"tiny\" value=\"\\tiny\"/>",
  "<marksize name=\"normal\" value=\"3\"/>",
  "<marksize name=\"small\" value=\"2\"/>",
  "<marksize name=\"tiny\" value=\"1.1\"/>",
  "<marksize name=\"large\" value=\"5\"/>",
  "<arrowsize name=\"normal\" value=\"7\"/>",
  "<arrowsize name=\"small\" value=\"5\"/>",
  "<arrowsize name=\"tiny\" value=\"3\"/>",
  "<arrowsize name=\"large\" value=\"10\"/>",
  "<grid name=\"4 pts\" value=\"4\"/>",
  "<grid name=\"8 pts\" value=\"8\"/>",
  "<grid name=\"16 pts\" value=\"16\"/>",
  "<grid name=\"32 pts\" value=\"32\"/>",
  "<grid name=\"5 mm\" value=\"14.17\"/>",
  "<grid name=\"10 mm\" value=\"28.34\"/>",
  "<grid name=\"20 mm\" value=\"46.68\"/>",
  "<angle name=\"90\" value=\"90\"/>",
  "<angle name=\"60\" value=\"60\"/>",
  "<angle name=\"45\" value=\"45\"/>",
  "<angle name=\"30\" value=\"30\"/>",
  "<angle name=\"22.5\" value=\"22.5\"/>",
  "<media name=\"A4\" value=\"595 842\"/>",
  "<media name=\"A4R\" value=\"842 595\"/>",
  "<media name=\"Letter\" value=\"612 792\"/>",
  "<media name=\"800 x 600\" value=\"800 600\"/>",
  "<media name=\"1024 x 768\" value=\"1024 768\"/>",
  "<media name=\"1280 x 1024\" value=\"1280 1024\"/>",
  "<margins tl=\"36 36\" br=\"36 36\"/>",
  "</ipestyle>",
  0 };

class IpeStandardStyleSource : public IpeXmlDataSource {
public:
  IpeStandardStyleSource(const char **lines)
    : iLine(lines), iChar(lines[0]) { /* nothing */ }
  int GetChar();
private:
  const char **iLine;
  const char *iChar;
};

int IpeStandardStyleSource::GetChar()
{
  if (!*iLine)
    return EOF;
  // not yet at end of data
  if (!*iChar) {
    iLine++;
    iChar = *iLine;
    return '\n'; // important: iChar may be 0 now!
  }
  return *iChar++;
}

//! Create standard built-in style sheet.
IpeStyleSheet *IpeStyleSheet::Standard(IpeRepository *rep)
{
  IpeStandardStyleSource source(StyleStandard);
  IpeImlParser parser(source, rep);
  IpeStyleSheet *sheet = parser.ParseStyleSheet();
  assert(sheet);
  sheet->iStandard = true;
  sheet->iName = "standard";
  sheet->iRepository = rep;
  return sheet;
}

// --------------------------------------------------------------------
