// -*- C++ -*-
// --------------------------------------------------------------------
// Private fontpool implementation
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef FONTPOOL_P_H
#define FONTPOOL_P_H

// --------------------------------------------------------------------

class FTFontEngine;
class FTFont;
class FTFace;
class XRef;
class Ref;
class GfxFont;

class IpeFontPoolPriv {
public:
  IpeFontPoolPriv();
  ~IpeFontPoolPriv();

  FTFace *GetFace(XRef *xref, GfxFont *gfxFont);
  FTFont *GetFont(Ref *id, double m11, double m12,
		  double m21, double m22) const;

  void RenderCharacter(QPixmap *pixmap, int fontObject,
		       const IpeMatrix &m,
		       const IpeVector &pos,
		       QRgb cRgb, uint charCode, uint uniCode) const;

private:
  FTFace *TryGetFTFace(XRef *xref, GfxFont *gfxFont);
  FTFace *TryGetFTFaceFromBuffer(XRef *xref,
				 const char *buffer, int size,
				 GfxFont *gfxFont);
  FTFace *TrySettingFTFaceMode(FTFace *face, GfxFont *gfxFont);

private:
  struct EmbeddableFont {
    int iLatexNumber;    //!< Font id in the Pdflatex output: /Fxx
    int iObjectNumber;   //!< Object number in Ipe-created PDF output.
    IpeString iFontDict;
    IpeString iFontDescriptor;
    IpeString iStreamDict;
    IpeBuffer iStreamData;
  };

  typedef std::list<FTFace *> FTFaceSeq;
  typedef std::list<FTFont *> FTFontSeq;
  typedef std::vector<EmbeddableFont> FontSeq;

  FTFontEngine *iEngine;
  FTFaceSeq iFTFaces;

  mutable FTFontSeq iFTFonts;
  FontSeq iFonts;

  friend class IpeLatex;
  friend class IpePdfWriter;
};

// --------------------------------------------------------------------
#endif
