// -*- C++ -*-
// --------------------------------------------------------------------
// Popup menu with object attributes
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef PROPS_H
#define PROPS_H

#include "ipevisitor.h"
#include "ipeobj.h"
#include "ipepage.h"

#include <QString>
#include <QPixmap>
#include <QMenu>

// --------------------------------------------------------------------

class IpeStyleSheet;
class IpeCanvas;
class IpeOverlayServices;
class IpeAction;

class AttributePopup : public QObject, public IpeVisitor {
  Q_OBJECT
public:
  AttributePopup(IpePage::iterator it, IpePage *page,
		 IpeCanvas *canvas, int layer,
		 const IpeStyleSheet *sheet,
		 const IpeAttributeSeq *syms,
		 IpeOverlayServices *services);

  virtual void VisitGroup(const IpeGroup *obj);
  virtual void VisitPath(const IpePath *obj);
  virtual void VisitMark(const IpeMark *obj);
  virtual void VisitText(const IpeText *obj);
  virtual void VisitImage(const IpeImage *obj);
  virtual void VisitReference(const IpeReference *obj);

  void Exec();

private slots:
  void SetStroke(int id);
  void SetFill(int id);
  void SetLineWidth(int id);
  void SetDashStyle(int id);
  void SetTextSize(int id);
  void SetMarkShape(int id);
  void SetMarkSize(int id);
  void SetForwardArrow(int id);
  void SetBackwardArrow(int id);
  void SetLayer(int id);
  void SetCap(int id);
  void SetJoin(int id);
  void SetWindRule(int id);
  void SetTransformable(int id);
  void SetVAlign(int id);
  void SetHAlign(int id);
  void SetParagraph(int id);

  void Edit();
  void Ungroup();
  void DecomposePath();
  void UseScissors();
  void ChangeWidth();

private:
  QString String(IpeAttribute attr) const;
  void connect(IpeAction *a, const char *receiver);

  void SetTitle(QString str);
  void AddComment(QString str);
  void InsertLayer(int layer);
  void InsertColor(QString str, IpeAttribute color, bool fill = false);
  void InsertAttribute(QString str, IpeKind kind, IpeAttribute attr);
  void InsertArrow(QString str, IpeAttribute arr, bool backw);
  void InsertStrokeStyle(IpeStrokeStyle attr);
  void InsertEdit();

private:
  QMenu *iMenu;
  IpeCanvas *iCanvas;
  IpeOverlayServices *iServices;
  const IpeStyleSheet *iStyleSheet;
  const IpeAttributeSeq *iSyms;
  IpePage *iPage;
  IpePage::iterator iIt;
  IpeObject *iObject;
  IpePgObject iOriginal;
  int iLayer;
  bool iLayerLocked;
  bool iChanged;
};

// --------------------------------------------------------------------
#endif
