// -*- C++ -*-
// --------------------------------------------------------------------
// Ipe <-> Qt interface
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef QIPE_H
#define QIPE_H

#include "ipebase.h"
#include "ipexml.h"
#include "ipecolor.h"

#include <QString>

// --------------------------------------------------------------------

class QIODevice;

inline IpeString IpeQ(const QString &str)
{
  return IpeString(str.toUtf8());
}

inline QString QIpe(const IpeString &str)
{
  return QString::fromUtf8(str.CString());
}

class IpeQStream : public IpeTellStream {
public:
  IpeQStream(QIODevice *file);
  virtual void PutChar(char ch);
  virtual void PutString(IpeString s);
  virtual void PutCString(const char *s);
  virtual void PutRaw(const char *data, int size);
  virtual int Tell() const;
private:
  QIODevice *iDevice;
};

class XmlQStringSource : public IpeDataSource {
public:
  XmlQStringSource(QString str);
  virtual int GetChar();
private:
  IpeString iData;
  int iPos;
};

class XmlQSource : public IpeDataSource {
public:
  XmlQSource(QIODevice *dev, bool skipPercent = false);
  virtual int GetChar();
private:
  bool iSkipPercent;
  QIODevice *iDev;
};

inline IpeStream &operator<<(IpeStream &stream, const QString &str)
{
  stream << IpeQ(str);
  return stream;
}

// --------------------------------------------------------------------
#endif
