/*
 * Copyright (c) 2018, Intel Corporation.
 * SPDX-License-Identifier: BSD-3-Clause
 */
"# ipmctl configuration file\n"
"\n"
"# 0 - Use SMBIOS Type 17 handle\n"
"# 1 - Use DIMM UID\n"
"CLI_DEFAULT_DIMM_ID = 0\n"
"\n"
"# 0 - Automatically use the best format for each capacity in binary format\n"
"# 1 - Automatically use the best format for each capacity in decimal multiples of bytes\n"
"# 2 - Display all capacities in bytes\n"
"# 3 - Display all capacities in megabytes\n"
"# 4 - Display all capacities in mebibytes\n"
"# 5 - Display all capacities in gigabytes\n"
"# 6 - Display all capacities in gibibytes\n"
"# 7 - Display all capacities in terabytes\n"
"# 8 - Display all capacities in tebibytes\n"
"CLI_DEFAULT_SIZE = 6\n"
"\n"
"# RECOMMENDED - 32 GiB\n"
"# 1 - 1 GiB\n"
"APPDIRECT_GRANULARITY = RECOMMENDED\n"
"\n"
"# RECOMMENDED - BIOS Recommended App Direct settings\n"
"# IMCSize_ChannelSize - iMC Size & Channel Size manually specified\n"
"APPDIRECT_SETTINGS = RECOMMENDED\n"
"# 0 - Disabled\n"
"# 1 - Enabled\n"
"CHANNEL_INTERLEAVE_SIZE = RECOMMENDED\n"
"IMC_INTERLEAVE_SIZE = RECOMMENDED\n"
"# The interleave settings to use when creating App Direct capacity in the\n"
"# format: (IMCSize_ChannelSize).Must be one of the BIOS supported\n"
"#  AppDirect settings returned by the command Show System Capabilities\n"
"\n"
"PERFORMANCE_MONITOR_ENABLED = 0\n"
"PERFORMANCE_MONITOR_INTERVAL_MINUTES = 60\n"
"# 0 - Disabled\n"
"# 1 - Enabled\n"
"EVENT_MONITOR_ENABLED = 0\n"
"EVENT_MONITOR_INTERVAL_MINUTES = 60\n"
"\n"
"# DIMM Mailbox payload size configuration\n"
"# If the value equals 1 the large payload access to the dimm is disabled\n"
"# If the value equals 0 the large payload access is allowed\n"
"# The other values will be ignored and won't affect the large payload access\n"
"LARGE_PAYLOAD_DISABLED = 1\n"
"\n"
"# Application temporary files path configuration\n"
"# The app is going to use the path to store various files required\n"
"# during the execution i.e. *.ar files\n"
"TEMP_FILE_PATH = "TEMP_FILE_PATH"\n"
"\n"
"# System Log configuration - in case configured history files all\n"
"# system events are being stored in both system log and the file\n"
"# otherwise only the system log is being used\n"
"EVENT_LOG_FILE_NAME = "LOG_INSTALL_PATH"event.log\n"
"EVENT_LOG_MAX = 0\n"
"DBG_LOG_FILE_NAME = "LOG_INSTALL_PATH"debug.log\n"
"DBG_LOG_MAX = 0\n"
"# 0 - Disabled\n"
"# 1 - Enabled\n"
"DBG_LOG_STDOUT_ENABLED = 0\n"
"# 0 - Disabled\n"
"# 1 - Enabled\n"
"DBG_LOG_DEBUG_FILE_ENABLED = 1\n"
"# 0 - Debug Logger Off\n"
"# 1 - Log ERRORs only\n"
"# 2 - Log WARNINGs and above\n"
"# 3 - Log INFOs and above\n"
"# 4 - Verbose mode On\n"
"DBG_LOG_LEVEL = 0\n"
