# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: mkupdate.py,v 1.2 2005/09/14 13:41:19 sgrayban Exp $

import zipfile
import time
import os, os.path
import sys

assert os.path.isfile('iPodderGui.py'), "Run this from the source directory!"

sys.path.insert(0, 'win32')
import setup

filename = "ipodder-%04d-%02d-%02d.zip" % time.localtime()[:3]
filename = os.path.join('dist', filename)
# zipfile.PyZipFile(filename, 'w').writepy('ipodder')
zf = zipfile.ZipFile(filename, 'w', zipfile.ZIP_DEFLATED)

for top in ['ipodder', 'gui']: 
    for root, dirs, files in os.walk(top): 
        if os.path.split(root)[1] == 'CVS': 
            continue
        for file in files: 
            name, ext = os.path.splitext(file)
            if not ext in ['.py']: 
                continue
            print file
            zf.write(os.path.join(root, file))

for root, files in setup.kwargs['data_files']: 
    for file in files: 
        print file
        zf.write(file)

zf.close()
os.system(filename)
