
"""
Translation credits:

English: Lemon Team
Dutch: Martijn Venrooy (martijn@active8.nl) - Agreed
Spanish: Gabriela Rodriguez (gabelula@gmail.com) - Agreed
French: Olivier (olisker@gmail.com) - Invited
German: Nicole Simon (nisiatyahoo@gnak.de) - Agreed
Brazilian: Helio Chissini de Castro (heliocastro@gmail.com) - Agreed
Japans: tomoya kawanishi (tomoppi@users.sourceforge.net) - Agreed

"""

from xml.sax import make_parser, handler
import StringIO
import iPodderStringsShared
import iPodderStringsEnglish
import iPodderStringsDutch
import iPodderStringsFrench
import iPodderStringsGerman
import iPodderStringsItalian
import iPodderStringsSpanish
import iPodderStringsBrazilianPortuguese
import iPodderStringsJapanese

DUTCH=360
ENGLISH=129
FRENCH=157
GERMAN=113
ITALIAN=232
SPANISH=135
BRAZILIAN_PORTUGUESE=190
JAPANESE=111

def supported_languages():
    return [DUTCH,
        ENGLISH,
        FRENCH,
        GERMAN,
        ITALIAN,
        SPANISH,
        BRAZILIAN_PORTUGUESE,
        JAPANESE,
    ]
         
class StringTable:
    class __impl:
        def __init__(self, language):   
            #self.m_languages = ["DUTCH", "ENGLISH", "FRENCH", "GERMAN", "ITALIAN", "SPANISH"]
            self.m_languages = [DUTCH, ENGLISH, FRENCH, GERMAN, ITALIAN, SPANISH, BRAZILIAN_PORTUGUESE, JAPANESE]
            self.m_string_table = {}
            for l in self.m_languages:
                self.m_string_table[l]={}            
            self.LoadLanguage(language)
            
        def LoadLanguage(self, language):
            iPodderStringsShared.AddStrings(self)
            if language==ENGLISH:
                iPodderStringsEnglish.AddStrings(self)
            if language==DUTCH:
                iPodderStringsDutch.AddStrings(self)
            if language==FRENCH:            
                iPodderStringsFrench.AddStrings(self)
            if language==GERMAN:            
                iPodderStringsGerman.AddStrings(self)
            if language==ITALIAN:            
                iPodderStringsItalian.AddStrings(self)
            if language==SPANISH:            
                iPodderStringsSpanish.AddStrings(self)
            if language==BRAZILIAN_PORTUGUESE:
                iPodderStringsBrazilianPortuguese.AddStrings(self)
            if language==JAPANESE:
                iPodderStringsJapanese.AddStrings(self)
            
        def AddText(self, language, label, text):
            if (self.m_string_table[language].has_key(label)):
                print "[" + label + "] exsists hence ignored."
            self.m_string_table[language][label]=text
            
        def GetText(self, language, label, args=None):
            if self.m_string_table[language].has_key(label):
                if args:
                    return self.m_string_table[language][label] % args
                else:
                    return self.m_string_table[language][label]
            else:
                if language==ENGLISH:
                    lstr = "ENGLISH"
                if language==DUTCH:
                    lstr = "DUTCH"
                if language==FRENCH:            
                    lstr = "FRENCH"
                if language==GERMAN:            
                    lstr = "GERMAN"
                if language==ITALIAN:            
                    lstr = "ITALIAN"
                if language==SPANISH:            
                    lstr = "SPANISH"
                if language==BRAZILIAN_PORTUGUESE:
                    lstr = "BRAZILIAN_PORTUGUESE"
                if language==JAPANESE:
                    lstr = "JAPANESE"                    
                print "don't have label [" + label + "] for this language [" + lstr + "]"
                return label
                
        def GetLanguages(self):
            return self.m_languages 

    __instance = None

    def __init__(self, language):
        if StringTable.__instance is None:
            StringTable.__instance = StringTable.__impl(language)
        self.__dict__['_StringTable__instance'] = StringTable.__instance
                
    def __getattr__(self, attr):
        return getattr(self.__instance, attr)

    def __setattr__(self, attr, value):
        return setattr(self.__instance, attr, value)

class XRCEventHandler(handler.ContentHandler):
    def __init__(self):
        self.m_labels = []
        self.m_xrc = ""
        self.m_label = ""
        self.p_label = False
        
    def startElement(self, name, attrs):
        if name=="label": 
            self.p_label = True
    
    def endElement(self,name):                    
        if name=="label": 
            self.p_label = False
            self.m_labels.append(self.m_label)
            self.m_label = ""
        
    def characters(self,ch):
        if self.p_label:
            self.m_label += ch
        self.m_xrc += ch
                      
def parse_xml_gui():
    xml_xrc = ""
    xrc = open("./gui/iPodderFeed.xrc", "r")
    for line in xrc:
        xml_xrc += line

    parser = make_parser()
    result = XRCEventHandler()
    parser.setContentHandler(result)
    io_xml_xrc = StringIO.StringIO(xml_xrc)
    parser.parse(io_xml_xrc)
        
    str_table = StringTable();
    
    for language in str_table.m_languages:
        for text in result.m_labels:
            print "s1.AddText(" + language + ", \"str_" + text.lower() + "\", \"" +  text + "\")";
     
def unittest():
    print "unit test"
    strt = StringTable()
    print "--------------"
    print strt.GetText(ENGLISH, "str_license_gpl")
    print "--------------"
    print strt.GetText(DUTCH, "str_license_gpl")
    print "--------------"
    print strt.GetText(FRENCH, "str_license_gpl")
    print "--------------"
    print strt.GetText(GERMAN, "str_license_gpl")
    print "--------------"
    print strt.GetText(ITALIAN, "str_license_gpl")
    print "--------------"
    print strt.GetText(SPANISH, "str_license_gpl")
    print "--------------"
    print strt.GetText(BRAZILIANPORTUGUESE, "str_license_gpl")
       
if __name__ == '__main__':
    unittest();
