/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "propertyutility.h"

const QString PropertyUtility::defaultmimetype= QString( "text/html");
const QString PropertyUtility::name= QString( "Properties");

PropertyUtility::PropertyUtility(ITunesDB& trackcontainer)
{
    container= &trackcontainer;
}

PropertyUtility::~PropertyUtility()
{
}

const QString& PropertyUtility::getName() {
    return name;
}

const QString& PropertyUtility::getDefaultMimeType() {
    return defaultmimetype;
}

void PropertyUtility::handleRequest(const KURL& request, QByteArray& response, QString& mimeType)
{
    QTextOStream stream( response);
    QString title= container->getMainplaylist()->getTitle();
    
    mimeType= "text/html";
    stream << "<html><head><title>Settings for <em>" + title + "</em></title></head>\n";
    stream << "<body bgcolor=\"white\">\n";
    stream << "<h1 align=\"right\">Settings page for " + title + "</h1>\n";
    stream << "<div align=\"center\">This utility isn't implemented yet. One thing you'll be able to do here in the future is set the name of the iPod. More ideas are welcome.</div>\n";
    stream << "</body></html>\n";
}

