/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "syncutility.h"

const QString SyncUtility::defaultmimetype= QString( "text/html");
const QString SyncUtility::name= QString( "Synchronize");

SyncUtility::SyncUtility(IPod& ipod)
    : IPodUtility(), _ipod_(ipod)
{
}


SyncUtility::~SyncUtility()
{
}

const QString& SyncUtility::getName() {
    return name;
}

const QString& SyncUtility::getDefaultMimeType()
{
    return defaultmimetype;
}

void SyncUtility::handleRequest(const KURL& request, QByteArray& response, QString& mimeType)
{
    QTextOStream stream( response);
    QString really= request.queryItem( "really");
    QString title= _ipod_.getName();

    
    mimeType= QString( "text/html");
    stream << "<html><head><title>" + name + "</title></head>\n<body bgcolor=\"white\">";
    
    if( really.isEmpty()) {
        // put the confirm message here ...
        stream << "<H1 align=\"right\">Sync with <em>" << title << "</em></H1>";
        stream << "<br>This Utility saves the changes to your iPod. Since this feature <strong>isn&#039;t fully tested yet</strong>\n";
        stream << "and may result in a <strong>corrupted Database</strong> please make sure you have a backup copy of your original iTunesDB file\n";
        stream << "<strong>before</strong> pressing the OK button below. You can find this file under\n";
        stream << "<a href=\"file://" + _ipod_.getITunesDbFilename() + "\">" + _ipod_.getITunesDbFilename() + "</a><br><br>\n";
        stream << "Press the OK button if you really want to save your changes or push the back button on your browser.<br>\n<hr><p><FORM method=\"GET\" action=\"Synchronize\">\n";
        stream << "<div align=\"center\"><INPUT type=\"submit\" name=\"really\" value=\"OK\"></div>\n</FORM></p>";
    } else {
        if( request.queryItem( "really") == "OK") {
            _ipod_.writeItunesDB();
        
            if( !_ipod_.getItunesDBError().isEmpty()) { // an error occured
                stream << "Sync failed. " + _ipod_.getItunesDBError();
            } else {
                stream << "Sync successfull";
            }
        } else {
            stream << "Sync cancelled";
        }
    }
    
    stream << "</body></html>\n";
}

