/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "statisticsutility.h"

#include <qtextstream.h>

const QString StatisticsUtility::defaultmimetype= QString( "text/html");
const QString StatisticsUtility::name= QString( "Statistics");

StatisticsUtility::StatisticsUtility()
 : IPodUtility()
{
}


StatisticsUtility::~StatisticsUtility()
{
}

const QString& StatisticsUtility::getName() {
    return name;
}

const QString& StatisticsUtility::getDefaultMimeType() {
    return defaultmimetype;
}

void StatisticsUtility::handleRequest(IPod& ipod, const KURL&, QByteArray& response, QString& mimeType)
{
    IPodSysInfo * sysInfo = ipod.getSysInfo();
    sysInfo->refreshDiskUsageStats();

    QTextOStream stream( response);
    QString title= ipod.getName();

    long mbTotal = sysInfo->getTotalDiskSpaceKB() >> 10;
    long mbAvail = sysInfo->getAvailableDiskSpaceKB() >> 10;
    long percent = (sysInfo->getUsedDiskSpaceKB() >> 10) * 100 / mbTotal;

    mimeType= "text/html";
    stream << "<html><head><title>Statistics for " + title + "</title></head>\n";
    stream << "<body bgcolor=\"white\">\n";
    stream << "<h1 align=\"right\">Statistics for <em>" + title + "</em></h1>\n";
    stream << "<table align=\"center\" frame=\"void\"><tbody>\n";
    stream << "<tr><td>Number of tracks</td><td>" << QString::number( ipod.getNumTracks()) << "</td></tr>\n";
    stream << "<tr><td>Number of playlists</td><td>" << QString::number( ipod.getNumPlaylists()) << "</td></tr>\n";
    stream << "<tr><td>Total disk space</td><td>" << mbTotal << " MB</td></tr>\n";
    stream << "<tr><td>Space available on the device</td><td>" << mbAvail << " MB</td></tr>\n";

    // usage graphics
    stream << "<tr><td colspan=\"2\"><table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr>\n";
    for (int i = 0; i < 20; ++i) {
        stream << "<td bgcolor=\"" << (((i * 5) < percent) ? "red" : "green") << "\">&nbsp</td>";
    }
    stream << "</tr></tbody></table></td></tr>";
    stream << "</tbody></table></body></html>\n";
}

