/***************************************************************************
 *   Copyright (C) 2009 by BUI Quang Minh   *
 *   minh.bui@univie.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "modelprotein.h"
#include "nclextra/myreader.h"
#include <string>

/*
	following are definitions for various protein models encoded in a string.
	This string contains the lower triangle of the rate matrix and the state frequencies at the end.
	It should follow the amino acid order:
	A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V
	Ala Arg Asn Asp Cys Gln Glu Gly His Ile Leu Lys Met Phe Pro Ser Thr Trp Tyr Val
*/
const char* builtin_prot_models = R"(
#nexus;

begin models;

model POISSON=
1
1 1
1 1 1
1 1 1 1
1 1 1 1 1
1 1 1 1 1 1
1 1 1 1 1 1 1
1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05 0.05;

model DAYHOFF=
27
98 32
120 0 905
36 23 0 0
89 246 103 134 0
198 1 148 1153 0 716
240 9 139 125 11 28 81
23 240 535 86 28 606 43 10
65 64 77 24 44 18 61 0 7
41 15 34 0 0 73 11 7 44 257
26 464 318 71 0 153 83 27 26 46 18
72 90 1 0 0 114 30 17 0 336 527 243
18 14 14 0 0 0 0 15 48 196 157 0 92
250 103 42 13 19 153 51 34 94 12 32 33 17 11
409 154 495 95 161 56 79 234 35 24 17 96 62 46 245
371 26 229 66 16 53 34 30 22 192 33 136 104 13 78 550
0 201 23 0 0 0 0 0 27 0 46 0 0 76 0 75 0
24 8 95 0 96 0 22 0 127 37 28 13 0 698 0 34 42 61
208 24 15 18 49 35 37 54 44 889 175 10 258 12 48 30 157 0 28
0.08712691 0.04090396 0.04043196 0.04687195 0.03347397 0.03825496 0.04952995 0.08861191 0.03361897 0.03688596 0.08535691 0.08048092 0.01475299 0.03977196 0.05067995 0.06957693 0.05854194 0.01049399 0.02991597 0.06471794;
[ NOTE 2019-06-04: normalised from original Dayhoff freqs, which do not sum to 1.0
 https://www.ebi.ac.uk/goldman-srv/dayhoff/dayhoff-dcmut.dat ]

model DCMUT=
26.7828
98.4474 32.7059
119.9805 0.0000 893.1515
36.0016 23.2374 0.0000 0.0000
88.7753 243.9939 102.8509 134.8551 0.0000
196.1167 0.0000 149.3409 1138.8659 0.0000 708.6022
238.6111 8.7791 138.5352 124.0981 10.7278 28.1581 81.1907
22.8116 238.3148 529.0024 86.8241 28.2729 601.1613 43.9469 10.6802
65.3416 63.2629 76.8024 23.9248 43.8074 18.0393 60.9526 0.0000 7.6981
40.6431 15.4924 34.1113 0.0000 0.0000 73.0772 11.2880 7.1514 44.3504 255.6685
25.8635 461.0124 314.8371 71.6913 0.0000 151.9078 83.0078 26.7683 27.0475 46.0857 18.0629
71.7840 89.6321 0.0000 0.0000 0.0000 112.7499 30.4803 17.0372 0.0000 333.2732 523.0115 241.1739
18.3641 13.6906 13.8503 0.0000 0.0000 0.0000 0.0000 15.3478 47.5927 195.1951 156.5160 0.0000 92.1860
248.5920 102.8313 41.9244 13.3940 18.7550 152.6188 50.7003 34.7153 93.3709 11.9152 31.6258 33.5419 17.0205 11.0506
405.1870 153.1590 488.5892 95.6097 159.8356 56.1828 79.3999 232.2243 35.3643 24.7955 17.1432 95.4557 61.9951 45.9901 242.7202
368.0365 26.5745 227.1697 66.0930 16.2366 52.5651 34.0156 30.6662 22.6333 190.0739 33.1090 135.0599 103.1534 13.6655 78.2857 543.6674
0.0000 200.1375 22.4968 0.0000 0.0000 0.0000 0.0000 0.0000 27.0564 0.0000 46.1776 0.0000 0.0000 76.2354 0.0000 74.0819 0.0000
24.4139 7.8012 94.6940 0.0000 95.3164 0.0000 21.4717 0.0000 126.5400 37.4834 28.6572 13.2142 0.0000 695.2629 0.0000 33.6289 41.7839 60.8070
205.9564 24.0368 15.8067 17.8316 48.4678 34.6983 36.7250 53.8165 43.8715 881.0038 174.5156 10.3850 256.5955 12.3606 48.5026 30.3836 156.1997 0.0000 27.9379
 0.08712691 0.04090396 0.04043196 0.04687195 0.03347397 0.03825496 0.04952995 0.08861191 0.03361897 0.03688596 0.08535691 0.08048092 0.01475299 0.03977196 0.05067995 0.06957693 0.05854194 0.01049399 0.02991597 0.06471794;
[ NOTE 2019-06-04: normalised from original Dayhoff-DCMUT freqs, which do not sum to 1.0
  https://www.ebi.ac.uk/goldman-srv/dayhoff/dayhoff-dcmut.dat ]

model JTT=
58
54 45
81 16 528
56 113 34 10
57 310 86 49 9
105 29 58 767 5 323
179 137 81 130 59 26 119
27 328 391 112 69 597 26 23
36 22 47 11 17 9 12 6 16
30 38 12 7 23 72 9 6 56 229
35 646 263 26 7 292 181 27 45 21 14
54 44 30 15 31 43 18 14 33 479 388 65
15 5 10 4 78 4 5 5 40 89 248 4 43
194 74 15 15 14 164 18 24 115 10 102 21 16 17
378 101 503 59 223 53 30 201 73 40 59 47 29 92 285
475 64 232 38 42 51 32 33 46 245 25 103 226 12 118 477
9 126 8 4 115 18 10 55 8 9 52 10 24 53 6 35 12
11 20 70 46 209 24 7 8 573 32 24 8 18 536 10 63 21 71
298 17 16 31 62 20 45 47 11 961 180 14 323 62 23 38 112 25 16
0.07674792 0.05169095 0.04264496 0.05154395 0.01980298 0.04075196 0.06182994 0.07315193 0.02294398 0.05376095 0.09190391 0.05867594 0.02382598 0.04012596 0.05090095 0.06876493 0.05856494 0.01426099 0.03210197 0.06600493;
[ NOTE 2019-06-04: original JTT freqs do not sum to 1.0, taken from PAML package ]

model MTREV=
23.18
26.95 13.24
17.67 1.90 794.38
59.93 103.33 58.94 1.90
1.90 220.99 173.56 55.28 75.24
9.77 1.90 63.05 583.55 1.90 313.56
120.71 23.03 53.30 56.77 30.71 6.75 28.28
13.90 165.23 496.13 113.99 141.49 582.40 49.12 1.90
96.49 1.90 27.10 4.34 62.73 8.34 3.31 5.98 12.26
25.46 15.58 15.16 1.90 25.65 39.70 1.90 2.41 11.49 329.09
8.36 141.40 608.70 2.31 1.90 465.58 313.86 22.73 127.67 19.57 14.88
141.88 1.90 65.41 1.90 6.18 47.37 1.90 1.90 11.97 517.98 537.53 91.37
6.37 4.69 15.20 4.98 70.80 19.11 2.67 1.90 48.16 84.67 216.06 6.44 90.82
54.31 23.64 73.31 13.43 31.26 137.29 12.83 1.90 60.97 20.63 40.10 50.10 18.84 17.31
387.86 6.04 494.39 69.02 277.05 54.11 54.71 125.93 77.46 47.70 73.61 105.79 111.16 64.29 169.90
480.72 2.08 238.46 28.01 179.97 94.93 14.82 11.17 44.78 368.43 126.40 136.33 528.17 33.85 128.22 597.21
1.90 21.95 10.68 19.86 33.60 1.90 1.90 10.92 7.08 1.90 32.44 24.00 21.71 7.84 4.21 38.58 9.99
6.48 1.90 191.36 21.21 254.77 38.82 13.12 3.21 670.14 25.01 44.15 51.17 39.96 465.58 16.21 64.92 38.73 26.25
195.06 7.64 1.90 1.90 1.90 19.00 21.14 2.53 1.90 1222.94 91.67 1.90 387.54 6.35 8.23 1.90 204.54 5.37 1.90
0.072 0.019 0.039 0.019 0.006 0.025 0.024 0.056 0.028 0.088 0.169 0.023 0.054 0.061 0.054 0.072 0.086 0.029 0.033 0.043;
[ NOTE 2019-06-04: The PI's used to sum to 0.999 and I (Z. Yang) changed one of the freq from 0.168
  into 0.169 so that the sum is 1.  Prepared by Z. Yang ]
 
model WAG=
55.15710
50.98480 63.53460
73.89980 14.73040 542.94200
102.70400 52.81910 26.52560 3.02949
90.85980 303.55000 154.36400 61.67830 9.88179
158.28500 43.91570 94.71980 617.41600 2.13520 546.94700
141.67200 58.46650 112.55600 86.55840 30.66740 33.00520 56.77170
31.69540 213.71500 395.62900 93.06760 24.89720 429.41100 57.00250 24.94100
19.33350 18.69790 55.42360 3.94370 17.01350 11.39170 12.73950 3.04501 13.81900
39.79150 49.76710 13.15280 8.48047 38.42870 86.94890 15.42630 6.13037 49.94620 317.09700
90.62650 535.14200 301.20100 47.98550 7.40339 389.49000 258.44300 37.35580 89.04320 32.38320 25.75550
89.34960 68.31620 19.82210 10.37540 39.04820 154.52600 31.51240 17.41000 40.41410 425.74600 485.40200 93.42760
21.04940 10.27110 9.61621 4.67304 39.80200 9.99208 8.11339 4.99310 67.93710 105.94700 211.51700 8.88360 119.06300
143.85500 67.94890 19.50810 42.39840 10.94040 93.33720 68.23550 24.35700 69.61980 9.99288 41.58440 55.68960 17.13290 16.14440
337.07900 122.41900 397.42300 107.17600 140.76600 102.88700 70.49390 134.18200 74.01690 31.94400 34.47390 96.71300 49.39050 54.59310 161.32800
212.11100 55.44130 203.00600 37.48660 51.29840 85.79280 82.27650 22.58330 47.33070 145.81600 32.66220 138.69800 151.61200 17.19030 79.53840 437.80200
11.31330 116.39200 7.19167 12.97670 71.70700 21.57370 15.65570 33.69830 26.25690 21.24830 66.53090 13.75050 51.57060 152.96400 13.94050 52.37420 11.08640
24.07350 38.15330 108.60000 32.57110 54.38330 22.77100 19.63030 10.36040 387.34400 42.01700 39.86180 13.32640 42.84370 645.42800 21.60460 78.69930 29.11480 248.53900
200.60100 25.18490 19.62460 15.23350 100.21400 30.12810 58.87310 18.72470 11.83580 782.13000 180.03400 30.54340 205.84500 64.98920 31.48870 23.27390 138.82300 36.53690 31.47300
0.08662791 0.043972 0.0390894 0.05704511 0.0193078 0.0367281 0.05805891 0.08325181 0.0244313 0.048466 0.08620901 0.06202861 0.0195027 0.0384319 0.0457631 0.06951791 0.06101271 0.0143859 0.0352742 0.07089561;
[ NOTE 2019-06-04: normalised from original WAG freqs, which do not sum to 1.0 ]

model RTREV=
34
51 35
10 30 384
439 92 128 1
32 221 236 78 70
81 10 79 542 1 372
135 41 94 61 48 18 70
30 90 320 91 124 387 34 68
1 24 35 1 104 33 1 1 34
45 18 15 5 110 54 21 3 51 385
38 593 123 20 16 309 141 30 76 34 23
235 57 1 1 156 158 1 37 116 375 581 134
1 7 49 1 70 1 1 7 141 64 179 14 247
97 24 33 55 1 68 52 17 44 10 22 43 1 11
460 102 294 136 75 225 95 152 183 4 24 77 1 20 134
258 64 148 55 117 146 82 7 49 72 25 110 131 69 62 671
5 13 16 1 55 10 17 23 48 39 47 6 111 182 9 14 1
55 47 28 1 131 45 1 21 307 26 64 1 74 1017 14 31 34 176
197 29 21 6 295 36 35 3 1 1048 112 19 236 92 25 39 196 26 59
0.0646 0.0453 0.0376 0.0422 0.0114 0.0606 0.0607 0.0639 0.0273 0.0679 0.1018 0.0751 0.0150 0.0287 0.0681 0.0488 0.0622 0.0251 0.0318 0.0619;

model CPREV=
105
227 357
175 43 4435
669 823 538 10
157 1745 768 400 10
499 152 1055 3691 10 3122
665 243 653 431 303 133 379
66 715 1405 331 441 1269 162 19
145 136 168 10 280 92 148 40 29
197 203 113 10 396 286 82 20 66 1745
236 4482 2430 412 48 3313 2629 263 305 345 218
185 125 61 47 159 202 113 21 10 1772 1351 193
68 53 97 22 726 10 145 25 127 454 1268 72 327
490 87 173 170 285 323 185 28 152 117 219 302 100 43
2440 385 2085 590 2331 396 568 691 303 216 516 868 93 487 1202
1340 314 1393 266 576 241 369 92 32 1040 156 918 645 148 260 2151
14 230 40 18 435 53 63 82 69 42 159 10 86 468 49 73 29
56 323 754 281 1466 391 142 10 1971 89 189 247 215 2370 97 522 71 346
968 92 83 75 592 54 200 91 25 4797 865 249 475 317 122 167 760 10 119
0.0755 0.0621 0.0410 0.0371 0.0091 0.0382 0.0495 0.0838 0.0246 0.0806 0.1011 0.0504 0.0220 0.0506 0.0431 0.0622 0.0543 0.0181 0.0307 0.0660;
[ NOTE 2019-06-04: CPREV freqs taken from PAML package with higher precision ]

model VT=
1.2412691067876198
1.2184237953498958 1.5720770753326880
1.3759368509441177 0.7550654439001206 7.8584219153689405
2.4731223087544874 1.4414262567428417 0.9784679122774127 0.2272488448121475
2.2155167805137470 5.5120819705248678 3.0143201670924822 1.6562495638176040 0.4587469126746136
2.3379911207495061 1.3542404860613146 2.0093434778398112 9.6883451875685065 0.4519167943192672 6.8124601839937675
3.3386555146457697 1.3121700301622004 2.4117632898861809 1.9142079025990228 1.1034605684472507 0.8776110594765502 1.3860121390169038
0.9615841926910841 4.9238668283945266 6.1974384977884114 2.1459640610133781 1.5196756759380692 7.9943228564946525 1.6360079688522375 0.8561248973045037
0.8908203061925510 0.4323005487925516 0.9179291175331520 0.2161660372725585 0.9126668032539315 0.4882733432879921 0.4035497929633328 0.2888075033037488 0.5787937115407940
1.0778497408764076 0.8386701149158265 0.4098311270816011 0.3574207468998517 1.4081315998413697 1.3318097154194044 0.5610717242294755 0.3578662395745526 1.0765007949562073 6.0019110258426362
1.4932055816372476 10.0173308173660018 4.4034547578962568 1.4521790561663968 0.3371091785647479 6.0519085243118811 4.3290086529582830 0.8945563662345198 1.8085136096039203 0.6244297525127139 0.5642322882556321
1.9006455961717605 1.2488638689609959 0.9378803706165143 0.4075239926000898 1.2213054800811556 1.9106190827629084 0.7471936218068498 0.5954812791740037 1.3808291710019667 6.7597899772045418 8.0327792947421148 1.7129670976916258
0.6883439026872615 0.4224945197276290 0.5044944273324311 0.1675129724559251 1.6953951980808002 0.3573432522499545 0.2317194387691585 0.3693722640980460 1.3629765501081097 2.2864286949316077 4.3611548063555778 0.3910559903834828 2.3201373546296349
2.7355620089953550 1.3091837782420783 0.7103720531974738 1.0714605979577547 0.4326227078645523 2.3019177728300728 1.5132807416252063 0.7744933618134962 1.8370555852070649 0.4811402387911145 1.0084320519837335 1.3918935593582853 0.4953193808676289 0.3746821107962129
6.4208961859142883 1.9202994262316166 6.1234512396801764 2.2161944596741829 3.6366815408744255 2.3193703643237220 1.8273535587773553 3.0637776193717610 1.9699895187387506 0.6047491507504744 0.8953754669269811 1.9776630140912268 1.0657482318076852 1.1079144700606407 3.5465914843628927
5.2892514169776437 1.3363401740560601 3.8852506105922231 1.5066839872944762 1.7557065205837685 2.1576510103471440 1.5839981708584689 0.7147489676267383 1.6136654573285647 2.6344778384442731 1.0192004372506540 2.5513781312660280 3.3628488360462363 0.6882725908872254 1.9485376673137556 8.8479984061248178
0.5488578478106930 1.5170142153962840 0.1808525752605976 0.2496584188151770 1.6275179891253113 0.8959082681546182 0.4198391148111098 0.9349753595598769 0.6301954684360302 0.5604648274060783 1.5183114434679339 0.5851920879490173 1.4680478689711018 3.3448437239772266 0.4326058001438786 0.6791126595939816 0.4514203099376473
0.5411769916657778 0.8912614404565405 1.0894926581511342 0.7447620891784513 2.1579775140421025 0.9183596801412757 0.5818111331782764 0.3374467649724478 7.7587442309146040 0.8626796044156272 1.2452243224541324 0.7835447533710449 1.0899165770956820 10.3848523331334590 0.4819109019647465 0.9547229305958682 0.8564314184691215 4.5377235790405388
4.6501894691803214 0.7807017855806767 0.4586061981719967 0.4594535241660911 2.2627456996290891 0.6366932501396869 0.8940572875547330 0.6193321034173915 0.5333220944030346 14.8729334615190609 3.5458093276667237 0.7801080335991272 4.0584577156753401 1.7039730522675411 0.5985498912985666 0.9305232113028208 3.4242218450865543 0.5658969249032649 1.0000000000000000
0.0770764620135024 0.0500819370772208 0.0462377395993731 0.0537929860758246 0.0144533387583345 0.0408923608974345 0.0633579339160905 0.0655672355884439 0.0218802687005936 0.0591969699027449 0.0976461276528445 0.0592079410822730 0.0220695876653368 0.0413508521834260 0.0476871596856874 0.0707295165111524 0.0567759161524817 0.0127019797647213 0.0323746050281867 0.0669190817443274;

model BLOSUM62=
0.735790389698
0.485391055466 1.297446705134
0.543161820899 0.500964408555 3.180100048216
1.459995310470 0.227826574209 0.397358949897 0.240836614802
1.199705704602 3.020833610064 1.839216146992 1.190945703396 0.329801504630
1.170949042800 1.360574190420 1.240488508640 3.761625208368 0.140748891814 5.528919177928
1.955883574960 0.418763308518 1.355872344485 0.798473248968 0.418203192284 0.609846305383 0.423579992176
0.716241444998 1.456141166336 2.414501434208 0.778142664022 0.354058109831 2.435341131140 1.626891056982 0.539859124954
0.605899003687 0.232036445142 0.283017326278 0.418555732462 0.774894022794 0.236202451204 0.186848046932 0.189296292376 0.252718447885
0.800016530518 0.622711669692 0.211888159615 0.218131577594 0.831842640142 0.580737093181 0.372625175087 0.217721159236 0.348072209797 3.890963773304
1.295201266783 5.411115141489 1.593137043457 1.032447924952 0.285078800906 3.945277674515 2.802427151679 0.752042440303 1.022507035889 0.406193586642 0.445570274261
1.253758266664 0.983692987457 0.648441278787 0.222621897958 0.767688823480 2.494896077113 0.555415397470 0.459436173579 0.984311525359 3.364797763104 6.030559379572 1.073061184332
0.492964679748 0.371644693209 0.354861249223 0.281730694207 0.441337471187 0.144356959750 0.291409084165 0.368166464453 0.714533703928 1.517359325954 2.064839703237 0.266924750511 1.773855168830
1.173275900924 0.448133661718 0.494887043702 0.730628272998 0.356008498769 0.858570575674 0.926563934846 0.504086599527 0.527007339151 0.388355409206 0.374555687471 1.047383450722 0.454123625103 0.233597909629
4.325092687057 1.122783104210 2.904101656456 1.582754142065 1.197188415094 1.934870924596 1.769893238937 1.509326253224 1.117029762910 0.357544412460 0.352969184527 1.752165917819 0.918723415746 0.540027644824 1.169129577716
1.729178019485 0.914665954563 1.898173634533 0.934187509431 1.119831358516 1.277480294596 1.071097236007 0.641436011405 0.585407090225 1.179091197260 0.915259857694 1.303875200799 1.488548053722 0.488206118793 1.005451683149 5.151556292270
0.465839367725 0.426382310122 0.191482046247 0.145345046279 0.527664418872 0.758653808642 0.407635648938 0.508358924638 0.301248600780 0.341985787540 0.691474634600 0.332243040634 0.888101098152 2.074324893497 0.252214830027 0.387925622098 0.513128126891
0.718206697586 0.720517441216 0.538222519037 0.261422208965 0.470237733696 0.958989742850 0.596719300346 0.308055737035 4.218953969389 0.674617093228 0.811245856323 0.717993486900 0.951682162246 6.747260430801 0.369405319355 0.796751520761 0.801010243199 4.054419006558
2.187774522005 0.438388343772 0.312858797993 0.258129289418 1.116352478606 0.530785790125 0.524253846338 0.253340790190 0.201555971750 8.311839405458 2.231405688913 0.498138475304 2.575850755315 0.838119610178 0.496908410676 0.561925457442 2.253074051176 0.266508731426 1.000000000000
0.074 0.052 0.045 0.054 0.025 0.034 0.054 0.074 0.026 0.068 0.099 0.058 0.025 0.047 0.039 0.057 0.051 0.013 0.032 0.073;

model MTMAM=
32
2 4
11 0.000001 864
0.000001 186 0.000001 0.000001
0.000001 246 8 49 0.000001
0.000001 0.000001 0.000001 569 0.000001 274
78 18 47 79 0.000001 0.000001 22
8 232 458 11 305 550 22 0.000001
75 0.000001 19 0.000001 41 0.000001 0.000001 0.000001 0.000001
21 6 0.000001 0.000001 27 20 0.000001 0.000001 26 232
0.000001 50 408 0.000001 0.000001 242 215 0.000001 0.000001 6 4
76 0.000001 21 0.000001 0.000001 22 0.000001 0.000001 0.000001 378 609 59
0.000001 0.000001 6 5 7 0.000001 0.000001 0.000001 0.000001 57 246 0.000001 11
53 9 33 2 0.000001 51 0.000001 0.000001 53 5 43 18 0.000001 17
342 3 446 16 347 30 21 112 20 0.000001 74 65 47 90 202
681 0.000001 110 0.000001 114 0.000001 4 0.000001 1 360 34 50 691 8 78 614
5 16 6 0.000001 65 0.000001 0.000001 0.000001 0.000001 0.000001 12 0.000001 13 0.000001 7 17 0.000001
0.000001 0.000001 156 0.000001 530 54 0.000001 1 1525 16 25 67 0.000001 682 8 107 0.000001 14
398 0.000001 0.000001 10 0.000001 33 20 5 0.000001 2220 100 0.000001 832 6 0.000001 0.000001 237 0.000001 0.000001
0.0692 0.0184 0.0400 0.0186 0.0065 0.0238 0.0236 0.0557 0.0277 0.0905 0.1675 0.0221 0.0561 0.0611 0.0536 0.0725 0.0870 0.0293 0.0340 0.0428;

model LG=
0.425093
0.276818 0.751878
0.395144 0.123954 5.076149
2.489084 0.534551 0.528768 0.062556
0.969894 2.807908 1.695752 0.523386 0.084808
1.038545 0.363970 0.541712 5.243870 0.003499 4.128591
2.066040 0.390192 1.437645 0.844926 0.569265 0.267959 0.348847
0.358858 2.426601 4.509238 0.927114 0.640543 4.813505 0.423881 0.311484
0.149830 0.126991 0.191503 0.010690 0.320627 0.072854 0.044265 0.008705 0.108882
0.395337 0.301848 0.068427 0.015076 0.594007 0.582457 0.069673 0.044261 0.366317 4.145067
0.536518 6.326067 2.145078 0.282959 0.013266 3.234294 1.807177 0.296636 0.697264 0.159069 0.137500
1.124035 0.484133 0.371004 0.025548 0.893680 1.672569 0.173735 0.139538 0.442472 4.273607 6.312358 0.656604
0.253701 0.052722 0.089525 0.017416 1.105251 0.035855 0.018811 0.089586 0.682139 1.112727 2.592692 0.023918 1.798853
1.177651 0.332533 0.161787 0.394456 0.075382 0.624294 0.419409 0.196961 0.508851 0.078281 0.249060 0.390322 0.099849 0.094464
4.727182 0.858151 4.008358 1.240275 2.784478 1.223828 0.611973 1.739990 0.990012 0.064105 0.182287 0.748683 0.346960 0.361819 1.338132
2.139501 0.578987 2.000679 0.425860 1.143480 1.080136 0.604545 0.129836 0.584262 1.033739 0.302936 1.136863 2.020366 0.165001 0.571468 6.472279
0.180717 0.593607 0.045376 0.029890 0.670128 0.236199 0.077852 0.268491 0.597054 0.111660 0.619632 0.049906 0.696175 2.457121 0.095131 0.248862 0.140825
0.218959 0.314440 0.612025 0.135107 1.165532 0.257336 0.120037 0.054679 5.306834 0.232523 0.299648 0.131932 0.481306 7.803902 0.089613 0.400547 0.245841 3.151815
2.547870 0.170887 0.083688 0.037967 1.959291 0.210332 0.245034 0.076701 0.119013 10.649107 1.702745 0.185202 1.898718 0.654683 0.296501 0.098369 2.188158 0.189510 0.249313
0.07906592 0.05594094 0.04197696 0.05305195 0.01293699 0.04076696 0.07158593 0.05733694 0.02235498 0.06215694 0.0990809 0.06459994 0.02295098 0.04230196 0.04403996 0.06119694 0.05328695 0.01206599 0.03415497 0.06914693;
[ NOTE 2019-06-04: normalised from original LG freqs, which do not sum to 1.0
  http://www.atgc-montpellier.fr/download/datasets/models/lg_LG.PAML.txt ]

model MTART=
0.2
0.2 0.2
1.0 4.0 500.0
254.0 36.0 98.0 11.0
0.2 154.0 262.0 0.2 0.2
0.2 0.2 183.0 862.0 0.2 262.0
200.0 0.2 121.0 12.0 81.0 3.0 44.0
0.2 41.0 180.0 0.2 12.0 314.0 15.0 0.2
26.0 2.0 21.0 7.0 63.0 11.0 7.0 3.0 0.2
4.0 2.0 13.0 1.0 79.0 16.0 2.0 1.0 6.0 515.0
0.2 209.0 467.0 2.0 0.2 349.0 106.0 0.2 0.2 3.0 4.0
121.0 5.0 79.0 0.2 312.0 67.0 0.2 56.0 0.2 515.0 885.0 106.0
13.0 5.0 20.0 0.2 184.0 0.2 0.2 1.0 14.0 118.0 263.0 11.0 322.0
49.0 0.2 17.0 0.2 0.2 39.0 8.0 0.2 1.0 0.2 12.0 17.0 5.0 15.0
673.0 3.0 398.0 44.0 664.0 52.0 31.0 226.0 11.0 7.0 8.0 144.0 112.0 36.0 87.0
244.0 0.2 166.0 0.2 183.0 44.0 43.0 0.2 19.0 204.0 48.0 70.0 289.0 14.0 47.0 660.0
0.2 0.2 8.0 0.2 22.0 7.0 11.0 2.0 0.2 0.2 21.0 16.0 71.0 54.0 0.2 2.0 0.2
1.0 4.0 251.0 0.2 72.0 87.0 8.0 9.0 191.0 12.0 20.0 117.0 71.0 792.0 18.0 30.0 46.0 38.0
340.0 0.2 23.0 0.2 350.0 0.2 14.0 3.0 0.2 1855.0 85.0 26.0 281.0 52.0 32.0 61.0 544.0 0.2 2.0
0.054116 0.018227 0.039903 0.020160 0.009709 0.018781 0.024289 0.068183 0.024518 0.092638 0.148658 0.021718 0.061453 0.088668 0.041826 0.091030 0.049194 0.029786 0.039443 0.057700;

model MTZOA=
3.3
1.7 33.6
16.1 3.2 617.0
272.5 61.1 94.6 9.5
7.3 231.0 190.3 19.3 49.1
17.1 6.4 174.0 883.6 3.4 349.4
289.3 7.2 99.3 26.0 82.4 8.9 43.1
2.3 61.7 228.9 55.6 37.5 421.8 14.9 7.4
33.2 0.2 24.3 1.5 48.8 0.2 7.3 3.4 1.6
15.6 4.1 7.9 0.5 59.7 23.0 1.0 3.5 6.6 425.2
0.2 292.3 413.4 0.2 0.2 334.0 163.2 10.1 23.9 8.4 6.7
136.5 3.8 73.7 0.2 264.8 83.9 0.2 52.2 7.1 449.7 636.3 83.0
26.5 0.2 12.9 2.0 167.8 9.5 0.2 5.8 13.1 90.3 234.2 16.3 215.6
61.8 7.5 22.6 0.2 8.1 52.2 20.6 1.3 15.6 2.6 11.4 24.3 5.4 10.5
644.9 11.8 420.2 51.4 656.3 96.4 38.4 257.1 23.1 7.2 15.2 144.9 95.3 32.2 79.7
378.1 3.2 184.6 2.3 199.0 39.4 34.5 5.2 19.4 222.3 50.0 75.5 305.1 19.3 56.9 666.3
3.1 16.9 6.4 0.2 36.1 6.1 3.5 12.3 4.5 9.7 27.2 6.6 48.7 58.2 1.3 10.3 3.6
2.1 13.8 141.6 13.9 76.7 52.3 10.0 4.3 266.5 13.1 5.7 45.0 41.4 590.5 4.2 29.7 29.0 79.8
321.9 5.1 7.1 3.7 243.8 9.0 16.3 23.7 0.3 1710.6 126.1 11.1 279.6 59.6 17.9 49.5 396.4 13.7 15.6
0.06887993 0.02103698 0.03038997 0.02069598 0.00996599 0.01862298 0.02498898 0.07196793 0.02681397 0.08507191 0.15671684 0.01927598 0.05065195 0.08171192 0.04480296 0.08053492 0.05638594 0.02799797 0.03740396 0.06608293;
[ NOTE 2019-06-04: original mtzoa freqs do not sum to 1.0, modified from PAML package ]

model PMB=
0.674995699
0.589645178 1.189067034
0.462499504 0.605460903 3.573373315
1.065445546 0.314448330 0.589852457 0.246951424
1.111766964 2.967840934 2.299755865 1.686058219 0.245163782
1.046334652 1.201770702 1.277836748 4.399995525 0.091071867 4.159678990
1.587964372 0.523770553 1.374854049 0.734992057 0.317066320 0.596789898 0.463812837
0.580830874 1.457127446 2.283037894 0.839348444 0.411543728 1.812173605 0.877842609 0.476331437
0.464590585 0.359645860 0.426069419 0.266775558 0.417547309 0.315256838 0.304215290 0.180198883 0.285186418
0.804404505 0.520701585 0.410094470 0.269124919 0.450795211 0.625792937 0.320784710 0.259854426 0.363981358 4.162454693
0.831998835 4.956476453 2.037575629 1.114178954 0.274163536 3.521346591 2.415974716 0.581001076 0.985885486 0.374784947 0.498011337
1.546725076 0.813462540 0.737846301 0.341932741 0.618614612 2.067388546 0.531773639 0.465349326 0.380925433 3.658070120 5.002338375 0.661095832
0.546169219 0.303437244 0.425193716 0.219005213 0.669206193 0.406042546 0.224154698 0.354028910 0.576231691 1.495264661 2.392638293 0.269496317 2.306919847
1.241586045 0.655773380 0.711495595 0.775624818 0.198679914 0.850116543 0.794584081 0.588254139 0.456058589 0.366232942 0.430073179 1.036079005 0.337502282 0.481144863
3.452308792 0.910144334 2.572577221 1.440896785 0.998700980 1.348272505 1.205509425 1.402122097 0.799966711 0.530641901 0.402471997 1.234648153 0.945453716 0.613230817 1.217683028
1.751412803 0.895171490 1.823161023 0.994227284 0.847312432 1.320626678 0.949599791 0.542185658 0.830392810 1.114132523 0.779827336 1.290709079 1.551488041 0.718895136 0.780913179 4.448982584
0.350110510 0.618778365 0.422407388 0.362495245 0.445669347 0.720384740 0.261258229 0.378748270 0.724367510 0.516260502 0.794797115 0.433409620 0.768395107 3.295193440 0.499869138 0.496334956 0.383723610
0.573154753 0.628599063 0.720013799 0.436220437 0.556261630 0.728970584 0.507200030 0.284727562 2.210952064 0.570562395 0.811019594 0.664884513 0.932536060 5.894735673 0.433748126 0.593795813 0.523549536 2.996248013
2.063050067 0.388680158 0.474418852 0.275658381 0.998911631 0.634408285 0.527640634 0.314700907 0.305792277 8.002789424 2.113077156 0.526184203 1.737356217 0.983844803 0.551333603 0.507506011 1.899650790 0.429570747 0.716795463
 
 0.07559244 0.05379462 0.03769623 0.04469553 0.02849715 0.03389661 0.05349465 0.0779922 0.029997 0.05989401 0.09579042 0.0519948 0.02189781 0.0449955 0.0419958 0.06819318 0.05639436 0.01569843 0.0359964 0.07149285;
 [ NOTE 2019-06-04: normalised from original PMB freqs, which do not sum to 1.0:
  0.0756 0.0538 0.0377 0.0447 0.0285 0.0339 0.0535 0.0780 0.0300 0.0599 0.0958 0.0520 0.0219 0.0450 0.0420 0.0682 0.0564 0.0157 0.0360 0.0715 ]

model HIVB=
0.30750700
0.00500000 0.29554300
1.45504000 0.00500000 17.66120000
0.12375800 0.35172100 0.08606420 0.00500000
0.05511280 3.42150000 0.67205200 0.00500000 0.00500000
1.48135000 0.07492180 0.07926330 10.58720000 0.00500000 2.56020000
2.13536000 3.65345000 0.32340100 2.83806000 0.89787100 0.06191370 3.92775000
0.08476130 9.04044000 7.64585000 1.91690000 0.24007300 7.05545000 0.11974000 0.00500000
0.00500000 0.67728900 0.68056500 0.01767920 0.00500000 0.00500000 0.00609079 0.00500000 0.10311100
0.21525600 0.70142700 0.00500000 0.00876048 0.12977700 1.49456000 0.00500000 0.00500000 1.74171000 5.95879000
0.00500000 20.45000000 7.90443000 0.00500000 0.00500000 6.54737000 4.61482000 0.52170500 0.00500000 0.32231900 0.08149950
0.01866430 2.51394000 0.00500000 0.00500000 0.00500000 0.30367600 0.17578900 0.00500000 0.00500000 11.20650000 5.31961000 1.28246000
0.01412690 0.00500000 0.00500000 0.00500000 9.29815000 0.00500000 0.00500000 0.29156100 0.14555800 3.39836000 8.52484000 0.03426580 0.18802500
2.12217000 1.28355000 0.00739578 0.03426580 0.00500000 4.47211000 0.01202260 0.00500000 2.45318000 0.04105930 2.07757000 0.03138620 0.00500000 0.00500000
2.46633000 3.47910000 13.14470000 0.52823000 4.69314000 0.11631100 0.00500000 4.38041000 0.38274700 1.21803000 0.92765600 0.50411100 0.00500000 0.95647200 5.37762000
15.91830000 2.86868000 6.88667000 0.27472400 0.73996900 0.24358900 0.28977400 0.36961500 0.71159400 8.61217000 0.04376730 4.67142000 4.94026000 0.01412690 2.01417000 8.93107000
0.00500000 0.99133800 0.00500000 0.00500000 2.63277000 0.02665600 0.00500000 1.21674000 0.06951790 0.00500000 0.74884300 0.00500000 0.08907800 0.82934300 0.04445060 0.02487280 0.00500000
0.00500000 0.00991826 1.76417000 0.67465300 7.57932000 0.11303300 0.07926330 0.00500000 18.69430000 0.14816800 0.11198600 0.00500000 0.00500000 15.34000000 0.03043810 0.64802400 0.10565200 1.28022000
7.61428000 0.08124540 0.02665600 1.04793000 0.42002700 0.02091530 1.02847000 0.95315500 0.00500000 17.73890000 1.41036000 0.26582900 6.85320000 0.72327400 0.00500000 0.07492180 0.70922600 0.00500000 0.04105930
0.060490222 0.066039665 0.044127815 0.042109048 0.020075899 0.053606488 0.071567447 0.072308239 0.022293943 0.069730629 0.098851122 0.056968211 0.019768318 0.028809447 0.046025282 0.050604330 0.053636813 0.033011601 0.028350243 0.061625237;

model HIVW=
0.0744808
0.6175090 0.1602400
4.4352100 0.0674539 29.4087000
0.1676530 2.8636400 0.0604932 0.0050000
0.0050000 10.6746000 0.3420680 0.0050000 0.0050000
5.5632500 0.0251632 0.2015260 12.1233000 0.0050000 3.2065600
1.8685000 13.4379000 0.0604932 10.3969000 0.0489798 0.0604932 14.7801000
0.0050000 6.8440500 8.5987600 2.3177900 0.0050000 18.5465000 0.0050000 0.0050000
0.0050000 1.3406900 0.9870280 0.1451240 0.0050000 0.0342252 0.0390512 0.0050000 0.0050000
0.1602400 0.5867570 0.0050000 0.0050000 0.0050000 2.8904800 0.1298390 0.0489798 1.7638200 9.1024600
0.5927840 39.8897000 10.6655000 0.8943130 0.0050000 13.0705000 23.9626000 0.2794250 0.2240600 0.8174810 0.0050000
0.0050000 3.2865200 0.2015260 0.0050000 0.0050000 0.0050000 0.0050000 0.0489798 0.0050000 17.3064000 11.3839000 4.0956400
0.5979230 0.0050000 0.0050000 0.0050000 0.3629590 0.0050000 0.0050000 0.0050000 0.0050000 1.4828800 7.4878100 0.0050000 0.0050000
1.0098100 0.4047230 0.3448480 0.0050000 0.0050000 3.0450200 0.0050000 0.0050000 13.9444000 0.0050000 9.8309500 0.1119280 0.0050000 0.0342252
8.5942000 8.3502400 14.5699000 0.4278810 1.1219500 0.1602400 0.0050000 6.2796600 0.7251570 0.7400910 6.1439600 0.0050000 0.3925750 4.2793900 14.2490000
24.1422000 0.9282030 4.5420600 0.6303950 0.0050000 0.2030910 0.4587430 0.0489798 0.9595600 9.3634500 0.0050000 4.0480200 7.4131300 0.1145120 4.3370100 6.3407900
0.0050000 5.9656400 0.0050000 0.0050000 5.4989400 0.0443298 0.0050000 2.8258000 0.0050000 0.0050000 1.3703100 0.0050000 0.0050000 0.0050000 0.0050000 1.1015600 0.0050000
0.0050000 0.0050000 5.0647500 2.2815400 8.3483500 0.0050000 0.0050000 0.0050000 47.4889000 0.1145120 0.0050000 0.0050000 0.5791980 4.1272800 0.0050000 0.9331420 0.4906080 0.0050000
24.8094000 0.2794250 0.0744808 2.9178600 0.0050000 0.0050000 2.1995200 2.7962200 0.8274790 24.8231000 2.9534400 0.1280650 14.7683000 2.2800000 0.0050000 0.8626370 0.0050000 0.0050000 1.3548200
0.0377494 0.0573210 0.0891129 0.0342034 0.0240105 0.0437824 0.0618606 0.0838496 0.0156076 0.0983641 0.0577867 0.0641682 0.0158419 0.0422741 0.0458601 0.0550846 0.0813774 0.0195970 0.0205847 0.0515638;

model JTTDCMUT=
0.531678
0.557967 0.451095
0.827445 0.154899 5.549530
0.574478 1.019843 0.313311 0.105625
0.556725 3.021995 0.768834 0.521646 0.091304
1.066681 0.318483 0.578115 7.766557 0.053907 3.417706
1.740159 1.359652 0.773313 1.272434 0.546389 0.231294 1.115632
0.219970 3.210671 4.025778 1.032342 0.724998 5.684080 0.243768 0.201696
0.361684 0.239195 0.491003 0.115968 0.150559 0.078270 0.111773 0.053769 0.181788
0.310007 0.372261 0.137289 0.061486 0.164593 0.709004 0.097485 0.069492 0.540571 2.335139
0.369437 6.529255 2.529517 0.282466 0.049009 2.966732 1.731684 0.269840 0.525096 0.202562 0.146481
0.469395 0.431045 0.330720 0.190001 0.409202 0.456901 0.175084 0.130379 0.329660 4.831666 3.856906 0.624581
0.138293 0.065314 0.073481 0.032522 0.678335 0.045683 0.043829 0.050212 0.453428 0.777090 2.500294 0.024521 0.436181
1.959599 0.710489 0.121804 0.127164 0.123653 1.608126 0.191994 0.208081 1.141961 0.098580 1.060504 0.216345 0.164215 0.148483
3.887095 1.001551 5.057964 0.589268 2.155331 0.548807 0.312449 1.874296 0.743458 0.405119 0.592511 0.474478 0.285564 0.943971 2.788406
4.582565 0.650282 2.351311 0.425159 0.469823 0.523825 0.331584 0.316862 0.477355 2.553806 0.272514 0.965641 2.114728 0.138904 1.176961 4.777647
0.084329 1.257961 0.027700 0.057466 1.104181 0.172206 0.114381 0.544180 0.128193 0.134510 0.530324 0.089134 0.201334 0.537922 0.069965 0.310927 0.080556
0.139492 0.235601 0.700693 0.453952 2.114852 0.254745 0.063452 0.052500 5.848400 0.303445 0.241094 0.087904 0.189870 5.484236 0.113850 0.628608 0.201094 0.747889
2.924161 0.171995 0.164525 0.315261 0.621323 0.179771 0.465271 0.470140 0.121827 9.533943 1.761439 0.124066 3.038533 0.593478 0.211561 0.408532 1.143980 0.239697 0.165473
0.07686192 0.05105695 0.04254596 0.05126895 0.02027898 0.04106096 0.06181994 0.07471393 0.02298298 0.05256895 0.09111091 0.05949794 0.02341398 0.04052996 0.05053195 0.06822493 0.05851794 0.01433599 0.03230297 0.06637393;
[ NOTE 2019-06-04: normalised from original JTTDCMUTT freqs, which do not sum to 1.0
  https://www.ebi.ac.uk/goldman-srv/dayhoff/jtt-dcmut.dat ]

model FLU=
0.138658765
0.053366579 0.161000889
0.584852306 0.006771843 7.737392871
0.026447095 0.167207008 0.000013000 0.014100000
0.353753982 3.292716942 0.530642655 0.145469388 0.002547334
1.484234503 0.124897617 0.061652192 5.370511279 0.000000000 1.195629122
1.132313122 1.190624465 0.322524648 1.934832784 0.116941459 0.108051341 1.593098825
0.214757862 1.879569938 1.387096032 0.887570549 0.021800000 5.330313412 0.256491863 0.058774527
0.149926734 0.246117172 0.218571975 0.014085917 0.001112158 0.028839950 0.014200000 0.000016300 0.243190142
0.023116952 0.296045557 0.000836000 0.005730682 0.005613627 1.020366955 0.016499536 0.006516229 0.321611694 3.512072282
0.474333610 15.300096620 2.646847965 0.290042980 0.000003830 2.559587177 3.881488809 0.264148929 0.347302791 0.227707997 0.129223639
0.058745423 0.890162346 0.005251688 0.041762964 0.111457310 0.190259181 0.313974351 0.001500467 0.001273509 9.017954203 6.746936485 1.331291619
0.080490909 0.016100000 0.000836000 0.000001060 0.104053666 0.032680657 0.001003501 0.001236645 0.119028506 1.463357278 2.986800036 0.320000000 0.279910509
0.659311478 0.154027180 0.036400000 0.188539456 0.000000000 0.712769599 0.319558828 0.038631761 0.924466914 0.080543327 0.634308521 0.195750632 0.056900000 0.007132430
3.011344519 0.950138410 3.881310531 0.338372183 0.336263345 0.487822499 0.307140298 1.585646577 0.580704250 0.290381075 0.570766693 0.283807672 0.007026588 0.996685670 2.087385344
5.418298175 0.183076905 2.140332316 0.135481233 0.011975266 0.602340963 0.280124895 0.018808030 0.368713573 2.904052286 0.044926357 1.526964200 2.031511321 0.000134906 0.542251094 2.206859934
0.196000000 1.369429408 0.000536000 0.000014900 0.094106680 0.044000000 0.155245492 0.196486447 0.022400000 0.032132150 0.431277663 0.000049800 0.070460039 0.814753094 0.000431021 0.099835753 0.207066206
0.018289288 0.099855497 0.373101927 0.525398543 0.601692431 0.072205935 0.104092870 0.074814997 6.448954446 0.273934263 0.340058468 0.012416222 0.874272175 5.393924245 0.000182000 0.392552240 0.124898020 0.427755430
3.532005270 0.103964386 0.010257517 0.297123975 0.054904564 0.406697814 0.285047948 0.337229619 0.098631355 14.394052190 0.890598579 0.073127930 4.904842235 0.592587985 0.058971975 0.088256423 0.654109108 0.256900461 0.167581647
0.04707195 0.05090995 0.07421393 0.04785995 0.02502197 0.03330397 0.05458695 0.07637292 0.01996398 0.06713393 0.07149793 0.05678494 0.01815098 0.03049597 0.05065595 0.08840891 0.07433893 0.01852398 0.03147397 0.06322894;
[ NOTE 2019-06-04: normalised from FLU freqs in PhyML, which do not sum 1.0 ]
 
model MTMET=
0.058078177576542
0.032893910131824 0.141364232590718
0.119156819252943 0.049700397089876 4.658418673473980
0.633255658023246 0.739813635055843 0.292999912100000 0.077399976780000
0.052454931263516 2.673107287067570 0.832791283162540 0.131355662593289 0.152595162221438
0.179163834250834 0.080835456749356 0.812240880327663 6.033787171863310 0.050599984820000 2.236616952014710
1.465861840241320 0.219967058009863 0.543750593874773 0.630753109774010 0.914125315762323 0.072395514281339 0.768853064344011
0.030192120942361 1.522256408322940 1.738679122396110 0.479790968062666 0.603999818800000 4.518449535464730 0.105414703375579 0.025252648424203
0.367600338719865 0.012428572271427 0.244934691519570 0.010668852799343 0.235804174258726 0.008875683337294 0.013999995800000 0.013799995860000 0.017140133857958
0.109872733038170 0.058179997545996 0.046299986110000 0.005529142341257 0.299518907144301 0.254452390664260 0.019157613252714 0.027264545820634 0.111638903508319 1.897973798607690
0.020509501847148 1.057185315844310 2.530397670880470 0.049007441297763 0.015799995260000 1.827217637834540 1.379217369234670 0.134187134743847 0.135153622453901 0.064936591519017 0.061324501602644
0.653363796990802 0.013494029951790 0.399827603051683 0.026109939167016 0.492339996297957 0.237094294871690 0.128410015476984 0.145331422400560 0.032834304149706 2.918352332494040 3.425552681333890 0.659310562206772
0.062762236171324 0.008039997588000 0.138999958300000 0.012599996220000 0.925810586256741 0.026306317108103 0.017716302685108 0.068139260558216 0.090353039894080 0.750900315729838 1.811100689669630 0.097099970870000 0.748424772472501
0.408076930576884 0.155008519497430 0.080299975910000 0.044609549617131 0.029399991180000 0.849512180146269 0.048786284364110 0.005914204225738 0.519954219013687 0.024850013544994 0.270260699921766 0.121234884629524 0.032699990190000 0.054271872718433
2.771685183494200 0.197379125786245 2.634377723686450 0.360804672758566 3.283013886095540 0.384800168559915 0.363104357068660 1.746569621028960 0.297585994724175 0.096272835118141 0.311525037542461 0.695087919473562 0.458733958379771 0.499349751195030 1.231180449645750
6.730883140734450 0.056079796176056 0.961284804614472 0.102136190359134 0.338668094399541 0.274195864741216 0.134802630559199 0.024558282632513 0.221010542696817 2.453457406962560 0.253366627989989 0.393851585844489 3.035214815435280 0.053947726815677 0.734604689618527 3.114741972577130
0.013599995920000 0.370819780754032 0.048999985300000 0.040899987730000 1.018410179476850 0.122999963100000 0.086028769191362 0.233963300810989 0.037499988750000 0.028656788402961 0.253242937027096 0.073499977950000 0.167575267727405 0.330781828765422 0.029433857169840 0.169211978236391 0.014378611686415
0.014501402649578 0.127519293744200 1.020785184764350 0.160289909913013 1.967370664788620 0.319105692268264 0.093214693035584 0.046746326976098 3.907917378624430 0.135319420404162 0.123555294933400 0.281699089490248 0.316598936020291 3.209082340275010 0.053999983800000 0.374184173744714 0.091031759690464 0.481044171686705
2.815162240451070 0.041063671680895 0.051741611477512 0.084589003623291 1.394527625641590 0.027669224699230 0.227826982651885 0.417148828855314 0.003511006946698 10.953422553972199 0.958273455517877 0.055461418361570 2.562484126254530 0.466243302126967 0.054078516776440 0.267109384867160 1.514059219782100 0.093136228059123 0.069964519010638
0.043793213137964 0.012957803887341 0.057001317100395 0.016899005069702 0.011330503399151 0.018018105405432 0.022538506761552 0.047050114115034 0.017183705155112 0.089779426933828 0.155226046567814 0.039913511974054 0.067444320233296 0.088448026534408 0.037528211258463 0.093752228125668 0.063579019073706 0.022671306801392 0.041568212470464 0.053317415995225;

model MTVER=
0.064684593342281
0.032311373155679 0.153152767576346
0.159447300723611 0.060872136436053 8.760497104246360
0.246553724276801 1.223667683833540 0.336000168000000 0.121000060500000
0.030870542435264 3.170387139192780 0.392967223483514 0.083338219669089 0.116173343086643
0.191894227947066 0.094355879177916 0.335734154866994 6.603638632817670 0.036400018200000 2.018143897071440
1.094200939100200 0.292471267235560 0.566907089453403 0.999256939628220 0.916865240432391 0.042512995256487 1.162715978357700
0.023294179647084 2.204735655367280 2.462271663135220 0.818112173055882 1.400000700000000 4.282733559365710 0.081141411570686 0.013333256666625
0.412485044242419 0.001173176586588 0.126395609197773 0.002450024225012 0.067512580756274 0.004179092089545 0.001250000625000 0.003120001560000 0.022239993119991
0.078175506087734 0.078821952410957 0.004520002260000 0.002303982151991 0.170993012496464 0.251583784791830 0.007547828773913 0.007030631515314 0.148659642329784 1.378981921490620
0.020785858392924 0.418858706429249 2.458223875111320 0.019527849763920 0.024800012400000 2.001705573852290 2.154179684089300 0.106373697186822 0.176407170203541 0.005826060913029 0.022236503118246
0.751880839940232 0.003339427669713 0.036342279171131 0.005454655727327 0.084565948282953 0.118300117150029 0.064939181469575 0.034441699220841 0.024341806170897 2.709085270541960 3.102549285273870 0.440831886415833
0.064446525223247 0.002480001240000 0.010300005150000 0.005850002925000 1.071950287974880 0.012628428314211 0.000332940166470 0.015567819783906 0.173363959681937 0.516016662008202 2.403419459709130 0.010400005200000 0.123894605947272
0.285569393784626 0.223106325553107 0.034500017250000 0.027518484759236 0.018900009450000 0.918408714204128 0.027495640747814 0.001858863929432 0.679485296742479 0.018484697242344 0.366808261404039 0.141827309913619 0.030900015450000 0.070221307110636
2.481817894908330 0.135104231552082 3.854777098387590 0.371726663863239 3.359148754573540 0.243906745953312 0.097749778874865 1.247283625641500 0.445289314644546 0.044145011072495 0.440667041333411 0.187506484753196 0.137172898586415 0.886724514362035 1.961395669697340
5.562701612349420 0.028643207321597 0.865443620721594 0.090462201231078 0.152312893156409 0.113601717800831 0.095055222527588 0.008518901259449 0.150502737251331 2.439178561588670 0.173310979655447 0.399752584876193 3.736806509402320 0.061993007996489 0.573808396904055 2.845373550686060
0.008420004210000 0.558540909270315 0.006680003340000 0.026900013450000 1.778859743429430 0.124000062000000 0.062341391170680 0.258646151323011 0.030600015300000 0.001901139950570 0.186367686183797 0.029400014700000 0.056840260420116 0.091906956953456 0.020008909004450 0.144081317040623 0.003186142593071
0.012484943242469 0.146342752171340 0.856969809484690 0.186328057163982 5.248219583108480 0.228833221416554 0.037356125678054 0.021047207523599 9.175812436903930 0.045429850714914 0.103344604672277 0.062036757018363 0.079617080808521 3.987260862629440 0.071900035950000 0.543167000583365 0.084368299184129 0.288348349174103
3.196938070468240 0.037629752814867 0.013796210898102 0.128208017103977 0.381860130929970 0.010633051316523 0.216260948130420 0.442992988496384 0.002759961379980 13.505144232568700 0.856259496129534 0.025253726626857 4.499326020661890 0.336159506079669 0.025768082884035 0.058280992140482 1.317930995965170 0.047174784587381 0.028686388343187
0.070820264589868 0.014049892975054 0.045209877395061 0.014793692603154 0.006814196592902 0.026340886829557 0.021495189252405 0.044239977880011 0.024230987884506 0.090735054632473 0.172309913845043 0.027381186309407 0.056193971903014 0.049775775112112 0.054386272806864 0.074421862789069 0.108809945595027 0.025652687173656 0.026484686757657 0.045853677073162;

model MTINV=
0.074334218266301
0.023989052404375 0.147604222958287
0.100963342614647 0.070670662731724 3.471722830310310
1.303663674534320 0.680711975715101 0.279969423012186 0.058303793678473
0.090980768607678 2.507737031904790 1.287188991124200 0.204531412187402 0.163006102797533
0.145240519903769 0.121635259345877 1.159082473366830 6.962509289995170 0.047068462172608 2.559965106013550
1.931554281377980 0.217695106921922 0.551419739432016 0.591216665513239 0.883545088581823 0.114080027367971 0.599017294392986
0.045194564922167 1.283366609653150 1.728634951545740 0.358935283425829 0.341191895523187 4.708030703786970 0.217387593044928 0.064352344259052
0.209390225243876 0.028420823631666 0.310892189643074 0.017124804150076 0.287547507980951 0.025100268959888 0.020795063681971 0.024809855076054 0.025529460788212
0.153999806400053 0.052763470894603 0.075114618954140 0.010524108790355 0.381393499442539 0.211473478410575 0.033099595760156 0.050781943687214 0.080842277663076 2.159573277170340
0.014824597070159 1.631885373245590 2.642319727071690 0.096074070570356 0.004392611242955 1.933672173530820 1.172486892005060 0.156144354542233 0.250218937912385 0.100258540896568 0.081982070207159
0.592864803853984 0.022385985045602 0.566989926203939 0.049089594364154 0.461585949365546 0.397060773175627 0.189458582216537 0.207637097945128 0.070807578676957 2.830888275644240 3.494915172033370 0.694473233210596
0.111082013567177 0.015357906856835 0.194205108317926 0.017157066137171 0.887097013161053 0.052545508981788 0.027169124132346 0.103612477554992 0.151813232274683 0.879509584196026 1.735138890944170 0.098766126493534 0.916539999383854
0.629531950187119 0.130198008920776 0.224156768337257 0.104690593123746 0.069312726274898 0.581011232595414 0.120987616604934 0.028323516670589 0.312042686182876 0.070886389645433 0.154372892250818 0.183146598741331 0.092516642993328 0.105108133956730
3.368752649498400 0.309426794229233 2.084469247211970 0.505643420742551 3.042784023885900 0.538789467484127 0.580233013906702 2.020140264943570 0.368422261631036 0.126690032323967 0.225488005804762 0.879840867063512 0.633585250565799 0.398961585415302 1.042509719995950
3.327041763182760 0.108593900562422 1.186265342493670 0.141991497203378 0.736861629255230 0.554297413280946 0.241928620228513 0.043791194483515 0.270595503761755 1.958518039592470 0.298279746688054 0.511283878486367 2.192058660176190 0.121269516492174 0.746916803233159 3.833298761679880
0.026501471399407 0.321740677303678 0.075398643840530 0.071630764347683 0.758571851571138 0.118046810781257 0.107622585950948 0.244698162120696 0.081171865531241 0.062889026844379 0.298463138614697 0.106016335593449 0.254195659321696 0.478876889449168 0.059737825104860 0.204318441272591 0.049859203056311
0.021939769224089 0.182762501894970 1.139165041333800 0.192759935895995 1.342951983818990 0.476209340516188 0.137649645940120 0.072268115092742 2.321701900318870 0.177138315144646 0.161052630578922 0.348477651608884 0.393193176722666 3.234681510126880 0.081395316441860 0.345719568712117 0.174898633040519 0.636664640334042
2.751362222454670 0.072153227138698 0.065420927831618 0.088077392769029 1.555396905840990 0.065221940911213 0.231186486525368 0.396428077428706 0.008043434782625 8.542589373962890 1.075872855650690 0.056252073499162 1.509852171058890 0.534676724129225 0.162975872809625 0.377288666084473 1.885338569864270 0.128598566560553 0.080346083861554
0.031742312696925 0.010900704360282 0.061579224631690 0.016149206459683 0.013570105428042 0.014644105857642 0.022311208924484 0.047847519139008 0.011641804656722 0.094322337728935 0.149407059762824 0.044438717775487 0.077262530905012 0.102287040914816 0.026290210516084 0.105939042375617 0.042869117147647 0.020701008280403 0.046556718622687 0.059540023816010;

end;
)";


ModelProtein::ModelProtein(const char *model_name, string model_params, StateFreqType freq, string freq_params, PhyloTree *tree, ModelsBlock* models_block)
 : ModelMarkov(tree)
{
    this->models_block = models_block;
	init(model_name, model_params, freq, freq_params);
}

void rescaleRates(double *rates, int nrates) {
    int i;

    double max_rate = 0.0;

    for (i = 0; i < nrates; i++)
        max_rate = max(max_rate, rates[i]);

    const double AA_SCALE = 10.0;
    double scaler = AA_SCALE / max_rate;

    /* SCALING HAS BEEN RE-INTRODUCED TO RESOLVE NUMERICAL  PROBLEMS */   

    for (i = 0; i < nrates; i++)
        rates[i] *= scaler;
}

void ModelProtein::init(const char *model_name, string model_params, StateFreqType freq, string freq_params) {
	ASSERT(num_states == 20);
    ASSERT(models_block && "models_block uninitialized");
	name = model_name;

	string name_upper = model_name;
	for (string::iterator it = name_upper.begin(); it != name_upper.end(); it++)
		(*it) = toupper(*it);

    NxsModel *nxs_model = models_block->findModel(name_upper);
    if (nxs_model) {
        if (nxs_model->flag != NM_ATOMIC)
            outError("Invalid protein model name ", model_name);

        readParametersString(nxs_model->description);
        rescaleRates(rates, getNumRateEntries());

        int i;
		double sum = 0.0;
		for (i = 0; i < num_states; i++)
			sum += (double) state_freq[i];
		if (fabs(sum-1.0) > 1e-7) {
			cout.precision(7);
			cout << "WARNING: " <<  name_upper << " state frequencies do not sum up to 1: " << sum << endl;
		}
        num_params = 0;

	} else if (!model_params.empty()) {
        readParametersString(model_params);
        num_params = 0;
    } else if (name_upper == "GTR20") {
        outWarning("GTR20 model will estimate 189 substitution rates that might be overfitting!");
        outWarning("Please only use GTR20 with very large data and always test for model fit!");
        if (freq == FREQ_UNKNOWN)
            freq = FREQ_EMPIRICAL;
        // initialize rate matrix with LG
        nxs_model = models_block->findModel("LG");
        ASSERT(nxs_model);
        readParametersString(nxs_model->description);
        rescaleRates(rates, getNumRateEntries());

        // 2018-05-08 bug fix: GTR20 rates are not optimized
        num_params = getNumRateEntries()-1;
	} else {
		// if name does not match, read the user-defined model
		readParameters(model_name);
        num_params = 0;
	}
	if (freq_params != "") {
//		stringstream ss(freq_params);
		readStateFreq(freq_params);
	}

	//assert(freq != FREQ_ESTIMATE);
	if (freq == FREQ_UNKNOWN) freq = FREQ_USER_DEFINED;
	ModelMarkov::init(freq);
}

void ModelProtein::startCheckpoint() {
    checkpoint->startStruct("ModelProtein");
}


void ModelProtein::saveCheckpoint() {
    if (num_params > 0) {
        startCheckpoint();
        CKP_ARRAY_SAVE(getNumRateEntries(), rates);
        endCheckpoint();
    }
    ModelMarkov::saveCheckpoint();
}

void ModelProtein::restoreCheckpoint() {
    ModelMarkov::restoreCheckpoint();

    if (num_params > 0) {
        startCheckpoint();
        CKP_ARRAY_RESTORE(getNumRateEntries(), rates);
        endCheckpoint();
        decomposeRateMatrix();
        if (phylo_tree)
            phylo_tree->clearAllPartialLH();
    }
}

void ModelProtein::readRates(istream &in) throw(const char*, string) {
	int nrates = getNumRateEntries();
	int row = 1, col = 0;
    if (is_reversible) {
        // since states for protein is stored in lower-triangle, special treatment is needed
        for (int i = 0; i < nrates; i++, col++) {
            if (col == row) {
                row++; col = 0;
            }
            // switch col and row
            int id = col*(2*num_states-col-1)/2 + (row-col-1);
            if (id >= nrates) {
                cout << row << " " << col << endl;
            }
            ASSERT(id < nrates && id >= 0); // make sure that the conversion is correct
            if (!(in >> rates[id]))
                throw name+string(": Rate entries could not be read");
            if (rates[id] < 0.0)
                throw "Negative rates found";
        }
    } else {
        // non-reversible model, read the whole rate matrix
        int i = 0;
        for (row = 0; row < num_states; row++) {
            double row_sum = 0.0;
            for (col = 0; col < num_states; col++) {
                if (row != col) {
                    if (!(in >> rates[i]))
                        throw name+string(": Rate entries could not be read");
                    if (rates[i] < 0.0)
                        throw "Negative rates found";
                    row_sum += rates[i];
                    i++;
                } else {
                    double d;
                    in >> d;
                    row_sum += d;
                }
            }
            if (fabs(row_sum) > 1e-3)
                throw "Row " + convertIntToString(row) + " does not sum to 0";
        }
    }
}


