.nr PS 9
.nr VS 11
.de V1
.ft CW
.nf
..
.de V2
.fi
.ft R
..
.de LS
.br
.in +2
..
.de LE
.br
.sp .5v
.in -2
..
.ND July 1995
.TL
Guide to the ARGUS Reduction Task DOARGUS
.AU
Francisco Valdes
.AI
IRAF Group - Central Computer Services
.K2
.DY

.AB
The \fBdoargus\fR reduction task is specialized for scattered light
subtraction, extraction, flat
fielding, fiber throughput correction, wavelength calibration, and sky
subtraction of \fIArgus\fR fiber spectra.  It is a
command language script which collects and combines the functions and
parameters of many general purpose tasks to provide a single complete data
reduction path.  The task provides a degree of guidance, automation, and
record keeping necessary when dealing with the large amount of data
generated by this multifiber instrument.  This guide describes what
this task does, it's usage, and parameters.
.AE
.NH
Introduction
.LP
The \fBdoargus\fR reduction task is specialized for scattered light
subtraction, extraction, flat
fielding, fiber throughput correction, wavelength calibration, and sky
subtraction of \fIArgus\fR fiber spectra.  It is a
command language script which collects and combines the functions and
parameters of many general purpose tasks to provide a single, complete data
reduction path.  The task provides a degree of guidance, automation, and
record keeping necessary when dealing with the large amount of data
generated by these multifiber instruments.
.LP
The general organization of the task is to do the interactive setup steps
first using representative calibration data and then perform the majority
of the reductions automatically, and possibly as a background process, with
reference to the setup data.  In addition, the task determines which setup
and processing operations have been completed in previous executions of the
task and, contingent on the \f(CWredo\fR and \f(CWupdate\fR options, skip or
repeat some or all the steps.
.LP
The description is divided into a quick usage outline followed by details
of the parameters and algorithms.  The usage outline is provided as a
checklist and a refresher for those familiar with this task and the
component tasks.  It presents only the default or recommended usage for
Argus since there are many variations possible.  Because \fBdoargus\fR
combines many separate, general purpose tasks, the description given here
refers to these tasks and leaves some of the details to their help
documentation.
.NH
Usage Outline
.LP
.IP [1] 6
The images are first processed with \fBccdproc\fR for overscan,
bias, and dark corrections.
The \fBdoargus\fR task will abort if the image header keyword CCDPROC,
which is added by \fBccdproc\fR, is missing.  If the data processed outside
of the IRAF \fBccdred\fR package then a dummy CCDPROC keyword should be
added to the image headers; say with \fBhedit\fR.
.IP [2]
Set the \fBdoargus\fR parameters with \fBeparam\fR.  Specify the object
images to be processed, the flat field image as the aperture reference and
the flat field, and one or more arc images.  A throughput file or image,
such as a blank sky observation, may also be specified.  If there are many
object or arc spectra per setup you might want to prepare "@ files".
Prepare and specify an aperture identification table if desired.
You might wish to verify the geometry parameters,
separations, dispersion direction, etc., which may change with different
detector setups.  The processing parameters are set for complete reductions
but for quicklook you might not use the clean option or dispersion
calibration and sky subtraction.
.IP
The parameters are set for a particular Argus configuration and different
configurations may use different flat fields, arcs, and aperture
identification tables.
.IP [3]
Run the task.  This may be repeated multiple times with different
observations and the task will generally only do the setup steps
once and only process new images.  Queries presented during the
execution for various interactive operations may be answered with
"yes", "no", "YES", or "NO".  The lower case responses apply just
to that query while the upper case responses apply to all further
such queries during the execution and no further queries of that
type will be made.
.IP [4]
The apertures are defined using the specified aperture reference image.
The spectra are found automatically and apertures assigned based on
task parameters and the aperture identification table.  Unassigned
fibers may have a negative beam number and will be ignored in subsequent
processing.  The resize option sets the aperture size to the widths of
the profiles at a fixed fraction of the peak height.  The interactive
review of the apertures is recommended.  If the identifications are off
by a shift the 'o' key is used.  To exit the aperture review type 'q'.
.IP [5]
The fiber positions at a series of points along the dispersion are measured
and a function is fit to these positions.  This may be done interactively to
adjust the fitting parameters.  Not all fibers need be examined and the "NO"
response will quit the interactive fitting.  To exit the interactive
fitting type 'q'.
.IP [6]
If scattered light subtraction is to be done the flat field image is
used to define the scattered light fitting parameters interactively.
If one is not specified then the aperture reference image is used for
this purpose.

There are two queries for the interactive fitting.  A graph of the
data between the defined reference apertures separated by a specified
buffer distance is first shown.  The function order and type may be
adjusted.  After quiting with 'q' the user has the option of changing
the buffer value and returning to the fitting, changing the image line
or column to check if the fit parameters are satisfactory at other points,
or to quit and accept the fit parameters.  After fitting all points
across the dispersion another graph showing the scattered light from
the individual fits is shown and the smoothing parameters along the
dispersion may be adjusted.  Upon quiting with 'q' you have the option
of checking other cuts parallel to the dispersion or quiting and finishing
the scattered light function smoothing and subtraction.

If there is a throughput image then this is corrected for scattered light
noninteractively using the previous fitting parameters.
.IP [7]
If flat fielding is to be done the flat field spectra are extracted.  The
average spectrum over all fibers is determined and a function is fit
interactively (exit with 'q').  This function is generally of sufficiently
high order that the overall shape is well fit.  This function is then used
to normalize the individual flat field spectra.  If a throughput image, a
sky flat, is specified then the total sky counts through each fiber are
used to correct the total flat field counts.  Alternatively, a separately
derived throughput file can be used for specifying throughput corrections.
If neither type of throughput is used the flat field also provides the
throughput correction.  The final response spectra are normalized to a unit
mean over all fibers.  The relative average throughput for each fiber is
recorded in the log and possibly printed to the terminal.
.IP [8]
If dispersion correction is selected the first arc in the arc list is
extracted.  The middle fiber is used to identify the arc lines and define
the dispersion function using the task \fBautoidentify\fR.  The
\fIcrval\fR and \fIcdelt\fR parameters are used in the automatic
identification.  Whether or not the automatic identification is
successful you will be shown the result of the arc line identification.
If the automatic identification is not successful identify a few arc
lines with 'm' and use the 'l' line list identification command to
automatically add additional lines and fit the dispersion function.  Check
the quality of the dispersion function fit with 'f'.  When satisfied exit
with 'q'.
.IP [9]
The remaining fibers are automatically reidentified.  You have the option
to review the line identifications and dispersion function for each fiber
and interactively add or delete arc lines and change fitting parameters.
This can be done selectively, such as when the reported RMS increases
significantly.
.IP [10]
If the spectra are to be resampled to a linear dispersion system
(which will be the same for all spectra) default dispersion parameters
are printed and you are allowed to adjust these as desired.
.IP [11]
If the sky line alignment option is selected and the sky lines have not
been identified for a particular aperture identification table then you are
asked to mark one or more sky lines.  You may simply accept the wavelengths
of these lines as defined by the dispersion solution for this spectrum and
fiber or you may specify knowns wavelengths for the lines. These lines will
be reidentified in all object spectra extracted and a mean zeropoint shift
will be added to the dispersion solution.  This has the effect of aligning
these lines to optimize sky subtraction.
.IP [12]
The object spectra are now automatically scattered light subtracted,
 extracted, flat fielded, and dispersion corrected.
.IP [13]
When sky subtracting, the individual sky spectra may be reviewed and some
spectra eliminated using the 'd' key.  The last deleted spectrum may be
recovered with the 'e' key.  After exiting the review with 'q' you are
asked for the combining option.  The type of combining is dictated by the
number of sky fibers.
.IP [14]
The option to examine the final spectra with \fBsplot\fR may be given.
To exit type 'q'.
.IP [15]
If scattered light is subtracted from the input data a copy of the
original image is made by appending "noscat" to the image name.
If the data are reprocessed with the \fIredo\fR flag the original
image will be used again to allow modification of the scattered
light parameters.

The final spectra will have the same name as the original 2D images
with a ".ms" extension added.  The flat field and arc spectra may
also have part of the aperture identification table name, if used, added to
allow different configurations to use the same 2D flat field and arcs
but with different aperture definitions.  If using the sky alignment
option an image "align" with the aperture identification table name
applied will also be created.
.NH
Spectra and Data Files
.LP
The basic input consists of Argus object and
calibration spectra stored as IRAF images.
The type of image format is defined by the
environment parameter \fIimtype\fR.  Only images with that extension will
be processed and created.
The raw CCD images must
be processed to remove overscan, bias, and dark count effects.  This
is generally done using the \fBccdred\fR package.
The \fBdoargus\fR task will abort if the image header keyword CCDPROC,
which is added by \fBccdproc\fR, is missing.  If the data processed outside
of the IRAF \fBccdred\fR package then a dummy CCDPROC keyword should be
added to the image headers; say with \fBhedit\fR.
 Flat fielding is
generally not done at this stage but as part of \fBdoargus\fR.
If flat fielding is done as part of the basic CCD processing then
a flattened flat field, blank sky observation, or throughput file
should still be created for applying fiber throughput corrections.
.LP
The task \fBdoargus\fR uses several types of calibration spectra.  These
are flat fields, blank sky flat fields, comparison lamp spectra, and auxiliary
mercury line (from the dome lights) or sky line spectra.  The flat field,
throughput image or file, and auxiliary emission line spectra are optional.
If a flat field is used then the sky flat
or throughput file is optional assuming the flat field has the same fiber
illumination.  It is legal to specify only a throughput image or file and
leave the flat field blank in order to simply apply a throughput
correction.  Because only the total counts through each fiber are used from
a throughput image, sky flat exposures need not be of high signal per
pixel.
.LP
There are two types of dispersion calibration methods.  One is to take arc
calibration exposures through all fibers periodically and apply the
dispersion function derived from one or interpolated between pairs to the
object fibers.  This is the usual method with Argus.
A second (uncommon) method is to \fIauxiliary
line spectra\fR such as lines in the dome lights or sky lines to monitor
shifts relative to a few actual arc exposures.  The main reason to do this
is if taking arc exposures through all fibers is inconvenient.
.LP
The assignment of arc or auxiliary line calibration exposures to object
exposures is generally done by selecting the nearest in time and
interpolating.  There are other options possible which are described under
the task \fBrefspectra\fR.  The most general option is to define a table
giving the object image name and the one or two arc spectra to be assigned
to that object.  That file is called an \fIarc assignment table\fR and it
is one of the optional setup files which can used with \fBdoargus\fR.
.LP
The first step in the processing is identifying the spectra in the images.
The default method is to use the fact that object and sky fibers alternate
and assign sequential numbers to the fibers so the sky fibers are the
even aperture numbers and the object fibers are the odd aperture numbers.
In this case the beam numbers are not used and are the same as the
aperture numbers and there are no object identifications associated with the
spectra.
.LP
A very useful, optional, setup parameter is an \fIaperture identification
table\fR.  The table contains information about the fiber assignments
including object titles.  The table is either a text file or an image
containing the keywords SLFIB.  An aperture identification file contains
lines consisting of an aperture number, a beam number, and an object
identification.  In an image the SLFIB keywords contain the aperture
number, the beam numbers, optional right ascension and declination, and a
title.  The aperture identification information must be in the same order
as the fibers in the image.  The aperture number may be any unique number
but it is recommended that the normal sequential fiber numbers be used.
The beam number may be used to flag object or sky spectra or simply be the
same as the aperture number.  The object identifications are optional but
it is good practice to include them so that the data will contain the
object information independent of other records.  Figure 1 shows an example
of a file for a configuration called LMC123.

.ce
Figure 1: Example Aperture Identification File

.V1
    cl> type LMC124
    1 1 143
    2 0 sky
    3 1 121
       .
       .
       .
    47 1 s92
    48 0 sky
.V2

Note the identification of the sky fibers with beam number 0 and the
object fibers with 1.  Any broken fibers should be included and
identified by a different beam number, say beam number -1, to give the
automatic spectrum finding operation the best chance to make the
correct identifications.  Naturally the identification table will vary
for each configuration.
Additional information about the aperture identification
file may be found in the description of the task \fBapfind\fR.
.LP
The final reduced spectra are recorded in two or three dimensional IRAF
images.  The images have the same name as the original images with an added
".ms" extension.  Each line in the reduced image is a one dimensional
spectrum with associated aperture, wavelength, and identification
information.  When the \f(CWextras\fR parameter is set the lines in the
third dimension contain additional information (see
\fBapsum\fR for further details).  These spectral formats are accepted by the
one dimensional spectroscopy tools such as the plotting tasks \fBsplot\fR
and \fBspecplot\fR.  The special task \fBscopy\fR may be used to extract
specific apertures or to change format to individual one dimensional
images.
.NH
Package Parameters
.LP
The \fBargus\fR package parameters, shown in Figure 1, set parameters
affecting all the tasks in the package.
.KS
.V1

.ce
Figure 1: Package Parameter Set for ARGUS

                           I R A F
            Image Reduction and Analysis Facility
PACKAGE = imred
   TASK = argus

(dispaxi=            2) Image axis for 2D images
(observa=  observatory) Observatory of data
(interp =        poly5) Interpolation type

(databas=     database) Database
(verbose=           no) Verbose output?
(logfile=      logfile) Log file
(plotfil=             ) Plot file

(records=             )
(version= ARGUS V1: January 1992)

.KE
.V2
The dispersion axis parameter defines the image axis along which the
dispersion runs.  This is used if the image header doesn't define the
dispersion axis with the DISPAXIS keyword.
The observatory parameter is only required
for data taken with fiber instruments other than Argus.
The spectrum interpolation type might be changed to "sinc" but
with the cautions given in \fBonedspec.package\fR.
The other parameters define the standard I/O functions.
The verbose parameter selects whether to print everything which goes
into the log file on the terminal.  It is useful for monitoring
what the \fBdoargus\fR task does.  The log and plot files are useful for
keeping a record of the processing.  A log file is highly recommended.
A plot file provides a record of apertures, traces, and extracted spectra
but can become quite large.
The plotfile is most conveniently viewed and printed with \fBgkimosaic\fR.
.NH
Processing Parameters
.LP
The \fBdoargus\fR parameters are shown in Figure 2.
.KS
.V1

.ce
Figure 2: Parameter Set for DOARGUS

                           I R A F
            Image Reduction and Analysis Facility
PACKAGE = argus
   TASK = doargus

objects =               List of object spectra
(apref  =             ) Aperture reference spectrum
(flat   =             ) Flat field spectrum
(through=             ) Throughput file or image (optional)
(arcs1  =             ) List of arc spectra
(arcs2  =             ) List of shift arc spectra
(arcrepl=             ) Special aperture replacements
(arctabl=             ) Arc assignment table (optional)

.KE
.V1
(readnoi=      RDNOISE) Read out noise sigma (photons)
(gain   =         GAIN) Photon gain (photons/data number)
(datamax=        INDEF) Max data value / cosmic ray threshold
(fibers =           97) Number of fibers
(width  =          12.) Width of profiles (pixels)
(minsep =           8.) Minimum separation between fibers (pixels)
(maxsep =          15.) Maximum separation between fibers (pixels)
(apidtab=             ) Aperture identifications
(crval  =        INDEF) Approximate wavelength
(cdelt  =        INDEF) Approximate dispersion
(objaps =             ) Object apertures
(skyaps =             ) Sky apertures
(arcaps =             ) Arc apertures
(objbeam=          0,1) Object beam numbers
(skybeam=            0) Sky beam numbers
(arcbeam=             ) Arc beam numbers

(scatter=           no) Subtract scattered light?
(fitflat=          yes) Fit and ratio flat field spectrum?
(clean  =          yes) Detect and replace bad pixels?
(dispcor=          yes) Dispersion correct spectra?
(savearc=          yes) Save simultaneous arc apertures?
(skysubt=          yes) Subtract sky?
(skyedit=          yes) Edit the sky spectra?
(savesky=          yes) Save sky spectra?
(splot  =           no) Plot the final spectrum?
(redo   =           no) Redo operations if previously done?
(update =          yes) Update spectra if cal data changes?
(batch  =           no) Extract objects in batch?
(listonl=           no) List steps but don't process?

(params =             ) Algorithm parameters

.V2
The list of objects and arcs can be @ files if desired.  The aperture
reference spectrum is usually the same as the flat field spectrum though it
could be any exposure with enough signal to accurately define the positions
and trace the spectra.  The first list of arcs are the standard Th-Ar or
HeNeAr comparison arc spectra (they must all be of the same type).  The
second list of arcs are the auxiliary emission line exposures mentioned
previously.
.LP
The detector read out noise and gain are used for cleaning and variance
(optimal) extraction.
The variance
weighting and cosmic-ray cleanning are sensitive to extremely strong
cosmic-rays; ones which are hundreds of times brighter than the
spectrum.  The \fIdatamax\fR is used to set an upper limit for any
real data.  Any pixels above this value will be flagged as cosmic-rays
and will not affect the extractions.
The dispersion axis defines the wavelength direction of spectra in
the image if not defined in the image header by the keyword DISPAXIS.  The
width and separation parameters define the dimensions (in pixels) of the
spectra (fiber profile) across the dispersion.  The width parameter
primarily affects the centering.  The maximum separation parameter is
important if missing spectra are to
be correctly skipped.  The number of fibers can be left at the default
and the task will try to account for unassigned or missing fibers.
However, this may lead to occasional incorrect
identifications so it is recommended that only the true number of
fibers be specified.  The aperture identification table was described
earlier.
.LP
The approximate central wavelength and dispersion are used for the
automatic identification of the arc reference.  They may be specified
as image header keywords or values.  The INDEF values search the
entire range of the coordinate reference file but the automatic
line identification algorithm works much better and faster if
approximate values are given.
.LP
The task needs to know which fibers are object and which are sky
if sky subtraction is to be done.  One could explicitly
give the aperture numbers but the recommended way is to use the default
of selecting every second fiber as sky.  If no list of aperture or beam
numbers is given
then all apertures or beam numbers are selected.  Sky subtracted sky
spectra are useful for evaluating the sky subtraction.  Since only
the spectra identified as objects are sky subtracted one can exclude
fibers from the sky subtraction.  For example, to eliminate the sky
spectra from the final results the \fIobjaps\fR parameter could be
set to "1x2".  All other fibers will remain in the extracted spectra
but will not be sky subtracted.
.LP
The next set of parameters select the processing steps and options.  The
scattered light option allows fitting and subtracting a scattered light
surface from the input object and flat field.  If there is significant
scattered light which is not subtracted the fiber throughput correction
will not be accurate.  The
flat fitting option allows fitting and removing the overall shape of the
flat field spectra while preserving the pixel-to-pixel response
corrections.  This is useful for maintaining the approximate object count
levels and not introducing the reciprocal of the flat field spectrum into
the object spectra.  The \f(CWclean\fR option invokes a profile fitting and
deviant point rejection algorithm as well as a variance weighting of points
in the aperture.  These options require knowing the effective (i.e.
accounting for any image combining) read out noise and gain.  For a
discussion of cleaning and variance weighted extraction see
\fBapvariance\fR and \fBapprofiles\fR.
.LP
The dispersion correction option selects whether to extract arc spectra,
determine a dispersion function, assign them to the object spectra, and,
possibly, resample the spectra to a linear (or log-linear) wavelength
scale.  If simultaneous arc fibers are defined there is an option to delete
them from the final spectra when they are no longer needed.
.LP
The sky alignment option allows applying a zeropoint dispersion shift
to all fibers based on one or more sky lines.  This requires all fibers
to have the sky lines visible.  When there are sky lines this will
improve the sky subtraction if there is a systematic error in the
fiber illumination between the sky and the arc calibration.
.LP
The sky subtraction option selects whether to combine the sky fiber spectra
and subtract this sky from the object fiber spectra.  It is also possible
to subtract the sky and object fibers by pairs.  \fIDispersion
correction and sky subtraction are independent operations.\fR  This means
that if dispersion correction is not done then the sky subtraction will be
done with respect to pixel coordinates.  This might be desirable in some
quick look cases though it is incorrect for final reductions.
.LP
The sky subtraction option has two additional options.  The individual sky
spectra may be examined and contaminated spectra deleted interactively
before combining.  This can be a useful feature in crowded regions.  The
final combined sky spectrum (or individual skys if subtracting by
pairs) may be saved for later inspection in an image
with the spectrum name prefixed by \fBsky\fR.
.LP
After a spectrum has been processed it is possible to examine the results
interactively using the \fBsplot\fR tasks.  This option has a query which
may be turned off with "YES" or "NO" if there are multiple spectra to be
processed.
.LP
Generally once a spectrum has been processed it will not be reprocessed if
specified as an input spectrum.  However, changes to the underlying
calibration data can cause such spectra to be reprocessed if the
\f(CWupdate\fR flag is set.  The changes which will cause an update are a new
aperture identification table, a new reference image, new flat fields, and a
new arc reference.  If all input spectra are to be processed regardless of
previous processing the \f(CWredo\fR flag may be used.  Note that
reprocessing clobbers the previously processed output spectra.
.LP
The \f(CWbatch\fR processing option allows object spectra to be processed as
a background or batch job.  This will only occur if sky spectra editing and
\fBsplot\fR review (interactive operations) are turned off, either when the
task is run or by responding with "NO" to the queries during processing.
.LP
The \f(CWlistonly\fR option prints a summary of the processing steps which
will be performed on the input spectra without actually doing anything.
This is useful for verifying which spectra will be affected if the input
list contains previously processed spectra.  The listing does not include
any arc spectra which may be extracted to dispersion calibrate an object
spectrum.
.LP
The last parameter (excluding the task mode parameter) points to another
parameter set for the algorithm parameters.  The way \fBdoargus\fR works
this may not have any value and the parameter set \fBparams\fR is always
used.  The algorithm parameters are discussed further in the next section.
.NH
Algorithms and Algorithm Parameters
.LP
This section summarizes the various algorithms used by the \fBdoargus\fR
task and the parameters which control and modify the algorithms.  The
algorithm parameters available to the user are collected in the parameter
set \fBparams\fR.  These parameters are taken from the various general
purpose tasks used by the \fBdoargus\fR processing task.  Additional
information about these parameters and algorithms may be found in the help
for the actual task executed.  These tasks are identified in the parameter
section listing in parenthesis.  The aim of this parameter set organization
is to collect all the algorithm parameters in one place separate from the
processing parameters and include only those which are relevant for
Argus.  The parameter values can be changed from the
defaults by using the parameter editor,
.V1

	cl> epar params

.V2
or simple typing \f(CWparams\fR.  The parameter editor can also be
entered when editing the \fBdoargus\fR parameters by typing \f(CW:e
params\fR or simply \f(CW:e\fR if positioned at the \f(CWparams\fR
parameter.  Figure 3 shows the parameters set.
.KS
.V1

.ce
Figure 3: Algorithm Parameter Set

                           I R A F
            Image Reduction and Analysis Facility
PACKAGE = argus
   TASK = params

(line   =        INDEF) Default dispersion line
(nsum   =           10) Number of dispersion lines to sum
(order  =   decreasing) Order of apertures
(extras =           no) Extract sky, sigma, etc.?

                        -- DEFAULT APERTURE LIMITS --
(lower  =          -5.) Lower aperture limit relative to center
(upper  =           5.) Upper aperture limit relative to center

                        -- AUTOMATIC APERTURE RESIZING PARAMETERS --
(ylevel =         0.05) Fraction of peak or intensity for resizing

.KE
.KS
.V1
                        -- TRACE PARAMETERS --
(t_step =           10) Tracing step
(t_funct=      spline3) Trace fitting function
(t_order=            3) Trace fitting function order
(t_niter=            1) Trace rejection iterations
(t_low  =           3.) Trace lower rejection sigma
(t_high =           3.) Trace upper rejection sigma

.KE
.KS
.V1
                        -- SCATTERED LIGHT PARAMETERS --
(buffer =           1.) Buffer distance from apertures
(apscat1=             ) Fitting parameters across the dispersion
(apscat2=             ) Fitting parameters along the dispersion

.KE
.KS
.V1
                        -- APERTURE EXTRACTION PARAMETERS --
(weights=         none) Extraction weights (none|variance)
(pfit   =        fit1d) Profile fitting algorithm (fit1d|fit2d)
(lsigma =           3.) Lower rejection threshold
(usigma =           3.) Upper rejection threshold
(nsubaps=            1) Number of subapertures

.KE
.KS
.V1
                        -- FLAT FIELD FUNCTION FITTING PARAMETERS --
(f_inter=          yes) Fit flat field interactively?
(f_funct=      spline3) Fitting function
(f_order=           10) Fitting function order

.KE
.KS
.V1
                        -- ARC DISPERSION FUNCTION PARAMETERS --
(coordli=linelists$idhenear.dat) Line list
(match  =          10.) Line list matching limit in Angstroms
(fwidth =           4.) Arc line widths in pixels
(cradius=          10.) Centering radius in pixels
(i_funct=      spline3) Coordinate function
(i_order=            3) Order of dispersion function
(i_niter=            2) Rejection iterations
(i_low  =           3.) Lower rejection sigma
(i_high =           3.) Upper rejection sigma
(refit  =          yes) Refit coordinate function when reidentifying?
(addfeat=           no) Add features when reidentifying?

.KE
.KS
.V1
                        -- AUTOMATIC ARC ASSIGNMENT PARAMETERS --
(select =       interp) Selection method for reference spectra
(sort   =           jd) Sort key
(group  =          ljd) Group key
(time   =           no) Is sort key a time?
(timewra=          17.) Time wrap point for time sorting

.KE
.KS
.V1
                        -- DISPERSION CORRECTION PARAMETERS --
(lineari=          yes) Linearize (interpolate) spectra?
(log    =           no) Logarithmic wavelength scale?
(flux   =          yes) Conserve flux?

.KE
.KS
.V1
                        -- SKY SUBTRACTION PARAMETERS --
(combine=      average) Type of combine operation
(reject =    avsigclip) Sky rejection option
(scale  =         none) Sky scaling option

.KE
.V2
.NH 2
Extraction
.LP
The identification of the spectra in the two dimensional images and their
scattered light subtraction and extraction to one dimensional spectra
in multispec format is accomplished
using the tasks from the \fBapextract\fR package.  The first parameters
through \f(CWnsubaps\fR control the extractions.
.LP
The dispersion line is that used for finding the spectra, for plotting in
the aperture editor, and as the starting point for tracing.  The default
value of \fBINDEF\fR selects the middle of the image.  The aperture
finding, adjusting, editing, and tracing operations also allow summing a
number of dispersion lines to improve the signal.  The number of lines is
set by the \f(CWnsum\fR parameter.
.LP
The order parameter defines whether the order of the aperture
identifications in the aperture identification table (or the default
sequential numbers if no file is used) is in the same sense as the image
coordinates (increasing) or the opposite sense (decreasing).  If the
aperture identifications turn out to be opposite to what is desired when
viewed in the aperture editing graph then simply change this parameter.
.LP
The basic data output by the spectral extraction routines are the one
dimensional spectra.  Additional information may be output when the
\f(CWextras\fR option is selected and the cleaning or variance weighting
options are also selected.  In this case a three dimensional image is
produced with the first element of the third dimension being the cleaned
and/or weighted spectra, the second element being the uncleaned and
unweighted spectra, and the third element being an estimate of the sigma
of each pixel in the extracted spectrum.  Currently the sigma data is not
used by any other tasks and is only for reference.
.LP
The initial step of finding the fiber spectra in the aperture reference
image consists of identifying the peaks in a cut across the dispersion,
eliminating those which are closer to each other than the \f(CWminsep\fR
distance, and then keeping the specified \f(CWnfibers\fR highest peaks.  The
centers of the profiles are determined using the \fBcenter1d\fR algorithm
which uses the \f(CWwidth\fR parameter.
.LP
Apertures are then assigned to each spectrum.  The initial edges of the
aperture relative to the center are defined by the \f(CWlower\fR and
\f(CWupper\fR parameters.
.LP
The initial apertures are the same for all spectra but they can each be
automatically resized.  The automatic resizing sets the aperture limits
at a fraction of the peak relative to the interfiber minimum.
The default \f(CWylevel\fR is to resize the apertures to 5% of the peak.
See the description for the task \fBapresize\fR for further details.
.LP
The user is given the opportunity to graphically review and adjust the
aperture definitions.  This is recommended
and it is fundamentally important that the correct aperture/beam numbers
be associated with the proper fibers;
otherwise the spectrum
identifications will not be for the objects they say.  An important command in
this regard is the 'o' key which allows reordering the identifications.
This is required if the first
fiber is actually missing since the initial assignment begins with the
first spectrum found.  The
aperture editor is a very powerful tool and is described in detail as
\fBapedit\fR.
.LP
The next set of parameters control the tracing and function fitting of the
aperture reference positions along the dispersion direction.  The position
of a spectrum across the dispersion is determined by the centering
algorithm (see \fBcenter1d\fR) at a series of evenly spaced steps, given by
the parameter \f(CWt_step\fR, along the dispersion.  The step size should be
fine enough to follow position changes but it is not necessary to measure
every point.  The fitted points may jump around a little bit due to noise
and cosmic rays even when summing a number of lines.  Thus, a smooth
function is fit.  The function type, order, and iterative rejection of
deviant points is controlled by the other trace parameters.  For more
discussion consult the help pages for \fBaptrace\fR and \fBicfit\fR.  The
default is to fit a cubic spline of three pieces with a single iteration of
3 sigma rejection.
.LP
The actual extraction of the spectra by summing across the aperture at each
point along the dispersion is controlled by the next set of parameters.
The default extraction simply sums the pixels using partial pixels at the
ends.  The options allow selection of a weighted sum based on a Poisson
variance model using the \f(CWreadnoise\fR and \f(CWgain\fR detector
parameters.  Note that if the \f(CWclean\fR option is selected the variance
weighted extraction is used regardless of the \f(CWweights\fR parameter.  The
sigma thresholds for cleaning are also set in the \fBparams\fR parameters.
For more on the variance weighted extraction and cleaning see
\fBapvariance\fR and \fBapprofiles\fR as well as \fBapsum\fR.
.LP
The last parameter, \f(CWnsubaps\fR, is used only in special cases when it is
desired to subdivide the fiber profiles into subapertures prior to
dispersion correction.  After dispersion correction the subapertures are
then added together.  The purpose of this is to correct for wavelength
shifts across a fiber.
.NH 2
Scattered Light Subtraction
.LP
Scattered light may be subtracted from the input two dimensional image as
the first step.  This is done using the algorithm described in
\fBapscatter\fR.  This can be important if there is significant scattered
light since the flat field/throughput correction will otherwise be
incorrect.  The algorithm consists of fitting a function to the data
outside the defined apertures by a specified \fIbuffer\fR at each line or
column across the dispersion.  The function fitting parameters are the same
at each line.  Because the fitted functions are independent at each line or
column a second set of one dimensional functions are fit parallel to the
dispersion using the evaluated fit values from the cross-dispersion step.
This produces a smooth scattered light surface which is finally subtracted
from the input image.  Again the function fitting parameters are the
same at each line or column though they may be different than the parameters
used to fit across the dispersion.
.LP
The first time the task is run with a particular flat field (or aperture
reference image if no flat field is used) the scattered light fitting
parameters are set interactively using that image.  The interactive step
selects a particular line or column upon which the fitting is done
interactively with the \fBicfit\fR commands.  A query is first issued
which allows skipping this interactive stage.  Note that the interactive
fitting is only for defining the fitting functions and orders.  When
the graphical \fBicfit\fR fitting is exited (with 'q') there is a second prompt
allowing you to change the buffer distance (in the first cross-dispersion
stage) from the apertures, change the line/column, or finally quit.
.LP
The initial fitting parameters and the final set parameters are recorded
in the \fBapscat1\fR and \fBapscat2\fR hidden parameter sets.  These
parameters are then used automatically for every subsequent image
which is scattered light corrected.
.LP
The scattered light subtraction modifies the input 2D images.  To preserve
the original data a copy of the original image is made with the same
root name and the word "noscat" appended.  The scattered light subtracted
images will have the header keyword "APSCATTE" which is how the task
avoids repeating the scattered light subtraction during any reprocessing.
However if the \fIredo\fR option is selected the scattered light subtraction
will also be redone by first restoring the "noscat" images to the original
input names.
.NH 2
Flat Field and Fiber Throughput Corrections
.LP
Flat field corrections may be made during the basic CCD processing; i.e.
direct division by the two dimensional flat field observation.  In that
case do not specify a flat field spectrum; use the null string "".  The
\fBdoargus\fR task provides an alternative flat field response correction
based on division of the extracted object spectra by the extracted flat field
spectra.  A discussion of the theory and merits of flat fielding directly
verses using the extracted spectra will not be made here.  The
\fBdoargus\fR flat fielding algorithm is the \fIrecommended\fR method for
flat fielding since it works well and is not subject to the many problems
involved in two dimensional flat fielding.
.LP
In addition to correcting for pixel-to-pixel response the flat field step
also corrects for differences in the fiber throughput.  Thus, even if the
pixel-to-pixel flat field corrections have been made in some other way it
is desirable to use a sky or dome flat observation for determining a fiber
throughput correction.  Alternatively, a separately derived throughput
file may be specified.  This file consists of the aperture numbers
(the same as used for the aperture reference) and relative throughput
numbers.
.LP
The first step is extraction of the flat field spectrum, if specified,
using the reference apertures.  Only one flat field is allowed so if
multiple flat fields are required the data must be reduced in groups.
After extraction one or more corrections are applied.  If the \f(CWfitflat\fR
option is selected (the default) the extracted flat field spectra are
averaged together and a smooth function is fit.  The default fitting
function and order are given by the parameters \f(CWf_function\fR and
\f(CWf_order\fR.  If the parameter \f(CWf_interactive\fR is "yes" then the
fitting is done interactively using the \fBfit1d\fR task which uses the
\fBicfit\fR interactive fitting commands.
.LP
The fitted function is divided into the individual flat field spectra to
remove the basic shape of the spectrum while maintaining the relative
individual pixel responses and any fiber to fiber differences.  This step
avoids introducing the flat field spectrum shape into the object spectra
and closely preserves the object counts.
.LP
If a throughput image is available (an observation of blank sky
usually at twilight) it is extracted.  If no flat field is used the average
signal through each fiber is computed and this becomes the response
normalization function.  Note that a dome flat may be used in place of a
sky in the sky flat field parameter for producing throughput only
corrections.  If a flat field is specified then each sky spectrum is
divided by the appropriate flat field spectrum.  The total counts through
each fiber are multiplied into the flat field spectrum thus making the sky
throughput of each fiber the same.  This correction is important if the
illumination of the fibers differs between the flat field source and the
sky.  Since only the total counts are required the sky or dome flat field
spectra need not be particularly strong though care must be taken to avoid
objects.
.LP
Instead of a sky flat or other throughput image a separately derived
throughput file may be used.  It may be used with or without a
flat field.
.LP
The final step is to normalize the flat field spectra by the mean counts of
all the fibers.  This normalization step is simply to preserve the average
counts of the extracted object and arc spectra after division by the
response spectra.  The final relative throughput values are recorded in the
log and possibly printed on the terminal.
.LP
These flat field response steps and algorithm are available as a separate
task called \fBmsresp1d\fR.
.NH 2
Dispersion Correction
.LP
Dispersion corrections are applied to the extracted spectra if the
\fBdispcor\fR parameter is set.  This can be a complicated process which
the \fBdoargus\fR task tries to simplify for you.  There are three basic
steps involved; determining the dispersion functions relating pixel
position to wavelength, assigning the appropriate dispersion function to a
particular observation, and resampling the spectra to evenly spaced pixels
in wavelength.
.LP
The comparison arc spectra are used to define dispersion functions for the
fibers using the tasks \fBautoidentify\fR and \fBreidentify\fR.  The
interactive \fBautoidentify\fR task is only used on the central fiber of the
first arc spectrum to define the basic reference dispersion solution from
which all other fibers and arc spectra are automatically derived using
\fBreidentify\fR. \fBAutoidentify\fR attempts to automatically identify
the arc lines using the \fIcrval\fR and \fIcdelt\fR parameters.  Whether or
not it is successful the user is presented with the interactive
identification graph.  The automatic identifications can be reviewed and a
new solution or corrections to the automatic solution may be performed.
.LP
The set of arc dispersion function parameters are from \fBautoidentify\fR and
\fBreidentify\fR.  The parameters define a line list for use in
automatically assigning wavelengths to arc lines, a parameter controlling
the width of the centering window (which should match the base line
widths), the dispersion function type and order, parameters to exclude bad
lines from function fits, and parameters defining whether to refit the
dispersion function, as opposed to simply determining a zero point shift,
and the addition of new lines from the line list when reidentifying
additional arc spectra.  The defaults should generally be adequate and the
dispersion function fitting parameters may be altered interactively.  One
should consult the help for the two tasks for additional details of these
parameters and the operation of \fBautoidentify\fR.
.LP
Generally, taking a number of comparison arc lamp exposures interspersed
with the program spectra is sufficient to accurately dispersion calibrate
Argus spectra. Dispersion functions are
determined independently for each fiber of each arc image and then assigned
to the matching fibers in the program object observations.  The assignment
consists of selecting one or two arc images to calibrate each object
image.
.LP
However, there is another calibration option which may be of interest.
This option uses auxiliary line spectra, such as from dome lights or night
sky lines, to monitor wavelength zero point shifts which are added to the
basic dispersion function derived from a single reference arc.  Initially
one of the auxiliary fiber spectra is plotted interactively by
\fBidentify\fR with the reference dispersion function for the appropriate
fiber.  The user marks one or more lines which will be used to compute zero
point wavelength shifts in the dispersion functions automatically.  In this
case it is auxiliary arc images which are assigned to particular objects.
.LP
The arc or auxiliary line image assignments may be done either explicitly with
an arc assignment
table (parameter \f(CWarctable\fR) or based on a header parameter.  The task
used is \fBrefspectra\fR and the user should consult this task if the
default behavior is not what is desired.  The default is to interpolate
linearly between the nearest arcs based on the Julian date (corrected to
the middle of the exposure).  The Julian date and a local Julian day number
(the day number at local noon) are computed automatically by the task
\fBsetjd\fR and recorded in the image headers under the keywords JD and
LJD.  In addition the universal time at the middle of the exposure, keyword
UTMIDDLE, is computed by the task \fBsetairmass\fR and this may also be used
for ordering the arc and object observations.
.LP
An optional step is to use sky lines in the spectra to compute a zeropoint
dispersion shift that will align the sky lines.  This may improve sky
subtraction if the illumination is not the same between the arc calibration
and the sky.  When selected the object spectrum is dispersion corrected
using a non-linear dispersion function to avoid resampling the spectrum.
The sky lines are then reidentified in wavelength space from a template
list of sky lines.  The mean shift in the lines for each fiber relative to
the template in that fiber is computed to give the zeropoint shift.  The
database file is created when the first object is extracted.  You are asked
to mark the sky lines in one fiber and then the lines are automatically
reidentified in all other fibers.  Note that this technique requires the
sky lines be found in all fibers.
.LP
The last step of dispersion correction (resampling the spectrum to evenly
spaced pixels in wavelength) is optional and relatively straightforward.
If the \f(CWlinearize\fR parameter is no then the spectra are not resampled
and the nonlinear dispersion information is recorded in the image header.
Other IRAF tasks (the coordinate description is specific to IRAF) will use
this information whenever wavelengths are needed.  If linearizing is
selected a linear dispersion relation, either linear in the wavelength or
the log of the wavelength, is defined once and applied to every extracted
spectrum.  The resampling algorithm  parameters allow selecting the
interpolation function type, whether to conserve flux per pixel by
integrating across the extent of the final pixel, and whether to linearize
to equal linear or logarithmic intervals.  The latter may be appropriate
for radial velocity studies.  The default is to use a fifth order
polynomial for interpolation, to conserve flux, and to not use logarithmic
wavelength bins.  These parameters are described fully in the help for the
task \fBdispcor\fR which performs the correction.  The interpolation
function options and the nonlinear dispersion coordinate system is
described in the help topic \fBonedspec.package\fR.
.NH 2
Sky Subtraction
.LP
Sky subtraction is selected with the \f(CWskysubtract\fR processing option.
The sky spectra are selected by their aperture and beam numbers.
If the \f(CWskyedit\fR
option is selected the sky spectra are plotted using the task
\fBspecplot\fR.  By default they are superposed to allow identifying
spectra with unusually high signal due to object contamination.  To
eliminate a sky spectrum from consideration point at it with the cursor and
type 'd'.  The last deleted spectrum may be undeleted with 'e'.  This
allows recovery of incorrect or accidental deletions.
.LP
If the combining option is "none" then the sky and object fibers are
paired and one sky is subtracted from one object and the saved sky will
be the individual sky fiber spectra.
.LP
However, the usual
case is to combine the individual skys into a single master sky spectrum
which is then subtracted from each object spectrum.
The sky combining algorithm parameters define how the individual sky fiber
spectra, after interactive editing, are combined before subtraction from
the object fibers.  The goals of combining are to reduce noise, eliminate
cosmic-rays, and eliminate fibers with inadvertent objects.  The common
methods for doing this to use a median and/or a special sigma clipping
algorithm (see \fBscombine\fR for details).  The scale
parameter determines whether the individual skys are first scaled to a
common mode.  The scaling should be used if the throughput is uncertain,
but in that case you probably did the wrong thing in the throughput
correction.  If the sky subtraction is done interactively, i.e. with the
\f(CWskyedit\fR option selected, then after selecting the spectra to be
combined a query is made for the combining algorithm.  This allows
modifying the default algorithm based on the number of sky spectra
selected since the "avsigclip" rejection algorithm requires at least
three spectra.
.LP
The combined sky spectrum is subtracted from only those spectra specified
by the object aperture and beam numbers.  Other spectra
are retained unchanged.  One may include the sky spectra as
object spectra to produce residual sky spectra for analysis.  The combined
master sky spectra may be saved if the \f(CWsaveskys\fR parameter is set.
The saved sky is given the name of the object spectrum with the prefix
"sky".
.NH
References
.NH 2
IRAF Introductory References
.LP
Work is underway on a new introductory guide to IRAF.  Currently, the
work below is the primary introduction.
.IP
P. Shames and D. Tody, \fIA User's Introduction to the IRAF Command
Language\fR, Central Computer Services, NOAO, 1986.
.NH 2
CCD Reductions
.IP
F. Valdes, \fIThe IRAF CCD Reduction Package -- CCDRED\fR, Central
Computer Services, NOAO, 1987.
.IP
F. Valdes, \fIUser's Guide to the CCDRED Package\fR, Central
Computer Services, NOAO, 1988.  Also on-line as \f(CWhelp ccdred.guide\fR.
.IP
P. Massey, \fIA User's Guide to CCD Reductions with IRAF\fR, Central
Computer Services, NOAO, 1989.
.NH 2
Aperture Extraction Package
.IP
F. Valdes, \fIThe IRAF APEXTRACT Package\fR, Central Computer Services,
NOAO, 1987 (out-of-date).
.NH 2
Task Help References
.LP
Each task in the \fBargus\fR package and tasks used by \fBdoargus\fR have
help pages describing the parameters and task in some detail.  To get
on-line help type
.V1

cl> help \fItaskname\fR

.V2
The output of this command can be piped to \fBlprint\fR to make a printed
copy.

.V1
      apall - Extract 1D spectra (all parameters in one task)
  apdefault - Set the default aperture parameters
     apedit - Edit apertures interactively
     apfind - Automatically find spectra and define apertures
 aprecenter - Recenter apertures
   apresize - Resize apertures
      apsum - Extract 1D spectra
    aptrace - Trace positions of spectra

      bplot - Batch plots of spectra
  continuum - Fit the continuum in spectra
    dispcor - Dispersion correct spectra
     dopcor - Doppler correct spectra
   identify - Identify features in spectrum for dispersion solution
   msresp1d - Create 1D response spectra from flat field and sky spectra
 refspectra - Assign wavelength reference spectra to other spectra
 reidentify - Automatically identify features in spectra
 sapertures - Set or change aperture header information
     sarith - Spectrum arithmetic
   scombine - Combine spectra having different wavelength ranges
      scopy - Select and copy apertures in different spectral formats
 setairmass - Compute effective airmass and middle UT for an exposure
      setjd - Compute and set Julian dates in images
      slist - List spectrum header parameters
   specplot - Stack and plot multiple spectra
      splot - Preliminary spectral plot/analysis

    doargus - Process ARGUS spectra
      demos - Demonstrations and tests

	    Additional help topics

   onedspec.package - Package parameters and general description of package
  apextract.package - Package parameters and general description of package
 approfiles - Profile determination algorithms
 apvariance - Extractions, variance weighting, cleaning, and noise model
   center1d - One dimensional centering algorithm
      icfit - Interactive one dimensional curve fitting
.V2
.SH
Appendix A:  DOARGUS Parameters
.LP
.nr PS 8
.nr VS 10
objects
.LS
List of object spectra to be processed.  Previously processed spectra are
ignored unless the \f(CWredo\fR flag is set or the \f(CWupdate\fR flag is set and
dependent calibration data has changed.  Extracted spectra are ignored.
.LE
apref = ""
.LS
Aperture reference spectrum.  This spectrum is used to define the basic
extraction apertures and is typically a flat field spectrum.
.LE
flat = "" (optional)
.LS
Flat field spectrum.  If specified the one dimensional flat field spectra
are extracted and used to make flat field calibrations.  If a separate
throughput file or image is not specified the flat field is also used
for computing a fiber throughput correction.
.LE
throughput = "" (optional)
.LS
Throughput file or image.  If an image is specified, typically a blank sky
observation, the total flux through each fiber is used to correct for fiber
throughput.  If a file consisting of lines with the aperture number and
relative throughput is specified then the fiber throughput will be
corrected by those values.  If neither is specified but a flat field image
is given it is used to compute the throughput.
.LE
arcs1 = "" (at least one if dispersion correcting)
.LS
List of primary arc spectra.  These spectra are used to define the dispersion
functions for each fiber apart from a possible zero point correction made
with secondary shift spectra or arc calibration fibers in the object spectra.
One fiber from the first spectrum is used to mark lines and set the dispersion
function interactively and dispersion functions for all other fibers and
arc spectra are derived from it.
.LE
arcs2 = "" (optional)
.LS
List of optional shift arc spectra.  Features in these secondary observations
are used to supply a wavelength zero point shift through the observing
sequence.  One type of observation is dome lamps containing characteristic
emission lines.
.LE
arctable = "" (optional) (refspectra)
.LS
Table defining arc spectra to be assigned to object
spectra (see \fBrefspectra\fR).  If not specified an assignment based
on a header parameter, \f(CWparams.sort\fR, such as the observation time is made.
.LE

readnoise = "0." (apsum)
.LS
Read out noise in photons.  This parameter defines the minimum noise
sigma.  It is defined in terms of photons (or electrons) and scales
to the data values through the gain parameter.  A image header keyword
(case insensitive) may be specified to get the value from the image.
.LE
gain = "1." (apsum)
.LS
Detector gain or conversion factor between photons/electrons and
data values.  It is specified as the number of photons per data value.
A image header keyword (case insensitive) may be specified to get the value
from the image.
.LE
datamax = INDEF (apsum.saturation)
.LS
The maximum data value which is not a cosmic ray.
When cleaning cosmic rays and/or using variance weighted extraction
very strong cosmic rays (pixel values much larger than the data) can
cause these operations to behave poorly.  If a value other than INDEF
is specified then all data pixels in excess of this value will be
excluded and the algorithms will yield improved results.
This applies only to the object spectra and not the flat field or
arc spectra.  For more
on this see the discussion of the saturation parameter in the
\fBapextract\fR package.
.LE
fibers = 48 (apfind)
.LS
Number of fibers.  This number is used during the automatic definition of
the apertures from the aperture reference spectrum.  It is best if this
reflects the actual number of fibers which may be found in the aperture
reference image.  Note that Argus fibers which are unassigned will still
contain enough light for identification and the aperture identification
table will be used to eliminate the unassigned fibers.  The interactive
review of the aperture assignments allows verification and adjustments
to the automatic aperture definitions.
.LE
width = 6. (apedit)
.LS
Approximate base full width of the fiber profiles.  This parameter is used
for the profile centering algorithm.
.LE
minsep = 8. (apfind)
.LS
Minimum separation between fibers.  Weaker spectra or noise within this
distance of a stronger spectrum are rejected.
.LE
maxsep = 10. (apfind)
.LS
Maximum separation between adjacent fibers.  This parameter
is used to identify missing fibers.  If two adjacent spectra exceed this
separation then it is assumed that a fiber is missing and the aperture
identification assignments will be adjusted accordingly.
.LE
apidtable = "" (apfind)
.LS
Aperture identification table.  This may be either a text file or an
image.  A text file contains the fiber number, beam number defining object
(1), sky (0), and arc (2) fibers, and a object title.  An image contains
the keywords SLFIBnnn with string value consisting of the fiber number,
beam number, optional right ascension and declination, and an object
title.  Unassigned and broken fibers (beam of -1)
should be included in this list since they will automatically be excluded.
.LE
crval = INDEF, cdelt = INDEF (autoidentify)
.LS
These parameters specify an approximate central wavelength and dispersion.
They may be specified as numerical values, INDEF, or image header keyword
names whose values are to be used.
If both these parameters are INDEF then the automatic identification will
not be done.
.LE
objaps = "", skyaps = "2x2"
.LS
List of object and sky aperture numbers.  These are used to
identify object and sky
apertures for sky subtraction.  Note sky apertures may be identified as
both object and sky if one wants to subtract the mean sky from the
individual sky spectra.  Because the fibers typically alternate
sky and object the default is to define the sky apertures by their
aperture numbers and select both object and sky fibers for sky subtraction.
.LE
objbeams = "", skybeams = ""
.LS
List of object and sky beam numbers.
The beam numbers are typically the same as the aperture numbers unless
set in the \fIapidtable\fR.
.LE

scattered = no (apscatter)
.LS
Smooth and subtracted scattered light from the object and flat field
images.  This operation consists of fitting independent smooth functions
across the dispersion using data outside the fiber apertures and then
smoothing the individual fits along the dispersion.  The initial
flat field, or if none is given the aperture reference image, are
done interactively to allow setting the fitting parameters.  All
subsequent subtractions use the same fitting parameters.
.LE
fitflat = yes (flat1d)
.LS
Fit the composite flat field spectrum by a smooth function and divide each
flat field spectrum by this function?  This operation removes the average
spectral signature of the flat field lamp from the sensitivity correction to
avoid modifying the object fluxes.
.LE
clean = yes (apsum)
.LS
Detect and correct for bad pixels during extraction?  This is the same
as the clean option in the \fBapextract\fR package.  If yes this also
implies variance weighted extraction and requires reasonably good values
for the readout noise and gain.  In addition the datamax parameters
can be useful.
.LE
dispcor = yes
.LS
Dispersion correct spectra?  Depending on the \f(CWparams.linearize\fR
parameter this may either resample the spectra or insert a dispersion
function in the image header.
.LE
skyalign = no
.LS
Align sky lines?  If yes then for the first object spectrum you are asked
to mark one or more sky lines to use for alignment.  Then these lines will
be found in all spectra and an average zeropoint shift computed and applied
to the dispersion solution to align these lines.  Note that this assumes
the sky lines are seen in all fibers.
.LE
skysubtract = yes
.LS
Subtract sky from the object spectra?  If yes the sky spectra are combined
and subtracted from the object spectra as defined by the object and sky
aperture/beam parameters.
.LE
skyedit = yes
.LS
Overplot all the sky spectra and allow contaminated sky spectra to be
deleted?
.LE
saveskys = yes
.LS
Save the combined sky spectrum?  If no then the sky spectrum will be
deleted after sky subtraction is completed.
.LE
splot = no
.LS
Plot the final spectra with the task \fBsplot\fR?
.LE
redo = no
.LS
Redo operations previously done?  If no then previously processed spectra
in the objects list will not be processed (unless they need to be updated).
.LE
update = yes
.LS
Update processing of previously processed spectra if aperture, flat
field, or dispersion reference definitions are changed?
.LE
batch = no
.LS
Process spectra as a background or batch job provided there are no interactive
options (\f(CWskyedit\fR and \f(CWsplot\fR) selected.
.LE
listonly = no
.LS
List processing steps but don't process?
.LE

params = "" (pset)
.LS
Name of parameter set containing additional processing parameters.  The
default is parameter set \fBparams\fR.  The parameter set may be examined
and modified in the usual ways (typically with "epar params" or ":e params"
from the parameter editor).  Note that using a different parameter file
is not allowed.  The parameters are described below.
.LE

.ce
-- PACKAGE PARAMETERS

Package parameters are those which generally apply to all task in the
package.  This is also true of \fBdoargus\fR.

dispaxis = 2
.LS
Default dispersion axis.  The dispersion axis is 1 for dispersion
running along image lines and 2 for dispersion running along image
columns.  If the image header parameter DISPAXIS is defined it has
precedence over this parameter.  The default value defers to the
package parameter of the same name.
.LE
observatory = "observatory"
.LS
Observatory at which the spectra were obtained if not specified in the
image header by the keyword OBSERVAT.  For Argus data the image headers
identify the observatory as "kpno" so this parameter is not used.
For data from other observatories this parameter may be used
as describe in \fBobservatory\fR.
.LE
interp = "poly5" (nearest|linear|poly3|poly5|spline3|sinc)
.LS
Spectrum interpolation type used when spectra are resampled.  The choices are:

.V1
	nearest - nearest neighbor
	 linear - linear
	  poly3 - 3rd order polynomial
	  poly5 - 5th order polynomial
	spline3 - cubic spline
	   sinc - sinc function
.V2
.LE
database = "database"
.LS
Database (directory) used for storing aperture and dispersion information.
.LE
verbose = no
.LS
Print verbose information available with various tasks.
.LE
logfile = "logfile", plotfile = ""
.LS
Text and plot log files.  If a filename is not specified then no log is
kept.  The plot file contains IRAF graphics metacode which may be examined
in various ways such as with \fBgkimosaic\fR.
.LE
records = ""
.LS
Dummy parameter to be ignored.
.LE
version = "ARGUS: ..."
.LS
Version of the package.
.LE

.ce
PARAMS PARAMETERS

The following parameters are part of the \fBparams\fR parameter set and
define various algorithm parameters for \fBdoargus\fR.

.ce
--  GENERAL PARAMETERS --

line = INDEF, nsum = 10
.LS
The dispersion line (line or column perpendicular to the dispersion
axis) and number of adjacent lines (half before and half after unless
at the end of the image) used in finding, recentering, resizing,
editing, and tracing operations.  A line of INDEF selects the middle of the
image along the dispersion axis.
.LE
order = "decreasing" (apfind)
.LS
When assigning aperture identifications order the spectra "increasing"
or "decreasing" with increasing pixel position (left-to-right or
right-to-left in a cross-section plot of the image).
.LE
extras = no (apsum)
.LS
Include extra information in the output spectra?  When cleaning or using
variance weighting the cleaned and weighted spectra are recorded in the
first 2D plane of a 3D image, the raw, simple sum spectra are recorded in
the second plane, and the estimated sigmas are recorded in the third plane.
.LE

.ce
-- DEFAULT APERTURE LIMITS --

lower = -3., upper = 3. (apdefault)
.LS
Default lower and upper aperture limits relative to the aperture center.
These limits are used when the apertures are first found and may be
resized automatically or interactively.
.LE

.ce
-- AUTOMATIC APERTURE RESIZING PARAMETERS --

ylevel = 0.05 (apresize)
.LS
Data level at which to set aperture limits during automatic resizing.
It is a fraction of the peak relative to a local background.
.LE

.ce
-- TRACE PARAMETERS --

t_step = 10 (aptrace)
.LS
Step along the dispersion axis between determination of the spectrum
positions.  Note the \f(CWnsum\fR parameter is also used to enhance the
signal-to-noise at each step.
.LE
t_function = "spline3", t_order = 3 (aptrace)
.LS
Default trace fitting function and order.  The fitting function types are
"chebyshev" polynomial, "legendre" polynomial, "spline1" linear spline, and
"spline3" cubic spline.  The order refers to the number of
terms in the polynomial functions or the number of spline pieces in the spline
functions.
.LE
t_niterate = 1, t_low = 3., t_high = 3. (aptrace)
.LS
Default number of rejection iterations and rejection sigma thresholds.
.LE

.ce
-- SCATTERED LIGHT PARAMETERS --

buffer = 1. (apscatter)
.LS
Buffer distance from the aperture edges to be excluded in selecting the
scattered light pixels to be used.
.LE
apscat1 = "" (apscatter)
.LS
Fitting parameters across the dispersion.  This references an additional
set of parameters for the ICFIT package.  The default is the "apscat1"
parameter set.
.LE
apscat2 = "" (apscatter)
.LS
Fitting parameters along the dispersion.  This references an additional
set of parameters for the ICFIT package.  The default is the "apscat2"
parameter set.
.LE

.ce
-- APERTURE EXTRACTION PARAMETERS --

weights = "none" (apsum)
.LS
Type of extraction weighting.  Note that if the \f(CWclean\fR parameter is
set then the weights used are "variance" regardless of the weights
specified by this parameter.  The choices are:

"none"
.LS
The pixels are summed without weights except for partial pixels at the
ends.
.LE
"variance"
.LS
The extraction is weighted by the variance based on the data values
and a poisson/ccd model using the \f(CWgain\fR and \f(CWreadnoise\fR
parameters.
.LE
.LE
pfit = "fit1d" (apsum) (fit1d|fit2d)
.LS
Profile fitting algorithm for cleaning and variance weighted extractions.
The default is generally appropriate for Argus data but users
may try the other algorithm.  See \fBapprofiles\fR for further information.
.LE
lsigma = 3., usigma = 3. (apsum)
.LS
Lower and upper rejection thresholds, given as a number of times the
estimated sigma of a pixel, for cleaning.
.LE
nsubaps = 1 (apsum)
.LS
During extraction it is possible to equally divide the apertures into
this number of subapertures.
.LE

.ce
-- FLAT FIELD FUNCTION FITTING PARAMETERS --

f_interactive = yes (fit1d)
.LS
Fit the composite one dimensional flat field spectrum interactively?
This is used if \f(CWfitflat\fR is set and a two dimensional flat field
spectrum is specified.
.LE
f_function = "spline3", f_order = 10 (fit1d)
.LS
Function and order used to fit the composite one dimensional flat field
spectrum.  The functions are "legendre", "chebyshev", "spline1", and
"spline3".  The spline functions are linear and cubic splines with the
order specifying the number of pieces.
.LE

.ce
-- ARC DISPERSION FUNCTION PARAMETERS --

threshold = 10. (autoidentify/identify/reidentify)
.LS
In order for a feature center to be determined the range of pixel intensities
around the feature must exceed this threshold.
.LE
coordlist = "linelists$ctiohenear.dat" (autoidentify/identify)
.LS
Arc line list consisting of an ordered list of wavelengths.
Some standard line lists are available in the directory "linelists$".
.LE
match = -3. (autoidentify/identify)
.LS
The maximum difference for a match between the dispersion function prediction
value and a wavelength in the coordinate list.
.LE
fwidth = 4. (autoidentify/identify)
.LS
Approximate full base width (in pixels) of arc lines.
.LE
cradius = 10. (reidentify)
.LS
Radius from previous position to reidentify arc line.
.LE
i_function = "chebyshev", i_order = 3 (autoidentify/identify)
.LS
The default function and order to be fit to the arc wavelengths as a
function of the pixel coordinate.  The functions choices are "chebyshev",
"legendre", "spline1", or "spline3".
.LE
i_niterate = 2, i_low = 3.0, i_high = 3.0 (autoidentify/identify)
.LS
Number of rejection iterations and sigma thresholds for rejecting arc
lines from the dispersion function fits.
.LE
refit = yes (reidentify)
.LS
Refit the dispersion function?  If yes and there is more than 1 line
and a dispersion function was defined in the arc reference then a new
dispersion function of the same type as in the reference image is fit
using the new pixel positions.  Otherwise only a zero point shift is
determined for the revised fitted coordinates without changing the
form of the dispersion function.
.LE
addfeatures = no (reidentify)
.LS
Add new features from a line list during each reidentification?
This option can be used to compensate for lost features from the
reference solution.  Care should be exercised that misidentified features
are not introduced.
.LE

.ce
-- AUTOMATIC ARC ASSIGNMENT PARAMETERS --

select = "interp" (refspectra)
.LS
Selection method for assigning wavelength calibration spectra.
Note that an arc assignment table may be used to override the selection
method and explicitly assign arc spectra to object spectra.
The automatic selection methods are:

average
.LS
Average two reference spectra without regard to any sort parameter.
If only one reference spectrum is specified then it is assigned with a
warning.  If more than two reference spectra are specified then only the
first two are used and a warning is given.
This option is used to assign two reference spectra, with equal weights,
independent of any sorting parameter.
.LE
following
.LS
Select the nearest following spectrum in the reference list based on the
sorting parameter.  If there is no following spectrum use the nearest preceding
spectrum.
.LE
interp
.LS
Interpolate between the preceding and following spectra in the reference
list based on the sorting parameter.  If there is no preceding and following
spectrum use the nearest spectrum.  The interpolation is weighted by the
relative distances of the sorting parameter.
.LE
match
.LS
Match each input spectrum with the reference spectrum list in order.
This overrides the reference aperture check.
.LE
nearest
.LS
Select the nearest spectrum in the reference list based on the sorting
parameter.
.LE
preceding
.LS
Select the nearest preceding spectrum in the reference list based on the
sorting parameter.  If there is no preceding spectrum use the nearest following
spectrum.
.LE
.LE
sort = "jd", group = "ljd" (refspectra)
.LS
Image header keywords to be used as the sorting parameter for selection
based on order and to group spectra.
A null string, "", or the word "none" may be use to disable the sorting
or grouping parameters.
The sorting parameter
must be numeric but otherwise may be anything.  The grouping parameter
may be a string or number and must simply be the same for all spectra within
the same group (say a single night).
Common sorting parameters are times or positions.
In \fBdoargus\fR the Julian date (JD) and the local Julian day number (LJD)
at the middle of the exposure are automatically computed from the universal
time at the beginning of the exposure and the exposure time.  Also the
parameter UTMIDDLE is computed.
.LE
time = no, timewrap = 17. (refspectra)
.LS
Is the sorting parameter a 24 hour time?  If so then the time origin
for the sorting is specified by the timewrap parameter.  This time
should precede the first observation and follow the last observation
in a 24 hour cycle.
.LE

.ce
-- DISPERSION  CORRECTION PARAMETERS --

linearize = yes (dispcor)
.LS
Interpolate the spectra to a linear dispersion sampling?  If yes the
spectra will be interpolated to a linear or log linear sampling
If no the nonlinear dispersion function(s) from the dispersion function
database are assigned to the input image world coordinate system
and the spectral data are not interpolated.
.LE
log = no (dispcor)
.LS
Use linear logarithmic wavelength coordinates?  Linear logarithmic
wavelength coordinates have wavelength intervals which are constant
in the logarithm of the wavelength.
.LE
flux = yes (dispcor)
.LS
Conserve the total flux during interpolation?  If \f(CWno\fR the output
spectrum is interpolated from the input spectrum at each output
wavelength coordinate.  If \f(CWyes\fR the input spectrum is integrated
over the extent of each output pixel.  This is slower than
simple interpolation.
.LE

.ce
-- SKY SUBTRACTION PARAMETERS --

combine = "average" (scombine) (average|median)
.LS
Option for combining sky pixels at the same dispersion coordinate after any
rejection operation.  The options are to compute the  "average" or "median"
of the pixels.  The median uses the average of the two central
values when the number of pixels is even.
.LE
reject = "none" (scombine) (none|minmax|avsigclip)
.LS
Type of rejection operation performed on the pixels which overlap at each
dispersion coordinate.  The algorithms are discussed in the
help for \fBscombine\fR.  The rejection choices are:

.V1
      none - No rejection
    minmax - Reject the low and high pixels
 avsigclip - Reject pixels using an averaged sigma clipping algorithm
.V2

.LE
scale = "none" (none|mode|median|mean)
.LS
Multiplicative scaling to be applied to each spectrum.  The choices are none
or scale by the mode, median, or mean.  This should not be necessary if the
flat field and throughput corrections have been properly made. 
.LE

.ce
ENVIRONMENT PARAMETERS
.LP
The environment parameter \fIimtype\fR is used to determine the extension
of the images to be processed and created.  This allows use with any
supported image extension.  For STF images the extension has to be exact;
for example "d1h".
