/*****************************************************************
 * PTlink IRCd is (C) CopyRight PTlink Coders Team 1999-2003     *
 * http://www.ptlink.net/Coders/ - coders@PTlink.net             *
 * This program is distributed under GNU Public License          *
 * Please read the file COPYING for copyright information.       *
 *****************************************************************
 *   $Id:
   
  File: strcache.c
  Desc: string cache system 
  Author: Lamego@PTlink.net
*/

#include "client.h"
#include "strcache.h"
#include "ircd.h"
#include "s_log.h"
#include "s_serv.h"
#include "send.h"

#include <string.h>
#include <stdlib.h>

static int cache_state; 
time_t our_cache_ts; /* our cache ts */
/* if we are synchronized this is our cache ts,
   otherwise is the cache ts we are synchronizing with */
int cache_count;     /* last id we have/expect */
static time_t last_scs_set;  

struct scs_entry scs_list[SCS_SIZE];

/*
  Send all cached messages newer than basetime
 */
void scs_send_msgs(struct Client *acptr, time_t basetime)
{
  int i;
  
  irclog(L_TRACE,"SCS sending cache newer than %d to %s",
    basetime, acptr->name);
  for(i=0;i<cache_count;++i)
    if(scs_list[i].time>basetime)
      sendto_one(acptr,":%s SCSSET %d %i :%s",
        me.name, our_cache_ts, i, scs_list[i].msg);
}

/*
 * m_scschk - cache check
 *      parv[0] = sender prefix
 *      parv[1] = time
 *      parv[2] = count
 */
int m_scschk(struct Client *cptr, struct Client *sptr, int parc, char *parv[])
{
  time_t new_ts;
  int   ccount;

  /* if we are synchronizing check for timeout */
  if((cache_state == SCS_SYNC) && 
    ((CurrentTime - last_scs_set)> SCS_SET_TIMEOUT))
    {
      irclog(L_TRACE,"SCSCHK: SCS synchronization timed out");
      cache_state = SCS_EMPTY;
      our_cache_ts = 0;
      cache_count = 0;
    }

  if(parc < 3 || !IsServer(sptr))
    return 0;
    
  new_ts = atol(parv[1]);
  ccount = atoi(parv[2]);
  
  if(ccount>(SCS_SIZE-1))
    {
      irclog(L_WARN,"Ignored SCSCHK, our SCS size too small");
      return 0;
    }
  
  /* check if incoming cache come from services or is newer than ours */  
  if(((IsService(sptr) && (our_cache_ts!=new_ts))
    || our_cache_ts<new_ts))
    {
      irclog(L_TRACE,"SCSCHK: SCS synchronizing with %s, ts=%d, count=%i",
      	sptr->name, new_ts, ccount);
      cache_state = SCS_SYNC;
      our_cache_ts = new_ts;
      cache_count = ccount;
      last_scs_set = CurrentTime;
 
      /* make sure our leafs will be synchronized */
      sendto_match_cap_servs(NULL, cptr, CAP_SCS, 
        ":%s SCSCHK %s %s",
        parv[0], parv[1], parv[2]);
    }
  else if(!IsService(sptr) &&
     (cache_state == SCS_OK) &&
     (our_cache_ts>new_ts))
    {
      /* send all messages newer than ts */
      scs_send_msgs(sptr, new_ts);
      SetSCS(cptr);
    }
  else
    { 
      if(our_cache_ts == new_ts)
      SetSCS(cptr);
    }
  return 0;
}

/*
 * m_scsset - set one cache string
 *      parv[0] = sender prefix
 *      parv[1] = cache ts
 *      parv[2] = id
 *      parv[3] = text
 */
int m_scsset(struct Client *cptr, struct Client *sptr, int parc, char *parv[])
{
  time_t new_ts;
  int id;
  
  if(!IsServer(sptr)|| parc<4)
    return 0;
    
  new_ts = atol(parv[1]);
  id = atoi(parv[2]);
  
  if(id<0 || id>(SCS_SIZE-1))
  
  if((cache_state==SCS_OK)||(new_ts != our_cache_ts))
    return 0;
    
  if(scs_list[id].msg)
    {
      free(scs_list[id].msg);
    }
    
  scs_list[id].msg = strdup(parv[3]);
  scs_list[id].time = new_ts;
  last_scs_set = CurrentTime;  

  /* Propagate string set to all connected servers */
  sendto_match_cap_servs(NULL, cptr, CAP_SCS, 
    ":%s SCSSET %d %i :%s",
    me.name, our_cache_ts, id, scs_list[id].msg);

  if(id>=cache_count-1)
    {
      irclog(L_TRACE,"SCSCHK: SCS synchronization completed at %i, ts=%d",
        id, new_ts);
      cache_state = SCS_OK;      
    }    
  return 0;
}

/*
 * m_scsmsg - send cached string
 *      parv[0] = sender prefix
 *      parv[1] = target
 *      parv[2] = id (a '-' prefix means message should be sen with NOTICE)
 */
int m_scsmsg(struct Client *cptr, struct Client *sptr, int parc, char *parv[])
{
  int id;
  struct Client *acptr;
  char sender[NICKLEN + USERLEN + HOSTLEN + 5];
  int is_notice = 0;

  if(!IsService(sptr) || parc<3)
    return 0;

  if(parv[2][0] == '-')
    {
      id = atoi(&parv[2][1]);
      is_notice = -1;  	
    }
  else 
    id = atoi(parv[2]);
  
  if((cache_state!=SCS_OK) || id<0 || id>cache_count)
    return 0;
    
  if((acptr = find_person(parv[1],NULL)) == NULL)
    return 0;
  
  if(MyClient(acptr) || !IsSCS(acptr->from))
    {
       if(scs_list[id].msg==NULL)
       	 return 0;
       	 
  	(void)strcpy(sender, sptr->name);
  	if (*sptr->username)
          {
           strcat(sender, "!");
           strcat(sender, sptr->username);
          }
        if (*sptr->host)
          {
            strcat(sender, "@");
            strcat(sender, sptr->host);
          }    
        sendto_one(acptr,":%s %s %s :%s",
          sender, 
          is_notice ? "NOTICE" : "PRIVMSG",
          parv[1], scs_list[id].msg);
    }
  else
    {
        sendto_one(acptr,":%s SCSMSG %s %s",
          parv[0], parv[1], parv[2]);       
    }
  return 0;
}

void scs_stats(struct Client *acptr)
{
  int i;
  char *cs = NULL;
  long total=0;  
  
  if(cache_state==SCS_OK)
    cs = "Ok";
  else if(cache_state==SCS_SYNC)
    cs = "Synchronizing";
  else
    cs = "Empty";
  sendto_one(acptr,":%s NOTICE %s :String Cache System stats",
    me.name, acptr->name);
  sendto_one(acptr,":%s NOTICE %s : - Cache state: %s",
    me.name, acptr->name, cs);    
  sendto_one(acptr,":%s NOTICE %s : - Storage struct [%i] (%dKb)",
    me.name, acptr->name,SCS_SIZE, (SCS_SIZE*sizeof(struct scs_entry))/1024); 
  for(i=0; i<cache_count; ++i)
    if(scs_list[i].msg)
    	total += strlen(scs_list[i].msg);    	
  sendto_one(acptr,":%s NOTICE %s : - Storage usage   [%i] (%dKb)",
    me.name, acptr->name, cache_count, total/1024);     
  sendto_one(acptr,":%s NOTICE %s :End of stats",
    me.name, acptr->name);
}

void  scs_timeout_scheck(void)
{

 	/* if we are synchronizing check for timeout */
  	if((cache_state == SCS_SYNC) && 
    		((CurrentTime - last_scs_set)> SCS_SET_TIMEOUT))
    	  {
      		irclog(L_TRACE,"SCSCHK: SCS synchronization timed out");
      		cache_state = SCS_EMPTY;
      		our_cache_ts = 0;
      		cache_count = 0;
    	   }
}
