/* ids.c
 *
 * PTlink Services is (C) CopyRight PTlink Coders Team 1999-2003
 * http://www.ptlink.net/Coders/ - coders@PTlink.net
 * This program is distributed under GNU Public License
 *
 * Please read the file COPYING for copyright information.
 * $Id: ids.c,v 1.1.1.1 2003/07/22 18:26:41 jpinto Exp $
*/
#include "stdinc.h"
#include "hash.h"

#define MAX_SUID	0xFFFFFFE /* 268,435,454 nicks should be enough */
#define MIN_SUID	0x1

static u_int32_t suids_inuse = 0;
static u_int32_t last_suid = 0;		/* last generated suid */

/* allocates an suid */
void alloc_suid(NickInfo* ni)
{
  if(suids_inuse == MAX_SUID)
    {
      ni->suid = 0;
      return;        
    }
  do
    {
      if(++last_suid>MAX_SUID-1)
        last_suid = MIN_SUID;
    } while (hash_find_suid(last_suid));
    
  add_to_suid_hash_table(last_suid, ni);
  ++suids_inuse;    
  ni->suid = last_suid;
};

/* sets an suid */
void set_suid(u_int32_t suid, NickInfo* ni)
{
  NickInfo* oni;
  oni = hash_find_suid(suid);
  if(oni)
    {
      log1("SUID (%d) conflict, first nick: %s , second nick: %s",
      	suid, oni->nick, ni->nick);
      abort();
    }
  add_to_suid_hash_table(suid, ni);
  ni->suid = suid;
  ++suids_inuse;  
}

/* frees an suid */
void free_suid(NickInfo* ni)
{
  del_from_suid_hash_table(ni->suid, ni);
  ni->suid = 0;
  if(--suids_inuse<0)
    {
      log2("ERROR: Negative SUID count reached!!!");
      suids_inuse=0;
    } 
  return;
};




