#

# Services is copyright (c) 1996-1999 Andy Church.
#     Email: <achurch@dragonfire.net>
# This program is free but copyrighted software; see the file
# COPYING for details.

# This file is translated by Cord Beermann <cord@Wunder-Nett.org>
# If you find a better formulation, send it to
# pt-service-deutsch@cord.de

# diese Datei ist bersetzt worden von Cord Beermann
# <cord@Wunder-Nett.org>. Wenn Dir eine bessere bersetzung fr
# etwas einfllt, schicke Sie bitte an pt-service-deutsch@cord.de

#################################################################
#
# Name of this language
#
#################################################################

# For languages other than English, this string should have the
# following format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Deutsch (German)

#################################################################
#
# General messages
#
#################################################################

# strftime() format strings.  man 3 strftime for information on
# the meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date
# and time together.
STRFTIME_DATE_TIME_FORMAT
	%d %b %Y %H:%M:%S %Z
# This is used as the format string for strftime() for a date
# alone in long format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# This is used as the format string for strftime() for a date
# alone in short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y
# These tell our strftime() what the names of months and days
# are.  If you don't use %a, %A, %b, or %B in your strftime()
# strings above, you can leave these empty.  However, if you
# enter names, they MUST stay in order, one per line, and the
# list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Son
	Mon
	Die
	Mit
	Don
	Fre
	Sam
# %A
STRFTIME_DAYS_LONG
	Sonntag
	Montag
	Dienstag
	Mittwoch
	Donnerstag
	Freitag
	Samstag
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Feb
	Mr
	Apr
	Mai
	Jun
	Jul
	Aug
	Sep
	Okt
	Nov
	Dez
# %B
STRFTIME_MONTHS_LONG
	Januar
	Februar
	Mrz
	April
	Mai
	Juni
	Juli
	August
	September
	Oktober
	November
	Dezember

# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	,

# Various error messages.
USER_RECORD_NOT_FOUND
	Interner Fehler - kann Befehl nicht ausfhren.
UNKNOWN_COMMAND
	Unbekannter Befehl %s.
UNKNOWN_COMMAND_HELP
	Unbekannter Befehl %s.
	Tippe /msg %s HELP fr Hilfe.
SYNTAX_ERROR
	Syntax: %s
MORE_INFO
	/msg %s HELP %s fr weitere Hilfe.
NO_HELP_AVAILABLE
	Keine Hilfe verfgbar fr %s.
BAD_USERHOST_MASK
	Maske mu in der Form user@host sein.
SERVICE_OFFLINE
	%s ist derzeit offline.
READ_ONLY_MODE
	Achtung: Services sind im read-only Modus;
	nderungen knnen nicht gespeichert werden!
PASSWORD_INCORRECT
	Passwort falsch.

# What's the difference between "Access denied" and "Permission
# denied"? Very little; you can safely make them the same
# message with no real loss of meaning.  If you want to make a
# distinction, "Access denied" is usually used more generally;
# for example, a non-oper trying to access OperServ gets "Access
# denied", while a non-Services admin trying to use NickServ
# SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Zugang verweigert.
PERMISSION_DENIED
	Erlaubnis verweigert.
MORE_OBSCURE_PASSWORD
	Bitte versuche es noch einmal mit einem komplizierteren
	Passwort. Passwrter sollen mindestens fnf Zeichen
	lang sein, sie sollen nicht einfach zu erraten sein (z.B.
	Dein richtiger Name oder Dein Nick), und knnen keine
	Leerzeichen oder Tabulatoren enthalten.
PASSWORD_TRUNCATED
	Achtung:  Dein Passwort wurde auf %d Zeichen gekrzt.
NICK_NOT_REGISTERED
	Dein Nick ist nicht registriert.
NICK_NOT_REGISTERED_HELP
	Dein Nick ist nicht registriert.
	Tippe /msg %s HELP fr weitere Informationen,
	wie man den Nick registriert.
NICK_X_NOT_REGISTERED
	Nick %s nicht registriert.
NICK_X_NOT_IN_USE
	Nick %s wird derzeit nicht benutzt.
NICK_X_NOT_ON_CHAN
	Nick %s isn't on channel %s.
NICK_X_FORBIDDEN
	Nick %s darf nicht registriert oder
	benutzt werden.
CHAN_X_NOT_REGISTERED
	Kanal %s ist nicht registriert.
CHAN_X_NOT_IN_USE
	Kanal %s existiert nicht.
CHAN_X_FORBIDDEN
	Kanal %s darf nicht registriert oder
	benutzt werden.
NICK_IDENTIFY_REQUIRED
	Fr diesem Befehl ist eine Autorisierung erforderlich.
	Versuche es noch einmal nach der Eingabe
	/msg %s IDENTIFY password.
CHAN_IDENTIFY_REQUIRED
	Fr diesen Befehl ist Autorisierung erforderlich.
	Versuche es noch einmal nach der Eingabe
	/msg %s IDENTIFY password.

#################################################################
#
# NickServ messages
#
#################################################################

# Automatic messages
NICK_IS_REGISTERED
	Dieser Nick gehrt jemand anderem.  Bitte whle einen
	anderen Nick.  (Wenn es Dein Nick ist, tippe
	/msg %s IDENTIFY password.)
NICK_IS_SECURE
	Dieser Nick ist registriert und geschtzt.  Wenn es Dein
	Nick sein sollte, tippe
	/msg %s IDENTIFY password.
	Ansonsten whle bitte einen anderen Nick.
NICK_MAY_NOT_BE_USED
	Dieser Nick darf nicht benutzt werden.
	Bitte whle einen anderen.
DISCONNECT_IN_1_MINUTE
	Wenn Du nicht innerhalb einer Minute wechselst, wirst Du
	vom Chat getrennt.
DISCONNECT_IN_20_SECONDS
	Wenn Du nicht innerhalb zwanzig Sekunden wechselst, wirst
	Du vom Chat getrennt.
DISCONNECT_NOW
	Dieser Nick ist registriert; Du darfst ihn
	nicht benutzen. Whle einen anderen Nick bevor
	Du wiederkommst.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER password email
NICK_REGISTRATION_DISABLED
	Sorry, Nick Registrierung ist derzeit abgeschaltet.
NICK_REGISTRATION_FAILED
	Sorry, Registrierung milungen.
NICK_REG_PLEASE_WAIT
	Bitte warte %d Sekunden, bevor Du den REGISTER Befehl
	erneut benutzt.
NICK_CANNOT_BE_REGISTERED
	Nick %s darf nicht registriert werden.
NICK_ALREADY_REGISTERED
	Nick %s ist bereits registriert!
NICK_REGISTERED
	Nick %s registriert unter Deinem
	Zugang: %s
NICK_PASSWORD_IS
	Dein Passwort ist %s - Bitte merk Dir
	dieses Passwort.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY password
NICK_IDENTIFY_FAILED
	Sorry, Identifizierung gescheitert.
NICK_IDENTIFY_SUCCEEDED
	Passwort akzeptiert - Du bist nun angemeldet.

# DROP responses
NICK_DROP_SYNTAX
	DROP
NICK_DROP_DISABLED
	Sorry, Nick lschen ist derzeit abgeschaltet.
NICK_DROPPED
	Dein Nick ist gelscht worden.
NICK_X_DROPPED
	Nick %s ist gelscht worden.

# SET responses
NICK_SET_SYNTAX
	SET option parameters
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] option parameters
NICK_SET_DISABLED
	Sorry, Nick Einstellungen ndern ist
	derzeit abgeschaltet.
NICK_SET_UNKNOWN_OPTION
	Unbekannte SET Einstellung %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Unbekannte SET Einstellung %s,
	oder Nick nicht registriert.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Sorry, ich kann das Passwort nicht ndern.
NICK_SET_PASSWORD_CHANGED
	Passwort gendert.
NICK_SET_PASSWORD_CHANGED_TO
	Passwort gendert auf %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE number
NICK_SET_LANGUAGE_UNKNOWN
	Unbekannte Sprache Nummer %d.  Tippe
	/msg %s HELP SET LANGUAGE fr eine Liste
	der verfgbaren	Sprachen.
NICK_SET_LANGUAGE_CHANGED
	Sprache gendert auf Deutsch.

# SET URL responses
NICK_SET_URL_CHANGED
	URL auf %s gendert.
NICK_SET_URL_UNSET
	URL gelscht.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	Email Adresse auf %s gendert.
NICK_SET_EMAIL_UNSET
	Email Adresse gelscht.

# SET ICQNUMBER responses
NICK_SET_ICQ_CHANGED
	ICQ Nummer auf #%s gendert.
NICK_SET_ICQ_UNSET
	ICQ Nummer gelscht.

# SET LOCATION responses
NICK_SET_LOCATION_CHANGED
	Standort auf %s gendert.
NICK_SET_LOCATION_UNSET
	Standort gelscht.

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Kill Schutz ist nun ON.
NICK_SET_KILL_QUICK
	Kill Schutz ist nun ON, mit
	reduzierter kill Verzgerung.
NICK_SET_KILL_IMMED
	Kill Schutz ist nun ON, ohne eine Kill Verzgerung.
NICK_SET_KILL_IMMED_DISABLED
	Die IMMED Einstellung ist in
	diesem Netz nicht mglich.
NICK_SET_KILL_OFF
	Kill Schutz ist nun OFF.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Privat Einstellung ist nun ON.
NICK_SET_PRIVATE_OFF
	Privat Einstellung ist nun OFF.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Deine Email Adresse wird nun auf
	%s INFO Anzeigen nicht angezeigt.
NICK_SET_HIDE_EMAIL_OFF
	Deine Email Adresse wird nun auf
	%s INFO Anzeigen angezeigt.
NICK_SET_HIDE_QUIT_ON
	Deine letzte quit Nachricht wird nun auf
	%s INFO Anzeigen nicht angezeigt.
NICK_SET_HIDE_QUIT_OFF
	Deine letzte quit Nachricht wird nun auf
	%s INFO Anzeigen angezeigt.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [nickname] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	Nick %s wird nicht ablaufen.
NICK_SET_NOEXPIRE_OFF
	Nick %s wird ablaufen.

# LINK responses
NICK_LINK_SYNTAX
	LINK nick password
NICK_NICKLINK_SYNTAX
	NICKLINK nick targetnick
NICK_LINK_DISABLED
	Der LINK Befehl ist nicht verfgbar.
NICK_LINK_FAILED
	Sorry, linking gescheitert.
NICK_NO_LINK_SAME
	Du kannst nicht an Deinen aktuellen Nick linken!
NICK_LINK_CIRCULAR
	Kann Nick nicht linken %s:
	circular link entdeckt.
NICK_LINKED
	Dein Nick ist nun gelinkt zu %s.
NICK_NICKLINKED
	Der Nick %s ist nun gelinkt zu %s.

# UNLINK responses
NICK_UNLINK_SYNTAX
	UNLINK [nick password]
NICK_UNLINK_FAILED
	Sorry, Linkaufhebung gescheitert.
NICK_NOT_LINKED
	Dein Nick ist nicht gelinkt.
NICK_UNLINKED
	Dein Nick ist nun entlinkt von %s.
NICK_X_NOT_LINKED
	Nick %s nicht gelinkt.
NICK_X_UNLINKED
	Nick %s ist nun entlinkt von %s.

# LISTLINKS responses
NICK_LISTLINKS_SYNTAX
	LISTLINKS nick [ALL]
NICK_LISTLINKS_SYNTAX2
	LISTLINKS
NICK_LISTLINKS_HEADER
	Liste der Nicks die zu %s gelinkt sind:
NICK_LISTLINKS_FOOTER
	%d gelinkte Nick.

# INFO responses
NICK_INFO_SYNTAX
	INFO nick
NICK_INFO_REALNAME
	%s ist %s
NICK_INFO_ADDRESS
	   Letzte gesehene Adresse: %s
NICK_INFO_TIME_REGGED
	          Zeit registriert: %s [%s]
NICK_INFO_LAST_IDENTIFY
	Letzte Identifikationszeit: %s [%s]
NICK_INFO_LAST_SEEN
	      Letzte Zeit anwesend: %s [%s]
NICK_INFO_ONLINE
	  Gesamte Anwesenheitszeit: %s
NICK_INFO_LAST_QUIT
	     Letzte quit Nachricht: %s
NICK_INFO_URL
	                       URL: %s
NICK_INFO_EMAIL
	             Email Adresse: %s
NICK_INFO_ICQ
	                ICQ Nummer: #%s
NICK_INFO_LOCATION
	                  Standort: %s
NICK_INFO_OPTIONS
	             Einstellungen: %s
NICK_INFO_NO_EXPIRE
	Dieser Nick wird nicht ablaufen.
NICK_INFO_OSUSPENDED
	             Oper Sperrung: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Kill Schutz
NICK_INFO_OPT_PRIVATE
	Privat
NICK_INFO_OPT_NONE
	Keine

# LIST responses
NICK_LIST_SYNTAX
	LIST pattern
NICK_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE]
NICK_LIST_HEADER
	Liste der Eintrge die auf %s passen:
NICK_LIST_RESULTS
	Ende der Liste - %d/%d Treffer angezeigt.

NICK_RELEASED
	der Service, der Deinen Nick hlt wurde freigegeben.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nickname [password]
NICK_NO_GHOST_SELF
	Du kannst Dich nicht selbst ghosten.
NICK_GHOST_KILLED
	Ghost mit Deinem Nick ist gekillt.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nickname
NICK_GETPASS_UNAVAILABLE
	GETPASS Befehl nicht verfgbar, weil Verschlsselung
	aktiviert ist.
NICK_GETPASS_PASSWORD_IS
	Passwort fr %s ist %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nickname
NICK_FORBID_SUCCEEDED
	Nick %s ist nun verboten.
NICK_FORBID_FAILED
	Ich kann den Nick %s nicht verbieten!

#################################################################
#
# ChanServ messages
#
#################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Automatischer Kanal Op Status
CHAN_LEVEL_AUTOVOICE
	Automatischer Mode +v
CHAN_LEVEL_AUTODEOP
	Kanal Op Status verboten
CHAN_LEVEL_NOJOIN
	Es ist verboten den Kanal zu betreten, wenn RESTRICTED
	gesetzt ist.
CHAN_LEVEL_INVITE
	Der INVITE Befehl ist erlaubt
CHAN_LEVEL_AKICK
	Der AKICK Befehl ist erlaubt
CHAN_LEVEL_SET
	Der SET Befehl ist erlaubt (nicht FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Der CLEAR Befehl ist erlaubt
CHAN_LEVEL_UNBAN
	Der UNBAN Befehl ist erlaubt
CHAN_LEVEL_OPDEOP
	Die OP/DEOP Befehle sind erlaubt
CHAN_LEVEL_ACCESS_LIST
	Das Anschauen der Zugangs-Liste ist erlaubt
CHAN_LEVEL_ACCESS_CHANGE
	Das ndern der Zugangs-Liste ist erlaubt
CHAN_LEVEL_MEMO_READ
	Listen/Lesen der Kanal-Memos ist erlaubt
CHAN_LEVEL_MEMO_SEND
	Senden von Kanal-Memos ist erlaubt
CHAN_LEVEL_MEMO_DEL
	Lschen von Kanal-Memos ist erlaubt
CHAN_LEVEL_KICK
	Der KICK Befehl ist erlaubt

# Automatic responses
CHAN_IS_REGISTERED
	Dieser Kanal wurde mit %s registriert.
CHAN_NOT_ALLOWED_OP
	Du darfst keinen Op Status auf Kanal %s haben.
CHAN_MAY_NOT_BE_USED
	Dieser Kanal darf nicht benutzt werden.
CHAN_NOT_ALLOWED_TO_JOIN
	Du hast nicht Recht auf diesem Kanal zu sein.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER channel password description
CHAN_REGISTER_DISABLED
	Sorry, Kanal Registrierung ist derzeit abgeschaltet.
CHAN_REGISTER_NOT_LOCAL
	Lokale Kanle knnen nicht registriert werden.
CHAN_MUST_REGISTER_NICK
	Du mut erst Deinen Nick registrieren. Tippe
	/msg %s HELP fr Informationen zum
	Nick registrieren.
CHAN_MUST_IDENTIFY_NICK
	Identifiziere Dich zuerst mit dem Befehl
	/msg %s IDENTIFY password
CHAN_MAY_NOT_BE_REGISTERED
	Kanal %s darf nicht registriert werden.
CHAN_ALREADY_REGISTERED
	Kanal %s ist bereits registriert!
CHAN_MUST_BE_CHANOP
	Du mut Kanal Op sein, um den Kanal zu registrieren.
CHAN_REACHED_CHANNEL_LIMIT
	Sorry, Du hast bereits die Obergrenze von
	%d Kanlen erreicht.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Sorry, Du hast bereits die Obergrenze von
	%d Kanlen berschritten.
CHAN_REGISTRATION_FAILED
	Sorry, Registrierung gescheitert.
CHAN_REGISTERED
	Kanal %s unter Deinem Nick
	registriert: %s
CHAN_PASSWORD_IS
	Dein Kanal Passwort ist %s -
	Bitte merk Dir dieses Passwort.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY channel password
CHAN_IDENTIFY_FAILED
	Sorry, Identifizierung gescheitert.
CHAN_IDENTIFY_SUCCEEDED
	Passwort akzeptiert - Du hast nun Founder Zugang zu
	%s.,

# DROP responses
CHAN_DROP_SYNTAX
	DROP channel
CHAN_DROP_DISABLED
	Sorry, Kanal lschen ist derzeit abgeschaltet.
CHAN_DROPPED
	Kanal %s ist nun gelscht.

# SET responses
CHAN_SET_SYNTAX
	SET channel option parameters
CHAN_SET_DISABLED
	Sorry, Kanal Einstellung ndern ist derzeit abgeschaltet.
CHAN_SET_UNKNOWN_OPTION
	Unbekannte SET Einstellung %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s hat zu viele Kanle registriert.
CHAN_FOUNDER_CHANGED
	Founder von %s ist nun %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Nachfolger fr %s ist nun %s.
CHAN_SUCCESSOR_UNSET
	Nachfolger fr %s gelscht.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Sorry, kann Passwort nicht setzen.
CHAN_PASSWORD_CHANGED
	%s Passwort gendert.
CHAN_PASSWORD_CHANGED_TO
	%s Passwort gendert auf %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Beschreibung von %s gendert auf %s.

# SET URL responses
CHAN_URL_CHANGED
	URL fr %s gendert auf %s.
CHAN_URL_UNSET
	URL fr %s gelscht.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	Email Adresse fr %s ist nun %s.
CHAN_EMAIL_UNSET
	Email Adresse fr %s gelscht.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Eingangs Nachricht fr %s gendert.
CHAN_ENTRY_MSG_UNSET
	Eingangs Nachricht fr %s gelscht.

# SET TOPIC responses
CHAN_SET_TOPIC_FAILED
	Sorry, kann Topic nicht setzen.

# SET MLOCK responses
CHAN_SET_MLOCK_KEY_REQUIRED
	Parameter bentigt fr MLOCK +k.
CHAN_SET_MLOCK_LIMIT_REQUIRED
	Parameter bentigt fr MLOCK +l.
CHAN_SET_MLOCK_LIMIT_POSITIVE
	Parameter fr MLOCK +l mu eine positive Nummer sein.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Unbekanntes Mode Zeichen %c ignoriert.
CHAN_MLOCK_CHANGED
	Mode Sperre auf Kanal %s auf
	%s gendert.
CHAN_MLOCK_REMOVED
	Mode Sperre auf Kanal %s gelscht.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET channel KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Topic Beibehaltung Einstellung ist nun ON.
CHAN_SET_KEEPTOPIC_OFF
	Topic Beibehaltung Einstellung ist nun OFF.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET channel TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Topic Sperre Einstellung ist nun ON.
CHAN_SET_TOPICLOCK_OFF
	Topic Sperre Einstellung ist nun OFF.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET channel PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Privat Einstellung ist nun ON.
CHAN_SET_PRIVATE_OFF
	Privat Einstellung ist nun OFF.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET channel SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Sichere Ops Einstellung ist nun ON.
CHAN_SET_SECUREOPS_OFF
	Sichere Ops Einstellung ist nun OFF.

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET channel LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	Belasse Ops Einstellung ist nun ON.
CHAN_SET_LEAVEOPS_OFF
	Belasse Ops Einstellung ist nun OFF.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET channel RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Eingeschrnkter Zugang Einstellung ist nun ON.
CHAN_SET_RESTRICTED_OFF
	Eingeschrnkter Zugang Einstellung ist nun OFF.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET channel OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Op-Notiz Einstellung ist nun ON.
CHAN_SET_OPNOTICE_OFF
	Op-Notiz Einstellung ist nun OFF.

# SET OPNOTICE responses
CHAN_SET_NOLINKS_SYNTAX
	SET channel NOLINKS {ON | OFF}
CHAN_SET_NOLINKS_ON
	NOLINKS Einstellung ist nun ON.
CHAN_SET_NOLINKS_OFF
	NOLINKS Einstellung ist nun OFF.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET channel NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Kanal %s wird nicht auslaufen.
CHAN_SET_NOEXPIRE_OFF
	Kanal %s wird auslaufen.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS channel {ADD|DEL|LIST} [nick [level] | entry-list]
CHAN_ACCESS_DISABLED
	Sorry, nderung der Kanal-Zugangs-Liste ist
	derzeit abgeschaltet.
CHAN_ACCESS_LEVEL_NONZERO
	Zugangs-Stufe mu nicht-Null sein.
CHAN_ACCESS_LEVEL_RANGE
	Zugangs-Stufe mu zwischen %d und %d
	inklusive sein.
CHAN_ACCESS_NICKS_ONLY
	Kanal-Zugangs-Liste darf nur registrierte
	Nicks enthalten.
CHAN_ACCESS_REACHED_LIMIT
	Sorry, Du kannst hchstens %d Zugangs-Eintrge fr
	einen Kanal haben.
CHAN_ACCESS_LEVEL_UNCHANGED
	Zugangs-Stufe fr %s auf %s nicht
	gendert von %d.
CHAN_ACCESS_LEVEL_CHANGED
	Zugangs-Stufe fr %s auf %s wurde von %d
	auf %d gendert.
CHAN_ACCESS_ADDED
	%s hinzugefgt zur %s Zugangs-Liste
	auf Stufe %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Keine Eintrag (#%d) auf %s Zugangs-Liste.
CHAN_ACCESS_NOT_FOUND
	%s wurde nicht auf der %s
	Zugangs-Liste gefunden.
CHAN_ACCESS_NO_MATCH
	Keine passenden Eintrge auf der %s Zugangs-Liste.
CHAN_ACCESS_DELETED
	%s von der %s Zugangs-Liste gelscht.
CHAN_ACCESS_DELETED_ONE
	Ein Eintrag von der %s Zugangs-Liste gelscht.
CHAN_ACCESS_DELETED_SEVERAL
	%d Eintrge von der %s Zugangs-Liste gelscht.
CHAN_ACCESS_LIST_EMPTY
	%s Zugangs-Liste ist leer.
CHAN_ACCESS_LIST_HEADER
	Zugangs-Liste fr %s:
	  Num  Stuf  Nick
CHAN_ACCESS_LIST_FORMAT
	  %3d  %4d  %s%s%s%s

# AOP/SOP error response
CHAN_NO_AOP_SOP
	Benutze den ACCESS Befehl um Kanal-Privilegien
	zuzuweisen; Tippe /msg %s HELP ACCESS fr
	weitere Informationen.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK channel {ADD | DEL | LIST} [nick-or-usermask]
CHAN_AKICK_DISABLED
	Sorry, nderungen der Kanal-Auto-KICK-Liste sind
	derzeit abgeschaltet.
CHAN_AKICK_ALREADY_EXISTS
	%s ist bereits auf der
	%s Auto-Kick-Liste.
CHAN_AKICK_REACHED_LIMIT
	Sorry, Du kannst hchstens %d Auto-Kick Masken auf
	einem Kanal haben.
CHAN_AKICK_ADDED
	%s wurde der Auto-Kick-Liste hinzugefgt.
CHAN_AKICK_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) auf der
	%s Auto-Kick-Liste.
CHAN_AKICK_NOT_FOUND
	%s wurde auf der %s Auto-Kick-Liste
	nicht gefunden.
CHAN_AKICK_NO_MATCH
	Keine passenden Eintrge auf der
	%s Auto-Kick-Liste.
CHAN_AKICK_DELETED
	%s wurde von der %s
	Auto-Kick-Liste gelscht.
CHAN_AKICK_DELETED_ONE
	Ein Eintrag von der %s Auto-Kick-Liste gelscht.
CHAN_AKICK_DELETED_SEVERAL
	%d Eintrge von der %s
	Auto-Kick-Liste gelscht.
CHAN_AKICK_LIST_EMPTY
	%s Auto-Kick-Liste ist leer.
CHAN_AKICK_LIST_HEADER
	Auto-Kick-Liste fr %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s%s
CHAN_AKICK_LIST_FORMAT2
	  %3d %s von %s : %s

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS channel {SET | DIS[ABLE] | LIST | RESET} [item [level]]
CHAN_LEVELS_RANGE
	Stufe mu zwischen %d und %d inklusive sein.
CHAN_LEVELS_CHANGED
	Stufe fr %s auf Kanal %s gendert
	auf %d.
CHAN_LEVELS_UNKNOWN
	Einstellung %s unbekannt.  Tippe
	/msg %s HELP LEVELS DESC fr eine Liste von
	korrekten Einstellungen.
CHAN_LEVELS_DISABLED
	%s abgeschaltet auf Kanal %s.
CHAN_LEVELS_LIST_HEADER
	Zugang-Stufen-Einstellung fr Kanal %s:
CHAN_LEVELS_LIST_DISABLED
	 %-*s  (abgeschaltet)
CHAN_LEVELS_LIST_FOUNDER
	 %-*s  (nur founder)
CHAN_LEVELS_LIST_NORMAL
	 %-*s  %d
CHAN_LEVELS_RESET
	Zugangs-Stufen fr %s auf die
	Voreinstellung zurckgesetzt.

# INFO responses
CHAN_INFO_SYNTAX
	INFO channel
CHAN_INFO_HEADER
	Information fr Kanal %s:
CHAN_INFO_FOUNDER
	          Founder: %s (%s)
CHAN_INFO_NO_FOUNDER
	          Founder: %s
CHAN_INFO_DESCRIPTION
	     Beschreibung: %s
CHAN_INFO_TIME_REGGED
	      Registriert: %s [%s]
CHAN_INFO_LAST_USED
	   Letzte Nutzung: %s [%s]
CHAN_INFO_LAST_TOPIC
	    Letztes Topic: %s
CHAN_INFO_TOPIC_SET_BY
	Topic gesetzt von: %s
CHAN_INFO_RECORD
	  Benutzer Rekord: %d user(s) am %s [%s]
CHAN_INFO_USERS
	         Besitzer: %d user(s)
CHAN_INFO_URL
	              URL: %s
CHAN_INFO_EMAIL
	    Email Adresse: %s
CHAN_INFO_OPTIONS
	    Einstellungen: %s
CHAN_INFO_NO_EXPIRE
	    Ablaufen: Nie
CHAN_INFO_OPT_PRIVATE
	Privat
CHAN_INFO_OPT_KEEPTOPIC
	Topic Beibehaltung
CHAN_INFO_OPT_TOPICLOCK
	Topic Sperre
CHAN_INFO_OPT_SECUREOPS
	Sichere Ops
CHAN_INFO_OPT_LEAVEOPS
	Belasse Ops
CHAN_INFO_OPT_RESTRICTED
	Eingeschrnkter Zugang
CHAN_INFO_OPT_NOLINKS
	Ignoriere Nick Links
CHAN_INFO_OPT_NONE
	Keine
CHAN_INFO_MODE_LOCK
	     Modus Sperre: %s

# LIST responses
CHAN_LIST_SYNTAX
	LIST pattern
CHAN_LIST_HEADER
	Liste der Eintrge die auf %s passen:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Ende der Liste - %d/%d Treffer angezeigt.

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE channel

# OP responses
CHAN_OP_SYNTAX
	OP channel nick

# DEOP responses
CHAN_DEOP_SYNTAX
	DEOP channel nick

# KICK responses
CHAN_KICK_SYNTAX
	KICK channel nick reason

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN channel
CHAN_UNBANNED
	Du bist nicht mehr von %s gebannt.

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR channel what
CHAN_CLEARED_BANS
	Alle Bans auf Kanal %s sind gelscht.
CHAN_CLEARED_MODES
	Alle Modi auf Kanal %s sind zurckgesetzt.
CHAN_CLEARED_OPS
	Modus +o wurde auf Kanal %s gelscht.
CHAN_CLEARED_VOICES
	Modus +v wurde auf Kanal %s gelscht.
CHAN_CLEARED_USERS
	Alle Benutzer sind aus dem Kanal %s
	gekickt worden.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS channel
CHAN_GETPASS_UNAVAILABLE
	GETPASS Befehl ist nicht verfgbar, weil Verschlsselung
	aktiviert ist.
CHAN_GETPASS_PASSWORD_IS
	Passwort fr Kanal %s ist %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID channel
CHAN_FORBID_SUCCEEDED
	Kanal %s ist nun verboten.
CHAN_FORBID_FAILED
	Kann Kanal %s nicht verbieten!

#################################################################
#
# MemoServ messages
#
#################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Du hast ein neues Memo.
MEMO_HAVE_NEW_MEMOS
	Du hast %d neue Memos.
MEMO_TYPE_READ_LAST
	Tippe /msg %s READ LAST um sie zu lesen.
MEMO_TYPE_READ_NUM
	Tippe /msg %s READ %d um sie zu lesen.
MEMO_TYPE_LIST_NEW
	Tippe /msg %s LIST NEW fr eine Liste.
MEMO_AT_LIMIT
	Warnung: Du hast die maximale Anzahl von Memos
	bekommen (%d). Du kannst keine neuen Memos erhalten,
	bis Du einige Alte gelscht hast.
MEMO_OVER_LIMIT
	Warnung: Du hast mehr als die maximale Anzahl von
	Memos bekommen (%d). Du kannst keine neuen Memos
	erhalten, bis Du einige Alte gelscht hast.
MEMO_NEW_MEMO_ARRIVED
	Du hast ein neues Memo von %s.
	Tippe /msg %s READ %d um sie zu lesen.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Du hast keine Memos.
MEMO_X_HAS_NO_MEMOS
	%s hat keine Memos.
MEMO_DOES_NOT_EXIST
	Memo %d existiert nicht.
MEMO_LIST_NOT_FOUND
	Keine passenden Memos gefunden.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | channel} memo-text
MEMO_SEND_DISABLED
	Sorry, Memo verschicken ist derzeit abgeschaltet.
MEMO_SEND_PLEASE_WAIT
	Bitte warte %d Sekunden bevor Du den SEND Befehl
	nochmals benutzt.
MEMO_X_GETS_NO_MEMOS
	%s kann keine Memos empfangen.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s hat derzeit zu viele Memos und kann keine
	weiteren empfangen.
MEMO_SENT
	Memo an %s geschickt.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [channel] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Du hast keine neuen Memos.
MEMO_X_HAS_NO_NEW_MEMOS
	%s hat keine neuen Memos.
MEMO_LIST_MEMOS
	Memos fr %s.  Um zu lesen tippe:
	/msg %s READ num
MEMO_LIST_NEW_MEMOS
	Neue Memos fr %s.  Um zu lesen tippe:
	/msg %s READ num
MEMO_LIST_CHAN_MEMOS
	Memos fr %s.  Um zu lesen tippe:
	/msg %s READ %s num
MEMO_LIST_CHAN_NEW_MEMOS
	Neue Memos fr %s.  Um zu lesen tippe:
	/msg %s READ num
MEMO_LIST_HEADER
	 Num  Sender            Datum/Zeit
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s "%s..."

# READ responses
MEMO_READ_SYNTAX
	READ [channel] {list | LAST | NEW}
MEMO_HEADER
	Memo %d von %s (%s).  Um zu lschen
	tippe: /msg %s DEL %d
MEMO_CHAN_HEADER
	Memo %d von %s (%s).  Um zu lschen
	tippe: /msg %s DEL %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [channel] {num | list | ALL}
MEMO_DELETED_NONE
	Es wurden keine Memos gelscht.
MEMO_DELETED_ONE
	Memo %d wurde gelscht.
MEMO_DELETED_SEVERAL
	Memos %s wurde gelscht.
MEMO_DELETED_ALL
	Es wurden alle Deine Memos gelscht.

# SET responses
MEMO_SET_SYNTAX
	SET option parameters
MEMO_SET_DISABLED
	Sorry, Memo Einstellung ist derzeit abgeschaltet.
MEMO_SET_UNKNOWN_OPTION
	Unbekannte SET Einstellung %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s wird Dich nun ber Memos benachrichtigen,
	wenn Du Dich anmeldest, und wenn Du Neue erhltst.
MEMO_SET_NOTIFY_LOGON
	%s wird Dich nun ber Memos benachrichtigen,
	wenn Du Dich anmeldest, und /AWAY abschaltest.
MEMO_SET_NOTIFY_NEW
	%s wird Dich nun ber Memos benachrichtigen,
	wenn Du  Neue erhltst.
MEMO_SET_NOTIFY_OFF
	%s wird Dich nicht wegen Memos benachrichtigen.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [channel] limit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [user | channel] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Du hast nicht das Recht Deine Memo-Obergrenze zu ndern.
MEMO_SET_LIMIT_FORBIDDEN
	Die Memo-Obergrenze fr %s darf nicht
	gendert werden.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Du kannst Deine Memo-Obergrenze nicht hher
	als %d setzen.
MEMO_SET_LIMIT_TOO_HIGH
	Du kannst die Memo-Obergrenze fr %s nicht hher
	als %d setzen.
MEMO_SET_LIMIT_OVERFLOW
	Memo-Obergrenze zu gro; zurckgesetzt auf %d.
MEMO_SET_YOUR_LIMIT
	Deine Memo-Obergrenze wurde auf %d gesetzt.
MEMO_SET_YOUR_LIMIT_ZERO
	Du kannst keine Memos mehr empfangen.
MEMO_UNSET_YOUR_LIMIT
	Deine Memo-Obergrenze wurde abgeschaltet.
MEMO_SET_LIMIT
	Memo-Obergrenze fr %s auf %d gesetzt.
MEMO_SET_LIMIT_ZERO
	Memo-Obergrenze fr %s auf 0 gesetzt.
MEMO_UNSET_LIMIT
	Memo-Obergrenze fr %s abgeschaltet.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [channel]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | channel]
MEMO_INFO_NO_MEMOS
	Du hast derzeit keine Memos.
MEMO_INFO_MEMO
	Du hast derzeit 1 Memo.
MEMO_INFO_MEMO_UNREAD
	Du hast derzeit 1 ungelesenes Memo.
MEMO_INFO_MEMOS
	Du hast derzeit %d Memos.
MEMO_INFO_MEMOS_ONE_UNREAD
	Du hast derzeit %d Memos, davon 1 Ungelesenes.
MEMO_INFO_MEMOS_SOME_UNREAD
	Du hast derzeit %d Memos, davon
	%d Ungelesene.
MEMO_INFO_MEMOS_ALL_UNREAD
	Du hast derzeit %d ungelesene Memos.
MEMO_INFO_LIMIT
	Deine Memo-Obergrenze ist %d.
MEMO_INFO_HARD_LIMIT
	Deine Memo-Obergrenze ist %d und kann nicht
	gendert werden.
MEMO_INFO_LIMIT_ZERO
	Deine Memo-Obergrenze ist 0; Du kannst keine neuen
	Memos empfangen.
MEMO_INFO_HARD_LIMIT_ZERO
	Deine Memo-Obergrenze ist 0; Du kannst keine neuen
	Memos empfangen. Du kannst diese Grenze nicht ndern.
MEMO_INFO_NO_LIMIT
	Du hast keine Memo-Obergrenze.
MEMO_INFO_X_NO_MEMOS
	%s hat derzeit keine Memos.
MEMO_INFO_X_MEMO
	%s hat derzeit 1 Memo.
MEMO_INFO_X_MEMO_UNREAD
	%s hat derzeit 1 ungelesenes Memo.
MEMO_INFO_X_MEMOS
	%s hat derzeit %d Memos.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s hat derzeit %d Memos, davon
	1 Ungelesenes.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s hat derzeit %d Memos, davon
	%d Ungelesene.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s hat derzeit %d ungelesene Memos.
MEMO_INFO_X_LIMIT
	%s Memo-Obergrenze ist %d.
MEMO_INFO_X_HARD_LIMIT
	%s Memo-Obergrenze ist %d.
MEMO_INFO_X_NO_LIMIT
	%s hat keine Memo-Obergrenze.

#################################################################
#
# OperServ messages
#
#################################################################

# General messages
OPER_BOUNCY_MODES
	Services knnen keine Modes ndern. Sind Deine Server
	richtig konfiguriert?
OPER_BOUNCY_MODES_U_LINE
	Services knnen keine Modes ndern.  Ist die U:line
	Deines Servers richtig konfiguriert?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL message

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Unbekannte STATS Einstellung%s.
OPER_STATS_CURRENT_USERS
	Aktuelle Benutzer: %d (%d Ops, %d Helfer, %d bots)
OPER_STATS_MAX_USERS
	Maximale Benutzer: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal
# preference is to only give resolution to the nearest minute
# when uptime is one hour or more, but just add a %d to get
# seconds as well.
OPER_STATS_UPTIME_DHMS
	Services seit %d Tagen, %02d:%02d aktiv
OPER_STATS_UPTIME_1DHMS
	Services seit %d Tag, %02d:%02d aktiv
OPER_STATS_UPTIME_HMS
	Services seit %d Stunden, %d Minuten aktiv
OPER_STATS_UPTIME_HM1S
	Services seit %d Stunden, %d Minuten aktiv
OPER_STATS_UPTIME_H1MS
	Services seit %d Stunden, %d Minute aktiv
OPER_STATS_UPTIME_H1M1S
	Services seit %d Stunden, %d Minute aktiv
OPER_STATS_UPTIME_1HMS
	Services seit %d Stunde, %d Minuten aktiv
OPER_STATS_UPTIME_1HM1S
	Services seit %d Stunde, %d Minuten aktiv
OPER_STATS_UPTIME_1H1MS
	Services seit %d Stunde, %d Minute aktiv
OPER_STATS_UPTIME_1H1M1S
	Services seit %d Stunde, %d Minute aktiv
OPER_STATS_UPTIME_MS
	Services seit %d Minuten, %d Sekunden aktiv
OPER_STATS_UPTIME_M1S
	Services seit %d Minuten, %d Sekunde aktiv
OPER_STATS_UPTIME_1MS
	Services seit %d Minute, %d Sekunden aktiv
OPER_STATS_UPTIME_1M1S
	Services seit %d Minute, %d Sekunde aktiv
OPER_STATS_USER_MEM
	Benutzer: %6d Rekord, %5d kB
OPER_STATS_CHANNEL_MEM
	Kanal   : %6d Rekord, %5d kB
OPER_STATS_NICKSERV_MEM
	NickServ: %6d Rekord, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ: %6d Rekord, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ: %6d Rekord, %5d kB
OPER_STATS_AKILL_COUNT
	 Aktuelle Zahl der AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Normale AKILL Ablauf Zeit: %d Tage
OPER_STATS_AKILL_EXPIRE_DAY
	Normale AKILL Ablauf Zeit: 1 Tag
OPER_STATS_AKILL_EXPIRE_HOURS
	Normale AKILL Ablauf Zeit: %d Stunden
OPER_STATS_AKILL_EXPIRE_HOUR
	Normale AKILL Ablauf Zeit: 1 Stunde
OPER_STATS_AKILL_EXPIRE_MINS
	Normale AKILL Ablauf Zeit: %d Minuten
OPER_STATS_AKILL_EXPIRE_MIN
	Normale AKILL Ablauf Zeit: 1 Minute
OPER_STATS_AKILL_EXPIRE_NONE
	Normale AKILL Ablauf Zeit: kein Ablauf

# MODE responses
OPER_MODE_SYNTAX
	MODE channel modes

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES channel [ALL]
OPER_CLEARMODES_DONE
	Binr Modes und Bans vom Kanal %s gelscht.
OPER_CLEARMODES_ALL_DONE
	Alle Modi vom Kanal %s gelscht.

# KICK responses
OPER_KICK_SYNTAX
	KICK channel user reason

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [nick]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD nick
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL nick
OPER_ADMIN_SKELETON
	Services sind im Skeleton Modus; der ADMIN Befehl ist
	nicht verfgbar.
OPER_ADMIN_EXISTS
	%s existiert bereits auf der
	Service Admin Liste.
OPER_ADMIN_ADDED
	%s wurde der Services Admin Liste hinzugefgt.
OPER_ADMIN_TOO_MANY
	Zu viele Eintrge (%d) auf der Service Admin Liste;
	kann keine weiteren hinzufgen.
OPER_ADMIN_REMOVED
	%s von der Service Admin Liste gelscht.
OPER_ADMIN_NOT_FOUND
	%s nicht auf der Service Admin Liste gefunden.
OPER_ADMIN_LIST_HEADER
	Service Admin Liste:

# OPER responses
OPER_OPER_SYNTAX
	OPER { {ADD | DEL | LIST} [nick] | SUSPEND nick Tage }
OPER_OPER_ADD_SYNTAX
	OPER ADD nick
OPER_OPER_DEL_SYNTAX
	OPER DEL nick
OPER_OPER_SKELETON
	Services sind im Skeleton Modus; der OPER Befehl ist
	nicht verfgbar.
OPER_OPER_EXISTS
	%s existiert bereits auf der
	Service Oper Liste.
OPER_OPER_ADDED
	%s wurde der Services Oper Liste hinzugefgt.
OPER_OPER_TOO_MANY
	Zu viele Eintrge (%d) auf der Service Oper Liste;
	kann keine weiteren hinzufgen.
OPER_OPER_REMOVED
	%s von der Service Oper Liste gelscht.
OPER_OPER_NOT_FOUND
	%s nicht auf der Service Oper Liste gefunden.
OPER_OPER_LIST_HEADER
	Service Oper Liste:

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW} [[+expiry] mask [reason]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+expiry] mask reason
OPER_AKILL_DEL_SYNTAX
	AKILL DEL mask
OPER_TOO_MANY_AKILLS
	AKILL Liste ist voll!
OPER_AKILL_NO_NICK
	Erinnerung: AKILL Masken knnen keine Nicks
	enthalten; Stelle sicher, das Du nicht Teile eines
	Nicks in einer Maske verwendest.
OPER_AKILL_ADDED
	%s wurde der AKILL Liste hinzugefgt.
OPER_AKILL_REMOVED
	%s von der AKILL Liste gelscht.
OPER_AKILL_NOT_FOUND
	%s nicht auf der AKILL Liste gefunden.
OPER_AKILL_LIST_HEADER
	Aktuelle AKILL Liste:
# mask, reason
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%s (von %s auf %s; %s)
	    %s
OPER_AKILL_NO_EXPIRE
	luft nicht ab.
OPER_AKILL_EXPIRES_SOON
	luft bei der nchsten Datenbank-Aktualisierung ab
OPER_AKILL_EXPIRES_M
	luft in %d Minuten ab
OPER_AKILL_EXPIRES_1M
	luft in %d Minute ab
OPER_AKILL_EXPIRES_HM
	luft in %d Stunden, %d Minuten ab
OPER_AKILL_EXPIRES_H1M
	luft in %d Stunden, %d Minute ab
OPER_AKILL_EXPIRES_1HM
	luft in %d Stunde, %d Minuten ab
OPER_AKILL_EXPIRES_1H1M
	luft in %d Stunde, %d Minute ab
OPER_AKILL_EXPIRES_D
	luft in %d Stunden ab
OPER_AKILL_EXPIRES_1D
	luft in %d Stunde ab

# SET responses
OPER_SET_SYNTAX
	SET option setting
OPER_SET_IGNORE_ON
	Ignore Code wird benutzt.
OPER_SET_IGNORE_OFF
	Ignore Code wird nicht benutzt.
OPER_SET_IGNORE_ERROR
	Einstellung von IGNORE mu ON oder OFF sein.
OPER_SET_READONLY_ON
	Services sind nun im read-only Modus.
OPER_SET_READONLY_OFF
	Services sind nun im read-write Modus.
OPER_SET_READONLY_ERROR
	Einstellung von READ-ONLY mu ON oder OFF sein.
OPER_SET_DEBUG_ON
	Services sind nun im debug Modus.
OPER_SET_DEBUG_OFF
	Services sind nun im non-debug Modus.
OPER_SET_DEBUG_LEVEL
	Services sind nun im debug Modus (Stufe %d).
OPER_SET_DEBUG_ERROR
	Einstellung von DEBUG muss ON, OFF oder eine
	positive Zahl sein.
OPER_SET_UNKNOWN_OPTION
	Unbekannte Einstellung %s.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE servername [reason]

# RAW responses
OPER_RAW_SYNTAX
	RAW text

# UPDATE responses
OPER_UPDATING
	Aktualisiere Datenbanken.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN nicht definiert; kein Neustart mglich.
	Starte das 'configure' Skript nochmals und compiliere
	die Services erneut um den RESTART Befehl zu aktivieren.

# LISTIGNORE responses
OPER_IGNORE_LIST
	Services Ignore Liste:
OPER_IGNORE_LIST_EMPTY
	Ignore liste ist leer.

#################################################################
#
# News System messages
#
#################################################################

NEWS_LOGON_TEXT
	[Logon News - %s] %s
NEWS_OPER_TEXT
	[Oper News - %s] %s
NEWS_LOGON_SYNTAX
	Syntax: LOGONNEWS {ADD|DEL|LIST} [text|num]
NEWS_LOGON_LIST_HEADER
	Logon News Artikel:
NEWS_LOGON_LIST_ENTRY
	%5d (%s von %s)
	    %s
NEWS_LOGON_LIST_NONE
	Es gibt keine Logon News.
NEWS_LOGON_ADD_SYNTAX
	Syntax: LOGONNEWS ADD text
NEWS_LOGON_ADD_FULL
	News Liste ist voll!
NEWS_LOGON_ADDED
	Neuer Logon News Artikel hinzugefgt (#%d).
NEWS_LOGON_DEL_SYNTAX
	Syntax: LOGONNEWS DEL {num | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Logon News Artikel #%d nicht gefunden!
NEWS_LOGON_DELETED
	Logon News Artikel #%d gelscht.
NEWS_LOGON_DEL_NONE
	Keine Logon News Artikel zum Lschen!
NEWS_LOGON_DELETED_ALL
	Alles Logon News Artikel gelscht.
NEWS_OPER_SYNTAX
	Syntax: OPERNEWS {ADD|DEL|LIST} [text|num]
NEWS_OPER_LIST_HEADER
	Oper News Artikel:
NEWS_OPER_LIST_ENTRY
	%5d (%s von %s)
	    %s
NEWS_OPER_LIST_NONE
	Keine Oper News.
NEWS_OPER_ADD_SYNTAX
	Syntax: OPERNEWS ADD text
NEWS_OPER_ADD_FULL
	News Liste ist voll!
NEWS_OPER_ADDED
	Neuer Oper News Artikel hinzugefgt (#%d).
NEWS_OPER_DEL_SYNTAX
	Syntax: OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper News Artikel #%d nicht gefunden!
NEWS_OPER_DELETED
	Oper News Artikel #%d gelscht.
NEWS_OPER_DEL_NONE
	Keine Oper News Artikel zum Lschen!
NEWS_OPER_DELETED_ALL
	Alle Oper News Artikel gelscht.
NEWS_HELP_LOGON
	Syntax: LOGONNEWS ADD text
	        LOGONNEWS DEL {num | ALL}
	        LOGONNEWS LIST
	
	Bearbeitet oder zeigt die Liste der Logon News
	Nachrichten. Wenn sich ein Benutzer anmeldet, werden ihm
	diese Nachrichten geschickt.  (Wie auch immer, es werden
	nicht mehr als drei Nachrichten verschickt um den
	Benutzer nicht zu flooden. Wenn mehr als drei Nachrichten
	vorliegen, werden nur die drei Neuesten geschickt.)
	
	LOGONNEWS LIST kann von einem IRC Operator benutzt
	werden, um die derzeitigen Nachrichten anzuzeigen.  ADD
	und DEL knnen nur von Service Admins benutzt werden.

NEWS_HELP_OPER
	Syntax: OPERNEWS ADD text
	        OPERNEWS DEL {num | ALL}
	        OPERNEWS LIST
	
	Bearbeitet oder zeigt die Liste der Oper News
	Nachrichten. Wenn sich ein Oper anmeldet (mit dem /oper
	Befehl), werden ihm diese Nachrichten geschickt.  (Wie
	auch immer, es werden nicht mehr als drei Nachrichten
	verschickt um den Benutzer nicht zu flooden. Wenn mehr
	als drei Nachrichten vorliegen, werden nur die drei
	Neuesten geschickt.)
	
	OPERNEWS LIST kann von jedem IRC Operator benutzt werden,
	um die derzeitigen Oper Nachrichten anzuzeigen.  ADD und
	DEL knnen nur von Service Admins benutzt werden.

#################################################################
#
# NickServ help messages
#
#################################################################

NICK_HELP
	%S erlaubt es, einen Nick zu registrieren, und
	andere davon abzuhalten Diesen zu benutzen.  Wenn ein
	Nick %d Tage nicht benutzt wird, luft die
	Registrierung ab.  Die folgenden Befehle ermglichen die
	Registrierung und Pflege von Nicks; um Sie zu benutzen
	tippe /msg %S command. Weitere Hilfe fr
	einen bestimmten Befehl erhltst Du mit
	/msg %S HELP command.
	
	 AJOIN      ndere Deine Auto-Join Kanal-Liste
	 REGISTER   Registriere einen Nick
	 IDENTIFY   Identifiziere Dich selbst mit Deinem Passwort
	 LINK       Linke Deinen Nick zu einen Anderen
	 SET        Setze Einstellungen
	 DROP       Lsche die Registrierung eines Nicks
	 LISTLINKS  Liste die Nicks, die mit Deinem Nick
	            gelinkt sind.
	 NOTES      Erlaubt Dir Text Nachrichten zu speichern.
	 GHOST	    Killt eine ghost Verbindung fuer den Nick

	Andere Befehle: UNLINK, INFO, LIST, STATUS
	
	Achtung: Dieser Service bietet einen Mglichkeit
	sicherzustellen, da die Identitt eines Benutzers nicht
	kompromittiert ist.  Er ist NICHT dafr gedacht, das
	"Stehlen" von Nicks und andere heimtckische Aktionen zu
	frdern.  Der Mibrauch des %S wird mindestens
	mit dem Verlust der mibrauchten Nick(s) geahndet.

NICK_HELP_EXPIRE_ZERO
	%S erlaubt es, einen Nick zu registrieren, und
	andere davon abzuhalten Diesen zu benutzen.  Die
	folgenden Befehle ermglichen die Registrierung und
	Pflege von Nicks; um Sie zu benutzen tippe
	/msg %S command.  Weitere Hilfe fr einen
	bestimmten Befehl erhltst Du mit
	/msg %S HELP command.
	
	 REGISTER  Registriere einen Nick
	 IDENTIFY  Identifiziere Dich selbst mit Deinem Passwort
	 LINK      Linke Deinen Nick zu einen Anderen
	 SET       Setze Einstellungen, einschlielich Kill
	           Schutz
	 DROP      Lsche die Registrierung eines Nicks
	
	Andere Befehle: UNLINK, GHOST, INFO, LIST, STATUS
	
	Achtung: Dieser Service bietet einen Mglichkeit
	sicherzustellen, da die Identitt eines Benutzers nicht
	kompromittiert ist.  Er ist NICHT dafr gedacht, das
	"Stehlen" von Nicks und andere heimtckische Aktionen zu
	frdern.  Der Mibrauch des %S wird mindestens
	mit dem Verlust der mibrauchten Nick(s) geahndet.

NICK_HELP_REGISTER
	Syntax: REGISTER password email
	
	Registriert Deinen Nick in der %S Datenbank.  Wenn
	Du keine Email-Adresse hast, trage NOMAIL ein.  Wenn
	Dein Nick registriert ist, kannst Du die Einstellungen
	mit dem SET Befehl ndern.
	
	Stelle sicher das Du Dir das Passwort merkst - Du
	brauchst es um spter weitere nderungen an Deiner
	Registrierung zu machen. (Achtung. Im Passwort ist
	Gro/Klein-Schreibung relevant FIDO, Fido,
	und fido sind alle verschiedene Passwrter!)
	
	Richtlinien um ein Passwort auszuwhlen:
	
	Passwrter sollen nicht einfach zu erraten sein.  Es ist
	zum Beispiel eine schlechte Idee, Deinen richtigen Namen
	als Passwort zu benutzen. Dein Nick als Passwort zu
	benutzen ist brigens eine noch schlechtere Idee ;-) und
	%S erlaubt dieses auch nicht.  Auerdem sind
	kurze Passwrter verwundbar fr
	Versuch-und-Fehler-Suchen. Du solltest also ein Passwort
	whlen, welches mindestens fnf Zeichen lang ist. Das
	Leerzeichen kann in Passwrtern nicht verwendet werden.
	
NICK_HELP_IDENTIFY
	Syntax: IDENTIFY password
	
	Beweist %S, das Du wirklich der Besitzer dieses
	Nicks bist. Viele Befehle erfordern, da Du Dich vor der
	Nutzung autorisierst.  Da Passwort mu dasselbe sein,
	wie das was Du mit dem REGISTER-Befehl geschickt hast.

NICK_HELP_DROP
	Syntax: DROP
	
	Lscht Deinen Nick aus der %S Datenbank.  Ein
	gelschter Nick kann von jedem anderen Benutzer wieder
	registriert werden.
	
	Um diesen Befehl zu benutzen, mut Du Dich erst mit
	Deinem Passwort identifizieren
	(/msg %S HELP IDENTIFY fr
	weitere Informationen).

NICK_HELP_LINK
	Syntax: LINK nick password
	
	Linkt Deinen Nick zu einem Anderen, registriert deinen
	aktuellen Nick als Alias fr den angegebenen Nick.  Wenn
	Du diesen Befehl eingibst, wird die Auto-Join Liste fr
	Deinen aktuellen Nick gelscht und durch die Liste des
	angegebenen Nicks ersetzt; alle Memos des aktuellen Nick
	werden den Memos des angegebenen Nick hinzugefgt
	(Dadurch kann die Obergrenze der Memos berschritten
	werden; Du mut dann einige Memos lschen, damit Du
	wieder neue Memos empfangen kannst).
	
	Wenn der Link eingerichtet ist, wird Dein Nick in allen
	Services in den Ziel-Nick umgewandelt, auer in den
	%S UNLINK und DROP Befehlen.  Du kannst
	zum Beispiel beide Nicks benutzen um Deine Memos zu lesen
	(und Memos an beide Nicks werden der gleichen Liste
	hinzugefgt). Wenn Du Dich fr einen Nick identifizierst,
	wirst Du auch fr den anderen Nick erkannt.  Wenn einer
	der Nicks auf der Zugangs-Liste eines Kanals ist,
	erhalten beide dieselben Zugangs-rechte.
	
	Um diesen Befehl zu benutzen, mut Du Dich erst mit
	Deinem Passwort identifizieren
	(/msg %S HELP IDENTIFY fr
	weitere Informationen).

NICK_HELP_UNLINK
	Syntax: UNLINK [nick pass]
	
	Entfernt einen Link von einen Nick zu einem Anderen.
	Wenn der Link gelscht wird, werden die Einstellungen und
	die Auto-Join Liste des entlinkten Nicks zu dem Aktuellen
	kopiert und knnen dann unabhngig voneinander gendert
	werden.  Memos werden nicht kopiert; alle Memos bleiben
	bei dem vorher gelinkten Nick gespeichert.
	
	Indem Du Nick und Passwort als Parameter angibst, kannst
	Du einen Nick entlinken, auer dem den Du zu dem
	Zeitpunkt benutzt.
	
NICK_HELP_SET
	Syntax: SET option parameters
	
	Setze verschiedene Nick Einstellung.
	option kann sein:
	
	 PASSWORD   Setze Dein Nick Passwort
	 LANGUAGE   Setze die Sprache, die Services benutzen um
	            Dir Nachrichten zu schicken
	 URL        Setze eine URL
	 EMAIL      Setze eine Email Adresse
	 ICQNUMBER  Setze eine ICQ Nummer
	 LOCATION   Setze einen Standort
	 KILL       Schalte Kill Schutz an oder aus
	 PRIVATE    Verhindere das Anzeigen Deines Nicks in
	            /msg %S LIST
	 HIDE       Unterdrcke bestimmte Teile Deiner Nick
	            Information
	
	Um diesen Befehl zu benutzen, mut Du Dich erst mit
	Deinem Passwort identifizieren
	(/msg %S HELP IDENTIFY fr
	weitere Informationen).
	
	Tippe /msg %S HELP SET option fr weitere
	Information zu einer bestimmten Einstellung.

NICK_HELP_SET_PASSWORD
	Syntax: SET PASSWORD new-password
	
	ndert das Passwort, welches Dich als Besitzer des
	Nicks identifiziert.

NICK_HELP_SET_LANGUAGE
	Syntax: SET LANGUAGE number
	
	ndert die Sprache, die die Services benutzen um Dir
	Nachrichten zu schicken (zum Beispiel als Antwort auf
	einen Befehl von Dir). number kann von der folgenden
	Liste der untersttzten Sprachen gewhlt werden:

NICK_HELP_SET_URL
	Syntax: SET URL url
	
	Fgt Deinem Nick die angegebene URL hinzu.  Die URL wird
	angezeigt wenn jemand mit dem INFO Befehl
	Informationen ber Deinen Nick abruft.

NICK_HELP_SET_EMAIL
	Syntax: SET EMAIL address
	
	Fgt Deinem Nick die angegebene Email Adresse hinzu.  Die
	Adresse wird angezeigt wenn jemand mit dem INFO
	Befehl Informationen ber Deinen Nick abruft.

NICK_HELP_SET_ICQ
	Syntax: SET ICQNUMBER #number
	
	Fgt Deinem Nick die angegebene ICQ Nummer hinzu. Die
	Nummer wird angezeigt wenn jemand mit dem INFO Befehl
	Informationen ber Deinen Nick abruft.
NICK_HELP_SET_LOCATION
	Syntax: SET LOCATION  location
	
	Fgt Deinem Nick den angegebenen Standort hinzu. Der
	Standort wird angezeigt wenn jemand mit dem INFO
	Befehl Informationen ber Deinen Nick abruft.
NICK_HELP_SET_KILL
	Syntax: SET KILL {ON | QUICK | IMMED | OFF}
	
	Schaltet den automatischen Kill-Schutz ein oder aus.  Mit
	eingeschaltetem Kill-Schutz wird einem anderen
	Benutzern, der Deinen Nick benutzt, eine Minute Zeit
	gegeben den Nick zu wechseln, bevor er von %S aus
	dem IRC entfernt wird.
	
	Wenn Du QUICK einstellst, werden dem Benutzer nur 20
	statt 60 Sekunden gegeben, um den Nick zu wechseln. Wenn
	Du IMMED einstellst, wird der Benutzer sofort
	ohne Warnung und ohne eine Chance den Nick zu
	wechseln aus dem IRC entfernt; Bitte benutze diese
	Einstellung nur im Notfall.  Diese Einstellung ist
	eventuell vom Administrator abgeschaltet.

NICK_HELP_SET_PRIVATE
	Syntax: SET PRIVATE {ON | OFF}
	
	Schaltet %S's Privat Einstellung fr Deinen
	Nick an oder aus.  Wenn PRIVATE eingeschaltet ist,
	wird Dein Nick nicht beim %S's LIST Befehl
	angezeigt.  (Wenn jemand Deinen Nick kennt, kann er
	mit dem INFO Befehl immer noch Informationen ber
	Dich abrufen.)

NICK_HELP_SET_HIDE
	Syntax: SET HIDE {EMAIL | QUIT} {ON | OFF}
	
	Ermglicht Dir die Unterdrckung bestimmter Teile Deiner
	Nick Information, wenn jemand Deinen Nick mit dem
	INFO Befehl abruft.  Du kannst Deine Email Adresse
	(EMAIL) und Deine letzte quit Nachricht (QUIT).
	Der zweite Parameter gibt an ob die Information angezeigt
	wird (OFF) oder nicht (ON).

NICK_HELP_GHOST
	Syntax: GHOST nickname [password]
	
	Terminiert eine "Ghost" IRC Session mit Deinem Nick.
	Eine "Ghost" Session ist eine Session die nicht mehr
	verbunden ist, bei der der Server aber immer noch
	annimmt, das sie aktiv sei.  So etwas passiert, wenn Dein
	Rechner abstrzt oder Deine Internet-Verbindung
	unterbrochen wurde, whrend Du im IRC warst.
	
	Um den GHOST Befehl fr einen Nick zu benutzen, mut
	Du das richtige Passwort fr den Nick angeben.

NICK_HELP_INFO
	Syntax: INFO nickname
	
	Zeigt Informationen ber den angegebenen Nick an, z.B.
	den Eigentmer, die zuletzt gesehene Adresse und Zeit und
	die Nick Einstellungen.

NICK_HELP_LIST
	Syntax: LIST pattern
	
	Zeige alle registrierten Nicks, welche auf den
	angegebenen Filter, in nick!user@host Format, passen.
	Nicks, die die PRIVATE Einstellung gesetzt haben,
	werden nicht angezeigt.
	
	Beispiele:
	
	 LIST *!joeuser@foo.com
	  Zeige alle registrierten Nicks die joeuser@foo.com
	  gehren.
	
	 LIST *Bot*!*@*
	  Zeige alle registrierten Nicks, die Bot in Ihrem
	  Namen haben (Gro/Kleinschreibung ignoriert)
	
	 LIST *!*@*.bar.org
	  Zeige alle registrierten Nicks, die Benutzern der
	  bar.org Domain gehren.

NICK_HELP_STATUS
	Syntax: STATUS nickname...
	
	Gibt aus, ob der Benutzer der den angegebenen Nick
	benutzt, der Besitzer des Namens ist. Die Antwort hat
	dieses Format:
	
	 nickname status-code
	
	nickname ist der Nick der der abgefragt wurde und
	status-code ist eins der folgenden:
	
	 0 - Benutzer nicht online oder Nick nicht
	     registriert.
	 1 - Benutzer wird nicht als der Eigentmer erkannt.
	 2 - Benutzer wurde als Eigentmer per Passwort
	     Identifizierung erkannt.
	 3 - Benutzer wurde als Eigentmer per Passwort
	     Identifizierung erkannt.
	
	Bis zu sechzehn Nicks knnen pro Befehl abgefragt werden;
	Der Rest wird ignoriert.  Es wird keine Fehlermeldung
	generiert wenn keine Nicks angegeben werden.

NICK_SERVADMIN_HELP
	
	Die folgenden Befehle sind fr Service Admins verfgbar:
	
	 GETPASS    Gib das Passwort fr einen Nick aus
	                (nur wenn Kodierung abgeschaltet ist)
	 FORBID     Verhindert die Nutzung eines Nick
	 LISTLINKS  Zeige alle Links fr einen Nick
	
	Service Admins knnen jeden Nick lschen, ohne sich dafr
	identifizieren zu mssen, und knnen die Auto-Join Liste
	fr jeden Nick ansehen
	(/msg %S AJOIN LIST nick).
	
NICK_SERVADMIN_HELP_DROP
	Syntax: DROP [nickname]
	
	Ohne Parameter: Lscht Deinen Nick aus der
	%S Datenbank.
	
	Mit einem Parameter: Lscht den gegebenen Nick aus der
	Datenbank. Dieses ist auf Services Admins begrenzt.

NICK_SERVADMIN_HELP_SET
	
	Service Admins knnen die Einstellung NOEXPIRE
	setzen, welches verhindert das Nicks ablaufen.  Auerdem
	knnen Service Admins Einstellungen fr jeden Nick
	setzen, ohne ein Passwort eingeben zu mssen. Format:
	SET nickname option parameters.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Syntax: SET [nickname] NOEXPIRE {ON | OFF}
	
	Gibt an, ob der Nick abluft.  Wenn auf ON gesetzt,
	luft der Nick nicht ab. Wenn kein Nick angegeben wird,
	wird Dein eigener Nick gesetzt.
	
	Nur fr Services Admins.

NICK_SERVADMIN_HELP_UNLINK
	
	Service Admins knnen jeden Nick, ohne ein Passwort
	eingeben zu mssen, entlinken.

NICK_HELP_LISTLINKS
	Syntax: LISTLINKS
	
	Zeige Nicks an, welche zu einem gegebenen Nick
	gelinkt sind.

NICK_SERVADMIN_HELP_LISTLINKS
	Syntax: LISTLINKS nick [ALL]
	
	Zeige Nicks an, welche zu einem gegebenen Nick gelinkt
	sind.  Wenn ALL angegeben wird, werden alle Nicks
	ausgegeben, die dieselben Privilegien wie der gegebene
	Nick haben; sonst werden nur Nicks ausgegeben die direkt
	gelinkt sind.

NICK_SERVADMIN_HELP_LIST
	Syntax: LIST pattern [FORBIDDEN] [NOEXPIRE]
	
	Zeige alle registrierten Nicks, welche auf den
	angegebenen Filter, in nick!user@host Format, passen.
	Nicks, die die PRIVATE Einstellung gesetzt haben,
	werden nur Services Admins angezeigt.  Nicks mit der
	NOEXPIRE Einstellung werden durch ein vorangestelltes
	! gekennzeichnet.
	
	Wenn die FORBIDDEN oder NOEXPIRE Einstellung angegeben
	wird, werden nur Nicks welche die FORBIDDEN oder NOEXPIRE
	gesetzt haben, angezeigt. Wenn beide Einstellungen
	angegeben werden, werden beide Typen ausgegeben. Diese
	Einstellungen sind nur fr Services Admins verfgbar.
	
	Beispiele:
	
	 LIST *!joeuser@foo.com
	  Zeige alle registrierten Nicks die joeuser@foo.com
	  gehren.
	
	 LIST *Bot*!*@*
	  Zeige alle registrierten Nicks, die Bot in Ihrem
	  Namen haben (Gro/Kleinschreibung ignoriert)
	
	 LIST * NOEXPIRE
	  Zeige alle registrierten Nicks die nicht  ablaufen.

NICK_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS nickname
	
	Zeigt das Passwort des Nicks.  Achtung Wenn dieser
	Befehl benutzt wird, wird eine Nachricht mit demjenigen
	der den Befehl eingeben hat und dem Nick der abgefragt
	wurde geloggt und als WALLOPS/GLOBOPS verschickt.
	
	Nur fr Services Admins.
	
	Dieser Befehl ist nicht verfgbar, wenn Kodierung
	aktiviert wurde.
	
NICK_SERVADMIN_HELP_FORBID
	Syntax: FORBID nickname
	
	Verbietet die Registrierung oder Nutzung des Nicks fr
	alle.  Kann gelscht werden mit dem DROP-Befehl.
	
	Nur fr Services Admins.

#################################################################
#
# ChanServ help messages
#
#################################################################

CHAN_HELP
	
	%S erlaubt es, einen Kanal zu registrieren,
	und verschiedene Einstellungen des Kanals zu
	kontrollieren.  %S kann meist verhindern, da
	boshafte Benutzer einen Kanal bernehmen, indem nur
	bestimmte Nicks erlaubt wird Operator Status zu erlangen.
	Verfgbare Befehle sind unten aufgefhrt; Um sie zu
	benutzen tippe /msg %S command. Weitere
	Hilfe fr einen bestimmten Befehl erhltst Du mit
	/msg %S HELP command.
	
	 REGISTER  Registriere einen Kanal
	 IDENTIFY  Identifiziere Dich selbst mit Deinem Passwort
	 SET       Setze Kanal Einstellungen und Information
	 ACCESS    Bearbeite die Liste der privilegierten
	           Benutzer
	 AOP/SOP   Alias um die Liste der privilegierten Benutzer 
	           zu bearbeiten
	 LEVELS    Redefiniere die Bedeutung der Zugangs-Stufen
	 AKICK     Pflege die Auto-Kick Liste
	 DROP      Lsche die Registrierung eines Kanals
	
	Andere Befehle: INFO, LIST, INVITE, OP, DEOP, UNBAN,
	                KICK, CLEAR

CHAN_HELP_EXPIRES
	Beachte das jeder Kanal, der %d Tage nicht benutzt
	wird (also kein Benutzer der Zugangs-Liste in dem
	Zeitraum den Kanal betritt) automatisch gelscht wird.

CHAN_HELP_REGISTER
	Syntax: REGISTER channel password description
	
	Registriert einen Kanal in der %S Datenbank.  Um
	diesen Befehl zu benutzen mut Du erst Operator in dem
	Kanal, den Du registrieren willst, sein.  Das Passwort
	wird im IDENTIFY Befehl benutzt, um Dir nderungen
	der Kanal Einstellungen zu einem spteren Zeitpunkt zu
	erlauben.  Der letzte Parameter, welcher benutzt werden
	mu, soll eine allgemeine Beschreibung des
	Kanal-Zwecks enthalten..
	
	Wenn Du einen Kanal registrierst, wirst Du als "Founder"
	des Kanals registriert. Der Kanal Founder darf alle
	Einstellungen des Kanals ndern; %S wird dem
	Founder auerdem automatisch Kanal-Operator-Rechte
	geben, wenn er den Kanal betritt.
	
	Benutze den ACCESS Befehl
	(/msg %S HELP ACCESS) um Privilegien an andere
	Kanal Benutzer weiterzugeben.
	
	HINWEIS: Um einen Kanal zu registrieren, mut Du zuerst
	Deinen Nick registrieren. Wenn Du das noch nicht getan
	hast, Tippe /msg %s HELP fr weitere Informationen,
	wie man das macht.

CHAN_HELP_IDENTIFY
	Syntax: IDENTIFY channel password
	
	Autentifiziert Dich fr %S als den Founder des
	angegebenen Kanals.  Viele Befehle lassen sich erst
	benutzen, nachdem Du diesen Befehl benutzt hast.  Da
	Passwort mu dasselbe sein, wie das was Du mit dem
	REGISTER-Befehl geschickt hast.

CHAN_HELP_DROP
	Syntax: DROP channel
	
	Lscht den angegebenen Kanal.  Dieser Befehl kann nur von
	dem Kanal Founder benutzt werden, nachdem er den
	IDENTIFY Befehl benutzt hat.

CHAN_HELP_SET
	Syntax: SET channel option parameters
	
	Ermglicht dem Kanal Founder, verschiedene Kanal
	Einstellungen und andere Informationen zu setzen.  Der
	Founder mu erst den IDENTIFY Befehl benutzen, bevor
	er SET benutzen kann.
	
	Verfgbare Einstellungen:
	
	 FOUNDER     Setzt den Founder eines Kanals
	 SUCCESSOR   Setzt den Nachfolger eines Kanals
	 PASSWORD    Setzt das Founder Passwort
	 DESC        Setzt die Kanal Beschreibung
	 URL         Setzt eine URL
	 EMAIL       Setzt eine Email Adresse
	 ENTRYMSG    Setzt eine Nachricht, die Benutzern
	             geschickt wird, wenn sie den Kanal betreten
	 TOPIC       ndert das Topic auf dem Kanal
	 KEEPTOPIC   Bewahrt das Topic, wenn ein Kanal nicht
	             benutzt wird
	 TOPICLOCK   Topic kann nur mit SET TOPIC gendert werden
	 MLOCK       Sperrung der Kanal Modi on oder off
	 PRIVATE     Unterdrcke die Anzeige des Kanals im LIST
	             Befehl
	 RESTRICTED  Beschrnke den Zugang zum Kanal
	 SECUREOPS   Strkere Kontrolle des Kanal Operator Status
	 LEAVEOPS    Nimmt niemals einen Op weg, auer mit dem
	             DEOP Befehl
	 OPNOTICE    Schicke eine Notiz, wenn der OP/DEOP Befehl
	             benutzt wird
	 NOLINKS     Ignoriert die Access-Listen Erkennung von 
		     gelinkten Nicks. 
	  
	Tippe /msg %S HELP SET option fr weitere
	Information zu einer bestimmten Option.

CHAN_HELP_SET_FOUNDER
	Syntax: SET channel FOUNDER nick
	
	ndert den Founder des Kanals. Der neue Nick mu
	registriert sein.

CHAN_HELP_SET_SUCCESSOR
	Syntax: SET channel SUCCESSOR nick
	
	ndert den Nachfolger fr einen Kanal.  Wenn der Nick des
	Founder abluft, oder gelscht wird, whrend der Kanal
	immer noch registriert ist, wird der Nachfolger der neue
	Founder des Kanals.  Wenn der Nachfolger allerdings
	bereits zu viele Kanle registriert hat (%d), wird der
	Kanal stattdessen gelscht, als ob kein Nachfolger
	eingetragen wurde.  Der neue Nick mu registriert sein.

CHAN_HELP_SET_PASSWORD
	Syntax: SET channel PASSWORD password
	
	ndert das Passwort, welches Dich als Founder des
	Kanals identifiziert.

CHAN_HELP_SET_DESC
	Syntax: SET channel DESC description
	
	Setzt die Beschreibung fr den Kanal, wird angezeigt mit
	dem LIST und dem INFO Befehl.

CHAN_HELP_SET_URL
	Syntax: SET channel URL [url]
	
	Ordnet dem Kanal die URL zu. Die URL wird angezeigt, wenn
	jemand mit dem INFO Befehl Informationen ber den
	Kanal abruft.  Ohne Parameter wird die aktuelle URL des
	Kanals gelscht.

CHAN_HELP_SET_EMAIL
	Syntax: SET channel EMAIL [address]
	
	Ordnet dem Kanal die Email Adresse zu. Diese Adresse wird
	angezeigt, wenn jemand mit dem INFO Befehl
	Informationen ber den Kanal abruft. Ohne Parameter wird
	die aktuelle Email Adresse des Kanals gelscht.

CHAN_HELP_SET_ENTRYMSG
	Syntax: SET channel ENTRYMSG [message]
	
	Setzt eine Nachricht, die Benutzern, wenn sie den Kanal
	betreten per /notice geschickt wird.  Ohne Parameter,
	wird keine Nachricht beim Betreten des Kanals verschickt.

CHAN_HELP_SET_TOPIC
	Syntax: SET channel TOPIC topic
	
	Veranlat %S das Topic des Kanals zu setzen.
	Dieser Befehl ist am Sinn-vollsten in Verbindung mit
	SET TOPICLOCK.

CHAN_HELP_SET_KEEPTOPIC
	Syntax: SET channel KEEPTOPIC {ON | OFF}
	
	Aktiviert und deaktiviert die Topic Beibehaltung
	Einstellung fr einen Kanal.  Wenn Topic Beibehaltung
	aktiviert ist, wird das Topic durch %S
	gespeichert, auch wenn der letzte Benutzer den Kanal
	verlassen hat, und wird wieder hergestellt, wenn der
	Kanal wieder geffnet wird.

CHAN_HELP_SET_TOPICLOCK
	Syntax: SET channel TOPICLOCK {ON | OFF}
	
	Aktiviert und deaktiviert die Topic Sperre
	Einstellung fr einen Kanal.  Wenn Topic Sperre
	aktiviert ist, verhindert %S die nderung des
	Topic, auer durch den SET TOPIC Befehl.

CHAN_HELP_SET_MLOCK
	Syntax: SET channel MLOCK modes
	
	Setzt die Mode-Sperre Parameter fr den Kanal.  Du kannst
	mit %S bestimmte Kanal Modi definieren, welche
	immer an (oder aus) sind.  Die Modi die so gesperrt
	werden knnen sind i, k, l, m, n,
	p, s, und t; jedes dieser Modi kann gesperrt,
	entsperrt, oder nicht gesperrt werden.  Die modes
	Parameter funktionieren genauso wie der /MODE Befehl;
	das bedeutet, Modi gefolgt von einem + sind gesperrt, und
	Modi gefolgt von einem - sind entsperrt.
	
	Warnung: Wenn Du einen Kanal-Schlssel sperrst, wie
	in dem zweiten Beispiel unten, solltest Du auerdem die
	RESTRICTED Einstellung fr den Kanal (siehe HELP
	SET RESTRICTED) setzen, oder jeder der den Kanal
	betritt, wenn er leer ist, kann den Schlssel sehen!
	
	Beispiele:
	
	 SET #channel MLOCK +nt-iklps
	  Schaltet die Modi n und t ein, und die Modi i, k, l, p
	  und s aus.  Mode m ist weiterhin frei.
	
	 SET #channel MLOCK +knst-ilmp my-key
	  Schaltet die Modi k, n, s und t ein, und die Modi i, l,
	  m und p aus.  Setzt auerdem den Kanal-Schlssel auf
	  "my-key".
	
	 SET #channel MLOCK +
	  Schaltet die Mode-sperre aus; alle Kanal Modi sind
	  freigegeben.

CHAN_HELP_SET_PRIVATE
	Syntax: SET channel PRIVATE {ON | OFF}
	
	Schaltet die PRIVATE Einstellung fr einen Kanal ein
	oder aus.  Wenn PRIVATE gesetzt ist, wird der Kanal
	bei einem /msg %S LIST nicht angezeigt.

CHAN_HELP_SET_RESTRICTED
	Syntax: SET channel RESTRICTED {ON | OFF}
	
	Aktiviert oder Deaktiviert den eingeschrnkten Zugang
	fr einen Kanal.  Wenn eingeschrnkter Zugang
	aktiviert ist, werden Benutzer die keinen Kanal Operator
	Status haben drfen (Benutzer mit Negativer Zugangs-Stufe
	und, wenn sichere Ops gesetzt ist, Benutzer die
	nicht auf der Zugangs-Liste sind) aus dem Kanal gekickt
	und gebannt.

CHAN_HELP_SET_SECUREOPS
	Syntax: SET channel SECUREOPS {ON | OFF}
	
	Aktiviert oder Deaktiviert die sichere Ops
	Einstellung fr einen Kanal. Wenn sichere Ops gesetzt
	ist, knnen Benutzer, die nicht auf der Zugangs-Liste
	sind, keine Kanal Op Status erlangen.

CHAN_HELP_SET_LEAVEOPS
	Syntax: SET channel LEAVEOPS {ON | OFF}
	
	Aktiviert oder Deaktiviert die Belasse Ops
	Einstellung fr den Kanal.  Wenn Belasse Ops
	aktiviert ist, wird %S nie jemanden den Op Status
	entziehen, auer mit dem DEOP Befehl.

CHAN_HELP_SET_OPNOTICE
	Syntax: SET channel OPNOTICE {ON | OFF}
	
	Aktiviert oder Deaktiviert die Op-Notiz Einstellung
	fr einen Kanal.  Wenn Op-Notiz aktiviert ist,
	schickt %S eine Notiz an den Kanal, wenn der
	OP oder DEOP Befehl fr einen Benutzer auf dem
	Kanal benutzt wird.

CHAN_HELP_SET_NOLINKS
	Syntax: SET channel NOLINKS {ON | OFF}
	
	Aktiviert oder Deaktiviert die NOLINKS Einstellung
	fr einen Kanal. Wenn NOLINKS aktiviert ist, erkennt
	%S nur die Nicks die auf der Zugangs Liste
	eingetragen sind, gelinkte Nicks werden nicht erkannt.

CHAN_HELP_ACCESS
	Syntax: ACCESS channel ADD nick level
	        ACCESS channel DEL {nick | entry-num | list | ALL }
	        ACCESS channel LIST [mask | list]
	
	Pflegt die Zugangs-Liste fr einen Kanal.  Die
	Zugangs-Liste gibt an, welche Benutzer einen Kanal Op
	Status haben drfen, und Zugang zu den %S Befehlen
	fr den Kanal haben.  Verschiedene Benutzer-Stufen
	erlauben den Zugang zu verschiedenen Subsets der
	Privilegien; Tippe /msg %S HELP ACCESS LEVELS
	fr weitere Informationen.  Jeder Nick der nicht auf der
	Liste ist, hat eine Benutzer-Stufe von 0.
	
	Der ACCESS ADD Befehl fgt der Zugangs-Liste den
	angegebenen Nick mit der angegebenen Zugangs-Stufe hinzu;
	wenn der Nick bereits auf der Liste existiert, wird die
	Zugangs-Stufe entsprechend gendert.  Der angegebene
	level mu geringer sein, als der level des
	Benutzers der den Befehl eingibt, und wenn der nick
	bereits auf der Zugangs-Liste ist, mu die aktuelle
	Zugangs-Stufe des Nicks geringer sein, als die
	Zugangs-Stufe des Benutzers der den Befehl eingibt.
	
	Der ACCESS DEL Befehl lscht den angegebenen Nick aus
	der Zugangs-Liste.  Wenn eine Liste der laufenden Nummern
	angegeben wird, werden die entsprechenden Eintrge
	gelscht.  (Siehe das Beispiel unten.) Mit ALL werden
	alle Eintrge gelscht, dieser Befehl ist nur fr den
	Founder mglich.
	
	Der ACCESS LIST Befehl zeigt die Zugangs-Liste.  Wenn
	eine Maske angegeben wird, werden nur dir passenden
	Eintrge ausgegeben.  Wenn eine Liste von laufenden
	Nummern angegeben wird, werden nur die entsprechenden
	Eintrge ausgegeben; zum Beispiel:
	
	 ACCESS #channel LIST 2-5,7-9
	  Zeigt die Eintrge 2 bis 5 und 7 bis 9 der
	  Zugangs-Liste.

CHAN_HELP_ACCESS_LEVELS
	Benutzer-Zugangs-Stufen
	
	Als Voreinstellung sind die folgenden
	Zugangs-Stufen definiert:
	
	 Founder  Voller Zugang zu den Funktionen des
	              %S; Automatisches Op geben beim
	              Betreten des Kanals.  Es kann nur eine
	              Person den Founder Status haben (Es kann
	              nicht mit dem ACCESS Befehl vergeben
	              werden).
	      10  Zugang zum AKICK Befehl; Automatisches Op
	              geben.
	       5  Automatisches Op geben.
	       3  Automatisches Rede-recht.
	       0  Keine speziellen Privilegien; Kann von
	              anderen Ops geopped werden (auer bei
	              gesetzten secure-ops).
	      <0  Darf nicht geoppt werden.
	
	Diese Stufen knnen mit dem LEVELS Befehl gendert
	werden, es knnen auch Neue hinzugefgt werden; Tippe
	/msg %S HELP LEVELS fr weitere Informationen.

CHAN_HELP_AKICK
	Syntax: AKICK channel ADD mask [reason]
	        AKICK channel DEL [ mask | ALL ]
	        AKICK channel LIST [mask]
	
	Bearbeite die AutoKick Liste fr einen Kanal.  Wenn
	ein Benutzer, der auf der AutoKick Liste ist, versucht
	den Kanal zu betreten, wird %S den Benutzer bannen
	und kicken.
	
	Der AKICK ADD Befehl fgt den gegebenen Nick oder die
	Benutzermaske zur AutoKickListe hinzu.  Wenn eine
	reason mit dem Befehl gesetzt wird, wird diese
	angegeben wenn ein Benutzer gekickt wird;
	wenn nicht ist der voreingestellte Grund "You have been
	banned from the channel".
	
	Der AKICK DEL Befehl lscht den gegebenen Nick oder
	die Benutzermaske aus der AutoKickListe.  Es lscht nicht
	die Bans die von einem AutoKick gesetzt wurden; diese
	mssen manuell entfernt werden.  Mit ALL werden alle
	AutoKick-Eintrge gelscht, dieser Befehl ist nur fr den
	Founder mglich.
	
	Der AKICK LIST Befehl zeigt die AutoKick Liste, oder
	nur die Eintrge die auf die gegebene Maske passen.

CHAN_HELP_LEVELS
	Syntax: LEVELS channel SET type level
	        LEVELS channel {DIS | DISABLE} type
	        LEVELS channel LIST
	        LEVELS channel RESET
	
	Der LEVELS Befehl ermglicht die Kontrolle ber die
	Bedeutung der numerischen Zugangsstufen der Kanle.  Mit
	diesem Befehl kannst Du die Zugangsstufen definieren,
	die fr die meissten %S Funktionen bentigt
	werden. (Die SET FOUNDER und SET PASSWORD
	Befehle und dieser Befehl sind immer nur fr den Kanal
	Founder verfgbar.)
	
	LEVELS SET ermglicht es die Zugangsstufe fr eine
	Funktion oder eine Gruppe von Funktionen zu ndern.
	LEVELS DISABLE (oder kurz DIS) schaltet eine
	automatische Funktion ab oder unterbindet den Zugang
	zu einer Funktion fr alle ausser den Kanal Founder.
	LEVELS LIST zeigt die aktuellen Stufen fr jede
	Funktion und Gruppe von Funktionen. LEVELS RESET
	setzt die Zugangsstufen wieder auf die
	Voreinstellungen fr einen neuen Kanal zurck
	(siehe HELP ACCESS LEVELS).
	
	Fr eine Liste der Funktionen, fr die Zugangsstufen
	gesetzt werden knnen, tippe HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Die folgenden Funktionsnamen sind understood.  Beachte
	dass die Stufen fr AUTODEOP und NOJOIN maximum Stufen
	sind, alle anderen sind Minimum Stufen.

CHAN_HELP_LEVELS_DESC_FORMAT
	 %-*s  %s

CHAN_HELP_INFO
	Syntax: INFO channel
	
	Gibt Informationen ber den genannten registrierten
	Kanal, inklusive dem Founder, dem Zeitpunkt der
	Registrierung, der letzten Nutzung, Beschreibung und
	Modesperre, wenn vorhanden aus.

CHAN_HELP_LIST
	Syntax: LIST pattern
	
	Gibt alle registrierten Kanle die auf die gegebene Maske
	passen, aus (Kanale mit der PRIVATE Einstellung
	werden nicht angezeigt)

CHAN_HELP_OP
	Syntax: OP #channel nick
	
	Oppt einen ausgewhlten Nick auf einem Kanal.  Als
	Voreinstellung ist dieser Befehl auf Benutzer mit Stufe 5
	Zugang oder hher beschrnkt.

CHAN_HELP_DEOP
	Syntax: DEOP #channel nick
	
	Deoppt einen ausgewhlten Nick auf einem Kanal. Als
	Voreinstellung ist dieser Befehl auf Benutzer mit Stufe 5
	Zugang oder hher beschrnkt.

CHAN_HELP_KICK
	Syntax: KICK #channel nick reason
	
	Kickt einen Benutzer mit %S aus einem Kanal.  Als
	Voreinstellung ist dieser Befehl auf Benutzer mit Stufe 5
	Zugang oder hher beschrnkt.

CHAN_HELP_INVITE
	Syntax: INVITE channel
	
	Veranlasst %S Dich auf den angegebenen Kanal
	einzuladen.  Als Voreinstellung ist dieser Befehl auf
	Benutzer mit Stufe 1 Zugang oder hher beschrnkt.

CHAN_HELP_UNBAN
	Syntax: UNBAN channel
	
	Veranlasst %S alle Bans zu lschen die verhindern,
	das Du auf den Kanal kannst.  Als Voreinstellung ist
	dieser Befehl auf Benutzer mit Stufe 1 Zugang oder
	hher beschrnkt.

CHAN_HELP_CLEAR
	Syntax: CLEAR channel what
	
	Veranlasst %S die angegebene Einstellung auf einem
	Kanal zu lschen.  what kann eins der folgenden sein:
	
	 MODES   Setzt alle Modes auf einem Kanal zurck (das
	         heisst alle i,k,l,m,n,p,s,t-Modes werden
	         gelscht).
	 BANS    Lscht alle Bans auf dem Kanal.
	 OPS     Deoppt alle Kanal Ops (mode +o)
	 VOICES  Lscht alle "voice" Modes (mode +v)
	 USERS   Kickt alle Benutzer aus dem Kanal.
	
	Als Voreinstellung ist dieser Befehl auf Benutzer mit
	Stufe 10 Zugang oder hher beschrnkt.

CHAN_SERVADMIN_HELP
	
	Die folgenden Befehle sind fr Service Admins verfgbar:
	
	 GETPASS  Gibt das Passwort des Founders aus (nur bei
	          abgeschalteter Kodierung)
	 FORBID   Verbietet die Nutzung des Kanals
	 STATUS   Gibt die aktuellen Zugangsstufe fr einen
	          Benutzer des Kanals aus
	
	Service Admins knnen ausserdem jeden Kanal ohne Passwort
	Identifizierung lschen, oder sich die Zugangs-,
	AutoKick- und Einstellungslisten ansehen.

CHAN_SERVADMIN_HELP_DROP
	Syntax: DROP channel
	
	Lscht den genannten Kanal.  Nur Services admins
	knnen einen Kanal lschen, fr den sie nicht
	angemeldet sind.

CHAN_SERVADMIN_HELP_SET
	
	Service Admins knnen die Einstellung NOEXPIRE
	setzen, welches verhindert das Kanle ablaufen.
	Ausserdem knnen Service Admins Einstellungen fr jeden
	Kanal setzen, ohne ein Passwort eingeben zu mssen.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Syntax: SET channel NOEXPIRE {ON | OFF}
	
	Gibt an, ob der Kanal abluft.  Wenn auf ON gesetzt,
	luft der Kanal nicht ab.
	
	Nur fr Services admins.

CHAN_SERVADMIN_HELP_LIST
	Syntax: LIST pattern
	
	Zeigt alle registrierten Kanle, welche auf den
	angegebenen Filter passen.  Kanle, die die
	PRIVATE Einstellung gesetzt haben, werden nur
	Service Admins angezeigt.

CHAN_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS channel
	
	Zeigt das Passwort des Kanals.  Achtung Wenn dieser
	Befehl benutzt wird, wird eine Nachricht mit demjenigen
	der den Befehl eingeben hat und dem Kanal der abgefragt
	wurde geloggt und als WALLOPS/GLOBOPS verschickt.
	
	Nur fr Service admins.

CHAN_SERVADMIN_HELP_FORBID
	Syntax: FORBID channel
	
	Verbietet die Registrierung und Nutzung des Kanals.  Kann
	mit dem DROP-Befehl gelscht werden.
	
	Nur fr Service admins.

CHAN_SERVADMIN_HELP_STATUS
	Syntax: STATUS channel nickname
	
	Gibt die aktuelle Zugangsstufe fr den angegebenen Nick
	fr den angegebenen Kanal aus.  Die Antwort erfolgt in
	der Form:
	
	 STATUS channel nickname access-level
	
	Wenn ein Fehler auftritt, erfolgt die Antwort in diesem
	Format:
	
	 STATUS ERROR error-message
	
	Nur fr Service admins.

#################################################################
#
# MemoServ help messages
#
#################################################################

MEMO_HELP
	%S ermglicht es IRC Benutzern kurze
	Nachrichten an andere IRC Benutzer oder Kanle(*) zu
	schicken, egal ob diese gerade online sind, oder nicht.
	Sowohl der Nick des Absenders als auch der Nick des
	Empfngers oder der Kanalname mssen registriert sein um
	ein Memo zu versenden.
	
	%S's Befehle enthalten:
	
	 SEND  Schicke ein Memo an einen Nick oder Kanal
	 LIST  Zeige Deine Memos an
	 READ  Lies ein Memo oder mehrere Memos
	 DEL   Lscht ein Memo oder mehrere Memos
	 SET   Setzt Einstellungen zu den Memos
	
	Tippe /msg %S HELP command fr Hilfe zu
	den obigen Befehlen.
	
	(*) Als Voreinstellung kann jeder Benutzer mit mindestens
	Zugangsstufe 10 eines Kanals die Kanal Memos lesen.
	Dieses kann mit dem %s LEVELS Befehl
	gendert werden.

MEMO_HELP_SEND
	Syntax: SEND {nick | channel} memo-text
	
	Schickt dem genannten nick oder Kanal ein Memo
	mit dem memo-text.  Wenn an einen Nick geschickt
	wird, erhlt der Empfnger eine Notice das er ein neues
	Memo erhalten hat.  Der Ziel Nick muss registriert sein.

	Mit einem vorgestellten ? wirst Du benachrichtigt, wenn 
	das Memo gelesen wurde.

MEMO_HELP_LIST
	Syntax: LIST [channel] [list | NEW]
	
	Zeigt alle Memos die Du derzeit hast.  Mit NEW werden
	nur neue (ungelesene) Memos angezeigt.  Ungelesene Memos
	werden mit einem "*" gekennzeichnet.  Du kannst auch eine
	Liste von Nummern angeben, wie in dem Beispiel unten:
	
	 LIST 2-5,7-9
	  Zeige Memos Nr. 2 bis 5 und 7 bis 9.

MEMO_HELP_READ
	Syntax: READ [channel] {num | list | LAST | NEW}
	
	Schickt Dir den Text des angegebenen Memos.  Wenn LAST
	angegeben wird, wird das neueste Memo ausgegeben.  Wenn
	NEW angegeben wird, werden alle neuen Memos ausgegeben.
	Sonst gibt es das Memo Nummer num aus. Du kannst auch
	eine Liste von Nummern angeben, wie in diesem Beispiel:
	
	 READ 2-5,7-9
	  Zeigt Memo Nr. 2 bis 5 und 7 bis 9 an.

MEMO_HELP_DEL
	Syntax: DEL [channel] {num | list | ALL}
	
	Lscht das angegebenen Memo oder Memos.  Du kannst statt
	einer Nummer mehrere Memo Nummern angeben, oder Bereiche
	von Nummern, wie im zweiten beispiel unten.
	
	Mit ALL kannst Du alle Memos lschen.
	
	Beispiele:
	
	 DEL 1
	  Lscht das erste Memo.
	
	 DEL 2-5,7-9
	  Lscht Memo Nr. 2 bis 5 und 7 bis 9.

MEMO_HELP_SET
	Syntax: SET option parameters
	
	Setze verschiedene Einstellungen.
	option ist eins von:
	
	 NOTIFY  ndert wann Du nach Empfang eines neuen Memos
	         benachrichtigst wirst. (nur fr Nicks)
	 LIMIT   Setze die Memo-Obergrenze die Du empfangen
	         kannst.
	
	Tippe /msg %S HELP SET option fr weitere
	Informationen ber eine bestimmte Einstellung.

MEMO_HELP_SET_NOTIFY
	Syntax: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	ndert wann Du nach Empfang eines neuen Memos
	benachrichtigt wirst:
	
	 ON     Du wirst ber Memos benachrichtigt, wenn Du Dich
	        anmeldest, wenn Du /away abschaltest und wenn
	        Dir Memos zugeschickt werden.
	 LOGON  Du wirst ber Memos benachrichtigt, wenn Du Dich
	        anmeldest und wenn Du /away abschaltest.
	 NEW    Du wirst nur ber Memos benachrichtigt, wenn Dir
	        Memos zugeschickt werden.
	 OFF    Du wirst nicht ber Memos benachrichtigt.
	
	ON ist praktisch eine Kombination von LOGON und
	NEW

MEMO_HELP_SET_LIMIT
	Syntax: SET LIMIT [channel] limit
	
	Setzt die Memo-Obergrenze die Du (oder der angegebene
	Kanal) haben darf.  Wenn Du dieses auf 0 setzt, kann Dir
	niemand Memos schicken.  Du kannst diesen Wert nicht
	hher als %d setzen.

MEMO_HELP_INFO
	Syntax: INFO [channel]
	
	Zeigt Informationen ber die Anzahl Deiner Memos, wieviel
	davon ungelesen sind, und wieviele Memos Du maximal
	empfangen kannst, an.  Mit einem Parameter werden diese
	Informationen fr den angegebenen Kanal angezeigt.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Syntax: SET LIMIT [user | channel] {limit | NONE} [HARD]
	
	Setzt die Memo-Obergrenze die eine Benutzer oder Kanal
	haben darf.  Wenn die Grenze auf 0 gesetzt wird, kann der
	Benutzer keine Memos mehr empfangen: wenn auf NONE
	gesetzt, kann der Benutzer unbegrenzt viele Memos haben.
	Ohne Angabe eines Nick oder Kanal, wird Deine eigene
	Grenze gesetzt.
	
	Mit der zustzlichen Einstellung HARD wird verhindert
	das der Benutzer seine Grenze ndern kann.  Ohne HARD
	wird dem benutzer erlaubt die Grenze zu ndern. (auch
	wenn eine frhere Obergrenze mit HARD gesetzt wurde).
	
	Die Benutzung des SET LIMIT Befehls ist auf
	Service admins beschrnkt.  Andere Benutzer
	knnen nur eine Obergrenze fr sich selbst oder einen
	Kanal, fr den sie dei entsprechenden Rechte haben
	mssen, ndern. Sie knnen Ihre Obergrenze nicht nicht
	lschen, sie knnen keine Obergrenze ber %d setzen,
	und knnen kein wenn HARD gesetzt wurde, Ihre Grenze
	nicht ndern.

MEMO_SERVADMIN_HELP_INFO
	Syntax: INFO [nick | channel]
	
	Ohne einen Parameter werden Informationen ber die Anzahl
	der Memos, wieviel davon ungelesen sind, und die maximale
	Anzahl der Memos angezeigt.
	
	Mit einem Kanal-Parameter, wird diese Information fr den
	gegebenen Kanal angezeigt.
	
	Mit einem Nick, wird diese Information fr den gegebenen
	Nick angezeigt.
	
	Dieser Befehl ist nur fr Services admins.

#################################################################
#
# OperServ help messages
#
#################################################################

OPER_HELP
	%S Befehle:
	 GLOBAL      Schickt eine Nachricht an alle Benutzer
	 STATS       Zeigt den Status der Services und des
	             Netzwerks
	 OPER LIST   Zeigt alle Service Operators
	 ADMIN LIST  Zeigt alle Service Admins
	
	Commands available to Services operators and admins only:
	 MODE        ndert einen Kanal Mode
	 KICK        Kickt einen Benutzer aus einem Kanal
	 AKILL       Manipuliert die AKILL Liste
	 VLINE       Manipuliert die VLINE Liste
	 BOT         Manipulatiert die BOT Liste.
	 SESSION     Sitzung Begrenzungs info
	
	Befehle die nur fr Service Admins verfgbar sind:
	 SQLINE      Manipuliert die SQLINE Liste
	 OPER        ndert die Service Operator Liste
	 LOGONNEWS   Definiert Nachrichten die Benutzern beim
	             Anmelden angezeigt werden
	 OPERNEWS    Definiert Nachrichten die Benutzern die
	             Oper werden angezeigt werden
	 JUPE        "Jupiter" einen Server
	 SET         Setzt verschiedene globale Service
	             Einstellungen
	 GETFOUNDER  Hole Kanal-Founder Zugangs-Privilegien.
	 UPDATE      Erzwingt eine Sofortaktualisierung der
	             Service Datenbank auf der Festplatte
	 QUIT        Beendet das Service Programm
	 RESTART     Speichert die Datenbank und startet die
	             Services neu
	 REHASH      Ldt die Konfigurationsdatei neu
	 SENDPASS    Schicke ein Nick Passwort per Email.
	
	Befehle die nur fr den Service super-user
	verfgbar sind:
	 ADMIN       ndert die Service Admin Liste
	 RAW         Schickt eine raw Zeichenkette an den
	             Server
	
	Achtung: alle Befehle die an den %S geschickt
	             werden, werden geloggt!

OPER_HELP_GLOBAL
	Syntax: GLOBAL message
	
	Ermglicht es IRCops Nachrichten an alle Benutzer des
	Netzwerks zu schicken.  Die Nachricht wird von dem Nick
	%s gesendet.

OPER_HELP_STATS
	Syntax: STATS [RECORD | AKILL | ALL]
	
	Ohne Einstellung werden alle derzeitigen Benutzer
	und IRCops (ausser den Services), die hchste Zahl
	Benutzer seit die Services gestartet wurden, und
	die Zeit seitdem angezeigt.
	
	Mit der AKILL Einstellung, wird die derzeitige
	Grsse der AKILL list und die voreingestellte
	Ablaufzeit gezeigt.
	
	Die ALL Einstellung ist nur fr Service Admins
	verfgbar, und zeigt den Speicherbedarf der Services an.
	Die Nutzung dieses Befehls kann die Services fr einen
	kurzen Moment einfrieren, deshalb benutze diesen Befehl
	nicht so oft.

	Die BRECORD Einstellung zeigt Daten ber Benutzer 
	insgesamt, Ops, Helfer, und Bot Zahlen.
	
	UPTIME kann als Synonym fr STATS benutzt werden.

OPER_HELP_OPER
	Syntax: OPER ADD nick
	        OPER DEL nick
	        OPER LIST
	        OPER SUSPEND nick Tage
	
	Ermglicht Service Admins der Service Operator Liste
	Nicks hinzuzufgen, zu sperren oder zu lschen.  Ein
	Benutzer dessen Nick auf der Service Operator Liste ist,
	und der sich dem %s identifiziert hat, kann die
	Service Operator Befehle benutzen.
	
	Jeder IRC Operator kann den OPER LIST Befehl
	benutzen. Alle anderen Formen des Befehls sind nur fr
	Service Admins verfgbar.

OPER_HELP_ADMIN
	Syntax: ADMIN ADD nick
	        ADMIN DEL nick
	        ADMIN LIST
	
	Ermglicht dem Service super-user der Service Admin Liste
	Nicks hinzuzufgen, oder zu lschen.  Ein Benutzer dessen
	Nick auf der Service Admin Liste ist, und der sich dem
	%s identifiziert hat, kann die Service Admin
	Befehle benutzen.
	
	Jeder IRC Operator kann den ADMIN LIST Befehl
	benutzen. Alle anderen Formen des Befehls sind nur fr
	den Service root verfgbar.

OPER_HELP_MODE
	Syntax: MODE channel modes
	
	Ermglicht es Service Operators Kanal Modes fr jeden
	Kanal zu setzen.  Die Parameter sind dieselben wie fr
	den standard /MODE Befehl.
	
	Nur fr BService Operator.

OPER_HELP_CLEARMODES
	Syntax: CLEARMODES channel [ALL]
	
	Lscht alle Modes (i,k,l,m,n,p,s,t) und Bans eines
	Kanals.  Wenn ALL angegeben wird, werden auch alle
	Ops und Voices (+o und +v modes) zurckgesetzt.
	
	Nur fr BService Operator.

OPER_HELP_KICK
	Syntax: KICK channel user reason
	
	Ermglicht es IRCops einen Benutzer aus einem Kanal zu
	kicken.  Die Parameter sind dieselben wie fr den
	standard /KICK Befehl.  Die kick-Nachricht wird den Nick
	des ausfhrenden IRCOps enthalten; zum Beispiel:
	
	*** SpamMan has been kicked off channel #my_channel by
	    %S (Alcan (Flood))
	
	Nur fr BService Operator.

OPER_HELP_AKILL
	Syntax: AKILL ADD [+expiry] mask reason
	        AKILL DEL mask
	        AKILL LIST [mask]
	        AKILL VIEW [mask]
	
	Ermglicht Service Operatorn die AKILL Liste zu
	bearbeiten.  Wenn ein Benutzer der auf eine AKILL Maske
	passt sich anmeldet, wird er von den Services gekillt
	und, auf untersttzten Servern Typen, wird ein Bann
	(K-Line) eingerichtet.
	
	AKILL ADD fgt die angegebene user@host Maske mit dem
	angegebenen Grund (welcher angegeben werrden muss) zu
	der AKILL Liste hinzu. AKILL DEL lscht die
	angegebene Maske aus der AKILL Liste, wenn sie dort
	vorhanden ist.  AKILL LIST zeigt alle aktuellen
	AKILLs; wenn die optionale Maske angegeben wird, werden
	nur die passenden AKILLs ausgegeben. AKILL VIEW ist
	eine ausfhrlichere Version von AKILL LIST, und zeigt
	an, wer den AKILL hinzugefgt hat, den Zeitpunkt als er
	eingerichtet wurde, wann er abluft, und die user@host
	Maske und den Grund.
	
	Ausserdem kann eine Ablaufzeit mit dem AKILL ADD
	Befehl angegeben werden.  Die Ablaufzeit geht der
	user@host Maske voraus, und wird als ganze Zahl mit
	einem folgenden d (Tage), h (Stunden), oder
	m (Minuten) angegeben. Kombinationen (wie
	1h30m) sind nicht mglich.  Wenn eine Einheit
	nicht angegeben wird, wird von Tagen ausgegangen
	(also wird mit +30 die Ablaufzeit auf 30 Tage
	gesetzt). Um einen AKILL einzutragen der nicht
	abluft, benutze +0. Wenn die angegebene
	Benutzermaske mit einem + beginnt muss eine
	Ablaufzeit angegeben werden, auch wenn es dieselbe
	ist wie die Voreinstellung.  Die aktuelle AKILL
	Ablaufzeit kann mit dem STATS AKILL Befehl
	abgerufen werden.
	
	Das reason Feld ist nur fr IRC Operator
	gedacht, und wird dem Benutzer in der KILL
	Nachricht nicht angezeigt.
	
	Nur fr Service Operator.

OPER_HELP_SET
	Syntax: SET option setting
	
	Setzt verschiedene globale Service Einstellungen.  Die
	Namen, die derzeit definiert sind, sind:
	 READONLY  Setzt den read-only oder read-write Modus
	 DEBUG      Aktiviert oder Deaktiviert den debug
	                Modus
	
	Nur fr Service Admins.

OPER_HELP_SET_READONLY
	Syntax: SET READONLY {ON | OFF}
	
	Schaltet den read-only Modus an oder aus.  Im read-only
	Modus knnen normale Benutzer keine Service Daten (z.B.
	Kanal und Nick Zugangslisten usw) ndern.  IRCops mit
	ausreichenden Service Privilegien knnen die AKILL Liste
	ndern und Nicks und Kanle lschen oder verbieten, aber
	alle nderungen werden nicht gesichert bis der read-only
	Modus deaktiviert wird, bevor der Service beendet oder
	neu gestartet wird.
	
	Diese Einstellung ist equivalent der Kommandozeilenoption
	-readonly.

OPER_HELP_SET_DEBUG
	Syntax: SET DEBUG {ON | OFF | num}
	
	Schaltet den Debug Modus ein oder aus.  Im debug Modus
	werden alle Daten die an den Service oder von dem Service
	geschickt werden mit weiteren debugging Nachrichten in
	die Logdatei geschrieben.  Wen num angegeben wird,
	wird der Debug Modus mit der Stufe num aktiviert.
	
	Diese Einstellung ist equivalent der Kommandozeilenoption
	-debug.

OPER_HELP_JUPE
	Syntax: JUPE server [reason]
	
	Veranlasst die Services einen server zu "jupitern" -- das
	bedeutet, einen geflschten Server zu simulieren, welcher
	den richtigen Server mit dem angegebenen Namen davon
	abhlt sich zu verbinden.  Der jupe kann mit einem
	standard SQUIT gelscht werden.  Wenn ein Grund
	angegeben wird, wird dieser im Server Informationsfeld
	eingetragen; sonst enthlt dieses Feld den text
	"Jupitered by <nick>", mit dem Nick des Benutzers der den
	Befehl eingegeben hat.
	
	Nur fr Service Admins

OPER_HELP_RAW
	Syntax: RAW text
	
	Schickt eine Zeichenkette direkt zu dem Server an den die
	Services konnektiert sind.  Der Befehl hat einen sehr
	eingeschrnkten Nutzen, und kann groe Probleme in einem
	Netzwerk auslsen, wenn er unsachgem eingesetzt wird.
	BENUTZE DIESEN BEFEHL NICHT solange Du nicht weit
	was Du tust!
	
	Nur fr Service Admins.

OPER_HELP_UPDATE
	Syntax: UPDATE
	
	Lt die Services alle Datenbank-Dateien aktualisieren.
	
	Nur fr Service Admins.

OPER_HELP_QUIT
	Syntax: QUIT
	
	Beendet sofort die Services; Datenbanken werden
	nicht gesichert.  Dieser Befehl sollte nicht
	benutzt werden, auer wenn Beschdigungen an den
	Datenbanken im Speicher befrchtet werden, und
	diese nicht abgespeichert werden sollen.
	Fr normales Beenden, benutze den SHUTDOWN Befehl.
	
	Nur fr Service Admins.

OPER_HELP_SHUTDOWN
	Syntax: SHUTDOWN
	
	Speichert die Datenbanken und beendet die Services.
	
	Nur fr Service Admins.

OPER_HELP_RESTART
	Syntax: RESTART
	
	Speichert die Datenbanken und startet die Services neu.
	(das heit beenden und sofortiges neu starten der
	ausfhrbaren Datei).
	
	Nur fr Service Admins.

OPER_HELP_REHASH
	Syntax: REHASH
	
	Ldt die services.conf neu.  ACHTUNG:
	Text-Parameter werden nicht gendert um die
	Integritt des Services zu erhalten.
	
	Nur fr Service Admins.

OPER_REHASH_DONE
	Service Konfiguration ist neu gelesen.

OPER_REHASH_ERROR
	Ein Fehler trat beim Laden der Konfiguration auf.

CHAN_LEVEL_PROTECT
	Schtzt einen Benutzer vor De-Op oder Kick aus
	einem Kanal.

NICK_AUTORECON
	Zugangs-Listen-Erkennung.

NICK_HELP_SET_AUTOJOIN
	Syntax: SET AUTOJOIN {ON | OFF}
	
	Aktiviert oder Deaktiviert Auto-Join auf Kanlen.  Wenn
	aktiviert, Lt Dich %S die Kanle betreten die
	auf Deiner AJOIN LIST gefunden werden.

NICK_SET_AUTOJOIN_ON
	Auto-Join ist nun On

NICK_SET_AUTOJOIN_OFF
	Auto-Join ist nun Off

NICK_SET_AUTOJOIN_SYNTAX
	Syntax: SET AUTOJOIN {ON | OFF}

NICK_HELP_AJOIN
	Syntax: AJOIN { ADD | DEL | LIST } [#channel]
	
	ndert oder zeigt die Auto Join Liste fr Deinen
	Nick. Dies ist die Liste der Kanle die Du nach
	der Identifizierung betrittst, wenn AUTOJOIN
	eingeschaltet ist.
	
	Benutze /msg %S AJOIN NOW wenn Du alle Kanle
	Deiner Auto Join Liste betreten willst.

NICK_AJOIN_LIST_X
	Auto Join Liste fr %s:

NICK_AJOIN_SYNTAX
	Syntax: AJOIN { ADD | DEL | LIST } [#channel]

NICK_AJOIN_REACHED_LIMIT
	Sorry, aber Du kannst maximal %d Kanle eintragen.

NICK_AJOIN_ALREADY_PRESENT
	Kanal ist bereits auf der Liste.

NICK_AJOIN_ADDED
	Kanal %s wurde der Liste hinzugefgt.

NICK_AJOIN_NOT_FOUND
	Kanal %s wurde auf Deiner Liste
	nicht gefunden.

NICK_AJOIN_DELETED
	Kanal %s wurde von Deiner Liste gelscht.

NICK_AJOIN_LIST
	Auto Join Liste:

NICK_INFO_OPT_AUTOJOIN
	Auto Join

BAD_CHAN_NAME
	Kanal mu in der Form #Kanal sein.

OPER_IDENTIFY_REQUIRED
	
	Die Sicherheit-Regeln beschrnken Oper auf identifizierte
	und bei OperServ registrierte Nicks.  Bitte kontaktiere
	Deinen IRC Admin fr weitere Informationen.

NICK_ALREADY_IDENTIFIED
	Dieser Nick ist bereits identifiziert.
TODAYSTATS
	Statistik fr heute (%s):
STATS_TOTAL
	     Gesamt: %d
STATS_REGISTERED
	Registriert: %d
STATS_DROPPED
	   Gelscht: %d
STATS_EXPIRED
	 Abgelaufen: %d
STATS_BALANCE
	    Balance: %s
OPER_HELP_BOTLIST
	Syntax:
	     BOT ADD hostname maxcon reason
	     BOT DEL  hostname
	     BOT LIST [mask]
	     BOT VIEW [mask]
	
	Ermglicht es Service Operatoren die BOT Liste zu
	ndern. Wenn ein Benutzer den Clone-Schutz auslst, aber
	der Host-Name in der BOT ist, wird er nicht gekillt.
OPER_TOO_MANY_BOTLIST
	Sorry, BOT Liste ist voll.
OPER_BOTLIST_NO_NICK
	Du kannst keine Nicks auf der BOT Liste benutzen.
OPER_BOTLIST_ADDED
	Neuer BOT Listen Eintrag fr %s hinzugefgt.
OPER_BOTLIST_ADD_SYNTAX
	BOT ADD hostname maxcon reason
OPER_BOTLIST_DEL_SYNTAX
	BOT DEL hostname reason
BOTLIST_REMOVED
	Eintrag %s aus der BOT Liste gelscht.
OPER_BOTLIST_NOT_FOUND
	Host-Name %s wurde nicht auf der
	BOT Liste gefunden.
OPER_BOTLIST_HEADER
	Aktuelle Bot-Liste:
# mask, reason	
OPER_BOTLIST_FORMAT
	%-32s %d : %s
#mask, set-by, set-time, reason
OPER_BOTLIST_VIEW_FORMAT
	%s (von %s am %s)
	   %s
OPER_BOTLIST_SYNTAX
	BOT {ADD | DEL | LIST | VIEW} hostname [maxcon reason]
CHAN_INFO_SUCCESSOR
	        Nachfolger: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	        Nachfolger: %s
NICK_SHOULD_REGISTER
	Dieser Nick ist nicht registriert, wenn Du ihn in der
	Zukunft benutzen willst, solltest Du ihn mit
	/msg %s REGISTER password email registrieren.
	Wenn Du keine Mail-Adresse hast, trage NOMAIL ein.
CHANGE_IN_1_MINUTE
	Wenn Du den Nick nicht innerhalb einer Minute nderst,
	wird er automatisch gendert.
NICK_AJOIN_EMPTY
	Auto-Join Liste ist leer
FEATURE_DISABLED
	Funktion auf diesem Server nicht verfgbar
CHAN_ACCESS_LIST_FORMAT2
	  %3d  %4d  %s%s%s%s von %s
NICK_AUTORECON_R
	Automatische Nick-Erkennung in +r Modus.
NICK_STATUS_0
	STATUS fr %s : 0 - Benutzer nicht da, oder Nick
	nicht registriert
NICK_STATUS_1
	STATUS fr %s : 1 - Benutzer nicht als
	Nick-Eigentmer erkannt
NICK_STATUS_2
	STATUS fr %s : 2 - Benutzer als Nick-Eigentmer
	durch die Zugangs-Liste erkannt
NICK_STATUS_3
	STATUS fr %s : 3 - Benutzer als Nick-Eigentmer
	durch Passwort Identifikation erkannt
OPER_HELP_SQLINE
	Syntax: SQLINE ADD nick reason
	        SQLINE DEL  nick
	        SQLINE LIST [mask]
	        SQLINE VIEW [mask]
	
	Ermglicht es Service Operators die SQLINE Liste zu
	ndern.  Ein geSQLINEter Nick kann nicht benutzt werden.
OPER_TOO_MANY_SQLINE
	Sorry, SQLINE Liste ist voll.
OPER_SQLINE_JUST_NICK
	Du kannst nur Nicks/Masken in der SQLINE Liste benutzen.
OPER_SQLINE_ADDED
	Neue SQLINE fr %s hinzugefgt.
OPER_SQLINE_ADD_SYNTAX
	SQLINE ADD nick reason
OPER_SQLINE_DEL_SYNTAX
	SQLINE DEL nick reason
OPER_SQLINE_REMOVED
	SQLINE %s gelscht aus der sqline Liste gelscht.
OPER_SQLINE_NOT_FOUND
	SQLINE fr %s wurde nicht gefunden.
OPER_SQLINE_HEADER
	Aktuelle SQLINE Liste:
# mask, reason	
OPER_SQLINE_FORMAT
	%-32s %s
#mask, set-by, set-time, reason
OPER_SQLINE_VIEW_FORMAT
	%s (von %s am %s)
	   %s
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW} nick [reason]
BAD_EMAIL_ADDRESS
	Falsche Email Adresse!
	Bitte Benutzer user@mailserver oder NOMAIL.
BAD_ICQNUMBER
	Falsche ICQ Nummer!
	Bitte gib #icqnummer ein.
BAD_LOCATION
	Kein Standort!
	Bitte gib einen krzeren Standort ein.
CHAN_DROP_AT
	Der Kanal wird in %d Tagen gelscht.
CHAN_DROP_CANCEL
	Die Lschung fr Kanal %s wurde zurckgezogen.
NICK_DROP_AT
	Der Nick wird in %d Tagen gelscht.
NICK_DROP_CANCEL
	Die Lschung des Nicks %s wurde zurckgezogen.
OPER_STATS_USERS_RECORD
	Benutzer Rekord war %d am %s
	Derzeit sind es %d Benutzer (%d%)
	-
OPER_STATS_OPERS_RECORD
	Oper Rekord war %d am %s
	Derzeit sind es %d Oper (%d%)
	-
OPER_STATS_HELPERS_RECORD
	Helfer Rekord war %d am %s
	Derzeit sind es %d Helfer (%d%)
	-
OPER_STATS_BOTS_RECORD
	Bot Rekord war %d am %s
	Derzeit sind es %d Bots (%d%)
	-
NEWSS_HELP
	%S bietet die die Mglichkeit Online News nach
	Bestellung zu lesen.
	
	Es gibt verschiedene Befehle die Du mit
	/msg %S command benutzen kannst.  Fr
	weitere Informationen zu einem speziellen Befehl, tippe
	/msg %S HELP command.
	
	 LIST         Liste der verfgbaren Subjekts und
	              Abonnierungen
	 SUBSCRIBE    Abonniere ein Subjekt
	 UNSUBSCRIBE  Bestelle ein Subjekt ab
	 SET          Setze Einstellungen.
	 RECENT       Zeige die neuesten News
NEWSS_HELP_OPER
	
	News Operator Befehle:
	 SEND        Schickt eine News Nachricht
	 VIEW        Zeigt aktuelle Liste mit detaillierten
	             Informationen
	 DEL         Lscht einen Eintrag der aktuell
	             gelieferten News
	 OPER LIST   Zeigt News Operators
	 ADMIN LIST  Zeigt News Admins
NEWSS_HELP_ADMIN
	
	News Administrator Befehle:
	 SUBJECT  ndert Subjekt Liste
	 OPER     Fgt News Operators hinzu oder lscht Sie
NEWSS_HELP_SADMIN
	Service Administrator Befehl:
	 ADMIN  Fgt News Admins hinzu oder lscht sie
NEWSS_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [nick]
NEWSS_OPER_ADD_SYNTAX
	OPER ADD nick
NEWSS_OPER_DEL_SYNTAX
	OPER DEL nick
NEWSS_OPER_SKELETON
	Services sind im Skeleton Modus; der OPER Befehl ist
	nicht verfgbar.
NEWSS_OPER_EXISTS
	%s ist bereits auf der News Operator Liste.
NEWSS_OPER_ADDED
	%s wurde der News Operator Liste hinzugefgt.
NEWSS_OPER_TOO_MANY
	Zu viele Eintrge (%d) auf der News Operator Liste;
	kann keine Neuen hinzufgen.
NEWSS_OPER_REMOVED
	%s wurde aus der News Operator Liste gelscht.
NEWSS_OPER_NOT_FOUND
	%s wurde auf der News Operator Liste
	nicht gefunden.
NEWSS_OPER_LIST_HEADER
	News Operator Liste:
	
NEWSS_OPER_HELP
	Syntax: OPER ADD nick
	        OPER DEL nick
	        OPER LIST
	
	Ermglicht es News Admins Nicks der News Operator
	Liste hinzuzufgen oder zu lschen.  Ein Benutzer
	dessen Nick auf der News Operator Liste ist und der
	sich %s identifiziert hat, hat Zugriff auf die
	News Operator Befehle.
	
	Jeder News Operator kann den OPER LIST Befehl
	benutzen, alle anderen Formen des Befehls sind nur fr
	News Admins verfgbar.

# News Server ADMIN responses
NEWSS_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [nick]
NEWSS_ADMIN_ADD_SYNTAX
	ADMIN ADD nick
NEWSS_ADMIN_DEL_SYNTAX
	ADMIN DEL nick
NEWSS_ADMIN_SKELETON
	Services sind im Skeleton Modus; der ADMIN Befehl ist
	nicht verfgbar.
NEWSS_ADMIN_EXISTS
	%s ist bereits auf der News Admin Liste.
NEWSS_ADMIN_ADDED
	%s wurde der News Admin Liste hinzugefgt.
NEWSS_ADMIN_TOO_MANY
	Zu viele Eintrge (%d) auf der News Admin Liste; kann
	keine Neuen hinzufgen.
NEWSS_ADMIN_REMOVED
	%s wurde aus der News Admin Liste gelscht.
NEWSS_ADMIN_NOT_FOUND
	%s wurde auf der News Admin Liste
	nicht gefunden.
NEWSS_ADMIN_LIST_HEADER
	News Admin Liste:
	
NEWSS_SUBJECT_HELP
	Syntax: SUBJECT number subject
	
	Ermglicht die nderung/Anlegung einen Subjekt Eintrag
	auf der %S Subjekt Liste.
	
NEWSS_SUBJECT_SYNTAX
	SUBJECT number subject
NEWSS_SUBJECT_ERROR
	Nummer mu zwischen 1 und %d liegen.
NEWSS_LIST_HELP
	Der LIST Befehl gibt eine Liste der verfgbaren
	Subjekts aus und ob sie eines bestellt haben oder nicht.
	Die mit X markierten Subjekt sind bestellt. Um zu
	bestellen/abzubestellen benutze die SUBCRIBE
	UNSUBSCRIBE Befehle.

NEWSS_LIST_HEADER
	Nr Subs Subjekt
	
NEWSS_LIST
	%2d  %c   %s
NEWSS_LIST_END
	Ende der Subjekt Liste
NEWSS_SUBJECT_NOTFOUND
	Das Subjekt Nummer %d existiert nicht!
NEWSS_SUBJECT_CHANGED
	Subjekt gendert von %s zu %s.
NEWSS_SUBJECT_CREATED
	Subjekt %s erstellt.
NEWSS_SUBSCRIBE_SYNTAX
	SUBSCRIBE  number [,number] | ALL
NEWSS_SUBSCRIBE_HELP
	Syntax: SUBSCRIBE  number [,number] | ALL
	
	Dieser Befehl ermglicht es Dir ein Subjekt zu bestellen.
	Du kannst mehrere Subjekts mit einem Befehl bestellen,
	indem Du die Nummern mit Kommata trennst.
NEWSS_SUBSCRIBE_SUBSCRIBED
	Du hast %d Subjekts bestellt.
NEWSS_UNSUBSCRIBE_SYNTAX
	UNSUBSCRIBE  number [,number] | ALL
NEWSS_UNSUBSCRIBE_HELP
	Syntax: UNSUBSCRIBE number [,number] | ALL
	
	Dieser Befehl ermglicht es Dir ein Subjekt
	abzubestellen.  Du kannst mehrere Subjekts mit
	einem Befehl abbestellen, indem Du die Nummern
	mit Kommata trennst.
NEWSS_UNSUBSCRIBE_UNSUBSCRIBED
	Du hast %d Subjekts abbestellt.
NEWSS_SEND_SYNTAX
	SEND number news message
NEWSS_SEND_HELP
	Syntax: SEND  number news message
	
	Ermglicht es News Opers/Admins News Nachrichten
	zu verschicken.
NEWSS_SEND_SENT
	News ist verschickt.
NEWSS_SET_SYNTAX
	SET option parameters
NEWSS_SET_HELP
	Syntax: SET option parameters
	
	Setzt verschiedene %S Einstellungen. option
	kann eins von:
	 NOTICE  Setzt News Empfang Modus Notice/Message.
NEWSS_SET_NOTICE_SYNTAX
	SET NOTICE [ON | OFF]
NEWSS_SET_NOTICE_HELP
	Syntax: SET NOTICE [ON | OFF]
	
	Wenn notice aktiviert ist, wirst Du News ber notices
	empfangen, wenn es aus ist ber Private Messages.
NEWSS_SET_NOTICE_ON
	NOTICE Einstellung ist nun ON
NEWSS_SET_NOTICE_OFF
	NOTICE Einstellung ist nun OFF
NEWSS_RECENT_HELP
	Syntax: RECENT
	
	Zeige die neuesten News.
NEWSS_RECENT_HEADER
	Neueste News Liste
NEWSS_RECENT_LIST
	%s : %s
NEWSS_RECENT_END
	Ende der Neueste News Liste.
NEWSS_VIEW_HELP
	Syntax: VIEW
	
	Zeige die neuesten News mit detailliertem Informationen,
	Subjekt 0 steht fr gelschte Beitrage.
NEWSS_VIEW_HEADER
	Nr. : Sub. : Zeit : News (Sender)
NEWSS_VIEW_LIST
	%s%2d : %2d : %s : %s (%s)%s
NEWSS_DEL_SYNTAX
	DEL number
NEWSS_DEL_HELP
	Syntax: DEL number
	
	Dieser Befehl lscht einen Eintrag von der aktuellen News
	Liste. number ist die Nummer der News von der ersten
	Spalte von /msg %S VIEW. Der gelschte Eintrag
	wird nicht auf der /msg %S RECENT Liste
	angezeigt, aber wird auf der /msg %S VIEW
	Liste als gelscht angezeigt.
NEWSS_DEL_NOTEXIST
	News Nummer %d existiert nicht.
NEWSS_DEL_DELETED
	News Nummer %d wurde gelscht.
NICK_INFO_PRIVATE
	Nick Information fr %s ist privat.
CHAN_INFO_PRIVATE
	Kanal Information fr %s ist privat.
CHAN_NEED_REGNICK
	Du mut einen registrierten Nick haben, um diesen Kanal
	zu betreten!
CHAN_MODE_PROTECTED
	Dieser Kanal benutzt den Join Schutz Modus.
NEWS_REC_PLEASE_WAIT
	Bitte warte %d Sekunden bevor Du den RECENT Befehl
	erneut benutzt.
NICK_HELP_NOTES
	Ermglicht es einem Benutzer Text Notizen zu speichern.
	Benutze /msg %S NOTES ADD text um eine
	Notiz zu speichern,
	/msg %S NOTES DEL number um eine Notiz zu
	lschen und /msg %S NOTES LIST um alle
	gespeicherten Notizen zu zeigen.
NICK_NOTES_SYNTAX
	LIST | ADD text | DEL number
NICK_NOTES_ADDED
	Notiz wurde munter der Nummer %d gespeichert.
NICK_NOTES_NOADD
	Du hast die maximale Anzahl (%d) von Notizen
	empfangen, die Deinem Nick gestattet sind, bitte
	lsche einige alte Notizen bevor Du versuchst eine
	Neue hinzuzufgen.
NICK_NOTES_DELETED
	Notiz Nummer %d wurde gelscht.
NICK_NOTES_NOTFOUND
	Notiz Nummer %d wurde nicht gefunden.
NICK_NOTES_LIST_HEADER
	Keine Notiz
NICK_NOTES_LIST
	%2d %s
NICK_NOTES_NONOTES
	Notiz Liste ist leer.
CHAN_ACCESS_CLEARALL
	Zugangs-Liste ist nun leer.
CHAN_AKICK_CLEARALL
	AKICK Liste ist nun leer.
NICK_STATUS_SYNTAX
	STATUS nick
NICK_X_ISFOUNDER
	Nick %s ist der Founder und kann nicht
	gleichzeitig der Nachfolger sein.
NICK_X_ISSUCCESSOR
	Nick %s ist Kanal Nachfolger und kann nicht
	gleichzeitig der Founder sein.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limit | VIEW hostname | TRACE hostname }
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limit
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	Sitzung-Beschrnkung ist abgeschaltet.
OPER_SESSION_INVALID_THRESHOLD
	Ungltiger threshold Wert. Es mu eine gltige ganze
	Zahl grerer als 1 sein.
OPER_SESSION_NOT_FOUND
	%s nicht in der Sitzung-Liste gefunden.
OPER_SESSION_LIST_HEADER
	Hosts mit mindestens %d Sitzungen:
OPER_SESSION_LIST_COLHEAD
	Sitzung   Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	Der Host %s hat derzeit %d Sitzungen
	mit einer Obergrenze von %d.
OPER_SESSION_EXCEEDED
	Netzwerk Sicherheit lehnt weitere Verbindungen von Deinem
	Host ab.
OPER_HELP_SESSION
	Syntax: SESSION LIST threshold
	        SESSION VIEW host
	        SESSION TRACE host
	
	Ermglicht Service Operators Du Sitzung-Liste anzusehen.
	
	SESSION LIST zeigt Hosts mit mindestens threshold
	Sitzungen.  Der threshold mu eine Zahl grerer 1 sein.
	Dieses verhindert das versehentlich eine groe Anzahl von
	Hosts mit einer Sitzung angezeigt wird.
	
	SESSION VIEW zeigt detaillierte Informationen ber
	einen bestimmten Host - inklusive der Anzahl der
	aktuellen Sitzungen und die Sitzung-Obergrenze. Die
	host Einstellung darf keine Masken enthalten.
	
	SESSION TRACE zeigt die Liste der Benutzer die ber
	den Host konnektiert sind. Die host Einstellung darf
	keine Masken enthalten.
OPER_HELP_VLINE
	Syntax: VLINE ADD file reason
	        VLINE DEL  file
	        VLINE LIST [pattern]
	        VLINE VIEW [pattern]
	
	Ermglicht Service Operators die nderung der VLINE
	Liste. V-Lined Datei Masken verhindern DCC SENDs und
	setzen den Absender auf +v soda sie keine weiteren
	SENDs schicken knnen.
OPER_TOO_MANY_VLINE
	Sorry, VLINE Liste ist voll.
OPER_VLINE_JUST_NICK
	Du kannst nur Dateien/Masken auf der
	VLIST Liste benutzen.
OPER_VLINE_ADDED
	Neue VLINE hinzugefgt fr %s
OPER_VLINE_ADD_SYNTAX
	VLINE ADD file reason
OPER_VLINE_DEL_SYNTAX
	VLINE DEL file reason
OPER_VLINE_REMOVED
	VLINE %s von der V-Line Liste gelscht
OPER_VLINE_NOT_FOUND
	VLINE %s nicht auf der Liste gefunden.
OPER_VLINE_HEADER
	Aktuelle VLINE Liste:
# mask, reason	
OPER_VLINE_FORMAT
	%-32s %s
#mask, set-by, set-time, reason
OPER_VLINE_VIEW_FORMAT
	%s (von %s am %s)
	   %s
OPER_VLINE_SYNTAX
	VLINE {ADD | DEL | LIST | VIEW} nick [reason]
OPER_SESSION_TRACE_SYNTAX
	TRACE host
OPER_SESSION_TRACE_BEGIN
	Liste die Sitzungen fr %s:
OPER_SESSION_TRACE_FORMAT
	    %s
OPER_SESSION_TRACE_END
	Ende der Sitzung-Liste
AGO_TIME_D
	vor %d Tag(en), %d Stunde(n), %d Minute(n) und %d Sekunde(n).
AGO_TIME
	vor %d Tag(en), %d Minute(n) und %d Sekunde(n).
TOTAL_TIME
	%d Tag(e), %d Stunde(n), %d Minute(n) und %d Sekunde(n).
OPER_OPER_SUSPENDED
	Oper %s ist nun fr %d Tage gesperrt.
OPER_OPER_UNSUSPEND
	Oper Sperrung fr %s wurde gelscht.
OPER_OPER_SUSPEND_SYNTAX
	OPER SUSPEND nick Tage
CHAN_HELP_AOP
	Alias fr die AUTOOP Zugangsliste.
	AOP ADD fgt den Nick mit AUTOOP level zu der Kanal
	Zugangsliste hinzu.
	AOP LIST zeigt alle Kanal Zugangseintrge mit
	AUTOOP level an.
CHAN_AOP_SYNTAX
	AOP ADD nick | DEL nick | LIST
CHAN_HELP_SOP
	Alias fr das ACC-CHANGE Zugangslistenmanagement.
	SOP ADD fgt den Nick mit ACC-CHANGE level zu der Kanal
	Zugangsliste hinzu.
	SOP LIST zeigt alle Kanal Zugangseintrge mit
	ACC-CHANGE level an.
CHAN_SOP_SYNTAX
	SOP ADD nick | DEL nick | LIST
CHAN_AJOIN_ADD
	Du solltest Deiner ajoin Liste den Kanal mit
	/msg %s AJOIN ADD %s hinzufgen.

# SENDPASS responses
OPER_SENDPASS_SYNTAX
	SENDPASS ^_nickname^_
OPER_SENDPASS_NOSENDMAIL
	SENDPASS Befehl ist nicht verfgbar, weil sendmail nicht
	gefunden wurde.
OPER_SENDPASS_UNAVAILABLE
	SENDPASS Befehl ist nicht verfgbar, weil Kodierung
	aktiviert ist.
OPER_SENDPASS_NOMAIL
	Nick %s hat keine Email-Adresse angegeben.
OPER_SENDPASS_SUBJECT
	Nickname passwort (%s)
OPER_SENDPASS_HEAD
	Hallo,
OPER_SENDPASS_LINE_1
	Du hast das Passwort von Nick %s per Email angefordert.
OPER_SENDPASS_LINE_2
	Das Passwort ist '%s'. Aus Sicherheitsgruenden solltest
	Du es so bald wie mglich ndern.
OPER_SENDPASS_LINE_3
	Wenn Du nicht weisst warum Du diese Mail bekommen hast,
	dann ignoriere sie bitte.
OPER_SENDPASS_LINE_4
	Bitte antworte nicht auf diese eMail!
OPER_SENDPASS_LINE_5
	PTlink Services - http://www.ptlink.net
OPER_SENDPASS_OK
	Passwort von %s wurde verschickt.
MAIL_LATER
	Kann derzeit keine Mail verschicken; Bitte probier es
	spter noch einmal.
MAIL_DELAYED
	Bitte warte %d Sekunden und versuche es dann 
	noch einmal.
OPER_HELP_SENDPASS
	Syntax: SENDPASS nickname
	
	Schicke das Passwort des angegebenen Nicks an die
	Email-Adresse die dem Nick zugeordnet ist. Dieser
	Befehl ist ntzlich um Benutzern das vergessene
	Passwort mitzuteilen.
	
	Kann in bestimmten Netzen auf IRC Operaters
	begrenzt sein.
	
	Dieser Befehl ist nicht verfgbar, wenn Kodierung
	aktiviert ist.
CHAN_RESTRICT_REGISTER
	Kanalregistrierung ist in diesem Netz nur fr Services
	Operators mglich!
OPER_GETFOUNDER_SYNTAX
	GETFOUNDER #channel
MEMO_WILL_EXPIRE
	Dein Memo %s werden bald ablaufen.
MEMO_HAVE_EXPIRED
	Dein Memo %s ist abgelaufen.
UPDATE_IN_PROGRESS
	Aktualisierung, gestartet von %s, laeuft.
UPDATE_DONE
	Aktualisierung in %d Sekunde(n) durchgefuehrt.
CHAN_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE]
