/* Initalization and related routines.
 *
 * PTlink Services is (C) CopyRight PTlink Coders Team 1999-2003
 * http://www.ptlink.net/Coders - coders@PTlink.net
 * This program is distributed under GNU Public License
 * Please read the file COPYING for copyright information.
 *
 * $Id: mysql.c,v 1.3 2004/03/25 17:14:58 jpinto Exp $
 */
/* MySQL functions.
 *
 * (C) 2003 Anope Team
 * Contact us at info@anope.org
 *
 * Please read COPYING and CREDITS for furhter details.
 *
 * Based on the original code of Epona by Lara.
 * Based on the original code of Services by Andy Church. 
 * 
 * $Id: mysql.c,v 1.3 2004/03/25 17:14:58 jpinto Exp $ 
 *
 */
#include "sysconf.h"
#include "services.h"

#if HAVE_MYSQL
#include <mysql/errmsg.h>
#include <mysql/mysql.h>
#include "stdinc.h"
#include "mysql.h"

/*************************************************************************/

/* Database Global Variables */
MYSQL *mysql;                   /* MySQL Handler */
MYSQL_RES *mysql_res;           /* MySQL Result  */
MYSQL_FIELD *mysql_fields;      /* MySQL Fields  */
MYSQL_ROW mysql_row;            /* MySQL Row     */

/*************************************************************************/

#define NR_INSERT_FIELDS \
      "snid, nick, rtype," \
      "t_reg, t_ident, t_seen, t_sign," \
      "pass, req_email, email, url, imid, location, ontime," \
      "username, realhost,  info,  nmask,  ajoin," \
      "status,  flags, memoscount, authcode, lang," \
      "master_snid, max_members"
#define NR_INSERT_PARAM \
      "0, '%s', %d," \
      "FROM_UNIXTIME(%d), FROM_UNIXTIME(%d), FROM_UNIXTIME(%d) ,FROM_UNIXTIME(%d)," \
      "'%s','%s','%s','%s','%s','%s',%d," \
      "'%s', '%s', '%s', %d, '%s'," \
      "%d, %d, %d , '%s', %d," \
      "%d, %d)", \
      qnick, 1, \
      (int) ni->time_registered, (int) ni->last_identify, (int) ni->last_seen, (int)ni->last_signon, \
      qpasswd, qremail, qemail, qurl, qimid, qlocation, ni->online, \
      quser, last_host, qinfo, ni->news_mask, qajoin, \
      ni->status, flags, 0, ni->auth, ni->language, \
      0, 0

#define NR_UPDATE_PARAM \
      "nick='%s', rtype=%d," \
      "t_reg=FROM_UNIXTIME(%d), t_ident=FROM_UNIXTIME(%d), t_seen=FROM_UNIXTIME(%d), t_sign=FROM_UNIXTIME(%d)," \
      "pass='%s', req_email='%s', email='%s', url='%s', imid='%s', location='%s', ontime=%d," \
      "username='%s', realhost='%s', info='%s', nmask=%d, ajoin='%s'," \
      "status=%d, flags=%d, memoscount=%d, authcode='%s', lang=%d," \
      "master_snid=%d, max_members=%d " \
      "WHERE snid=%d", \
      qnick, ni->rtype, \
      (int) ni->t_reg, (int) ni->t_ident, (int) ni->t_seen, (int)ni->t_sign, \
      qpasswd, qremail, qemail, qurl, qimid, qlocation, ni->ontime, \
      quser, ni->realhost, qinfo, ni->nmask, qajoin, \
      ni->status, flags, ni->memoscount, ni->authcode, ni->lang, \
      ni->master_snid, ni->max_members, \
      ni->snid

void db_mysql_error(int severity, char *msg)
{
    static char buf[512];

    if (mysql_error(mysql)) {
        snprintf(buf, sizeof(buf), "MySQL %s %s: %s", msg,
                 severity == MYSQL_WARNING ? "warning" : "error",
                 mysql_error(mysql));
    } else {
        snprintf(buf, sizeof(buf), "MySQL %s %s", msg,
                 severity == MYSQL_WARNING ? "warning" : "error");
    }

    log1(buf);

    if (severity == MYSQL_ERROR) {
        log1("MySQL FATAL error... aborting.");
        exit(0);
    }

}

/*************************************************************************/


int db_mysql_open()
{
    mysql = mysql_init(NULL);

#if 0
    if (MysqlSock) {
        if ((!mysql_real_connect
             (mysql, MySQLHost, MySQLUser, MySQLPass, MySQLDB, 0,
              MysqlSock, 0))) {
            log_perror("Cant connect to MySQL: %s\n", mysql_error(mysql));
            return 0;
        }
    } else {
#endif    
        if ((!mysql_real_connect
             (mysql, MySQLHost, MySQLUser, MySQLPass, MySQLDB, 0,
              NULL, 0))) {
            log1("Cant connect to MySQL: %s\n", mysql_error(mysql));
            return 0;
        }
        log1("MySQL connected to %s", MySQLHost);
#if 0        
    }
#endif
    return 1;

}

/*************************************************************************/

int db_mysql_query(char *sql)
{

    int result, lcv;
    result = mysql_query(mysql, sql);

    if (result) {
        switch (mysql_errno(mysql)) {
        case CR_SERVER_GONE_ERROR:
        case CR_SERVER_LOST:
            /* Reconnect -> 5 tries (need to move to config file) */
            for (lcv = 0; lcv < 5; lcv++) {
                if (db_mysql_open()) {
                    result = mysql_query(mysql, sql);
                    return (result);
                }
                sleep(1);
            }

            /* If we get here, we could not connect. */
            log1("Unable to reconnect to database: %s\n",
                       mysql_error(mysql));
            db_mysql_error(MYSQL_ERROR, "connect");

            /* Never reached. */
            break;

        default:
            /* Unhandled error. */
            return (result);
        }
    }

    return (0);

}

/*************************************************************************/

char* db_mysql_quote(char *sql)
{
    int slen;
    char *quoted;

    if (sql == NULL)
      return strdup("");

    slen = strlen(sql);
    quoted = malloc((1 + (slen * 2)) * sizeof(char));

    mysql_real_escape_string(mysql, quoted, sql, slen);
    return quoted;

}

/*************************************************************************/

/* I don't like using res here, maybe we can pass it as a param? */
int db_mysql_close()
{
    mysql_free_result(mysql_res);
    mysql_close(mysql);
    return 1;
}

int db_mysql_init()
{
  char sqlcmd[MAX_SQL_BUF]; 

  snprintf(sqlcmd, MAX_SQL_BUF,"UPDATE nicks SET status=0 WHERE status<>0");
  if (db_mysql_query(sqlcmd))
    {
      log1("Can't create sql query: %s", sqlcmd);
        db_mysql_error(MYSQL_WARNING, "query");
        return 0;
    }  
  return 1;
}

/*************************************************************************/

/*
 * NickRecord functions
 */
 
/* Insert a new nick record */
int db_mysql_insert_nr(NickInfo* ni)
{
    char *qnick, *quser, *qpasswd, *qemail, *qinfo, *qurl, *qremail;
    char *qajoin, *qlocation, *qimid;
    char *last_username, *last_host;
    char sqlcmd[MAX_SQL_BUF];
    char *tmpmask;
    u_int32_t flags;
    
    tmpmask = strdup(ni->last_usermask);
    last_username = strtok(tmpmask, "@");
    last_host = strtok(NULL, "");
    qnick = db_mysql_quote(ni->nick);    
    flags = 0;

    /* set default flags */    
    flags = FL_REGISTERED;
    if (ni->status & NS_VERBOTEN)    
      flags |= FL_FORBIDDEN;
    if(ni->flags & NI_PRIVATE)    
      flags |= FL_PRIVATE;
    if(ni->crypt_method == 3)
       flags |= FL_ENCRYPTED;
      
    if(last_username)      
      quser = db_mysql_quote(last_username);
    else
      quser = strdup("NULL");
    if(ni->crypt_method==3)
      qpasswd =  strdup(hex_str(ni->pass,16));
    else
      qpasswd = db_mysql_quote(ni->pass);      
    qinfo = db_mysql_quote(ni->last_realname);
    qemail = db_mysql_quote(ni->email);
    qremail = db_mysql_quote(ni->email_request);    
    qurl = db_mysql_quote(ni->url);
/*    qajoin = db_mysql_quote(ni->ajoin); */
    qajoin = strdup("NULL");
    qlocation = db_mysql_quote(ni->location);
    qimid = db_mysql_quote(ni->icq_number);

    snprintf(sqlcmd, MAX_SQL_BUF,
      "INSERT INTO nicks("
      NR_INSERT_FIELDS
      ") VALUES ("
      NR_INSERT_PARAM
      );
    free(qnick);free(quser);free(qpasswd);free(qinfo);free(qemail);
    free(qremail);free(qurl);free(qajoin);free(qlocation);free(qimid);
    free(tmpmask);
    if (db_mysql_query(sqlcmd)) {
        log1("Can't create sql query: %s", sqlcmd);
        db_mysql_error(MYSQL_WARNING, "query");
        return -1;
    }
    return 0;
}

void clear_mysql_db(void)
{
  db_mysql_query("DELETE FROM nicks");
  db_mysql_query("DELETE FROM nicks_memos");
  db_mysql_query("DELETE FROM nicks_notes");  
}
#endif  /* HAVE_MYSQL */
