/*
 *  - VRM list menu tab
 */

#if 0

#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"

// defines

#define STR_LEN 32

// variables

extern int focus,CO_Id,vrm_total;
extern char **vrmfuncs;

static int curvrm=0;

static int VrmName_Id,VrmPath_Id;
static char str32[STR_LEN+1];

// functions

extern void Toolbar();
static void Nothing();

void GetVrmName();
void GetVrmPath();
void VrmUpdate();                       // Update the displays
void NewVrm();
void PickVrm();
void DelVrm();
static int CMP(char *a, char *b);
static int VrmInUse(int spr);

static int GetNumForFilename(char *str);

// GoFocal - The menu tab function.  This is called from the toolbar

void CO_GoFocal()
{
if(focus==4)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;  // Make a 255 character string

focus=4;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(CO_Id);     // And make the button stick inwards

// VRM list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

IG_TextButton(32,64," Add New Function  ",NewVrm,NULL,NULL);
IG_TextButton(32,96," Pick a Function   ",PickVrm,NULL,NULL);
IG_TextButton(32,128," Delete a function ",DelVrm,NULL,NULL);

IG_AddKey(KEY_A,NewVrm);
IG_AddKey(KEY_P,PickVrm);
IG_AddKey(KEY_D,DelVrm);

DrawSunkBox3D(300,56,620,460);

setcolor(ITG_WHITE);
DrawScreenText(320,64,"VRM Function name:");
VrmName_Id = IG_InputButton(320,80,str32,GetVrmName,NULL,NULL);

DrawScreenText(320,112,"VRM filename:");
VrmPath_Id = IG_InputButton(320,128,str32,GetVrmPath,NULL,NULL);

IG_AddKey(KEY_N,GetVrmName);
IG_AddKey(KEY_F,GetVrmPath);

VrmUpdate();
}

// Callback for a null event

void Nothing()
{
return;
}


// Callback for Setting the sprite description

void GetVrmName()
{
//if(curspr<SPtot)
    InputString(-1,-1,"Enter the new description of the function",32,PElist[curvrm].name);
VrmUpdate();
}

// Callback for Setting the sprite filename

void GetVrmPath()
{
char oldpath[128];

strcpy(oldpath,PElist[curvrm].fname);
InputNameFromListWithFunc(-1,-1,"Choose a VRM file:",vrm_total-1,vrmfuncs,5,PElist[curvrm].fname,0,0,NULL);
if(!PElist[curvrm].fname[0])
    strcpy(PElist[curvrm].fname,oldpath);
else
    {
//    Init_Sprite(curspr);
//    SPedit[curspr].image = SPlist[GetNumForFilename(SPedit[curspr].fname)].image;
    }
VrmUpdate();
}

// Function for updating the display

void VrmUpdate()
{
int num;
// Update the sprite number

//sprintf(SprNoStr,"%d",curspr);
//IG_UpdateText(SprNo_Id,SprNoStr);

// Clear the sprite's name and path, set to proper value later, if valid no.
IG_UpdateText(VrmPath_Id,"");
IG_UpdateText(VrmName_Id,"");

if(!COlist[curvrm].name || !COlist[curvrm].fname)
    num = -1;
else
    {
    num = GetNumForFilename(COlist[curvrm].fname);
    IG_UpdateText(VrmPath_Id,COlist[curvrm].fname);
    IG_UpdateText(VrmName_Id,COlist[curvrm].name);
    }
}

int GetNumForFilename(char *str)
{
if(!str)
    return -1;
for(int ctr=0;ctr<vrm_total;ctr++)
    if(COlist[ctr].fname)
    if(!stricmp(COlist[ctr].fname,str))
        return ctr;
return -1;
}

void PickVrm()
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(vrm_alloc,sizeof(char *));

for(ctr=0;ctr<vrm_alloc;ctr++)
    if(COlist[ctr].name && COlist[ctr].fname)
        mlist[num++]=COlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,COlist[curvrm].name);
InputNameFromListWithFunc(-1,-1,"Choose a function:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,COlist[curvrm].name);

M_free(mlist);

for(ctr=0;ctr<vrm_alloc;ctr++)
    if(COlist[ctr].name != NULL)
    if(!stricmp(COlist[ctr].name,name))
        {
        curvrm=ctr;
        VrmUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void NewVrm()
{
long ctr;
for(ctr=0;ctr<vrm_alloc;ctr++)
    if(!COlist[ctr].name)
        {
        curvrm=ctr;
        COlist[curvrm].fname = (char *)M_get(1,64);
        COlist[curvrm].name = (char *)M_get(1,64);
        strcpy(COlist[curvrm].fname,"NONE");
        strcpy(COlist[curvrm].name,"NONE");
        VrmUpdate();

        GetVrmPath();
        GetVrmName();

        return;
        }

Notify(-1,-1,"Cannot create a new VRM function.","Increase the value of MAX_VRMS in SCRIPTER.INI");
}

void DelVrm()
{
//int res;
//char msg[80];

if(curvrm == 0)
    {
    Notify(-1,-1,"This function is special and cannot be deleted.","You can still change it to something else though..");
    return;
    }

if(Confirm(-1,-1,"Really delete this function?",COlist[curvrm].name))
    {
    M_free(COlist[curvrm].fname);
    M_free(COlist[curvrm].name);
    COlist[curvrm].fname = NULL;
    COlist[curvrm].name = NULL;
    curvrm=0;
    VrmUpdate();
    }

}

int CMP(char *a,char *b)
{
return strcmp(a,b);
}

#endif
