/*
 *      Game state information
 */

#include "core.hpp"
#include "media.h"
#include "gamedata.h"

#define MAX_WORLDS 4

OBJECT *syspocket;          // Storage area for GUI objects
OBJECT *player;             // The player
OBJECT *victim;             // Global variable
OBJECT *person;             // Current object being moved
OBJECT *current_object;     // Global variable
OBJECT *fx_obj;
TILE *current_tile;         // Global variable
OBJECT **party;
char **partyname;
WORLD *curmap;               // pointer to current world
WORLD worldcache[MAX_WORLDS];
OBJECT limbo;              // This is where things are placed between worlds

int game_minute=0;     // The script engine only supports integer (not char)
int game_hour=0;
int game_day=0;
int game_month=0;
int game_year=0;
int days_passed=0;
int day_of_week=0;

int mapx=0,mapy=0,mapx2=0,mapy2=0; // Coordinates for Seer
int new_x,new_y;           // Seer parameters
int Fader=0;               // Lighting control
int SoundFixed=0;          // Stop sounds fading with distance if 1
int irekey;                // Key pressed by user
int show_roof=1;           // Project the roof? (Yes)
int force_roof=0;          // Roof override (0 = none, -1 = hide, 1 = show)
char fullrestore=0;        // Do we revert all objects to their defaults?
int ytab[MAX_H];           // Fast access to parts of the map
int buggy=0;               // Were warnings detected?
int combat_mode=0;
int ire_running=1;

// Map transition variables
int change_map=0,change_map_x,change_map_y,change_map_tag=0;

// Global vars, intended for use with the conversation engine
int pe_usernum1,pe_usernum2,pe_usernum3,pe_usernum4,pe_usernum5;

// Map window info

int VSW=8; // Tiles
int VSH=8;
int VSA=64;
int VSMIDX;
int VSMIDY;
int VSW32; // Pixels
int VSH32;
int VSA32;

OBJECT *largemap[LMSIZE][LMSIZE];  // Large Object caches
OBJECT *solidmap[LMSIZE][LMSIZE];
int decorxmap[LMSIZE][LMSIZE];
int decorymap[LMSIZE][LMSIZE];
OBJLIST *ActiveList=NULL;  // List of all active objects

// Cached ID numbers for 'system' VRMs

int Sysfunc_scheduler = -1, Sysfunc_status = -1, Sysfunc_follower = -1;
int Sysfunc_splash = -1, Sysfunc_trackstop = -1, Sysfunc_updatelife = -1;
int Sysfunc_erase = -1, Sysfunc_wakeup = -1;
int mapnumber=1,fx_func;

// Resource data info

struct S_POOL    *SPlist;              // Sprite list
struct SEQ_POOL  *SQlist;              // Sequence list
struct OBJECT    *CHlist;              // Main list of characters
struct TILE      *TIlist;              // Map tile
struct S_POOL    *RTlist;              // Roof-tile list
struct L_POOL    *LTlist;              // Lightmap list
struct DATATABLE *DTlist;              // Data tables list
struct TILELINK  *TLlist;              // Map tile connections

BITMAP *MouseOverPtr=NULL;             // New mouse pointer

char **pe_files;			// List of user script files (not funcs)
extern struct SMTab *wavtab;          // Sound table
extern struct SMTab *mustab;          // Music table

long SPtot;                     // Total number of sprite
long SQtot;                     // Total number of sequence
long COtot;                     // Total number of code
long CHtot;                     // Total number of characters
long TItot;                     // Total number of tiles
long RTtot;                     // Total number of roof tiles
long LTtot;                     // Total number of Lights
long PEtot;			            // Total number of PissEasy functions
long DTtot;			            // Total number of Data Tables
long TLtot;			            // Total number of Tile Links


long spr_alloc=0;
long seq_alloc=0;
long vrm_alloc=0;
long chr_alloc=0;
long til_alloc=0;
long mus_alloc=0;
long wav_alloc=0;
long rft_alloc=256;
long lgt_alloc=256;
long pef_alloc=0;
long tab_alloc=0;
long tli_alloc=0;

// Special Effects Engine registers

int tfx_sx,tfx_sy,tfx_radius,tfx_drift,tfx_speed;
int tfx_dx,tfx_dy;
int tfx_Brushsize,tfx_Colour,tfx_Alpha,tfx_intensity,tfx_falloff;
int tfx_picdelay1=0,tfx_picdelay2=0,tfx_picdelay3=0;


/*
 *  Save game variables
 */

void VM_SaveRegs(OBJREGS *o)
{
o->player = player;
o->current = current_object;
o->me = person;
o->victim = victim;
}

/*
 *  Restore system variables
 */

void VM_RestoreRegs(OBJREGS *o)
{
player = o->player;
current_object = o->current;
person = o->me;
victim = o->victim;
}
