/*
 *      Media System: mostly Input, Output and some display functions
 */

#include <allegro.h>
#include "tdgui.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void init_media(int game);
extern void init_enginemedia();
extern void term_media();
extern BITMAP *load_cel(char *filename, RGB *pal);
extern int sizeof_sprite(BITMAP *bmp);
extern int UpdateAnim();
extern unsigned int GetIREClock();
extern unsigned int GetAnimClock();
extern void ResetIREClock();
extern int GetKey();
extern int GetMouseButton();
extern unsigned char WaitForKey();
extern unsigned char WaitForAscii();
extern void FlushKeys();
extern void Plot(int max);
extern void BMPshot();
extern int GetStringInput(char *ptr,int len);

extern BITMAP *swapscreen;
extern BITMAP *screen;
extern char *lastvrmcall;
extern int ire_transparent,ire_bpp,ire_black,ire_bytespp;
extern unsigned char ire_transparent_r;
extern unsigned char ire_transparent_g;
extern unsigned char ire_transparent_b;
extern BITMAP *MakeScreen(int w, int h);
extern void SaveScreen();
extern void RestoreScreen();

extern void LoadBacking(BITMAP *bmp, char *fname);

#ifdef __cplusplus
}
#endif

