/*************************************************************************
 * $Id: mod_alarm.c,v 1.6 2000/06/20 00:59:41 dpotter Exp $
 *
 * mod_alarm.c - Alarm support.
 *
 * Copyright (C) 2000 by David E. Potter <dp-irmp3@dpotter.com>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <dirent.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include "tools.h"
#include "config.h"
#include "log.h"
#include "mod.h"
#include "mod_alarm.h"


/*************************************************************************
 * GLOBALS
 */

int alarm_allow = 1;


/*************************************************************************
 * MODULE INFO
 */
mod_t mod_alarm = {
	mod_alarm_deinit,	// deinit
	NULL,			// reload
	&blank_fd,		// watchfd
	NULL,			// poll
	NULL,			// update
	mod_alarm_message,		// message
	NULL,			// SIGCHLD handler
};


/*************************************************************************
 * MODULE INIT FUNCTION
 */
char *mod_alarm_init (void)
{
	log_printf(LOG_DEBUG, "mod_alarm_init(): initializing\n");

	// register our module
	mod_register(&mod_alarm);

	// catch SIGUSR1 signals
	signal(SIGUSR1,mod_alarm1_signal);
	signal(SIGUSR2,mod_alarm2_signal);

	return NULL;
}

void mod_alarm1_signal()
{
	log_printf(LOG_DEBUG, "mod_alarm1_signal(): caught a SIGUSR1 signal.\n");
	if(alarm_allow) {
		log_printf(LOG_DEBUG, "mod_alarm1_signal(): Sounding alarm...\n");
		mod_sendmsg(MSGTYPE_INPUT, "environment alarm1");
	} else log_printf(LOG_DEBUG, "mod_alarm1_signal(): skipping alarm since alarms are disabled.\n");
	
}

void mod_alarm2_signal()
{
	log_printf(LOG_DEBUG, "mod_alarm2_signal(): caught a SIGUSR2 signal. Sounding alarm....\n");
	if(alarm_allow) {
		log_printf(LOG_DEBUG, "mod_alarm1_signal(): Sounding alarm...\n");
		mod_sendmsg(MSGTYPE_INPUT, "environment alarm2");
	} else log_printf(LOG_DEBUG, "mod_alarm1_signal(): skipping alarm since alarms are disabled.\n");
	
}


/*************************************************************************
 * RECEIVE MESSAGE
 */
void mod_alarm_message (int msgtype, char *msg)
{
	char *c1,*c2;

	// handle input messages
	if (msgtype == MSGTYPE_INPUT) {
		c1 = msg ? strtok(msg, " \t") : NULL;
		c2 = c1 ? strtok(NULL, " \t") : NULL;
		// process alarm commands
		if (c1 && (!strcasecmp(c1, "alarm") || !strcasecmp(c1,"alarms"))) {
			if (c2 != NULL) {
				if (!strcasecmp(c2,"1") || !strcasecmp(c2,"enable")) {
					log_printf(LOG_NORMAL,"Alarms enabled.\n");
					mod_sendmsg(MSGTYPE_GENERIC, "alarm 1");
					alarm_allow = 1;
				} else if (!strcasecmp(c2,"0") || !strcasecmp(c2,"disable")) {
					log_printf(LOG_NORMAL,"Alarms disabled.\n");
					mod_sendmsg(MSGTYPE_GENERIC, "alarm 0");
					alarm_allow = 0;
				} else log_printf(LOG_NORMAL,"mod_alarm(): unknown alarm command: %s %s.\n",c1,c2);
			}
		}
	} 
}


/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_alarm_deinit (void)
{
	// do not catch SIGUSR1 signals
	log_printf(LOG_DEBUG, "mod_alarm_deinit(): not catching SIGUSR1 anymore.\n");
	signal(SIGUSR1,SIG_DFL);
	log_printf(LOG_DEBUG, "mod_alarm_deinit(): not catching SIGUSR2 anymore.\n");
	signal(SIGUSR2,SIG_DFL);

	log_printf(LOG_DEBUG, "mod_alarm_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */
