#ifndef _INCLUDE_GUARD_PROTOTYPES_H_
#define _INCLUDE_GUARD_PROTOTYPES_H_

/*
   Copyright (C) 2003 Red Hat, Inc. All rights reserved.
                                                                                                             
   Usage and distribution of this file are subject to the Open Software License version 1.1
   that can be found at http://www.opensource.org/licenses/osl-1.1.txt and the COPYING file as
   distributed together with this file is included herein by reference.
                                                                                                                      found
   Author: Arjan van de Ven   <arjanv@redhat.com>

*/


#define IRQ_OTHER 	0
#define IRQ_LEGACY 	1
#define IRQ_SCSI	2
#define IRQ_TIMER	3
#define IRQ_ETH		4
#define IRQ_GIGE	5
#define IRQ_INACTIVE	-1

#define POLICY_DEFAULT	0
#define POLICY_ROTATE	1
#define POLICY_IGNORE	2

#define MAX_CPU		32
#define MAX_INTERRUPTS  256

extern unsigned int cpubrother[];
extern unsigned int class_policy[];

struct irqdescriptor;
struct irqdescriptor {
	struct irqdescriptor *next; 	/* for putting on lists */
	int donttouch;			/* special irq, like irq0 and ide */
	
	unsigned long long oldcount;		/* total irq count on the previous check */
	unsigned long long count;		/* new irq count */
	unsigned long delta;		/* the difference */
	
	unsigned int oldcpu;		/* current coded cpu */
	unsigned int cpu;		/* future cpu; MAX_CPU is none */
	
	int type;			/* one of the IRQ_ defines */	
	int number;			/* number of the irq */
};

extern struct irqdescriptor interrupts[];
extern int cpucount;
extern int machineneedsbalance;

extern int rotate_premium;


extern int parse_proc_cpuinfo(void);
extern int parse_proc_interrupts(int incremental);
extern void classify_type(int irqnumber, char *moduletext);

extern void activate_irqtable(void);
extern int get_current_irqcpu(int irq);
extern void balance_policy(void);
extern void dump_settings(void);

#endif
