/*****************************************************************************
 *                              CursorMgr.h 
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#ifndef INCLUDED_CURSOR_MGR_H
#define INCLUDED_CURSOR_MGR_H
#include "CallbackMgr.h"
#include "vector.h"
#include <tcl.h>

class SdbReader;
class SdbrCursor;

typedef void (*CursorMgrEventCB)(voidPtr userData, Uint32 flags);

class CursorMgr {

public:
    CursorMgr(Tcl_Interp *interp, SdbReader *sdbr);
   ~CursorMgr();

    void update(SdbrCursor *cursor);
    void update();
    void update_list();

    SdbrCursor *nearestCursor(
            Uint32    targetTime,
            Uint32    lowerBound,
            Uint32    upperBound,
            Uint32    tolerance);

    SdbrCursor *addCursor(void);
    void delCursor(Uint32 idx);
    void delCursor(SdbrCursor *c);

    Char *getInstName(void) {return instName;}
    Vector<SdbrCursor> *getCursors();
    Vector<SdbrCursor> *getSortCursors();



    SdbReader                 *sdbr;

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:
        
        /************************************************************
         * sortList()
         ************************************************************/
        void sortList();

private:
    Vector<SdbrCursor>         d_cursors;
    Vector<SdbrCursor>         d_sortCursors;
    SdbrCursor                *activeCursor;
    Uint32                     cursorIdx;
    Tcl_Interp                *interp;
    Char                      *instName;
    CallbackList              *d_CursorListCB;
    CallbackList              *d_CursorUpdateCB;
    bool                       d_sortValid;

};
#endif /* INCLUDED_CURSOR_MGR_H */

