/****************************************************************************
 *                             SimInfo.h
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "SimInfo.h"
#include <string.h>
#include <ctype.h>

/**********************************************************
 * SimInfo()
 **********************************************************/
SimInfo::SimInfo(Tcl_Interp *interp, Char *name, Char *desc, Char *suffixes) 
    : simName(name), simDesc(desc), fileSuffixes(suffixes), d_interp(interp)
{
    char *dptr, *eptr;

    d_suffixList = Tcl_NewListObj(0, 0);

    dptr = suffixes;

    while ((dptr = strchr(dptr, '.'))) {
        eptr = dptr;

        /**** Scan until whitespace is found... ****/
        while (*eptr && !isspace((int)*eptr)) {
            eptr++;
        }

        if ((eptr-dptr) > 0) {
            Tcl_Obj *tmp = Tcl_NewStringObj(dptr, eptr-dptr);
            Tcl_ListObjAppendElement(d_interp, d_suffixList, tmp);
        }

        dptr = eptr;
    }
}

/**********************************************************
 * newSim()
 **********************************************************/
IviSim *SimInfo::newSim(Tcl_Interp *interp, int argc, char **argv)
{
    return new IviSim(interp, argc, argv);
}


