/****************************************************************************
 *                              debug.h
 *
 * Author: Matthew Ballance
 * Desc:   Defines some debug macros for using on a per-module basis...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_DEBUG_H
#define INCLUDED_DEBUG_H


#ifdef  MODULE_DEBUG
#ifndef DEBUG_HNDL
#define DEBUG_HNDL    fprintf(stderr 
#endif
#define DEBUG(_x)              DEBUG_HNDL, _x)
#define DEBUG_0(_x)            DEBUG_HNDL, _x)
#define DEBUG_1(_x, _y)        DEBUG_HNDL, _x, _y)
#define DEBUG_2(_x, _y, _z)    DEBUG_HNDL, _x, _y, _z)
#define DEBUG_3(_x, _y, _z, _a)    DEBUG_HNDL, _x, _y, _z, _a)
#else
#define DEBUG(_x)
#define DEBUG_0(_x)            
#define DEBUG_1(_x, _y)
#define DEBUG_2(_x, _y, _z)
#define DEBUG_3(_x, _y, _z, _a) 
#endif

#endif

