/**************************************************************************
 *                              tree_node.h
 * Author: Matthew Ballance
 * Desc:   Represents one node within a tree. Every node has a pointer 
 *         back to the tree root.
 *
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 **************************************************************************/
#ifndef INCLUDED_TREE_NODE_H
#define INCLUDED_TREE_NODE_H
#include "types.h"
#include "tree_type.h"
#include "vector.h"
#include "ivi_String.h"
#include "tree_field.h"

/**********************************************************
 * TreeNode
 **********************************************************/
class TreeNode {


    /******************************************************
     * Public functions
     ******************************************************/
public:

    TreeNode(char         sepChar);
    TreeNode(TreeNode    *templ);

    TreeNode(TreeNode    *treeRoot,
             TreeNode    *parent,
             char         sepChar);

    TreeNode(TreeNode    *treeRoot,
             TreeNode    *parent,
             char         sepChar,
             char        *nodeName
            );

    TreeNode(char        *nodeName);
   ~TreeNode(void);

    /***************************************************
     * newTreeNode(pathToNode, nodeName, nodeTypeName)
     * Creates a new tree node... The new node is 
     * inserted at the specified point in the hierarchy
     * and the node is returned...
     ***************************************************/
    TreeNode *newTreeNode(char        *pathToNode, 
                          char        *nodeName,
                          char        *nodeTypeName
                         );

    /***************************************************
     * newTreeNode(pathToNode, nodeName)
     ***************************************************/
    TreeNode *newTreeNode(char        *pathToNode,
                          char        *nodeName
                         );
    /***************************************************
     * addChild()
     ***************************************************/
    TreeNode *addChild(char           *nodeName);

    /***************************************************
     * addChild()
     ***************************************************/
    TreeNode *addChild(TreeNode       *newChild);

    /***************************************************
     * addChildOfType()
     ***************************************************/
    TreeNode *addChildOfType(char           *nodeType,
                             char           *nodeName);
        

    /***************************************************
     * newNodeOfType()
     ***************************************************/
    TreeNode *newNodeOfType(char      *nodeTypeName,
                            char      *nodeName
                           );

    /***************************************************
     * addField
     ***************************************************/
    void addField(TreeField *newField);

    /***************************************************
     * getParent()
     ***************************************************/
    inline TreeNode *getParent(TreeNode      *Child) { return parent; }

    /*************************************************** 
     * findNodeType() 
     ***************************************************/
    TreeNode *findNodeType(char       *nodeType);

    /*************************************************** 
     * findNode()
     ***************************************************/
    TreeNode *findNode(char    *path);

    /***************************************************
     * findField()
     ***************************************************/
    TreeField *findField(char    *fieldName);

    /***************************************************  
     * newTreeNode()
     ***************************************************/
    TreeNode *newTreeNode(TreeNode    *parentNode,
                          char        *nodeName,
                          char        *nodeTypeName
                         );

    /*************************************************** 
     * getTreeNode()
     * Locate a given path in the tree...
     ***************************************************/
    TreeNode *getTreeNode(char       *pathToNode);

    /***************************************************
     * newNodeType()
     ***************************************************/
    TreeNode *newNodeType(char        *nodeName);

    /*************************************************** 
     * getNodeType()
     ***************************************************/
    TreeNode *getNodeType(char        *nodeName);

    bool                isType;
    String             *nodeName;
    char                sepChar;

    /*************************************************** 
     * getTreeTop()
     ***************************************************/
    inline TreeNode *getTreeTop(void) {return treeTop;}
 
    /*************************************************** 
     * getParent()
     ***************************************************/
    inline TreeNode *getParent(void) {return parent;}

    /*************************************************** 
     * getTypes()
     ***************************************************/
    inline Vector<TreeNode> *getTypes(void) {return types;}
  
    /*************************************************** 
     * getChildren()
     ***************************************************/
    inline Vector<TreeNode> *getChildren(void) {return children;}

    /*************************************************** 
     * getFields()
     ***************************************************/
    inline Vector<TreeField> *getFields(void) {return fields;}

    /*************************************************** 
     * getTreeType()
     ***************************************************/
    inline String *getTreeType(void) { return treeType;}
     
    TreeNode           *treeTop;
    TreeNode           *parent;

    String             *treeType;    

    Vector<TreeNode>   *children;
    Vector<TreeNode>   *types; 
    Vector<TreeField>  *fields; 

};


#endif /* INCLUDED_TREE_NODE_H */



