/****************************************************************************
 *                            ShmDFIOReader.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a read-only DFIO interface to a shared-memory DFIO
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SHM_DFIO_READER_H
#define INCLUDED_SHM_DFIO_READER_H
#include "ShmDFIO.h"
#include "ShmDFIOFile.h"
#include "ShmDFIOHeader.h"

/********************************************************************/
/** \class ShmDFIOReader
 *  \brief Implements the ShmDFIO interface for a file reader
 ********************************************************************/
class ShmDFIOReader : public ShmDFIO {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************/
        /** ShmDFIOReader()
         ************************************************************/
        ShmDFIOReader(
                Tcl_Interp        *interp,
                int                argc,
                char             **argv);

        /************************************************************/
        /** findTrace()
         *
         * Searches for a named trace within the shared-memory file
         ************************************************************/
        virtual DFIOTrace *findTrace(Char *traceName);

        /************************************************************/
        /** UpdateMapping()
         *
         * Implements UpdateMapping() for the reader. Checks to see
         * if the file size, as specified in the file header matches
         * the current mapped size. If not, the file is remapped
         ************************************************************/
        virtual void UpdateMapping();

        bool        ok;

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * AddTraces()
         ************************************************************/
        void AddTraces();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        Uint32                  d_mappedSize;
        Uint32                  d_traceCount;
};

#endif /* INCLUDED_SHM_DFIO_READER_H */
