/****************************************************************************
 *                            VVPRemoteIviSim.h
 *
 * Author: Matthew Ballance
 * Desc:  
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_VVP_REMOTE_IVI_SIM_H
#define INCLUDED_VVP_REMOTE_IVI_SIM_H
#include "IviSim.h"

typedef struct VPIProcVecStruct {
  void (*vpi_register_systf)(const struct t_vpi_systf_data*ss);
  void (*vpi_vprintf)(const char*fmt, va_list ap);
  unsigned int (*vpi_mcd_close)(unsigned int mcd);
  char *(*vpi_mcd_name)(unsigned int mcd);
  unsigned int (*vpi_mcd_open)(char *name);
  int (*vpi_mcd_vprintf)(unsigned int mcd, const char*fmt, va_list ap);
  vpiHandle (*vpi_register_cb)(p_cb_data data);
  int (*vpi_remove_cb)(vpiHandle ref);
  void (*vpi_sim_vcontrol)(int operation, va_list ap);
  vpiHandle (*vpi_handle)(int type, vpiHandle ref);
  vpiHandle (*vpi_iterate)(int type, vpiHandle ref);
  vpiHandle (*vpi_scan)(vpiHandle iter);
  vpiHandle (*vpi_handle_by_index)(vpiHandle ref, int index);
  void (*vpi_get_time)(vpiHandle obj, s_vpi_time*t);
  int (*vpi_get)(int property, vpiHandle ref);
  char* (*vpi_get_str)(int property, vpiHandle ref);
  void (*vpi_get_value)(vpiHandle expr, p_vpi_value value);
  vpiHandle (*vpi_put_value)(vpiHandle obj, p_vpi_value value,
				     p_vpi_time when, int flags);
  int (*vpi_free_object)(vpiHandle ref);
  int (*vpi_get_vlog_info)(p_vpi_vlog_info vlog_info_p);
} VPIProcVecStruct;

class VVPRemoteIviSim : public IviSim {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * VVPRemoteIviSim()
         ************************************************************/
        VVPRemoteIviSim(
            Tcl_Interp *interp, int argc, char **argv, VPIProcVecStruct *pv);

        /************************************************************
         * ~VVPRemoteIviSim()
         ************************************************************/
        virtual ~VVPRemoteIviSim();


        /*****************************************************************
         * vpi_register_systf()
         *****************************************************************/
        virtual void vpi_register_systf(const struct t_vpi_systf_data *ss);

        /*****************************************************************
         * vpi_printf()
         *****************************************************************/
        virtual void vpi_printf(const char*fmt, ...);

        /*****************************************************************
         * vpi_mcd_close()
         *****************************************************************/
        virtual Uint32 vpi_mcd_close(unsigned int mcd);

        /*****************************************************************
         * vpi_mcd_name()
         *****************************************************************/
        virtual Char *vpi_mcd_name(unsigned int mcd);

        /*****************************************************************
         * vpi_mcd_open()
         *****************************************************************/
        virtual Uint32 vpi_mcd_open(char *name);

        /*****************************************************************
         * vpi_mcd_printf()
         *****************************************************************/
        virtual Int32 vpi_mcd_printf(Uint32 mcd, const Char *fmt, ...);

        /*****************************************************************
         * vpi_mcd_vprintf(
         *****************************************************************/
        virtual Int32 vpi_mcd_vprintf(Uint32 mcd, const Char *fmt, va_list ap);

        /*****************************************************************
         * vpi_register_cb()
         *****************************************************************/
        virtual vpiHandle vpi_register_cb(p_cb_data data);

        /*****************************************************************
         * vpi_remove_cb
         *****************************************************************/
        virtual Int32 vpi_remove_cb(vpiHandle ref);

        /*****************************************************************
         * vpi_sim_control()
         *****************************************************************/
        virtual void vpi_sim_control(Int32 operation, ...);

        /*****************************************************************
         * vpi_handle()
         *****************************************************************/
        virtual vpiHandle vpi_handle(Int32 type, vpiHandle ref);

        /*****************************************************************
         * vpi_iterate()
         *****************************************************************/
        virtual vpiHandle vpi_iterate(Int32 type, vpiHandle ref);

        /*****************************************************************
         * vpi_scan()
         *****************************************************************/
        virtual vpiHandle vpi_scan(vpiHandle iter);

        /*****************************************************************
         * vpi_handle_by_index()
         *****************************************************************/
        virtual vpiHandle vpi_handle_by_index(vpiHandle ref, Int32 index);

        /*****************************************************************
         * vpi_get_time()
         *****************************************************************/
        virtual void vpi_get_time(vpiHandle obj, s_vpi_time *t);

        /*****************************************************************
         * vpi_get()
         *****************************************************************/
        virtual Int32 vpi_get(Int32 property, vpiHandle ref);

        /*****************************************************************
         * vpi_get_str()
         *****************************************************************/
        virtual Char *vpi_get_str(Int32 property, vpiHandle ref);

        /*****************************************************************
         * vpi_get_value()
         *****************************************************************/
        virtual void vpi_get_value(vpiHandle expr, p_vpi_value value);

        /*****************************************************************
         * vpi_put_value()
         *****************************************************************/
        virtual vpiHandle vpi_put_value(vpiHandle obj, p_vpi_value value,
				     p_vpi_time when, Int32 flags);

        /*****************************************************************
         * vpi_free_object()
         *****************************************************************/
        virtual Int32 vpi_free_object(vpiHandle ref);

        /*****************************************************************
         * vpi_get_vlog_info()
         *****************************************************************/
        virtual Int32 vpi_get_vlog_info(p_vpi_vlog_info vlog_info_p);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        VPIProcVecStruct            *d_pv;
};

#endif /* INCLUDED_VVP_REMOTE_IVI_SIM_H */

