/****************************************************************************
 *                          VVPRemoteSimPlugin.cc
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "VVPRemoteSimPlugin.h"
#include "VVPRemoteIviSim.h"
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include "iviSplitString.h"
#include "ivi_print.h"

#undef DEBUG_SIM_RUN

#ifdef DEBUG_SIM_RUN
#define SIM_MSG(x)  ivi_print x
#else
#define SIM_MSG(x)
#endif

/********************************************************************
 * VVPRemoteSimPlugin()
 ********************************************************************/
VVPRemoteSimPlugin::VVPRemoteSimPlugin(Tcl_Interp *interp) :
    IviRemoteSimPlugin(interp)
{
    SetupVpiCBs();
}

/********************************************************************
 * ~VVPRemoteSimPlugin()
 ********************************************************************/
VVPRemoteSimPlugin::~VVPRemoteSimPlugin()
{

}

/********************************************************************
 * ConstructSim()
 ********************************************************************/
IviSim *VVPRemoteSimPlugin::ConstructSim()
{
    VPIProcVecStruct  *pv;
    char               buf[1024];
    int                argc;
    char             **argv;

    pv = new VPIProcVecStruct;
    memset(pv, 0, sizeof(VPIProcVecStruct));

    pv->vpi_register_systf     = vpi_register_systf;
//    pv->vpi_vprintf            = vpi_vprintf;
    pv->vpi_mcd_close          = vpi_mcd_close;
    pv->vpi_mcd_name           = vpi_mcd_name;
    pv->vpi_mcd_open           = vpi_mcd_open;
//    pv->vpi_mcd_vprintf        = vpi_mcd_vprintf;
    pv->vpi_register_cb        = vpi_register_cb;
    pv->vpi_remove_cb          = vpi_remove_cb;
//    pv->vpi_sim_vcontrol       = vpi_sim_vcontrol;
    pv->vpi_handle             = vpi_handle;
    pv->vpi_iterate            = vpi_iterate;
    pv->vpi_scan               = vpi_scan;
    pv->vpi_handle_by_index    = vpi_handle_by_index;
    pv->vpi_get_time           = vpi_get_time;
    pv->vpi_get                = vpi_get;
    pv->vpi_get_str            = vpi_get_str;
    pv->vpi_get_value          = vpi_get_value;
    pv->vpi_put_value          = vpi_put_value;
    pv->vpi_free_object        = vpi_free_object;
    pv->vpi_get_vlog_info      = vpi_get_vlog_info;

    sprintf(buf, "sim %s", getInstName());
    iviSplitString(buf, &argc, &argv);

    d_sim = new VVPRemoteIviSim(getInterp(), argc, argv, pv);

    iviFreeStringArr(argv);
    

    return d_sim;
}

/********************************************************************
 * BeginRun()
 ********************************************************************/
int VVPRemoteSimPlugin::BeginRun(Uint32 runLen)
{
    s_vpi_time           tt;

    tt.type = vpiSimTime;
    d_sim->vpi_get_time(0, &tt);

//    d_cbdata.reason = cbReadOnlySynch;
    d_cbdata.reason = cbAfterDelay;
//    d_time_s.low = runLen + tt.low;
    d_time_s.low = runLen;
    d_time_s.high = 0;
    d_time_s.type = vpiSimTime;

    SIM_MSG(("VVPRemoteSimPlugin::BeginRun(%d)\n\t"
        "time=%d ; cb_time=%d\n", runLen, tt.low, d_time_s.low));

    d_cbdata.time = &d_time_s;
    d_cbdata.obj  = 0;
    d_cbdata.value = 0;

    d_cbdata.user_data = (char *)this;
    d_cbdata.cb_rtn    = &VVPRemoteSimPlugin::TimeCB;
    d_sim->vpi_register_cb(&d_cbdata);

    return TCL_OK;
}

/********************************************************************
 * TimeCB()
 ********************************************************************/
void VVPRemoteSimPlugin::TimeCB(p_cb_data cb_data, int null)
{
    Uint64            iTime;
    s_vpi_time        tt;
    s_vpi_time       *cb_time;

    tt.type = vpiSimTime;
    d_sim->vpi_get_time(0, &tt);

    iTime.low  = tt.low;
    iTime.high = tt.high;

    cb_time = cb_data->time;

    SIM_MSG(("TimeCB() time=%d (cb_time=%d)\n", iTime.low, cb_time->low));

    SignalEndOfRun(iTime);
}

/********************************************************************
 * EndOfSimCB()
 ********************************************************************/
void VVPRemoteSimPlugin::EndOfSimCB()
{
    Uint64            iTime;
    s_vpi_time        tt;

    tt.type = vpiSimTime;
    d_sim->vpi_get_time(0, &tt);

    iTime.low  = tt.low;
    iTime.high = tt.high;

    SignalEndOfSimulation(iTime);
}

/********************************************************************
 * EndOfCompile()
 ********************************************************************/
void VVPRemoteSimPlugin::EndOfCompileCB()
{
    SignalReadyForSimulation();
}

/********************************************************************
 * SetupVpiCBs()
 ********************************************************************/
void VVPRemoteSimPlugin::SetupVpiCBs()
{
    s_cb_data     cbdata;

    cbdata.reason          = cbEndOfCompile;
    cbdata.cb_rtn          = &VVPRemoteSimPlugin::EndOfCompileCB;
    cbdata.user_data       = (char *)this;
    vpi_register_cb(&cbdata);

    cbdata.reason          = cbEndOfSimulation;
    cbdata.cb_rtn          = &VVPRemoteSimPlugin::EndOfSimCB;
    cbdata.user_data       = (char *)this;
    vpi_register_cb(&cbdata);
}

/********************************************************************
 * hup_handler()
 ********************************************************************/
static void hup_handler(int sig)
{
    fprintf(stderr, "HUP handler\n");
    _exit(0);
}

extern "C" int IviCommon_RemoteInit(Tcl_Interp *interp);
extern "C" int Shm_dfio_Init(Tcl_Interp *interp);

/********************************************************************
 * VVPRemoteSimPlugin_Init()
 ********************************************************************/
static void VVPRemoteSimPlugin_Init()
{
    VVPRemoteSimPlugin     *vplug;
    Tcl_Interp             *interp;

    if (getenv("VVP_REMOTE_SIM_PAUSE")) {
        char buf[16];
        fprintf(stderr, "pid %d paused...\n", getpid());
        fgets(buf, 16, stdin);
    }

    interp = Tcl_CreateInterp();
    Tcl_Init(interp);

#ifndef __MINGW32__
    signal(SIGHUP, hup_handler);
#endif

    IviCommon_RemoteInit(interp);
    Shm_dfio_Init(interp);

    vplug = new VVPRemoteSimPlugin(interp);

    if (!vplug->ok()) {
        fprintf(stderr, "ERROR: Cannot initialize IVI VVP plugin\n");
    }
}

/********************************************************************
 * vlog_startup_routines
 ********************************************************************/
void (*vlog_startup_routines[])() = {
    VVPRemoteSimPlugin_Init,
    0
};

