.\"                                      Hey, EMACS: -*- nroff -*-
.\" First parameter, NAME, should be all caps
.\" Second parameter, SECTION, should be 1-8, maybe w/ subsection
.\" other parameters are allowed: see man(7), man(1)
.TH JACK 1 "November 22, 2004"
.\" Please adjust this date whenever revising the manpage.
.\"
.\" Some roff macros, for reference:
.\" .nh        disable hyphenation
.\" .hy        enable hyphenation
.\" .ad l      left justify
.\" .ad b      justify to both left and right margins
.\" .nf        disable filling
.\" .fi        enable filling
.\" .br        insert line break
.\" .sp <n>    insert n+1 empty lines
.\" for manpage-specific macros, see man(7)
.SH NAME
Jack \- rip and encode CDs with one command
.SH SYNOPSIS
.B jack
.RI [ options ]
.SH DESCRIPTION
.B Jack 
transforms your audio-CDs to MP3 or Ogg Vorbis files. It uses several helper programs
in order to achieve things like ripping, encoding and ID3-tagging. 
Ripping is either done via
.B cdparanoia
(in which case the ripping status is displayed by Jack as well) or
.B cdda2wav.
Jack works with several encoders, namely 
.B oggenc, lame, gogo, bladeenc, l3enc, mp3enc
and
.B xing.
Any time during operation (and even when everything is finished and
the original CD lost) you can let Jack look up the track names at 
.B freedb.org
and rename the tracks accordingly. ID3-tagging of MP3s (or insertion
of equivalent comment fields in Ogg Vorbis files) is performed
as well. 
.PP
If no freedb-lookup has been performed, Jack drops all files in a
directory
.BR ~/jack/jack-xxxxxxxx ,
with
.B xxxxxxxx
representing the CD's CDDB/freedb disc ID. 
This directory is renamed by Jack when the appropriate information is known.
.PP
Most options like ripper, encoder, preferred freedb-Server, directory
and MP3-filename format, etc. can be user defined by changing the
defaults in 
.B /etc/jackrc
or by saving them to
.BR ~/.jack3rc .
.PP
While Jack is running, these keyboard commands are available:
.RS
.TP
.BR q " or " Q
quit
.TP
.BR p " or " P
disable ripping (for example, if you need the CD drive)
.TP
.BR p " or " P " (again) or " c " or " C
resume ripping
.TP
.BR e " or " E
pause/continue all encoders 
.TP
.BR r " or " R
pause/continue all rippers.
.TP
.BR ?
toggle the copyright/help box
.RE
.SH OPTIONS
Different options need different data-types as arguments:
.TP
.B bool
can be "yes" or "no", like in
.B \-\-vbr=yes
.TP
.B string
can be anything, like in
.B \-\-rename\-fmt
"%n.%t"
.TP
.B int
an integer number, like in
.B \-\-bitrate 192
(or
.B \-\-bitrate=192
)
.TP
.B list
multiple strings, delimited by the final ";".
Example:
.B \-\-guess\-toc file1.mp3 file2.mp3 ... fileN.mp3
\\;
.PP
Jack understands the following options:
.TP
.B \-\-append-year=bool
if known, append the year to dir in the format " (%y)"
.TP
.B \-b, \-\-bitrate int
target bitrate (in kbit/s, default is 160).
.TP
.B \-\-char-filter string
convert file names using a python method
.TP
.B \-\-charset string
charset of freedb data (default "latin-1").
.TP
.B \-c, \-\-check-toc 
compare toc-file and cd-toc, then exit. Jack caches the TOC of a
CD in a file ("jack.toc"). If you want to know if the inserted CD
matches the toc-file in the current directory, use this option.
.TP
.B \-C, \-\-claim-dir
rename directories even if they were was not created by Jack.
.TP
.B  \-\-cont-failed-query  
continue without freedb data if query fails.
.TP
.B \-D, \-\-create-dirs 
tells Jack to create sub-directories in which Jack puts all the
files for the current CD. If no freedb data is available, i.e.
when not using 
.B -Q
, these directories will be named "jack-xxxxxxxx"
where "xxxxxxxx" stands for the CD's freedb-id. Otherwise
dir_template (see above) will be used. This option is turned on
by default.
.TP
.B \-\-device string
The device-name of your cdrom-drive. The default is 
.B /dev/cdrom
.TP
.B \-\-dir-template string
if directories are renamed, this is the format used (default "%a/%l")
.TP
.B \-d, \-\-dont-work
don't do DAE, encoding, tagging or renaming. This may be useful if you only
want to do a freedb query, e.g. while another jack is running.
.TP
.B \-\-edit-cddb
open an editor to change the CDDB information which has been obtained
previously (only useful with -Q).
.TP
.B \-\-encoder-name, -E string
use which encoder (default "oggenc")
.TP
.B \-e, \-\-encoders int
encode how many files in parallel. If you have a SMP machine or
simply want to stress your system, you can have Jack encode
several files at once.
.TP
.B \-x, \-\-exec
run predefined command when finished.
.TP
.B \-\-extt-is-artist
the artist is contained in the EXTT fields. The EXTT fields are lines in the
freedb file which contain additional data for each track. As it's the
submitting user's choice what to use them for, Jack can't determine by itself
what they were intended for. You have to provide this information.
.TP
.B \-\-extt-is-title
the track title is contained in the EXTT fields.
.TP
.B \-\-extt-is-comment
a track comment is contained in the EXTT fields.
.TP
.B \-\-force
do not ask. Like when deleting incomplete files.
.TP
.B \-f, \-\-from-tocfile string
rip from a cdrdao created CD image on hd. The specified toc-file 
contains the name of the image file. Use
.B \-F
if jack can't find the image file.
.TP
.B \-F, \-\-from-image string
read audio data from image file. Like
.BR \-\-from-tocfile ,
but the
image itself is specified instead of the tocfile. If you
do not have a toc-file (or don't specify a toc-file),
the TOC is read from the CD itself.
.TP
.B \-g, \-\-guess-toc list
make up a TOC from the MP3 file given in mp3_files. Format is 
.B track_01.mp3 ... track_nn.mp3 ;
Note that the trailing "
.B ;
" is only necessary if you want to
append more options to your command line.
You can use it to do a freedb query based on
MP3s alone - no need for the CD. Very useful if you have no idea
which CD the MP3s are from. The MP3s must be given in the same
order as they were on their CD. The generated TOC file is
similar, but not identical to the TOC of the CD - do not submit
these!
.TP
.B \-G, \-\-id3-genre string
set ID3 genre. Use 'help' to get a list of all known genres. (You can also specify the ID3v1 genre as an int)
.TP
.B \-Y, \-\-id3-year int
set ID3 year.
.TP
.B \-h, \-\-help
Show summary of options.
.TP
.B \-k, \-\-keep-wavs
do not delete WAVs after encoding them.
.TP
.B \-m, \-\-mail-submit
submit freedb entry via e-mail. HTTP submission is preferred. 
You will have to enter the category of the CD.
.TP
.B \-l, \-\-max-load float
only start new encoders if your system's load is below the specified value.
/proc/loadavg must be readable by you for this to work.
.TP
.B \-\-multi-mode         
try to query freedb for all dirs in searchdirs which
have no freedb data.
.TP
.B \-\-my-mail string
your e-mail address, needed for freedb submissions.
.TP
.B \-n, \-\-nice int
nice-level with which the encoders are started. Default is 12
which shouldn't hurt your system much.
.TP
.B \-o, \-\-overwrite
overwrite existing files, i.e. do not check if already
ripped WAVs or an already encoded file seem to be OK. Use this if
you
.B know
something went wrong last time. This is off by default.
.TP
.B \-O, \-\-only-dae
only produce WAVs, implies 
.B \-\-keep-wavs.
This is off by default.
.TP
.B \-\-otf=bool
On-the-fly operation. Only on some encoders/rippers. Do not
create WAVs, pipe ripper output through the encoder. Default is
no as it's a torture for the CDROM drive.
.TP
.B \-o, \-\-overwrite=bool
overwrite existing files.
.\" .TP
.\" .B \-\-playorder
.\" use the freedb PLAYORDER field to limit the tracks to
.\" rip (non-functional, sorry)
.TP
.B \-\-quality int
vbr encoding quality. -1 is lowest, 10 highest (default 6). You can also specify a float.
.TP
.B \-q, \-\-query
do freedb query when all is done. This is useful if Jack was previously
run without a freedb query. If all tracks are done you don't even
have to have a CD inserted as the TOC is cached by Jack. After
having finished ripping and encoding, Jack will rename the files
and tag them.
.TP
.B \-\-query\-if\-needed=bool
like \-\-query-now, but only if freedb data hasn't been successfully
queried before.
.TP
.B \-Q, \-\-query-now
do freedb query when starting. Use this if you are connected to
the Internet when starting Jack. Know that the query may need
user-interaction. After having finished ripping and encoding, Jack
will rename the files and tag them.
.TP
.B \-a, \-\-read-ahead int
read how many WAVs in advance. At most read_ahead + num_encoders
WAVs are ripped before a track has completely been encoded.
Default is 99 which will read the whole CD, provided there is
enough disk space.
.TP
.B \-\-remove-files
have Jack remove its temp jack*-files.
Be careful - don't delete them too early!
.TP
.B \-R, \-\-rename
rename and tag files according to freedb file. On startup, Jack
creates a blank freedb entry file (except if 
.B \-\-query-now
is used, 
then the file is queried from your freedb server). If you have
changed its contents (e.g. because the CD was unknown to freedb)
and want to rename and tag your MP3s accordingly, use this option.
Give all other needed options too, like
.B \-t
, 
.B \-E
, ...
.TP
.B \-\-rename-dir=bool
rename directory as well (default).
.TP
.B \-\-rename-fmt string
format of normal files (default "%n - %t")
.TP
.B \-\-rename-fmt-va string
format of Various Artists files (default "%n - %a - %t")
.TP
.B \-r, \-\-reorder=bool
optimize track-order for disk space. This can save you some peak
disk space during the encoding process; this may make it possible
to do a CD which would otherwise fail to be encoded.
.TP
.B \-\-replacement-chars list
unusable chars are replaced by the corresponding list item (default "%").
.TP
.B \-\-ripper string
which program to use for extracting the audio data (default "cdparanoia").
.TP
.B \-\-save
save options to \fI~/.jack3rc\fP file and exit.
.TP
.B \-\-scan-dirs int
Scan this many
levels from the current working directory for a matching toc-file (0
to disable, default 2).
.TP
.B \-\-search list
add these directories to the list of directories searched when looking for the
workdir (default ".").
.TP
.B \-\-server string
which freedb server to use. Don't forget to set your HTTP proxy.
Currently either "freedb" (default) or "freedb-de".
.TP
.B \-\-silent-mode=bool
be quiet (no screen output).
.TP
.B \-s, \-\-space int
forcibly set usable disk space, in bytes. This option lets you
limit the disk space Jack uses, maybe you need it for something
else? Be careful: if set too high or too low, ripping and encoding will
probably fail. The default is to look how much is free and to use
this value.
.TP
.B \-\-submit
submit freedb entry via HTTP. You will have to enter the category
of the CD.
.TP
.B \-S, \-\-swab=bool
swap byte order from image file. As cdrdao momentarily only
outputs "raw" .cdr files, you quite likely want to swap the
byte order. Try this option if your WAVs and encoded files contain 
only noise.
This is on by default as cdrdao currently generates .cdr files
that are "wrong".
.TP
.B \-\-todo
print what would be done and exit.
.TP
.B \-t, \-\-tracks string
limit ripping and encoding to the specified tracks, use comma to
separate tracks. Ranges are also possible; 5-9 is equivalent to
5,6,7,8,9; 12- is like specifying track 12,...,last_track. The
default is to process the whole CD.
.TP
.B \-u, \-\-undo-rename
undo file renaming and exit. If you don't like how Jack renamed
your files, use this option to restore the previous state.
Several levels of undo are possible. Note
that ID3 tags are not restored.
.TP
.B \-\-unusable-chars list
characters which can't be used in filenames (default "/").
.TP
.B \-\-upd-progress
have Jack re-create its temp files. Use this if you deleted them
too early.
.TP
.B \-\-update-freedb, -U
update the freedb info and exit.
.TP
.B \-\-usage\-win=bool
show the help screen while running.
.TP
.B \-v, \-\-vbr=bool
Generate variable bitrate files, only on encoders which support
this. Default is no.
.TP
.B \-\-various=bool
when parsing freedb data, Jack assumes that if the disc\'s artist
is set to "Various" the track titles have the format
"[artist] - [title]". If the disc title is set to something else
and you still want the above behaviour, use 
.B \-\-various.
.TP
.B \-\-various-swap
exchange artist and title, many freedb entries have them wrong.
.TP
.B \-\-wait=bool
wait for key press before quitting.
.TP
.B \-w, \-\-workdir string
where to create directories and put the files.
.TP
.B \-\-write\-id3v1=bool
write a smart id3v1 tag to the encoded file.
.TP
.B \-\-write\-id3v2=bool
write an id3v1 and an id3v2 tag to the encoded file.
.TP
.B \-\-write-m3u
create a playlist in .m3u format. This has bugs, don't rely on it.
.SH EXAMPLES
Insert a CD, fire up jack:
.RS
jack
.RE
.PP
Now watch it work. It's fun for a while. After having finished, you have
the following files on your HD: track_01.mp3, track_02.mp3, ...,
track_nn.mp3 plus jack.toc, jack.freedb, jack.progress. The last three are
used to store the state jack is in so it can resume work when interrupted.
.PP
Jack will create a directory called jack-xxxxxxxx for you, there it
stores all the file for the CD whose id is xxxxxxxx. After a freedb query
this directory is renamed to something human readable, like "Artist -
Title".
.PP
When jack is interrupted, call it again using the same command line as
before to resume work, in this case
.RS
jack
.RE
.PP
Now let's try a freedb query:
.RS
jack -q
.RE
.PP
when successful the files are now renamed to something more readable and 
have been ID3 tagged accordingly. jack.freedb contains the queried freedb
entry, the original file has been backed up to jack.freedb.bak.
.PP
All in one: query, rip, encode, cleanup:
.RS
jack -Q --remove-files
.RE
.PP
Editing / normalizing / stripping the WAV files before encoding:
.RS
jack -O --remove-files ; gnoise *wav ; jack -g *wav ; jack
.RE
.PP
Just replace gnoise by the operation you'd like to perform.
.SH FILES
.IP \fI/etc/jackrc\fP 
Site-wide configuration file.
.IP \fI~/.jack3rc\fP 
User-specific configuration file. Use the
.B \-\-save
option to save your configuration to this file.
.SH AUTHOR
Arne Zellentin <zarne@users.sf.net> is the author of Jack.
.SH SEE ALSO
.BR cdparanoia (1),
.BR cdda2wav (1),
.BR oggenc (1)
and
.BR lame (1)
