/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2005 Olivier Guilyardi <olivier@samalyse.com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <string.h>
#include <config.h>
#include <stdlib.h>
#include <unistd.h>

#include "song.h"
#include "gui.h"
#include "arg.h"

#ifdef MEMDEBUG
#include "memdebug.h"
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#include <signal.h>
#include <execinfo.h>

#ifdef __i386__
/* get REG_EIP from ucontext.h */
#define __USE_GNU
#include <ucontext.h>
#endif

#ifdef __i386__
void bt_sighandler(int sig, siginfo_t *info,
				   void *secret) {

  printf ("CAUGHT SIGSEV >> DUMPING BACKTRACE\n");

  void *trace[200];
  int trace_size = 0;
  ucontext_t *uc = (ucontext_t *)secret;

  trace_size = backtrace(trace, 200);
  /* overwrite sigaction with caller's address */
  trace[1] = (void *) uc->uc_mcontext.gregs[REG_EIP];

  backtrace_symbols_fd(trace + 1, trace_size - 1, STDOUT_FILENO);

  printf ("\n####################################################\n");
  printf ("#                     KRASH !!!                    #\n");
  printf ("#                                                  #\n");
  printf ("#   Please help fixing this issue by sending all   #\n");
  printf ("#    the above output to <olivier@samalyse.com>    #\n");
  printf ("#                                                  #\n");
  printf ("#     Merci d'envoyer toute la sortie console      #\n");
  printf ("#       ci-dessus  <olivier@samalyse.com>         #\n");
  printf ("####################################################\n\n");

  exit(0);
}
#endif


int
main (int argc, char *argv[])
{
#ifdef __i386__
  struct sigaction sa;

  sa.sa_sigaction = (void *)bt_sighandler;
  sigemptyset (&sa.sa_mask);
  sa.sa_flags = SA_RESTART | SA_SIGINFO;

  sigaction (SIGSEGV, &sa, NULL);
#endif

  rc_t rc;  
  rc_read (&rc);

  arg_t *arg = arg_parse (argc, argv);
  
  song_t *song = song_new();

  gui_new (&rc, arg, song);

  song_destroy (song);

  return 0;
}
