/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.jasperreports.engine;


/**
 * An abstract representation of a break element.
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: JRBreak.java 3033 2009-08-27 11:46:22Z teodord $
 */
public interface JRBreak extends JRElement
{


	/**
	 * Constant used for specifying that the break type.
	 */
	public static final byte TYPE_PAGE = 1;

	/**
	 * Constant used for specifying that the break type.
	 */
	public static final byte TYPE_COLUMN = 2;


	/**
	 * Gets the break type.
	 * @return one of the type constants
	 */
	public byte getType();

	/**
	 * Sets the break type.
	 * @param type one of the type constants
	 */
	public void setType(byte type);


}
