# This is included by jh_* and contains common functions
#
# - argument parsing
# - package selection
#

VERSION=0.5

parseargs()
{
   ARGC=0
   ARGV=()
   while [ -n "$1" ]; do
      if [ "-V" = "$1" ] || [ "--version" = "$1" ]; then
         echo "Javahelper Version $VERSION"
         exit 0
      elif [ "-h" = "$1" ] || [ "--help" = "$1" ]; then
         syntax
      elif [ "-" = "${1:1:1}" ]; then
      # long opt
         optn="`echo $1 | sed -n 's/^--\([^=]*\)\(=.*\)*$/\1/p'`"
         if [ -z "$optn" ] || ! echo $ARGS | grep $optn >/dev/null; then
            echo "Invalid option: $optn"
            syntax
         fi
         optv="`echo $1 | sed -n 's/^[^=]*=\(.*\)$/\1/p'`"
         if [ -z "$optv" ]; then
            optv=true
         fi
         export opt_$optn=$optv
      elif [ "-" = "${1:0:1}" ]; then
      # short opt
         optn="${1:1:1}"
         if [ -z "$optn" ] || ! echo $ARGS | grep $optn >/dev/null; then
            echo "Invalid option: $optn"
            syntax
         fi
         optv="${1:2}"
         if [ -z "$optv" ]; then
            optv=true
         fi
         export opt_$optn=$optv
      else
      # not-opt arg
         ARGV[$ARGC]="$1"
         ARGC=$(( $ARGC + 1 ))
      fi
      shift
   done
   export ARGC
   export ARGV
}

findpackages()
{
   if [ -n "$opt_p" ]; then
      echo $opt_p
   elif [ -n "$opt_package" ]; then
      echo $opt_package
   elif [ -n "$opt_i" ] || [ -n "$opt_indep" ]; then
      egrep '^(Package|Architecture)' debian/control | grep -B1 'Architecture: all'|sed -n '/^Package:/s/^[^:]*: *//p'
   elif [ -n "$opt_s" ] || [ -n "$opt_arch" ]; then
      egrep '^(Package|Architecture)' debian/control | grep -v 'Architecture: all' | grep -B1 Architecture|sed -n '/^Package:/s/^[^:]*: *//p'
   else
      sed -n '/^Package:/s/^[^:]*: *//p' debian/control
   fi
}

firstpackage()
{ 
   findpackages | head -n1
}

getarg()
{
   while [ -n "$1" ]; do
      optn="opt_$1"
      if [ -n "${!optn}" ]; then
         echo ${!optn}
         return
      fi
      shift
   done
}
