/* 
    * $id:jalali.h - Jalali Calendar
    * Tools for converting Jalali to Gregorian dates and vice-versa.
    * author: Ashkan Ghassemi ( ghassemi at ftml dot net )
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#include "config.h"

#ifndef __JALALI_H
#define __JALALI_H

struct j_date_ {
    int year ;
    int month ;
    int day ;
    int wday ;
    int today ;
};

typedef struct j_date_ j_date ;


/*
 * Dealing with leap years.
 */

int is_jleap(int) ;
int is_gleap(int) ;
int get_last_jleap(int) ;
int get_last_gleap(int) ;

/*
 * Methods of conversion, used to convert a date to jalali days and days to jalali date.
 * all days are calculated from UTC Epoch.
 */

int convert_to_jalali(long, j_date*) ;
long convert_to_days(int, int, int) ;

/* 
 * calc_current() is a method to get the current date. It gets five 
 * arguments which are pointers and fill them with the corresponding 
 * value. Year, Month, Day (of the month), Wday (day of week), Today
 * (day of year).
 */

void calc_current(j_date*) ;

/*
 * gets week day, for a certain year, month, day.
 */

int get_week_day(int, int, int) ;

/*
 * gets day number in year, for a certain year, month, day.
 */
int get_year_day(int, int, int) ;

/*
 * gets week number, for a certain year, month, day.
 */
int get_year_week(int, int, int) ;


#endif /* __JALALI_H */
