/* 
    * $id:config.h - Jalali Calendar
    * Tools for converting Jalali to Gregorian dates and vice-versa.
    * author: Ashkan Ghassemi (ghassemi at ftml dot net)
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#ifndef __CONFIG_H
#define __CONFIG_H

#define GLEAP 1968
#define JLEAP 1346

#define BASE_CAL_DAY 11
#define BASE_CAL_MONTH 10
#define BASE_CAL_YEAR 1348

#define NYEAR_LEN 31536000 /* normal year */
#define LYEAR_LEN 31622400 /* leap year */
#define YEAR_LEN 31557600 /* exact */
#define BYEAR_DIFF 21600
#define DAY_LEN  86400

#define CAL_TRIGGER 1
#define CAL_DTRIGGER 2
#define UTC_D_YEAR 1970
#define GRE_JAL_DCONV 79
#define JAL_GRE_DCONV 286

#define SEGMENT_REDIRECTION 0.70
#define YEAR_LEND 365.24220
#define PAHLAVI_DIFF 1180

#define JULIAN_FLAG 'j'
#define WHOLEYEAR_FLAG 'y'
#define CURRENT_MONTH '1'
#define THREE_MONTHS '3'
#define PAHLAVI_FLAG 'p'
#define SHOW_VERSION 'V'

#define CAL_VERSION "0.0.99a" 

#endif /* __CONFIG_H */
