import jcifs.util.transport.TransportException;
import jcifs.smb.*;

public class InterruptTest extends Thread {

    String url;

    public InterruptTest(String url) {
        this.url = url;
    }
    public void run() {
        for (int i = 0; i < 10; i++) {
            try {
                SmbFileInputStream in = new SmbFileInputStream(url);

                byte[] b = new byte[10];
                while(in.read( b ) > 0) {
                    ;
                }

                in.close();
            } catch(SmbException se) {
                Throwable t = se.getRootCause();
                if (t instanceof TransportException) {
                    TransportException te = (TransportException)t;
                    t = te.getRootCause();
                    if (t instanceof InterruptedException) {
                        System.out.println("interrupted ok");
                        continue;
                    }
                }
                se.printStackTrace();
                try { Thread.sleep(500); } catch(InterruptedException ie) {}
            } catch(Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    public static void main( String argv[] ) throws Exception {
        InterruptTest it = new InterruptTest(argv[0]);
        it.start();
        Thread.sleep(300);
        for (int i = 0; i < 10; i++) {
            Thread.sleep(200);
            it.interrupt();
        }
    }
}

