/*
 * This is just an INCOMPLETE, EMPTY and NO-OPERATIONAL implementation of the 
 * QuickTime(TM) for Java library, based on the public API available at: 
 * http://developer.apple.com/documentation/Java/Reference/1.4.1/Java141API_QTJ
 *
 * The information contained in this file is used only at compile-time to make 
 * possible the complete build process of JClic without external non-free 
 * dependencies. 
 *
 * A full operational version of the library is available at:
 * http://developer.apple.com/quicktime/qtjava
 */

package quicktime.std;

public interface StdQTConstants
{

    public static final int codecCanScale = 1;
    public static final int codecCanMask = 2;
    public static final int codecCanMatte = 4;
    public static final int codecCanTransform = 8;
    public static final int codecCanTransferMode = 16;
    public static final int codecCanCopyPrev = 32;
    public static final int codecCanSpool = 64;
    public static final int codecCanClipVertical = 128;
    public static final int codecCanClipRectangular = 256;
    public static final int codecCanRemapColor = 512;
    public static final int codecCanFastDither = 1024;
    public static final int codecCanSrcExtract = 2048;
    public static final int codecCanCopyPrevComp = 4096;
    public static final int codecCanAsync = 8192;
    public static final int codecCanMakeMask = 16384;
    public static final int codecCanShift = 32768;
    public static final int codecCanAsyncWhen = 0x10000;
    public static final int codecCanShieldCursor = 0x20000;
    public static final int codecCanManagePrevBuffer = 0x40000;
    public static final int codecHasVolatileBuffer = 0x80000;
    public static final int codecWantsRegionMask = 0x100000;
    public static final int codecImageBufferIsOnScreen = 0x200000;
    public static final int codecWantsDestinationPixels = 0x400000;
    public static final int codecWantsSpecialScaling = 0x800000;
    public static final int codecHandlesInputs = 0x1000000;
    public static final int codecCanDoIndirectSurface = 0x2000000;
    public static final int codecIsSequenceSensitive = 0x4000000;
    public static final int codecRequiresOffscreen = 0x8000000;
    public static final int codecRequiresMaskBits = 0x10000000;
    public static final int codecCanRemapResolution = 0x20000000;
    public static final int codecIsDirectToScreenOnly = 0x40000000;
    public static final int codecCanLockSurface = 0x80000000;
    public static final int codecConditionFirstBand = 1;
    public static final int codecConditionLastBand = 2;
    public static final int codecConditionFirstFrame = 4;
    public static final int codecConditionNewDepth = 8;
    public static final int codecConditionNewTransform = 16;
    public static final int codecConditionNewSrcRect = 32;
    public static final int codecConditionNewMask = 64;
    public static final int codecConditionNewMatte = 128;
    public static final int codecConditionNewTransferMode = 256;
    public static final int codecConditionNewClut = 512;
    public static final int codecConditionNewAccuracy = 1024;
    public static final int codecConditionNewDestination = 2048;
    public static final int codecConditionFirstScreen = 4096;
    public static final int codecConditionDoCursor = 8192;
    public static final int codecConditionCatchUpDiff = 16384;
    public static final int codecConditionMaskMayBeChanged = 32768;
    public static final int codecConditionToBuffer = 0x10000;
    public static final int codecConditionCodecChangedMask = 0x80000000;
    public static final int codecInfoResourceType = 0x63646369;
    public static final int codecInterfaceVersion = 2;
    public static final int matrixFlagScale2x = 128;
    public static final int matrixFlagScale1x = 64;
    public static final int matrixFlagScaleHalf = 32;
    public static final int kScreenFloodMethodNone = 0;
    public static final int kScreenFloodMethodKeyColor = 1;
    public static final int kScreenFloodMethodAlpha = 2;
    public static final int kFlushLastQueuedFrame = 0;
    public static final int kFlushFirstQueuedFrame = 1;
    public static final int kNewImageGWorldErase = 1;
    public static final int kCodecFrameTypeUnknown = 0;
    public static final int kCodecFrameTypeKey = 1;
    public static final int kCodecFrameTypeDifference = 2;
    public static final int kCodecFrameTypeDroppableDifference = 3;
    public static final int kParameterTitleName = 0x6e616d65;
    public static final int kParameterTitleID = 1;
    public static final int kParameterWhatName = 0x77686174;
    public static final int kParameterWhatID = 1;
    public static final int kParameterVersionName = 0x76657273;
    public static final int kParameterVersionID = 1;
    public static final int kParameterRepeatableName = 0x70657465;
    public static final int kParameterRepeatableID = 1;
    public static final int kParameterRepeatableTrue = 1;
    public static final int kParameterRepeatableFalse = 0;
    public static final int kParameterAlternateCodecName = 0x73756273;
    public static final int kParameterAlternateCodecID = 1;
    public static final int kParameterSourceCountName = 0x73726373;
    public static final int kParameterSourceCountID = 1;
    public static final int kParameterDependencyName = 0x64656570;
    public static final int kParameterDependencyID = 1;
    public static final int kParameterListDependsUponColorProfiles = 0x70726f66;
    public static final int kParameterListDependsUponFonts = 0x666f6e74;
    public static final int kParameterEnumList = 0x656e756d;
    public static final int kParameterAtomTypeAndID = 0x74797065;
    public static final int kNoAtom = 0x6e6f6e65;
    public static final int kAtomNoFlags = 0;
    public static final int kAtomNotInterpolated = 1;
    public static final int kAtomInterpolateIsOptional = 2;
    public static final int kParameterDataType = 0x64617461;
    public static final int kParameterTypeDataText = 0x74657874;
    public static final int kParameterTypeDataEnum = 0x656e756d;
    public static final int kParameterTypeDataBitField = 0x626f6f6c;
    public static final int kParameterTypeDataImage = 0x696d6167;
    public static final int kParameterAlternateDataType = 0x616c7431;
    public static final int kParameterTypeDataColorValue = 0x636d6c72;
    public static final int kParameterTypeDataCubic = 0x63756269;
    public static final int kParameterTypeDataNURB = 0x6e757262;
    public static final int kParameterDataRange = 0x72616e67;
    public static final int kNoMinimumLongFixed = 0x7fffffff;
    public static final int kNoMaximumLongFixed = 0x80000000;
    public static final int kNoScaleLongFixed = 0;
    public static final int kNoPrecision = -1;
    public static final int kParameterImageNoFlags = 0;
    public static final int kParameterDataBehavior = 0x6469746c;
    public static final int kParameterItemEditText = 0x65646974;
    public static final int kParameterItemEditLong = 0x6c6f6e67;
    public static final int kParameterItemEditFixed = 0x66697864;
    public static final int kParameterItemEditDouble = 0x646f7562;
    public static final int kParameterItemPopUp = 0x706f7075;
    public static final int kParameterItemRadioCluster = 0x72616469;
    public static final int kParameterItemCheckBox = 0x63686578;
    public static final int kParameterItemControl = 0x636e746c;
    public static final int kParameterItemLine = 0x6c696e65;
    public static final int kParameterItemColorPicker = 0x7069636b;
    public static final int kParameterItemGroupDivider = 0x64697669;
    public static final int kParameterItemStaticText = 0x73746174;
    public static final int kParameterItemDragImage = 0x696d6167;
    public static final int kGraphicsNoFlags = 0;
    public static final int kGraphicsFlagsGray = 1;
    public static final int kGroupNoFlags = 0;
    public static final int kGroupAlignText = 0x10000;
    public static final int kGroupSurroundBox = 0x20000;
    public static final int kGroupMatrix = 0x40000;
    public static final int kGroupNoName = 0x80000;
    public static final int kDisableControl = 1;
    public static final int kDisableWhenNotEqual = 1;
    public static final int kDisableWhenEqual = 17;
    public static final int kDisableWhenLessThan = 33;
    public static final int kDisableWhenGreaterThan = 49;
    public static final int kPopupStoreAsString = 0x10000;
    public static final int kParameterDataUsage = 0x75736520;
    public static final int kParameterUsagePixels = 0x7069786c;
    public static final int kParameterUsageRectangle = 0x72656374;
    public static final int kParameterUsagePoint = 0x78792020;
    public static final int kParameterUsage3DPoint = 0x78797a20;
    public static final int kParameterUsageDegrees = 0x64656772;
    public static final int kParameterUsageRadians = 0x72616473;
    public static final int kParameterUsagePercent = 0x70636e74;
    public static final int kParameterUsageSeconds = 0x73656373;
    public static final int kParameterUsageMilliseconds = 0x6d736563;
    public static final int kParameterUsageMicroseconds = 0xb5736563;
    public static final int kParameterUsage3by3Matrix = 0x33627933;
    public static final int kParameterDataDefaultItem = 0x64666c74;
    public static final int kParameterInfoLongName = 0xa96e616d;
    public static final int kParameterInfoCopyright = 0xa9637079;
    public static final int kParameterInfoDescription = 0xa9696e66;
    public static final int kParameterInfoWindowTitle = 0xa9776e74;
    public static final int kParameterInfoPicture = 0xa9706978;
    public static final int kParameterInfoManufacturer = 0xa96d616e;
    public static final int kParameterInfoIDs = 1;
    public static final int kParameterValidationNoFlags = 0;
    public static final int kParameterValidationFinalValidation = 1;
    public static final int kImageCodecSettingsFieldCount = 0x6669656c;
    public static final int kImageCodecSettingsFieldOrdering = 0x66646f6d;
    public static final int kImageCodecSettingsFieldOrderingF1F2 = 1;
    public static final int kImageCodecSettingsFieldOrderingF2F1 = 2;
    public static final int kMotionJPEGTag = 0x6d6a7067;
    public static final int kJPEGQuantizationTablesImageDescriptionExtension = 0x6d6a7174;
    public static final int kJPEGHuffmanTablesImageDescriptionExtension = 0x6d6a6874;
    public static final int kFieldInfoImageDescriptionExtension = 0x6669656c;
    public static final int kFieldOrderUnknown = 0;
    public static final int kFieldsStoredF1F2DisplayedF1F2 = 1;
    public static final int kFieldsStoredF1F2DisplayedF2F1 = 2;
    public static final int kFieldsStoredF2F1DisplayedF1F2 = 5;
    public static final int kFieldsStoredF2F1DisplayedF2F1 = 6;
    public static final int kEffectSourceName = 0x73726320;
    public static final int kEffectDataSourceType = 0x64747374;
    public static final int kEffectRawSource = 0;
    public static final int kEffectGenericType = 0x67656666;
    public static final int kLinearGradient = 0;
    public static final int kCircularGradient = 1;
    public static final int kCurveGetLengthSelect = 256;
    public static final int kCurveLengthToPointSelect = 257;
    public static final int kCurveNewPathSelect = 258;
    public static final int kCurveCountPointsInPathSelect = 259;
    public static final int kCurveGetPathPointSelect = 260;
    public static final int kCurveInsertPointIntoPathSelect = 261;
    public static final int kCurveSetPathPointSelect = 262;
    public static final int kCurveGetNearestPathPointSelect = 263;
    public static final int kCurvePathPointToLengthSelect = 264;
    public static final int kCurveCreateVectorStreamSelect = 265;
    public static final int kCurveAddAtomToVectorStreamSelect = 266;
    public static final int kCurveAddPathAtomToVectorStreamSelect = 267;
    public static final int kCurveAddZeroAtomToVectorStreamSelect = 268;
    public static final int kCurveGetAtomDataFromVectorStreamSelect = 269;
    public static final int gxNoFill = 0;
    public static final int gxOpenFrameFill = 1;
    public static final int gxFrameFill = 1;
    public static final int gxClosedFrameFill = 2;
    public static final int gxHollowFill = 2;
    public static final int gxEvenOddFill = 3;
    public static final int gxSolidFill = 3;
    public static final int gxWindingFill = 4;
    public static final int gxInverseEvenOddFill = 5;
    public static final int gxInverseSolidFill = 5;
    public static final int gxInverseFill = 5;
    public static final int gxInverseWindingFill = 6;
    public static final int kDontUseValidateToFindGraphicsImporter = 1;
    public static final int identityMatrixType = 0;
    public static final int translateMatrixType = 1;
    public static final int scaleMatrixType = 2;
    public static final int scaleTranslateMatrixType = 3;
    public static final int linearMatrixType = 4;
    public static final int linearTranslateMatrixType = 5;
    public static final int perspectiveMatrixType = 6;
    public static final int graphicsImporterUsesImageDecompressor = 0x800000;
    public static final int quickTimeImageFileImageDescriptionAtom = 0x69647363;
    public static final int quickTimeImageFileImageDataAtom = 0x69646174;
    public static final int quickTimeImageFileMetaDataAtom = 0x6d657461;
    public static final int kGraphicsExportGroup = 0x6578706f;
    public static final int kGraphicsExportFileType = 0x66747970;
    public static final int kGraphicsExportMIMEType = 0x6d696d65;
    public static final int kGraphicsExportExtension = 0x65787420;
    public static final int kGraphicsExportDescription = 0x64657363;
    public static final int imageTranscodererComponentType = 0x696d7463;
    public static final int handlerHasSpatial = 1;
    public static final int handlerCanClip = 2;
    public static final int handlerCanMatte = 4;
    public static final int handlerCanTransferMode = 8;
    public static final int handlerNeedsBuffer = 16;
    public static final int handlerNoIdle = 32;
    public static final int handlerNoScheduler = 64;
    public static final int handlerWantsTime = 128;
    public static final int handlerCGrafPortOnly = 256;
    public static final int handlerCanSend = 512;
    public static final int handlerCanHandleComplexMatrix = 1024;
    public static final int handlerWantsDestinationPixels = 2048;
    public static final int handlerCanSendImageData = 4096;
    public static final int mMustDraw = 8;
    public static final int mAtEnd = 16;
    public static final int mPreflightDraw = 32;
    public static final int mSyncDrawing = 64;
    public static final int mDidDraw = 1;
    public static final int mNeedsToDraw = 4;
    public static final int mDrawAgain = 8;
    public static final int mPartialDraw = 16;
    public static final int forceUpdateRedraw = 1;
    public static final int forceUpdateNewBuffer = 2;
    public static final int mHitTestBounds = 1;
    public static final int mHitTestImage = 2;
    public static final int mHitTestInvisible = 4;
    public static final int mHitTestIsClick = 8;
    public static final int mOpaque = 1;
    public static final int mInvisible = 2;
    public static final int kMediaVideoParamBrightness = 1;
    public static final int kMediaVideoParamContrast = 2;
    public static final int kMediaVideoParamHue = 3;
    public static final int kMediaVideoParamSharpness = 4;
    public static final int kMediaVideoParamSaturation = 5;
    public static final int kMediaVideoParamBlackLevel = 6;
    public static final int kMediaVideoParamWhiteLevel = 7;
    public static final int standardCompressionType = 0x73636469;
    public static final int standardCompressionSubType = 0x696d6167;
    public static final int standardCompressionSubTypeSound = 0x736f756e;
    public static final int scListEveryCodec = 2;
    public static final int scAllowZeroFrameRate = 4;
    public static final int scAllowZeroKeyFrameRate = 8;
    public static final int scShowBestDepth = 16;
    public static final int scUseMovableModal = 32;
    public static final int scDisableFrameRateItem = 64;
    public static final int scPreferCropping = 1;
    public static final int scPreferScaling = 2;
    public static final int scPreferScalingAndCropping = 3;
    public static final int scDontDetermineSettingsFromTestImage = 4;
    public static final int scTestImageWidth = 80;
    public static final int scTestImageHeight = 80;
    public static final int scOKItem = 1;
    public static final int scCancelItem = 2;
    public static final int scCustomItem = 3;
    public static final int scUserCancelled = 1;
    public static final int scSpatialSettingsType = 0x7370746c;
    public static final int scTemporalSettingsType = 0x7470726c;
    public static final int scDataRateSettingsType = 0x64726174;
    public static final int scColorTableType = 0x636c7574;
    public static final int scProgressProcType = 0x70726f67;
    public static final int scExtendedProcsType = 0x78707263;
    public static final int scPreferenceFlagsType = 0x70726566;
    public static final int scSettingsStateType = 0x73737461;
    public static final int scSequenceIDType = 0x73657175;
    public static final int scWindowPositionType = 0x776e6477;
    public static final int scCodecFlagsType = 0x63666c67;
    public static final int scCodecSettingsType = 0x63646563;
    public static final int scForceKeyValueType = 0x6b73696d;
    public static final int scSoundSampleRateType = 0x73737274;
    public static final int scSoundSampleSizeType = 0x73737373;
    public static final int scSoundChannelCountType = 0x73736363;
    public static final int scSoundCompressionType = 0x73736374;
    public static final int scCompressionListType = 0x6374796c;
    public static final int scCodecManufacturerType = 0x636d6672;
    public static final int scGetCompression = 1;
    public static final int scShowMotionSettings = 1;
    public static final int scSettingsChangedItem = -1;
    public static final int scCompressFlagIgnoreIdenticalFrames = 1;
    public static final int kQTSettingsVideo = 0x76696465;
    public static final int kQTSettingsSound = 0x736f756e;
    public static final int tcSourceRefNameType = 0x6e616d65;
    public static final int tctNegFlag = 128;
    public static final int movieExportWidth = 0x77647468;
    public static final int movieExportHeight = 0x68656774;
    public static final int movieExportDuration = 0x64757261;
    public static final int movieExportVideoFilter = 0x69666c74;
    public static final int pnotComponentWantsEvents = 1;
    public static final int pnotComponentNeedsNoCache = 2;
    public static final int showFilePreviewComponentType = 0x706e6f74;
    public static final int createFilePreviewComponentType = 0x706d616b;
    public static final int dataCompressorComponentType = 0x64636f6d;
    public static final int dataDecompressorComponentType = 0x64646563;
    public static final int appleDataCompressorSubType = 0x61646563;
    public static final int zlibDataCompressorSubType = 0x7a6c6962;
    public static final int kDataHExtendedSchedule = 0x78746e64;
    public static final int grabPictOffScreen = 1;
    public static final int grabPictIgnoreClip = 2;
    public static final int grabPictCurrentImage = 4;
    public static final int sgFlagControlledGrab = 1;
    public static final int sgDeviceNameFlagDeviceUnavailable = 1;
    public static final int sgPanelFlagForPanel = 1;
    public static final int seqGrabSettingsPreviewOnly = 1;
    public static final int qtVideoOutputComponentType = 0x766f7574;
    public static final int qtVideoOutputComponentBaseSubType = 0x62617365;
    public static final int kQTVideoOutputDontDisplayToUser = 1;
    public static final int kBackgroundSpriteLayerNum = 32767;
    public static final int kSpritePropertyMatrix = 1;
    public static final int kSpritePropertyImageDescription = 2;
    public static final int kSpritePropertyImageDataPtr = 3;
    public static final int kSpritePropertyVisible = 4;
    public static final int kSpritePropertyLayer = 5;
    public static final int kSpritePropertyGraphicsMode = 6;
    public static final int kSpritePropertyImageDataSize = 7;
    public static final int kOnlyDrawToSpriteWorld = 1;
    public static final int kSpriteWorldPreflight = 2;
    public static final int kSpriteWorldDidDraw = 1;
    public static final int kSpriteWorldNeedsToDraw = 2;
    public static final int kScaleSpritesToScaleWorld = 2;
    public static final int kSpriteWorldHighQuality = 4;
    public static final int kSpriteWorldDontAutoInvalidate = 8;
    public static final int kSpriteWorldInvisible = 16;
    public static final int spriteHitTestBounds = 1;
    public static final int spriteHitTestImage = 2;
    public static final int spriteHitTestInvisibleSprites = 4;
    public static final int spriteHitTestIsClick = 8;
    public static final int spriteHitTestLocInDisplayCoordinates = 16;
    public static final int qtcbNeedsRateChanges = 1;
    public static final int qtcbNeedsTimeChanges = 2;
    public static final int qtcbNeedsStartStopChanges = 4;
    public static final int clockComponentType = 0x636c6f6b;
    public static final int systemTickClock = 0x7469636b;
    public static final int systemSecondClock = 0x7365636f;
    public static final int systemMillisecondClock = 0x6d696c6c;
    public static final int systemMicrosecondClock = 0x6d696372;
    public static final int kClockRateIsLinear = 1;
    public static final int kClockImplementsCallBacks = 2;
    public static final int kClockCanHandleIntermittentSound = 4;
    public static final int loopTimeBase = 1;
    public static final int palindromeLoopTimeBase = 2;
    public static final int maintainTimeBaseZero = 4;
    public static final int triggerAtStart = 1;
    public static final int triggerAtStop = 2;
    public static final int triggerRateLT = 4;
    public static final int triggerRateGT = 8;
    public static final int triggerRateEqual = 16;
    public static final int triggerRateLTE = 20;
    public static final int triggerRateGTE = 24;
    public static final int triggerRateNotEqual = 28;
    public static final int triggerRateChange = 0;
    public static final int timeBaseBeforeStartTime = 1;
    public static final int timeBaseAfterStopTime = 2;
    public static final int triggerTimeFwd = 1;
    public static final int triggerTimeBwd = 2;
    public static final int triggerTimeEither = 3;
    public static final int kAnyType = 0;
    public static final int kAnySubType = 0;
    public static final int kSorensonCodecType = 0x53565131;
    public static final int kRawCodecType = 0x72617720;
    public static final int kCinepakCodecType = 0x63766964;
    public static final int kGraphicsCodecType = 0x736d6320;
    public static final int kAnimationCodecType = 0x726c6520;
    public static final int kVideoCodecType = 0x72707a61;
    public static final int kComponentVideoCodecType = 0x79757632;
    public static final int kJPEGCodecType = 0x6a706567;
    public static final int kMotionJPEGACodecType = 0x6d6a7061;
    public static final int kMotionJPEGBCodecType = 0x6d6a7062;
    public static final int kSGICodecType = 0x2e534749;
    public static final int kPlanarRGBCodecType = 0x38425053;
    public static final int kMacPaintCodecType = 0x50435447;
    public static final int kGIFCodecType = 0x67696620;
    public static final int kPhotoCDCodecType = 0x6b706364;
    public static final int kQuickDrawGXCodecType = 0x71646778;
    public static final int kAVRJPEGCodecType = 0x61767220;
    public static final int kOpenDMLJPEGCodecType = 0x646d6231;
    public static final int kBMPCodecType = 0x57524c45;
    public static final int kWindowsRawCodecType = 0x57524157;
    public static final int kVectorCodecType = 0x70617468;
    public static final int kQuickDrawCodecType = 0x71647277;
    public static final int kWaterRippleCodecType = 0x7269706c;
    public static final int kFireCodecType = 0x66697265;
    public static final int kCloudCodecType = 0x636c6f75;
    public static final int kH261CodecType = 0x68323631;
    public static final int kH263CodecType = 0x68323633;
    public static final int kDVCNTSCCodecType = 0x64766320;
    public static final int kDVCPALCodecType = 0x64766370;
    public static final int kDVCProNTSCCodecType = 0x6476706e;
    public static final int kDVCProPALCodecType = 0x64767070;
    public static final int kBaseCodecType = 0x62617365;
    public static final int kFLCCodecType = 0x666c6963;
    public static final int kTargaCodecType = 0x74676120;
    public static final int kComponentVideoSigned = 0x79757675;
    public static final int kComponentVideoUnsigned = 0x79757673;
    public static final int kCMYKCodecType = 0x636d796b;
    public static final int kMicrosoftVideo1CodecType = 0x6d737663;
    public static final int kBlurImageFilterType = 0x626c7572;
    public static final int kSharpenImageFilterType = 0x73687270;
    public static final int kEdgeDetectImageFilterType = 0x65646765;
    public static final int kEmbossImageFilterType = 0x656d6273;
    public static final int kConvolveImageFilterType = 0x67656e6b;
    public static final int kAlphaGainImageFilterType = 0x6761696e;
    public static final int kRGBColorBalanceImageFilterType = 0x72676262;
    public static final int kHSLColorBalanceImageFilterType = 0x68736c62;
    public static final int kColorSyncImageFilterType = 0x73796e63;
    public static final int kFilmNoiseImageFilterType = 0x666d6e73;
    public static final int kSolarizeImageFilterType = 0x736f6c72;
    public static final int kColorTintImageFilterType = 0x74696e74;
    public static final int kAlphaCompositorTransitionType = 0x626c6e64;
    public static final int kCrossFadeTransitionType = 0x64736c76;
    public static final int kChromaKeyTransitionType = 0x636b6579;
    public static final int kImplodeTransitionType = 0x6d706c6f;
    public static final int kExplodeTransitionType = 0x78706c6f;
    public static final int kGradientTransitionType = 0x6d617474;
    public static final int kPushTransitionType = 0x70757368;
    public static final int kSlideTransitionType = 0x736c6964;
    public static final int kWipeTransitionType = 0x736d7074;
    public static final int kIrisTransitionType = 0x736d7032;
    public static final int kRadialTransitionType = 0x736d7033;
    public static final int kMatrixTransitionType = 0x736d7034;
    public static final int kRandomWipeTransitionType = 409;
    public static final int kCurvePathAtom = 0x70617468;
    public static final int kCurveEndAtom = 0x7a65726f;
    public static final int kCurveAntialiasControlAtom = 0x616e7469;
    public static final int kCurveAntialiasOff = 0;
    public static final int kCurveAntialiasOn = -1;
    public static final int kCurveFillTypeAtom = 0x66696c6c;
    public static final int kCurvePenThicknessAtom = 0x70656e74;
    public static final int kCurveMiterLimitAtom = 0x6d697472;
    public static final int kCurveJoinAttributesAtom = 0x6a6f696e;
    public static final int kCurveMinimumDepthAtom = 0x6d696e64;
    public static final int kCurveDepthAlwaysOffscreenMask = 0x80000000;
    public static final int kCurveGradientAngleAtom = 0x616e676c;
    public static final int kCurveGradientRadiusAtom = 0x72616469;
    public static final int kCurveGradientOffsetAtom = 0x63656e74;
    public static final int kCurveARGBColorAtom = 0x61726762;
    public static final int kCurveGradientTypeAtom = 0x67726474;
    public static final int kCurveGradientRecordAtom = 0x67726164;
    public static final int codecInfoDoes1 = 1;
    public static final int codecInfoDoes2 = 2;
    public static final int codecInfoDoes4 = 4;
    public static final int codecInfoDoes8 = 8;
    public static final int codecInfoDoes16 = 16;
    public static final int codecInfoDoes32 = 32;
    public static final int codecInfoDoesDither = 64;
    public static final int codecInfoDoesStretch = 128;
    public static final int codecInfoDoesShrink = 256;
    public static final int codecInfoDoesMask = 512;
    public static final int codecInfoDoesTemporal = 1024;
    public static final int codecInfoDoesDouble = 2048;
    public static final int codecInfoDoesQuad = 4096;
    public static final int codecInfoDoesHalf = 8192;
    public static final int codecInfoDoesQuarter = 16384;
    public static final int codecInfoDoesRotate = 32768;
    public static final int codecInfoDoesHorizFlip = 0x10000;
    public static final int codecInfoDoesVertFlip = 0x20000;
    public static final int codecInfoHasEffectParameterList = 0x40000;
    public static final int codecInfoDoesBlend = 0x80000;
    public static final int codecInfoDoesWarp = 0x100000;
    public static final int codecInfoDoesRecompress = 0x200000;
    public static final int codecInfoDoesSpool = 0x400000;
    public static final int codecInfoDoesRateConstrain = 0x800000;
    public static final int codecInfoDepth1 = 1;
    public static final int codecInfoDepth2 = 2;
    public static final int codecInfoDepth4 = 4;
    public static final int codecInfoDepth8 = 8;
    public static final int codecInfoDepth16 = 16;
    public static final int codecInfoDepth32 = 32;
    public static final int codecInfoDepth24 = 64;
    public static final int codecInfoDepth33 = 128;
    public static final int codecInfoDepth34 = 256;
    public static final int codecInfoDepth36 = 512;
    public static final int codecInfoDepth40 = 1024;
    public static final int codecInfoStoresClut = 2048;
    public static final int codecInfoDoesLossless = 4096;
    public static final int codecInfoSequenceSensitive = 8192;
    public static final int compressorComponentType = 0x696d636f;
    public static final int decompressorComponentType = 0x696d6463;
    public static final int defaultDither = 0;
    public static final int forceDither = 1;
    public static final int suppressDither = 2;
    public static final int useColorMatching = 4;
    public static final int callStdBits = 1;
    public static final int callOldBits = 2;
    public static final int noDefaultOpcodes = 4;
    public static final int graphicsModeStraightAlpha = 256;
    public static final int graphicsModePreWhiteAlpha = 257;
    public static final int graphicsModePreBlackAlpha = 258;
    public static final int graphicsModeComposition = 259;
    public static final int graphicsModeStraightAlphaBlend = 260;
    public static final int graphicsModePreMulColorAlpha = 261;
    public static final int evenField1ToEvenFieldOut = 1;
    public static final int evenField1ToOddFieldOut = 2;
    public static final int oddField1ToEvenFieldOut = 4;
    public static final int oddField1ToOddFieldOut = 8;
    public static final int evenField2ToEvenFieldOut = 16;
    public static final int evenField2ToOddFieldOut = 32;
    public static final int oddField2ToEvenFieldOut = 64;
    public static final int oddField2ToOddFieldOut = 128;
    public static final int icmFrameTimeHasVirtualStartTimeAndDuration = 1;
    public static final int elOptionsIncludeNoneInList = 1;
    public static final int pdOptionsCollectOneValue = 1;
    public static final int pdOptionsAllowOptionalInterpolations = 2;
    public static final int pdOptionsModalDialogBox = 4;
    public static final int effectIsRealtime = 0;
    public static final int kEffectPercentage = 0x70636e74;
    public static final int kEffectWipe = 0x77704944;
    public static final int kEffectSoftBorder = 0x736f6674;
    public static final int kEffectBorderWidth = 0x77696474;
    public static final int kEffectBorderColor = 0x62636c72;
    public static final int kEffectHorizontalRepeat = 0x686f7269;
    public static final int kEffectVerticalRepeat = 0x76657274;
    public static final int kEffectBlendMode = 0x624d6f64;
    public static final int kEffectPreMultiplyColor = 0x6d636c72;
    public static final int kEffectStraightAlpha = 1;
    public static final int kEffectPreMultiplyAlpha = 2;
    public static final int kEffectReverseAlpha = 3;
    public static final int kEffectGainValue = 0x6761696e;
    public static final int kEffectOffsetValue = 0x6f666673;
    public static final int kEffectTopAlphaPin = 0x70696e54;
    public static final int kEffectBottomAlphaPin = 0x70696e42;
    public static final int kEffectFromDirection = 0x66726f6d;
    public static final int kEffectDirectionTop = 0;
    public static final int kEffectDirectionLeft = 1;
    public static final int kEffectDirectionBottom = 2;
    public static final int kEffectDirectionRight = 3;
    public static final int kEffectSlideAngle = 0x616e676c;
    public static final int kEffectWhatAtom = 0x77686174;
    public static final int kEffectSrcAtom = 0x73726320;
    public static final int kEffectNameAtom = 0x6e616d65;
    public static final int kEffectTypeAtom = 0x74797065;
    public static final int kEffectManufacturerAtom = 0x6d616e75;
    public static final int pdActionConfirmDialog = 1;
    public static final int pdActionSetAppleMenu = 2;
    public static final int pdActionSetEditMenu = 3;
    public static final int pdActionGetDialogValues = 4;
    public static final int pdActionSetPreviewUserItem = 5;
    public static final int pdActionSetPreviewPicture = 6;
    public static final int pdActionSetColorPickerEventProc = 7;
    public static final int pdActionSetDialogTitle = 8;
    public static final int pdActionGetSubPanelMenu = 9;
    public static final int pdActionActivateSubPanel = 10;
    public static final int pdActionConductStopAlert = 11;
    public static final int pdActionModelessCallback = 12;
    public static final int kVendorApple = 0x6170706c;
    public static final int graphicsExporterComponentType = 0x67726578;
    public static final int kBaseGraphicsExporterSubType = 0x62617365;
    public static final int graphicsExporterIsBaseExporter = 1;
    public static final int graphicsExporterCanTranscode = 2;
    public static final int graphicsExporterUsesImageCompressor = 4;
    public static final int kQTResolutionSettings = 0x7265736f;
    public static final int kQTTargetDataSize = 0x6461737a;
    public static final int kQTDontRecompress = 0x646e7472;
    public static final int kQTInterlaceStyle = 0x696c63;
    public static final int kQTColorSyncProfile = 0x6963636d;
    public static final int kQTTIFFCompressionMethod = 0x74696663;
    public static final int kQTTIFFCompression_None = 1;
    public static final int kQTTIFFLittleEndian = 0x74696665;
    public static final int kQTPNGFilterPreference = 0x6d6e6966;
    public static final int kQTPNGFilterBestForColorType = 0x62666c74;
    public static final int kQTPNGFilterNone = 0;
    public static final int kQTPNGFilterSub = 1;
    public static final int kQTPNGFilterUp = 2;
    public static final int kQTPNGFilterAverage = 3;
    public static final int kQTPNGFilterPaeth = 4;
    public static final int kQTPNGFilterAdaptivePerRow = 0x61666c74;
    public static final int kQTPNGInterlaceStyle = 0x696c63;
    public static final int kQTPNGInterlaceNone = 0;
    public static final int kQTPNGInterlaceAdam7 = 1;
    public static final int graphicsImporterComponentType = 0x67726970;
    public static final int graphicsImporterDrawsAllPixels = 0;
    public static final int graphicsImporterDoesntDrawAllPixels = 1;
    public static final int graphicsImporterDontKnowIfDrawAllPixels = 2;
    public static final int kAccessKeyAtomType = 0x61636b79;
    public static final int kAccessKeySystemFlag = 1;
    public static final int kTrackReferenceChapterList = 0x63686170;
    public static final int kTrackReferenceTimeCode = 0x746d6364;
    public static final int kTrackReferenceModifier = 0x73737263;
    public static final int codecLosslessQuality = 1024;
    public static final int codecMaxQuality = 1023;
    public static final int codecMinQuality = 0;
    public static final int codecLowQuality = 256;
    public static final int codecNormalQuality = 512;
    public static final int codecHighQuality = 768;
    public static final int codecLockBitsShieldCursor = 1;
    public static final int codecCompletionSource = 1;
    public static final int codecCompletionDest = 2;
    public static final int codecCompletionDontUnshield = 4;
    public static final int codecCompletionWentOffscreen = 8;
    public static final int codecCompletionUnlockBits = 16;
    public static final int codecCompletionForceChainFlush = 32;
    public static final int codecCompletionDropped = 64;
    public static final int codecProgressOpen = 0;
    public static final int codecProgressUpdatePercent = 1;
    public static final int codecProgressClose = 2;
    public static final int codecFlagUseImageBuffer = 1;
    public static final int codecFlagUseScreenBuffer = 2;
    public static final int codecFlagUpdatePrevious = 4;
    public static final int codecFlagNoScreenUpdate = 8;
    public static final int codecFlagWasCompressed = 16;
    public static final int codecFlagDontOffscreen = 32;
    public static final int codecFlagUpdatePreviousComp = 64;
    public static final int codecFlagForceKeyFrame = 128;
    public static final int codecFlagOnlyScreenUpdate = 256;
    public static final int codecFlagLiveGrab = 512;
    public static final int codecFlagDontUseNewImageBuffer = 1024;
    public static final int codecFlagInterlaceUpdate = 2048;
    public static final int codecFlagCatchUpDiff = 4096;
    public static final int codecFlagSupportDisable = 8192;
    public static final int codecFlagReenable = 16384;
    public static final int codecFlagOutUpdateOnDataSourceChange = 1024;
    public static final int codecFlagSequenceSensitive = 2048;
    public static final int codecFlagOutUpdateOnTimeChange = 4096;
    public static final int codecFlagImageBufferNotSourceImage = 8192;
    public static final int codecFlagUsedNewImageBuffer = 16384;
    public static final int codecFlagUsedImageBuffer = 32768;
    public static final int codecMinimumDataSize = 32768;
    public static final int kDeleteCurFile = 0x80000000;
    public static final int defaultProgressFuntion = -1;
    public static final int kMimeInfoMimeTypeTag = 0x6d696d65;
    public static final int kMimeInfoFileExtensionTag = 0x65787420;
    public static final int kMimeInfoFileTypeTag = 0x66747970;
    public static final int kMimeInfoDescriptionTag = 0x64657363;
    public static final int kMimeInfoGroupTag = 0x67726f70;
    public static final int kMimeInfoDoNotOverrideExistingFileTypeAssociation = 0x6e6f6661;
    public static final int kDataRefMimeTypeTag = 0x6d696d65;
    public static final int kDataRefFileExtensionTag = 0x65787420;
    public static final int kDataRefQTFileTypeTag = 0x66747970;
    public static final int kDataRefExtensionChokeSpeed = 0x63686f6b;
    public static final int kDataRefExtensionMIMEType = 0x6d696d65;
    public static final int kDataRefExtensionMacOSFileType = 0x66747970;
    public static final int kDataRefExtensionInitializationData = 0x64617461;
    public static final int kQTFileTypeAIFF = 0x41494646;
    public static final int kQTFileTypeAIFC = 0x41494643;
    public static final int kQTFileTypeDVC = 0x64766321;
    public static final int kQTFileTypeMIDI = 0x4d696469;
    public static final int kQTFileTypePicture = 0x50494354;
    public static final int kQTFileTypeMovie = 0x4d6f6f56;
    public static final int kQTFileTypeText = 0x54455854;
    public static final int kQTFileTypeWave = 0x57415645;
    public static final int kQTFileTypeSystemSevenSound = 0x7366696c;
    public static final int kQTFileTypeMuLaw = 0x554c4157;
    public static final int kQTFileTypeAVI = 0x56665720;
    public static final int kQTFileTypeSoundDesignerII = 0x53643266;
    public static final int kQTFileTypeAudioCDTrack = 0x7472616b;
    public static final int kQTFileTypePICS = 0x50494353;
    public static final int kQTFileTypeGIF = 0x47494666;
    public static final int kQTFileTypePhotoShop = 0x38425053;
    public static final int kQTFileTypeSGIImage = 0x2e534749;
    public static final int kQTFileTypeBMP = 0x424d5066;
    public static final int kQTFileTypeJPEG = 0x4a504547;
    public static final int kQTFileTypeJFIF = 0x4a504547;
    public static final int kQTFileTypeMacPaint = 0x504e5447;
    public static final int kQTFileTypeTargaImage = 0x54504943;
    public static final int kQTFileTypeQuickDrawGXPicture = 0x71646778;
    public static final int kQTFileTypeQuickTimeImage = 0x71746966;
    public static final int kQTFileType3DMF = 0x33444d46;
    public static final int kMoviePlayer = 0x54564f44;
    public static final int kMShp = 0x4d536870;
    public static final int kVis3 = 0x56697333;
    public static final int kPhotoshop = 0x3842494d;
    public static final int kClarisWorks = 0x424f424f;
    public static final int kTeachText = 0x74746574;
    public static final int kPictureCompressor = 0x70707869;
    public static final int kGKON = 0x474b4f4e;
    public static final int createMovieFileDeleteCurFile = 0x80000000;
    public static final int createMovieFileDontCreateMovie = 0x40000000;
    public static final int createMovieFileDontOpenFile = 0x20000000;
    public static final int createMovieFileDontCreateResFile = 0x10000000;
    public static final int sfpItemPreviewAreaUser = 11;
    public static final int sfpItemPreviewStaticText = 12;
    public static final int sfpItemPreviewDividerUser = 13;
    public static final int sfpItemCreatePreviewButton = 14;
    public static final int sfpItemShowPreviewButton = 15;
    public static final int kMovieVersion = 0;
    public static final int kVersionCheckMin = 0;
    public static final int kVersionCheckMask = 1;
    public static final int kDataRate144ModemRate = 1400;
    public static final int kDataRate288ModemRate = 2800;
    public static final int kDataRateISDNRate = 5600;
    public static final int kDataRateDualISDNRate = 11200;
    public static final int kDataRateT1Rate = 0x249f0;
    public static final int kDataRateInfiniteRate = 0x7fffffff;
    public static final int trackEnable = 1;
    public static final int trackInMovie = 2;
    public static final int trackInPreview = 4;
    public static final int trackInPoster = 8;
    public static final int movieFileType = 0x4d6f6f56;
    public static final int movieScrapType = 0x6d6f6f76;
    public static final int movieResourceType = 0x6d6f6f76;
    public static final int movieForwardPointerResourceType = 0x666f7265;
    public static final int movieBackwardPointerResourceType = 0x6261636b;
    public static final int movieResourceAtomType = 0x6d6f6f76;
    public static final int movieDataAtomType = 0x6d646174;
    public static final int movieAID = 0x6d6f6f76;
    public static final int movieHeaderAID = 0x6d766864;
    public static final int clipAID = 0x636c6970;
    public static final int rgnClipAID = 0x6372676e;
    public static final int matteAID = 0x6d617474;
    public static final int matteCompAID = 0x6b6d6174;
    public static final int trackAID = 0x7472616b;
    public static final int userDataAID = 0x75647461;
    public static final int trackHeaderAID = 0x746b6864;
    public static final int editsAID = 0x65647473;
    public static final int editListAID = 0x656c7374;
    public static final int mediaAID = 0x6d646961;
    public static final int mediaHeaderAID = 0x6d646864;
    public static final int mediaInfoAID = 0x6d696e66;
    public static final int videoMediaInfoHeaderAID = 0x766d6864;
    public static final int soundMediaInfoHeaderAID = 0x736d6864;
    public static final int genericMediaInfoHeaderAID = 0x676d6864;
    public static final int genericMediaInfoAID = 0x676d696e;
    public static final int dataInfoAID = 0x64696e66;
    public static final int dataRefAID = 0x64726566;
    public static final int sampleTableAID = 0x7374626c;
    public static final int sTSampleDescAID = 0x73747364;
    public static final int sTTimeToSampAID = 0x73747473;
    public static final int sTSyncSampleAID = 0x73747373;
    public static final int sTSampleToChunkAID = 0x73747363;
    public static final int sTShadowSyncAID = 0x73747368;
    public static final int handlerAID = 0x68646c72;
    public static final int sTSampleSizeAID = 0x7374737a;
    public static final int sTChunkOffsetAID = 0x7374636f;
    public static final int sTChunkOffset64AID = 0x636f3634;
    public static final int sTSampleIDAID = 0x73746964;
    public static final int dataRefContainerAID = 0x64726663;
    public static final int trackReferenceAID = 0x74726566;
    public static final int colorTableAID = 0x63746162;
    public static final int loadSettingsAID = 0x6c6f6164;
    public static final int propertyAtomAID = 0x636f6465;
    public static final int inputMapAID = 0x696d6170;
    public static final int movieBufferHintsAID = 0x6d626668;
    public static final int movieDataRefAliasAID = 0x6d647261;
    public static final int soundLocalizationAID = 0x736c6f63;
    public static final int compressedMovieAID = 0x636d6f76;
    public static final int compressedMovieDataAID = 0x636d7664;
    public static final int dataCompressionAtomAID = 0x64636f6d;
    public static final int referenceMovieRecordAID = 0x726d7261;
    public static final int referenceMovieDescriptorAID = 0x726d6461;
    public static final int referenceMovieDataRefAID = 0x72647266;
    public static final int referenceMovieVersionCheckAID = 0x726d7663;
    public static final int referenceMovieDataRateAID = 0x726d6472;
    public static final int referenceMovieComponentCheckAID = 0x726d6364;
    public static final int referenceMovieQualityAID = 0x726d7175;
    public static final int kDataRefIsSelfContained = 1;
    public static final int kParentAtomIsContainer = 0;
    public static final int kITextRemoveEverythingBut = 0;
    public static final int kITextRemoveLeaveSuggestedAlternate = 2;
    public static final int kITextAtomType = 0x69747874;
    public static final int kITextStringAtomType = 0x74657874;
    public static final int fullScreenHideCursor = 1;
    public static final int fullScreenAllowEvents = 2;
    public static final int fullScreenDontChangeMenuBar = 4;
    public static final int fullScreenPreflightSize = 8;
    public static final int newMovieActive = 1;
    public static final int newMovieDontResolveDataRefs = 2;
    public static final int newMovieDontAskUnresolvedDataRefs = 4;
    public static final int newMovieDontAutoAlternates = 8;
    public static final int newMovieDontUpdateForeBackPointers = 16;
    public static final int keepInRam = 1;
    public static final int unkeepInRam = 2;
    public static final int flushFromRam = 4;
    public static final int loadForwardTrackEdits = 8;
    public static final int loadBackwardTrackEdits = 16;
    public static final int visualMediaCharacteristic = 0x65796573;
    public static final int audioMediaCharacteristic = 0x65617273;
    public static final int kCharacteristicCanSendVideo = 0x76736e64;
    public static final int kCharacteristicProvidesURLs = 0x75726c6c;
    public static final int kCharacteristicNonLinear = 0x6e6f6e6c;
    public static final int kCharacteristicProvidesActions = 0x6163746e;
    public static final int kUserDataMovieControllerType = 0x63747970;
    public static final int kUserDataName = 0x6e616d65;
    public static final int kUserDataTextFullName = 0xa96e616d;
    public static final int kUserDataTextCopyright = 0xa9637079;
    public static final int kUserDataTextInformation = 0xa9696e66;
    public static final int searchTextDontGoToFoundTime = 0x10000;
    public static final int searchTextDontHiliteFoundText = 0x20000;
    public static final int searchTextOneTrackOnly = 0x40000;
    public static final int searchTextEnabledTracksOnly = 0x80000;
    public static final int pasteInParallel = 1;
    public static final int showUserSettingsDialog = 2;
    public static final int movieToFileOnlyExport = 4;
    public static final int movieFileSpecValid = 8;
    public static final int movieInDataForkResID = -1;
    public static final int flattenAddMovieToDataFork = 1;
    public static final int flattenActiveTracksOnly = 4;
    public static final int flattenDontInterleaveFlatten = 8;
    public static final int flattenFSSpecPtrIsDataRefRecordPtr = 16;
    public static final int flattenCompressMovieResource = 32;
    public static final int flattenForceMovieResourceBeforeMovieData = 64;
    public static final int nextTimeMediaSample = 1;
    public static final int nextTimeMediaEdit = 2;
    public static final int nextTimeTrackEdit = 4;
    public static final int nextTimeSyncSample = 8;
    public static final int nextTimeStep = 16;
    public static final int nextTimeEdgeOK = 16384;
    public static final int nextTimeIgnoreActiveSegment = 32768;
    public static final int movieScrapDontZeroScrap = 1;
    public static final int movieScrapOnlyPutMovie = 2;
    public static final int hintsScrubMode = 1;
    public static final int hintsLoop = 2;
    public static final int hintsDontPurge = 4;
    public static final int hintsUseScreenBuffer = 32;
    public static final int hintsAllowInterlace = 64;
    public static final int hintsUseSoundInterp = 128;
    public static final int hintsHighQuality = 256;
    public static final int hintsPalindrome = 512;
    public static final int hintsInactive = 2048;
    public static final int hintsOffscreen = 4096;
    public static final int hintsDontDraw = 8192;
    public static final int hintsAllowBlacklining = 16384;
    public static final int hintsDontUseVideoOverlaySurface = 0x10000;
    public static final int hintsIgnoreBandwidthRestrictions = 0x20000;
    public static final int hintsPlayingEveryFrame = 0x40000;
    public static final int hintsAllowDynamicResize = 0x80000;
    public static final int movieDrawingCallWhenChanged = 0;
    public static final int movieDrawingCallAlways = 1;
    public static final int movieTrackMediaType = 1;
    public static final int movieTrackCharacteristic = 2;
    public static final int movieTrackEnabledOnly = 4;
    public static final int movieControllerComponentType = 0x706c6179;
    public static final int mcTopLeftMovie = 1;
    public static final int mcScaleMovieToFit = 2;
    public static final int mcWithBadge = 4;
    public static final int mcNotVisible = 8;
    public static final int mcWithFrame = 16;
    public static final int mcFlagSuppressMovieFrame = 1;
    public static final int mcFlagSuppressStepButtons = 2;
    public static final int mcFlagSuppressSpeakerButton = 4;
    public static final int mcFlagsUseWindowPalette = 8;
    public static final int mcFlagsDontInvalidate = 16;
    public static final int mcFlagsUseCustomButton = 32;
    public static final int mcPositionDontInvalidate = 32;
    public static final int kMCIEEnabledButtonPicture = 1;
    public static final int kMCIEDisabledButtonPicture = 2;
    public static final int kMCIEDepressedButtonPicture = 3;
    public static final int kMCIEEnabledSizeBoxPicture = 4;
    public static final int kMCIEDisabledSizeBoxPicture = 5;
    public static final int kMCIEEnabledUnavailableButtonPicture = 6;
    public static final int kMCIEDisabledUnavailableButtonPicture = 7;
    public static final int kMCIESoundSlider = 128;
    public static final int kMCIESoundThumb = 129;
    public static final int kMCIEColorTable = 256;
    public static final int kMCIEIsFlatAppearance = 257;
    public static final int kMCIEDoButtonIconsDropOnDepress = 258;
    public static final int mcInfoUndoAvailable = 1;
    public static final int mcInfoCutAvailable = 2;
    public static final int mcInfoCopyAvailable = 4;
    public static final int mcInfoPasteAvailable = 8;
    public static final int mcInfoClearAvailable = 16;
    public static final int mcInfoHasSound = 32;
    public static final int mcInfoIsPlaying = 64;
    public static final int mcInfoIsLooping = 128;
    public static final int mcInfoIsInPalindrome = 256;
    public static final int mcInfoEditingEnabled = 512;
    public static final int mcInfoMovieIsInteractive = 1024;
    public static final int mcMenuUndo = 1;
    public static final int mcMenuCut = 3;
    public static final int mcMenuCopy = 4;
    public static final int mcMenuPaste = 5;
    public static final int mcMenuClear = 6;
    public static final int kControllerHeight = 16;
    public static final short mcActionIdle = 1;
    public static final short mcActionDraw = 2;
    public static final short mcActionActivate = 3;
    public static final short mcActionDeactivate = 4;
    public static final short mcActionMouseDown = 5;
    public static final short mcActionKey = 6;
    public static final short mcActionPlay = 8;
    public static final short mcActionGoToTime = 12;
    public static final short mcActionSetVolume = 14;
    public static final short mcActionGetVolume = 15;
    public static final short mcActionStep = 18;
    public static final short mcActionSetLooping = 21;
    public static final short mcActionGetLooping = 22;
    public static final short mcActionSetLoopIsPalindrome = 23;
    public static final short mcActionGetLoopIsPalindrome = 24;
    public static final short mcActionSetGrowBoxBounds = 25;
    public static final short mcActionControllerSizeChanged = 26;
    public static final short mcActionSetSelectionBegin = 29;
    public static final short mcActionSetSelectionDuration = 30;
    public static final short mcActionSetKeysEnabled = 32;
    public static final short mcActionGetKeysEnabled = 33;
    public static final short mcActionSetPlaySelection = 34;
    public static final short mcActionGetPlaySelection = 35;
    public static final short mcActionSetUseBadge = 36;
    public static final short mcActionGetUseBadge = 37;
    public static final short mcActionSetFlags = 38;
    public static final short mcActionGetFlags = 39;
    public static final short mcActionSetPlayEveryFrame = 40;
    public static final short mcActionGetPlayEveryFrame = 41;
    public static final short mcActionGetPlayRate = 42;
    public static final short mcActionShowBalloon = 43;
    public static final short mcActionBadgeClick = 44;
    public static final short mcActionMovieClick = 45;
    public static final short mcActionSuspend = 46;
    public static final short mcActionResume = 47;
    public static final short mcActionSetControllerKeysEnabled = 48;
    public static final short mcActionGetTimeSliderRect = 49;
    public static final short mcActionMovieEdited = 50;
    public static final short mcActionGetDragEnabled = 51;
    public static final short mcActionSetDragEnabled = 52;
    public static final short mcActionGetSelectionBegin = 53;
    public static final short mcActionGetSelectionDuration = 54;
    public static final short mcActionPrerollAndPlay = 55;
    public static final short mcActionGetCursorSettingEnabled = 56;
    public static final short mcActionSetCursorSettingEnabled = 57;
    public static final short mcActionSetColorTable = 58;
    public static final short mcActionLinkToURL = 59;
    public static final short mcActionCustomButtonClick = 60;
    public static final short mcActionForceTimeTableUpdate = 61;
    public static final short mcActionSetControllerTimeLimits = 62;
    public static final short mcActionExecuteAllActionsForQTEvent = 63;
    public static final short mcActionExecuteOneActionForQTEvent = 64;
    public static final short mcActionAdjustCursor = 65;
    public static final short mcActionUseTrackForTimeTable = 66;
    public static final short mcActionClickAndHoldPoint = 67;
    public static final short mcActionShowMessageString = 68;
    public static final short mcActionShowStatusString = 69;
    public static final short mcActionGetExternalMovie = 70;
    public static final short mcActionGetChapterTime = 71;
    public static final short mcActionPerformActionList = 72;
    public static final short mcActionEvaluateExpression = 73;
    public static final short mcActionFetchParameterAs = 74;
    public static final short mcActionGetCursorByID = 75;
    public static final short mcActionGetNextURL = 76;
    public static final int kActionMovieSetVolume = 1024;
    public static final int kActionMovieSetRate = 1025;
    public static final int kActionMovieSetLoopingFlags = 1026;
    public static final int kActionMovieGoToTime = 1027;
    public static final int kActionMovieGoToTimeByName = 1028;
    public static final int kActionMovieGoToBeginning = 1029;
    public static final int kActionMovieGoToEnd = 1030;
    public static final int kActionMovieStepForward = 1031;
    public static final int kActionMovieStepBackward = 1032;
    public static final int kActionMovieSetSelection = 1033;
    public static final int kActionMovieSetSelectionByName = 1034;
    public static final int kActionMoviePlaySelection = 1035;
    public static final int kActionMovieSetLanguage = 1036;
    public static final int kActionMovieChanged = 1037;
    public static final int kActionTrackSetVolume = 2048;
    public static final int kActionTrackSetBalance = 2049;
    public static final int kActionTrackSetEnabled = 2050;
    public static final int kActionTrackSetMatrix = 2051;
    public static final int kActionTrackSetLayer = 2052;
    public static final int kActionTrackSetClip = 2053;
    public static final int kActionSpriteSetMatrix = 3072;
    public static final int kActionSpriteSetImageIndex = 3073;
    public static final int kActionSpriteSetVisible = 3074;
    public static final int kActionSpriteSetLayer = 3075;
    public static final int kActionSpriteSetGraphicsMode = 3076;
    public static final int kActionSpritePassMouseToCodec = 3078;
    public static final int kActionSpriteClickOnCodec = 3079;
    public static final int kActionSpriteTranslate = 3080;
    public static final int kActionSpriteScale = 3081;
    public static final int kActionSpriteRotate = 3082;
    public static final int kActionSpriteStretch = 3083;
    public static final int kActionQTVRSetPanAngle = 4096;
    public static final int kActionQTVRSetTiltAngle = 4097;
    public static final int kActionQTVRSetFieldOfView = 4098;
    public static final int kActionQTVRShowDefaultView = 4099;
    public static final int kActionQTVRGoToNodeID = 4100;
    public static final int kActionMusicPlayNote = 5120;
    public static final int kActionMusicSetController = 5121;
    public static final int kActionCase = 6144;
    public static final int kActionWhile = 6145;
    public static final int kActionGoToURL = 6146;
    public static final int kActionSendQTEventToSprite = 6147;
    public static final int kActionDebugStr = 6148;
    public static final int kActionPushCurrentTime = 6149;
    public static final int kActionPushCurrentTimeWithLabel = 6150;
    public static final int kActionPopAndGotoTopTime = 6151;
    public static final int kActionPopAndGotoLabeledTime = 6152;
    public static final int kOperandExpression = 1;
    public static final int kOperandConstant = 2;
    public static final int kOperandMovieVolume = 1024;
    public static final int kOperandMovieRate = 1025;
    public static final int kOperandMovieIsLooping = 1026;
    public static final int kOperandMovieLoopIsPalindrome = 1027;
    public static final int kOperandMovieTime = 1028;
    public static final int kOperandTrackVolume = 2048;
    public static final int kOperandTrackBalance = 2049;
    public static final int kOperandTrackEnabled = 2050;
    public static final int kOperandTrackLayer = 2051;
    public static final int kOperandTrackWidth = 2052;
    public static final int kOperandTrackHeight = 2053;
    public static final int kOperandSpriteBoundsLeft = 3072;
    public static final int kOperandSpriteBoundsTop = 3073;
    public static final int kOperandSpriteBoundsRight = 3074;
    public static final int kOperandSpriteBoundsBottom = 3075;
    public static final int kOperandSpriteImageIndex = 3076;
    public static final int kOperandSpriteVisible = 3077;
    public static final int kOperandSpriteLayer = 3078;
    public static final int kOperandSpriteTrackVariable = 3079;
    public static final int kOperandSpriteTrackNumSprites = 3080;
    public static final int kOperandSpriteTrackNumImages = 3081;
    public static final int kOperandSpriteID = 3082;
    public static final int kOperandSpriteIndex = 3083;
    public static final int kOperandSpriteFirstCornerX = 3084;
    public static final int kOperandSpriteFirstCornerY = 3085;
    public static final int kOperandSpriteSecondCornerX = 3086;
    public static final int kOperandSpriteSecondCornerY = 3087;
    public static final int kOperandSpriteThirdCornerX = 3088;
    public static final int kOperandSpriteThirdCornerY = 3089;
    public static final int kOperandSpriteFourthCornerX = 3090;
    public static final int kOperandSpriteFourthCornerY = 3091;
    public static final int kOperandSpriteImageRegistrationPointX = 3092;
    public static final int kOperandSpriteImageRegistrationPointY = 3093;
    public static final int kOperandQTVRPanAngle = 4096;
    public static final int kOperandQTVRTiltAngle = 4097;
    public static final int kOperandQTVRFieldOfView = 4098;
    public static final int kOperandQTVRNodeID = 4099;
    public static final int kOperandMouseLocalHLoc = 5120;
    public static final int kOperandMouseLocalVLoc = 5121;
    public static final int kOperandKeyIsDown = 5122;
    public static final int kOperandRandom = 5123;
    public static final int kTargetMovie = 0x6d6f6f76;
    public static final int kTargetTrackName = 0x74726e61;
    public static final int kTargetTrackID = 0x74726964;
    public static final int kTargetTrackType = 0x74727479;
    public static final int kTargetTrackIndex = 0x7472696e;
    public static final int kTargetSpriteName = 0x73706e61;
    public static final int kTargetSpriteID = 0x73706964;
    public static final int kTargetSpriteIndex = 0x7370696e;
    public static final int kQTEventType = 0x65766e74;
    public static final int kAction = 0x6163746e;
    public static final int kWhichAction = 0x77686963;
    public static final int kActionParameter = 0x7061726d;
    public static final int kActionTarget = 0x74617267;
    public static final int kActionFlags = 0x666c6167;
    public static final int kActionParameterMinValue = 0x6d696e76;
    public static final int kActionParameterMaxValue = 0x6d617876;
    public static final int kActionListAtomType = 0x6c697374;
    public static final int kExpressionContainerAtomType = 0x65787072;
    public static final int kConditionalAtomType = 0x74657374;
    public static final int kOperatorAtomType = 0x6f706572;
    public static final int kOperandAtomType = 0x6f70726e;
    public static final int kCommentAtomType = 0x77687920;
    public static final int kQTEventMouseClick = 0x636c696b;
    public static final int kQTEventMouseClickEnd = 0x63656e64;
    public static final int kQTEventMouseClickEndTriggerButton = 0x74726967;
    public static final int kQTEventMouseEnter = 0x656e7472;
    public static final int kQTEventMouseExit = 0x65786974;
    public static final int kQTEventFrameLoaded = 0x6672616d;
    public static final int kQTEventIdle = 0x69646c65;
    public static final int kQTEventRequestToModifyMovie = 0x7265716d;
    public static final int kActionFlagActionIsDelta = 2;
    public static final int kActionFlagParameterWrapsAround = 4;
    public static final int kActionFlagActionIsToggle = 8;
    public static final int kOperatorAdd = 0x61646420;
    public static final int kOperatorSubtract = 0x73756220;
    public static final int kOperatorMultiply = 0x6d756c74;
    public static final int kOperatorDivide = 0x64697620;
    public static final int kOperatorOr = 0x6f722020;
    public static final int kOperatorAnd = 0x616e6420;
    public static final int kOperatorNot = 0x6e6f7420;
    public static final int kOperatorLessThan = 0x3c202020;
    public static final int kOperatorLessThanEqualTo = 0x3c3d2020;
    public static final int kOperatorEqualTo = 0x3d202020;
    public static final int kOperatorNotEqualTo = 0x213d2020;
    public static final int kOperatorGreaterThan = 0x3e202020;
    public static final int kOperatorGreaterThanEqualTo = 0x3e3d2020;
    public static final int kOperatorModulo = 0x6d6f6420;
    public static final int kOperatorIntegerDivide = 0x69646976;
    public static final int kOperatorAbsoluteValue = 0x61627320;
    public static final int kOperatorNegate = 0x6e656720;
    public static final int kMediaPropertyNonLinearAtomType = 0x6e6f6e6c;
    public static final int kMediaPropertyHasActions = 105;
    public static final int preloadAlways = 1;
    public static final int preloadOnlyIfEnabled = 2;
    public static final int trackUsageInMovie = 2;
    public static final int trackUsageInPreview = 4;
    public static final int trackUsageInPoster = 8;
    public static final int kTrackModifierInput = 26990;
    public static final int kTrackModifierType = 29817;
    public static final int kTrackModifierReference = 0x73737263;
    public static final int kTrackModifierObjectID = 0x6f626964;
    public static final int kTrackModifierInputName = 0x6e616d65;
    public static final int kTrackModifierTypeMatrix = 1;
    public static final int kTrackModifierTypeClip = 2;
    public static final int kTrackModifierTypeGraphicsMode = 5;
    public static final int kTrackModifierTypeVolume = 3;
    public static final int kTrackModifierTypeBalance = 4;
    public static final int kTrackModifierTypeImage = 0x76696465;
    public static final int kTrackModifierObjectMatrix = 6;
    public static final int kTrackModifierObjectGraphicsMode = 7;
    public static final int kTrackModifierType3d4x4Matrix = 8;
    public static final int kTrackModifierCameraData = 9;
    public static final int kTrackModifierSoundLocalizationData = 10;
    public static final int kTrackModifierObjectImageIndex = 11;
    public static final int kTrackModifierObjectLayer = 12;
    public static final int kTrackModifierObjectVisible = 13;
    public static final int kTrackModifierPanAngle = 0x70616e20;
    public static final int kTrackModifierTiltAngle = 0x74696c74;
    public static final int kTrackModifierVerticalFieldOfViewAngle = 0x666f7620;
    public static final int kTrackModifierObjectQTEventSend = 0x65766e74;
    public static final int videoMediaType = 0x76696465;
    public static final int soundMediaType = 0x736f756e;
    public static final int textMediaType = 0x74657874;
    public static final int baseMediaType = 0x676e7263;
    public static final int MPEGMediaType = 0x4d504547;
    public static final int musicMediaType = 0x6d757369;
    public static final int timeCodeMediaType = 0x746d6364;
    public static final int spriteMediaType = 0x73707274;
    public static final int tweenMediaType = 0x7477656e;
    public static final int threeDMediaType = 0x71643364;
    public static final int threeDeeMediaType = 0x71643364;
    public static final int DVCMediaType = 0x64766320;
    public static final int handleDataHandlerSubType = 0x686e646c;
    public static final int resourceDataHandlerSubType = 0x72737263;
    public static final int aliasDataHandlerSubType = 0x616c6973;
    public static final int urlDataHandlerSubType = 0x75726c20;
    public static final int mediaSampleNotSync = 1;
    public static final int mediaSampleShadowSync = 2;
    public static final int dataRefSelfReference = 1;
    public static final int dataRefWasNotResolved = 2;
    public static final int dataHandlerType = 0x64686c72;
    public static final int kDataHCanRead = 1;
    public static final int kDataHSpecialRead = 2;
    public static final int kDataHSpecialReadFile = 4;
    public static final int kDataHCanWrite = 8;
    public static final int kDataHSpecialWrite = 16;
    public static final int kDataHSpecialWriteFile = 32;
    public static final int kDataHCanStreamingWrite = 64;
    public static final int kDataHMustCheckDataRef = 128;
    public static final int kGetMovieImporterValidateToFind = 1;
    public static final int kGetMovieImporterAllowNewFile = 2;
    public static final int kGetMovieImporterDontConsiderGraphicsImporters = 4;
    public static final int mediaHandlerType = 0x6d686c72;
    public static final int kSpritePropertyImageIndex = 100;
    public static final int kSpriteTrackPropertyBackgroundColor = 101;
    public static final int kSpriteTrackPropertyOffscreenBitDepth = 102;
    public static final int kSpriteTrackPropertySampleFormat = 103;
    public static final int kSpriteTrackPropertyScaleSpritesToScaleWorld = 104;
    public static final int kSpriteTrackPropertyHasActions = 105;
    public static final int kSpriteTrackPropertyVisible = 106;
    public static final int kSpriteTrackPropertyQTIdleEventsFrequency = 107;
    public static final int kSpriteImagePropertyRegistrationPoint = 1000;
    public static final int kSpriteImagePropertyGroupID = 1001;
    public static final int kNoQTIdleEvents = -1;
    public static final int kKeyFrameAndSingleOverride = 2;
    public static final int kKeyFrameAndAllOverrides = 4;
    public static final int kSpriteAtomType = 0x73707274;
    public static final int kSpriteImagesContainerAtomType = 0x696d6374;
    public static final int kSpriteImageAtomType = 0x696d6167;
    public static final int kSpriteImageDataAtomType = 0x696d6461;
    public static final int kSpriteImageGroupIDAtomType = 0x696d6772;
    public static final int kSpriteImageRegistrationAtomType = 0x696d7267;
    public static final int kSpriteSharedDataAtomType = 0x64666c74;
    public static final int kSpriteNameAtomType = 0x6e616d65;
    public static final int kSpriteImageNameAtomType = 0x6e616d65;
    public static final int kSpriteUsesImageIDsAtomType = 0x75736573;
    public static final int findTextEdgeOK = 1;
    public static final int findTextCaseSensitive = 2;
    public static final int findTextReverseSearch = 4;
    public static final int findTextWrapAround = 8;
    public static final int findTextUseOffset = 16;
    public static final int dropShadowOffsetType = 0x6472706f;
    public static final int dropShadowTranslucencyType = 0x64727074;
    public static final int dfDontDisplay = 1;
    public static final int dfDontAutoScale = 2;
    public static final int dfClipToTextBox = 4;
    public static final int dfUseMovieBGColor = 8;
    public static final int dfShrinkTextBoxToFit = 16;
    public static final int dfScrollIn = 32;
    public static final int dfScrollOut = 64;
    public static final int dfHorizScroll = 128;
    public static final int dfReverseScroll = 256;
    public static final int dfContinuousScroll = 512;
    public static final int dfFlowHoriz = 1024;
    public static final int dfContinuousKaraoke = 2048;
    public static final int dfDropShadow = 4096;
    public static final int dfAntiAlias = 8192;
    public static final int dfKeyedText = 16384;
    public static final int dfInverseHilite = 32768;
    public static final int dfTextColorHilite = 0x10000;
    public static final int k3DMediaRendererEntry = 0x72656e64;
    public static final int k3DMediaRendererName = 0x6e616d65;
    public static final int k3DMediaRendererCode = 0x72636f64;
    public static final int kGetAtomicInstNoExpandedSamples = 1;
    public static final int kGetAtomicInstNoOriginalSamples = 2;
    public static final int kGetAtomicInstNoSamples = 3;
    public static final int kGetAtomicInstNoKnobList = 4;
    public static final int kGetAtomicInstNoInstrumentInfo = 8;
    public static final int kGetAtomicInstOriginalKnobList = 16;
    public static final int kGetAtomicInstAllKnobs = 32;
    public static final int kSetAtomicInstKeepOriginalInstrument = 1;
    public static final int kSetAtomicInstShareAcrossParts = 2;
    public static final int kSetAtomicInstCallerTosses = 4;
    public static final int kSetAtomicInstCallerGuarantees = 8;
    public static final int kSetAtomicInstInterruptSafe = 16;
    public static final int kSetAtomicInstDontPreprocess = 128;
    public static final int kInstrumentExactMatch = 2;
    public static final int kInstrumentRecommendedSubstitute = 1;
    public static final int kInstrumentRoland8BitQuality = 5;
    public static final int kGetInstrumentInfoNoBuiltIn = 1;
    public static final int kGetInstrumentInfoMidiUserInst = 2;
    public static final int kGetInstrumentInfoNoIText = 4;
    public static final int kBaseInstrumentSubType = 0x62617365;
    public static final int kInstrumentComponentType = 0x696e7374;
    public static final int kMusicComponentType = 0x6d757369;
    public static final int kSoftSynthComponentSubType = 0x73732020;
    public static final int kGMSynthComponentSubType = 0x676d2020;
    public static final int kaiToneDescType = 0x746f6e65;
    public static final int kaiNoteRequestInfoType = 0x6e747271;
    public static final int kaiKnobListType = 0x6b6e626c;
    public static final int kaiKeyRangeInfoType = 0x73696e66;
    public static final int kaiSampleDescType = 0x73647363;
    public static final int kaiSampleInfoType = 0x736d696e;
    public static final int kaiSampleDataType = 0x73646174;
    public static final int kaiSampleDataQUIDType = 0x71756964;
    public static final int kaiInstInfoType = 0x69696e66;
    public static final int kaiPictType = 0x70696374;
    public static final int kaiWriterType = 0x40777274;
    public static final int kaiCopyrightType = 0x40637079;
    public static final int kaiOtherStrType = 0x73747220;
    public static final int kaiInstrumentRefType = 0x69726566;
    public static final int kaiInstGMQualityType = 0x7175616c;
    public static final int kaiLibraryInfoType = 0x6c696e66;
    public static final int kaiLibraryDescType = 0x6c647363;
    public static final int kInstKnobMissingUnknown = 0;
    public static final int kInstKnobMissingDefault = 1;
    public static final int kMusicLoopTypeNormal = 0;
    public static final int kMusicLoopTypePalindrome = 1;
    public static final int instSamplePreProcessFlag = 1;
    public static final int kQTMIDIComponentType = 0x6d696469;
    public static final int kOMSComponentSubType = 0x4f4d5320;
    public static final int kFMSComponentSubType = 0x464d5320;
    public static final int kMIDIManagerComponentSubType = 0x6d6d6772;
    public static final int kAppleSysexID = 17;
    public static final int kAppleSysexCmdSampleSize = 1;
    public static final int kAppleSysexCmdSampleBreak = 2;
    public static final int kAppleSysexCmdAtomicInstrument = 16;
    public static final int kAppleSysexCmdDeveloper = 32512;
    public static final int kMusicPacketPortLost = 1;
    public static final int kMusicPacketPortFound = 2;
    public static final int kMusicPacketTimeGap = 3;
    public static final int kNoteAllocatorComponentType = 0x6e6f7461;
    public static final int kPickDontMix = 1;
    public static final int kPickSameSynth = 2;
    public static final int kPickUserInsts = 4;
    public static final int kPickEditAllowEdit = 8;
    public static final int kPickEditAllowPick = 16;
    public static final int kPickEditSynthGlobal = 32;
    public static final int kPickEditControllers = 64;
    public static final int kNoteRequestNoGM = 1;
    public static final int kNoteRequestNoSynthType = 2;
    public static final int kNoteRequestSynthMustMatch = 4;
    public static final int kVoiceCountDynamic = -1;
    public static final int kGeneralEventNoteRequest = 1;
    public static final int kGeneralEventPartKey = 4;
    public static final int kGeneralEventTuneDifference = 5;
    public static final int kGeneralEventAtomicInstrument = 6;
    public static final int kGeneralEventKnob = 7;
    public static final int kGeneralEventMIDIChannel = 8;
    public static final int kGeneralEventPartChange = 9;
    public static final int kGeneralEventNoOp = 10;
    public static final int kGeneralEventUsedNotes = 11;
    public static final int kGeneralEventPartMix = 12;
    public static final int kMarkerEventEnd = 0;
    public static final int kMarkerEventBeat = 1;
    public static final int kMarkerEventTempo = 2;
    public static final int kMIDINoteOn = 144;
    public static final int kMIDINoteOff = 128;
    public static final int kMIDIPolyPressure = 160;
    public static final int kMIDIControlChange = 176;
    public static final int kMIDIProgramChange = 192;
    public static final int kMIDIAftertouch = 208;
    public static final int kMIDIChannelPressure = 208;
    public static final int kMIDIPitchBend = 224;
    public static final int kMIDIBeginSystemExclusive = 240;
    public static final int kMIDIEndSystemExclusive = 247;
    public static final int kMIDIChannel1 = 0;
    public static final int kMIDIChannel2 = 1;
    public static final int kMIDIChannel3 = 2;
    public static final int kMIDIChannel4 = 3;
    public static final int kMIDIChannel5 = 4;
    public static final int kMIDIChannel6 = 5;
    public static final int kMIDIChannel7 = 6;
    public static final int kMIDIChannel8 = 7;
    public static final int kMIDIChannel9 = 8;
    public static final int kMIDIChannel10 = 9;
    public static final int kMIDIChannel11 = 10;
    public static final int kMIDIChannel12 = 11;
    public static final int kMIDIChannel13 = 12;
    public static final int kMIDIChannel14 = 13;
    public static final int kMIDIChannel15 = 14;
    public static final int kMIDIChannel16 = 15;
    public static final int kControllerModulationWheel = 1;
    public static final int kControllerBreath = 2;
    public static final int kControllerFoot = 4;
    public static final int kControllerPortamentoTime = 5;
    public static final int kControllerVolume = 7;
    public static final int kControllerBalance = 8;
    public static final int kControllerPan = 10;
    public static final int kControllerExpression = 11;
    public static final int kControllerLever1 = 16;
    public static final int kControllerLever2 = 17;
    public static final int kControllerLever3 = 18;
    public static final int kControllerLever4 = 19;
    public static final int kControllerLever5 = 80;
    public static final int kControllerLever6 = 81;
    public static final int kControllerLever7 = 82;
    public static final int kControllerLever8 = 83;
    public static final int kControllerPitchBend = 32;
    public static final int kControllerAfterTouch = 33;
    public static final int kControllerPartTranspose = 40;
    public static final int kControllerTuneTranspose = 41;
    public static final int kControllerPartVolume = 42;
    public static final int kControllerTuneVolume = 43;
    public static final int kControllerSustain = 64;
    public static final int kControllerPortamento = 65;
    public static final int kControllerSostenuto = 66;
    public static final int kControllerSoftPedal = 67;
    public static final int kControllerReverb = 91;
    public static final int kControllerTremolo = 92;
    public static final int kControllerChorus = 93;
    public static final int kControllerCeleste = 94;
    public static final int kControllerPhaser = 95;
    public static final int kControllerEditPart = 113;
    public static final int kControllerMasterTune = 114;
    public static final int kControllerMasterTranspose = 114;
    public static final int kControllerMasterVolume = 115;
    public static final int kControllerMasterCPULoad = 116;
    public static final int kControllerMasterPolyphony = 117;
    public static final int kControllerMasterFeatures = 118;
    public static final int kQTMSKnobStartID = 0x2000000;
    public static final int kQTMSKnobVolumeAttackTimeID = 0x2000001;
    public static final int kQTMSKnobVolumeDecayTimeID = 0x2000002;
    public static final int kQTMSKnobVolumeSustainLevelID = 0x2000003;
    public static final int kQTMSKnobVolumeRelease1RateID = 0x2000004;
    public static final int kQTMSKnobVolumeDecayKeyScalingID = 0x2000005;
    public static final int kQTMSKnobVolumeReleaseTimeID = 0x2000006;
    public static final int kQTMSKnobVolumeLFODelayID = 0x2000007;
    public static final int kQTMSKnobVolumeLFORampTimeID = 0x2000008;
    public static final int kQTMSKnobVolumeLFOPeriodID = 0x2000009;
    public static final int kQTMSKnobVolumeLFOShapeID = 0x200000a;
    public static final int kQTMSKnobVolumeLFODepthID = 0x200000b;
    public static final int kQTMSKnobVolumeOverallID = 0x200000c;
    public static final int kQTMSKnobVolumeVelocity127ID = 0x200000d;
    public static final int kQTMSKnobVolumeVelocity96ID = 0x200000e;
    public static final int kQTMSKnobVolumeVelocity64ID = 0x200000f;
    public static final int kQTMSKnobVolumeVelocity32ID = 0x2000010;
    public static final int kQTMSKnobVolumeVelocity16ID = 0x2000011;
    public static final int kQTMSKnobPitchTransposeID = 0x2000012;
    public static final int kQTMSKnobPitchLFODelayID = 0x2000013;
    public static final int kQTMSKnobPitchLFORampTimeID = 0x2000014;
    public static final int kQTMSKnobPitchLFOPeriodID = 0x2000015;
    public static final int kQTMSKnobPitchLFOShapeID = 0x2000016;
    public static final int kQTMSKnobPitchLFODepthID = 0x2000017;
    public static final int kQTMSKnobPitchLFOQuantizeID = 0x2000018;
    public static final int kQTMSKnobStereoDefaultPanID = 0x2000019;
    public static final int kQTMSKnobStereoPositionKeyScalingID = 0x200001a;
    public static final int kQTMSKnobPitchLFOOffsetID = 0x200001b;
    public static final int kQTMSKnobExclusionGroupID = 0x200001c;
    public static final int kQTMSKnobSustainTimeID = 0x200001d;
    public static final int kQTMSKnobSustainInfiniteID = 0x200001e;
    public static final int kQTMSKnobVolumeLFOStereoID = 0x200001f;
    public static final int kQTMSKnobVelocityLowID = 0x2000020;
    public static final int kQTMSKnobVelocityHighID = 0x2000021;
    public static final int kQTMSKnobVelocitySensitivityID = 0x2000022;
    public static final int kQTMSKnobPitchSensitivityID = 0x2000023;
    public static final int kQTMSKnobVolumeLFODepthFromWheelID = 0x2000024;
    public static final int kQTMSKnobPitchLFODepthFromWheelID = 0x2000025;
    public static final int kQTMSKnobVolumeExpOptionsID = 0x2000026;
    public static final int kQTMSKnobEnv1AttackTimeID = 0x2000027;
    public static final int kQTMSKnobEnv1DecayTimeID = 0x2000028;
    public static final int kQTMSKnobEnv1SustainLevelID = 0x2000029;
    public static final int kQTMSKnobEnv1SustainTimeID = 0x200002a;
    public static final int kQTMSKnobEnv1SustainInfiniteID = 0x200002b;
    public static final int kQTMSKnobEnv1ReleaseTimeID = 0x200002c;
    public static final int kQTMSKnobEnv1ExpOptionsID = 0x200002d;
    public static final int kQTMSKnobEnv2AttackTimeID = 0x200002e;
    public static final int kQTMSKnobEnv2DecayTimeID = 0x200002f;
    public static final int kQTMSKnobEnv2SustainLevelID = 0x2000030;
    public static final int kQTMSKnobEnv2SustainTimeID = 0x2000031;
    public static final int kQTMSKnobEnv2SustainInfiniteID = 0x2000032;
    public static final int kQTMSKnobEnv2ReleaseTimeID = 0x2000033;
    public static final int kQTMSKnobEnv2ExpOptionsID = 0x2000034;
    public static final int kQTMSKnobPitchEnvelopeID = 0x2000035;
    public static final int kQTMSKnobPitchEnvelopeDepthID = 0x2000036;
    public static final int kQTMSKnobFilterKeyFollowID = 0x2000037;
    public static final int kQTMSKnobFilterTransposeID = 0x2000038;
    public static final int kQTMSKnobFilterQID = 0x2000039;
    public static final int kQTMSKnobFilterFrequencyEnvelopeID = 0x200003a;
    public static final int kQTMSKnobFilterFrequencyEnvelopeDepthID = 0x200003b;
    public static final int kQTMSKnobFilterQEnvelopeID = 0x200003c;
    public static final int kQTMSKnobFilterQEnvelopeDepthID = 0x200003d;
    public static final int kQTMSKnobReverbThresholdID = 0x200003e;
    public static final int kQTMSKnobVolumeAttackVelScalingID = 0x200003f;
    public static final int kQTMSKnobLastIDPlus1 = 0x2000040;
    public static final int kFirstGMInstrument = 1;
    public static final int kLastGMInstrument = 128;
    public static final int kFirstGSInstrument = 129;
    public static final int kLastGSInstrument = 16383;
    public static final int kFirstROMInstrument = 32768;
    public static final int kLastROMInstrument = 65535;
    public static final int kFirstUserInstrument = 0x10000;
    public static final int kLastUserInstrument = 0x1ffff;
    public static final int kInstrumentMatchSynthesizerType = 1;
    public static final int kInstrumentMatchSynthesizerName = 2;
    public static final int kInstrumentMatchName = 4;
    public static final int kInstrumentMatchNumber = 8;
    public static final int kInstrumentMatchGMNumber = 16;
    public static final int kInstrumentMatchGSNumber = 32;
    public static final int kKnobBasic = 8;
    public static final int kKnobReadOnly = 16;
    public static final int kKnobInterruptUnsafe = 32;
    public static final int kKnobKeyrangeOverride = 64;
    public static final int kKnobGroupStart = 128;
    public static final int kKnobFixedPoint8 = 1024;
    public static final int kKnobFixedPoint16 = 2048;
    public static final int kKnobTypeNumber = 0;
    public static final int kKnobTypeGroupName = 4096;
    public static final int kKnobTypeBoolean = 8192;
    public static final int kKnobTypeNote = 12288;
    public static final int kKnobTypePan = 16384;
    public static final int kKnobTypeInstrument = 20480;
    public static final int kKnobTypeSetting = 24576;
    public static final int kKnobTypeMilliseconds = 28672;
    public static final int kKnobTypePercentage = 32768;
    public static final int kKnobTypeHertz = 36864;
    public static final int kKnobTypeButton = 40960;
    public static final int kUnknownKnobValue = 0x7fffffff;
    public static final int kDefaultKnobValue = 0x7ffffffe;
    public static final short kControllerMaximum = 32767;
    public static final short kControllerMinimum = -32768;
    public static final int kNoDrumKit = 16384;
    public static final int kFirstDrumkit = 16385;
    public static final int kLastDrumkit = 16512;
    public static final int kSynthesizerConnectionMono = 1;
    public static final int kSynthesizerConnectionMMgr = 2;
    public static final int kSynthesizerConnectionOMS = 4;
    public static final int kSynthesizerConnectionQT = 8;
    public static final int kSynthesizerConnectionUnavailable = 256;
    public static final int kSynthesizerConnectionFMS = 16;
    public static final int kSynthesizerDynamicVoice = 1;
    public static final int kSynthesizerUsesMIDIPort = 2;
    public static final int kSynthesizerMicrotone = 4;
    public static final int kSynthesizerHasSamples = 8;
    public static final int kSynthesizerMixedDrums = 16;
    public static final int kSynthesizerSoftware = 32;
    public static final int kSynthesizerHardware = 64;
    public static final int kSynthesizerDynamicChannel = 128;
    public static final int kSynthesizerHogsSystemChannel = 256;
    public static final int kSynthesizerHasSystemChannel = 512;
    public static final int kSynthesizerSlowSetPart = 1024;
    public static final int kSynthesizerOffline = 4096;
    public static final int kSynthesizerGM = 16384;
    public static final int kSynthesizerDLS = 32768;
    public static final int kSynthesizerSoundLocalization = 0x10000;
    public static final int kTunePlayerComponentType = 0x74756e65;
    public static final int kTuneStartNow = 1;
    public static final int kTuneDontClipNotes = 2;
    public static final int kTuneExcludeEdgeNotes = 4;
    public static final int kTuneQuickStart = 8;
    public static final int kTuneLoopUntil = 16;
    public static final int kTunePlayDifference = 32;
    public static final int kTunePlayConcurrent = 64;
    public static final int kTuneStartNewMaster = 16384;
    public static final int kTuneStopFade = 1;
    public static final int kTuneStopSustain = 2;
    public static final int kTuneStopInstant = 4;
    public static final int kTuneStopReleaseChannels = 8;
    public static final int kTuneMixMute = 1;
    public static final int kTuneMixSolo = 2;
    public static final int kRestEventType = 0;
    public static final int kNoteEventType = 1;
    public static final int kControlEventType = 2;
    public static final int kMarkerEventType = 3;
    public static final int kUndefined1EventType = 8;
    public static final int kXNoteEventType = 9;
    public static final int kXControlEventType = 10;
    public static final int kKnobEventType = 11;
    public static final int kUndefined2EventType = 12;
    public static final int kUndefined3EventType = 13;
    public static final int kUndefined4EventType = 14;
    public static final int kGeneralEventType = 15;
    public static final int kXEventLengthBits = 2;
    public static final int kGeneralEventLengthBits = 3;
    public static final int kEventLen = 1;
    public static final int kXEventLen = 2;
    public static final int kRestEventLen = 1;
    public static final int kNoteEventLen = 1;
    public static final int kControlEventLen = 1;
    public static final int kMarkerEventLen = 1;
    public static final int kXNoteEventLen = 2;
    public static final int kXControlEventLen = 2;
    public static final int kGeneralEventLen = 2;
    public static final int kEventLengthFieldPos = 30;
    public static final int kEventLengthFieldWidth = 2;
    public static final int kEventTypeFieldPos = 29;
    public static final int kEventTypeFieldWidth = 3;
    public static final int kXEventTypeFieldPos = 28;
    public static final int kXEventTypeFieldWidth = 4;
    public static final int kEventPartFieldPos = 24;
    public static final int kEventPartFieldWidth = 5;
    public static final int kXEventPartFieldPos = 16;
    public static final int kXEventPartFieldWidth = 12;
    public static final int kRestEventDurationFieldPos = 0;
    public static final int kRestEventDurationFieldWidth = 24;
    public static final int kRestEventDurationMax = 0xffffff;
    public static final int kNoteEventPitchFieldPos = 18;
    public static final int kNoteEventPitchFieldWidth = 6;
    public static final int kNoteEventPitchOffset = 32;
    public static final int kNoteEventVolumeFieldPos = 11;
    public static final int kNoteEventVolumeFieldWidth = 7;
    public static final int kNoteEventVolumeOffset = 0;
    public static final int kNoteEventDurationFieldPos = 0;
    public static final int kNoteEventDurationFieldWidth = 11;
    public static final int kNoteEventDurationMax = 2047;
    public static final int kXNoteEventPitchFieldPos = 0;
    public static final int kXNoteEventPitchFieldWidth = 16;
    public static final int kXNoteEventDurationFieldPos = 0;
    public static final int kXNoteEventDurationFieldWidth = 22;
    public static final int kXNoteEventDurationMax = 0x3fffff;
    public static final int kXNoteEventVolumeFieldPos = 22;
    public static final int kXNoteEventVolumeFieldWidth = 7;
    public static final int kControlEventControllerFieldPos = 16;
    public static final int kControlEventControllerFieldWidth = 8;
    public static final int kControlEventValueFieldPos = 0;
    public static final int kControlEventValueFieldWidth = 16;
    public static final int kXControlEventControllerFieldPos = 0;
    public static final int kXControlEventControllerFieldWidth = 16;
    public static final int kXControlEventValueFieldPos = 0;
    public static final int kXControlEventValueFieldWidth = 16;
    public static final int kKnobEventValueHighFieldPos = 0;
    public static final int kKnobEventValueHighFieldWidth = 16;
    public static final int kKnobEventKnobFieldPos = 16;
    public static final int kKnobEventKnobFieldWidth = 14;
    public static final int kKnobEventValueLowFieldPos = 0;
    public static final int kKnobEventValueLowFieldWidth = 16;
    public static final int kMarkerEventSubtypeFieldPos = 16;
    public static final int kMarkerEventSubtypeFieldWidth = 8;
    public static final int kMarkerEventValueFieldPos = 0;
    public static final int kMarkerEventValueFieldWidth = 16;
    public static final int kGeneralEventSubtypeFieldPos = 16;
    public static final int kGeneralEventSubtypeFieldWidth = 14;
    public static final int kGeneralEventLengthFieldPos = 0;
    public static final int kGeneralEventLengthFieldWidth = 16;
    public static final int kCurrentlyNativeEndian = 1;
    public static final int kCurrentlyNotNativeEndian = 2;
    public static final int movieExportType = 0x73706974;
    public static final int kMovieExportTextOnly = 0;
    public static final int kMovieExportAbsoluteTime = 1;
    public static final int kMovieExportRelativeTime = 2;
    public static final int movieImportType = 0x65617420;
    public static final int movieImportCreateTrack = 1;
    public static final int movieImportInParallel = 2;
    public static final int movieImportMustUseTrack = 4;
    public static final int movieImportResultUsedMultipleTracks = 8;
    public static final int kMIDIImportSilenceBefore = 1;
    public static final int kMIDIImportSilenceAfter = 2;
    public static final int kMIDIImport20Playable = 4;
    public static final int kMIDIImportWantLyrics = 8;
    public static final int kQTSettingsEffect = 0x65666665;
    public static final int kQTSettingsMIDI = 0x4d494449;
    public static final int kQTSettingsMIDISettingFlags = 0x73747467;
    public static final int kQTSettingsText = 0x74657874;
    public static final int kQTSettingsTextDescription = 0x64657363;
    public static final int kQTSettingsTextSize = 0x73697a65;
    public static final int kQTSettingsTextSettingFlags = 0x73747467;
    public static final int kQTSettingsTextTimeFraction = 0x74696d66;
    public static final int kQTSettingsTime = 0x74696d65;
    public static final int kQTSettingsAudioCDTrack = 0x7472616b;
    public static final int kQTSettingsAudioCDTrackRateShift = 0x72736866;
    public static final int tcDropFrame = 1;
    public static final int tc24HourMax = 2;
    public static final int tcNegTimesOK = 4;
    public static final int tcCounter = 8;
    public static final int tcdfShowTimeCode = 1;
    public static final int tweenComponentType = 0x7477656e;
    public static final int kTweenEntry = 0x7477656e;
    public static final int kTweenData = 0x64617461;
    public static final int kTweenType = 0x74776e74;
    public static final int kTweenStartOffset = 0x74777374;
    public static final int kTweenDuration = 0x74776475;
    public static final int kTweenFlags = 0x666c6167;
    public static final int kTweenOutputMin = 0x6f6d696e;
    public static final int kTweenOutputMax = 0x6f6d6178;
    public static final int kTweenSequenceElement = 0x73657165;
    public static final int kTween3dInitialCondition = 0x69636e64;
    public static final int kTweenInterpolationID = 0x696e7472;
    public static final int kTweenInterpolateStyle = 0x69737479;
    public static final int kInputMapSubInputID = 0x73756269;
    public static final int kTweenRegionData = 0x71647267;
    public static final int kTweenPictureData = 0x50494354;
    public static final int kListElementType = 0x74797065;
    public static final int kListElementDataType = 0x64617479;
    public static final int kNameAtom = 0x6e616d65;
    public static final int kInitialRotationAtom = 0x696e726f;
    public static final int kNonLinearTweenHeader = 0x6e6c7468;
    public static final int kTweenReturnDelta = 1;
    public static final int kTweenTypeShort = 1;
    public static final int kTweenTypeLong = 2;
    public static final int kTweenTypeFixed = 3;
    public static final int kTweenTypeFloat = 3;
    public static final int kTweenTypePoint = 4;
    public static final int kTweenTypeQDRect = 5;
    public static final int kTweenTypeQDRegion = 6;
    public static final int kTweenTypeMatrix = 7;
    public static final int kTweenTypeRGBColor = 8;
    public static final int kTweenTypeGraphicsModeWithRGBColor = 9;
    public static final int kTweenTypeQTFloatSingle = 10;
    public static final int kTweenTypeQTFloatDouble = 11;
    public static final int kTweenTypeFixedPoint = 12;
    public static final int kTweenType3dScale = 0x33736361;
    public static final int kTweenType3dTranslate = 0x33747261;
    public static final int kTweenType3dRotate = 0x33726f74;
    public static final int kTweenType3dRotateAboutPoint = 0x33726170;
    public static final int kTweenType3dRotateAboutAxis = 0x33726178;
    public static final int kTweenType3dRotateAboutVector = 0x33727663;
    public static final int kTweenType3dQuaternion = 0x33717561;
    public static final int kTweenType3dMatrix = 0x336d6174;
    public static final int kTweenType3dCameraData = 0x3363616d;
    public static final int kTweenType3dSoundLocalizationData = 0x33736c63;
    public static final int kTweenTypePathToMatrixTranslation = 0x67786d74;
    public static final int kTweenTypePathToMatrixRotation = 0x67787072;
    public static final int kTweenTypePathToMatrixTranslationAndRotation = 0x67786d72;
    public static final int kTweenTypePathToFixedPoint = 0x67786670;
    public static final int kTweenTypePathXtoY = 0x67787879;
    public static final int kTweenTypePathYtoX = 0x67787978;
    public static final int kTweenTypeAtomList = 0x61746f6d;
    public static final int kTweenTypePolygon = 0x706f6c79;
    public static final int kTweenTypeMultiMatrix = 0x6d756c6d;
    public static final int kTweenTypeSpin = 0x7370696e;
    public static final int kTweenType3dMatrixNonLinear = 0x336e6c72;
    public static final int kTweenType3dVRObject = 0x3376726f;
    public static final int kParameterTypeDataLong = 2;
    public static final int kParameterTypeDataFixed = 3;
    public static final int kParameterTypeDataRGBValue = 8;
    public static final int kParameterTypeDataDouble = 11;
    public static final int seqGrabComponentType = 0x62617267;
    public static final int seqGrabChannelType = 0x73676368;
    public static final int seqGrabPanelType = 0x7367706e;
    public static final int seqGrabCompressionPanelType = 0x636d7072;
    public static final int seqGrabSourcePanelType = 0x736f7572;
    public static final int seqGrabUnpause = 0;
    public static final int seqGrabPause = 1;
    public static final int seqGrabPauseForMenu = 3;
    public static final int seqGrabToDisk = 1;
    public static final int seqGrabToMemory = 2;
    public static final int seqGrabDontUseTempMemory = 4;
    public static final int seqGrabAppendToFile = 8;
    public static final int seqGrabDontAddMovieResource = 16;
    public static final int seqGrabDontMakeMovie = 32;
    public static final int seqGrabPreExtendFile = 64;
    public static final int seqGrabDataProcIsInterruptSafe = 128;
    public static final int seqGrabDataProcDoesOverlappingReads = 256;
    public static final int seqGrabRecord = 1;
    public static final int seqGrabPreview = 2;
    public static final int seqGrabPlayDuringRecord = 4;
    public static final int seqGrabHasBounds = 1;
    public static final int seqGrabHasVolume = 2;
    public static final int seqGrabHasDiscreteSamples = 4;
    public static final int sgDeviceListWithIcons = 1;
    public static final int sgDeviceListDontCheckAvailability = 2;
    public static final int seqGrabWriteAppend = 0;
    public static final int seqGrabWriteReserve = 1;
    public static final int seqGrabWriteFill = 2;
    public static final int channelPlayNormal = 0;
    public static final int channelPlayFast = 1;
    public static final int channelPlayHighQuality = 2;
    public static final int channelPlayAllData = 4;
    public static final int channelFlagDontOpenResFile = 2;
    public static final int channelFlagHasDependency = 4;
    public static final int videoDigitizerComponentType = 0x76696467;
    public static final int vdigInterfaceRev = 2;
    public static final int ntscIn = 0;
    public static final int currentIn = 0;
    public static final int palIn = 1;
    public static final int secamIn = 2;
    public static final int ntscReallyIn = 3;
    public static final int compositeIn = 0;
    public static final int sVideoIn = 1;
    public static final int rgbComponentIn = 2;
    public static final int rgbComponentSyncIn = 3;
    public static final int yuvComponentIn = 4;
    public static final int yuvComponentSyncIn = 5;
    public static final int tvTunerIn = 6;
    public static final int sdiIn = 7;
    public static final int vdPlayThruOff = 0;
    public static final int vdPlayThruOn = 1;
    public static final int vdDigitizerBW = 0;
    public static final int vdDigitizerRGB = 1;
    public static final int vdBroadcastMode = 0;
    public static final int vdVTRMode = 1;
    public static final int vdUseAnyField = 0;
    public static final int vdUseOddField = 1;
    public static final int vdUseEvenField = 2;
    public static final int vdTypeBasic = 0;
    public static final int vdTypeAlpha = 1;
    public static final int vdTypeMask = 2;
    public static final int vdTypeKey = 3;
    public static final int digiInDoesNTSC = 1;
    public static final int digiInDoesPAL = 2;
    public static final int digiInDoesSECAM = 4;
    public static final int digiInDoesGenLock = 128;
    public static final int digiInDoesComposite = 256;
    public static final int digiInDoesSVideo = 512;
    public static final int digiInDoesComponent = 1024;
    public static final int digiInVTR_Broadcast = 2048;
    public static final int digiInDoesColor = 4096;
    public static final int digiInDoesBW = 8192;
    public static final int digiInSignalLock = 0x80000000;
    public static final int digiOutDoes1 = 1;
    public static final int digiOutDoes2 = 2;
    public static final int digiOutDoes4 = 4;
    public static final int digiOutDoes8 = 8;
    public static final int digiOutDoes16 = 16;
    public static final int digiOutDoes32 = 32;
    public static final int digiOutDoesDither = 64;
    public static final int digiOutDoesStretch = 128;
    public static final int digiOutDoesShrink = 256;
    public static final int digiOutDoesMask = 512;
    public static final int digiOutDoesDouble = 2048;
    public static final int digiOutDoesQuad = 4096;
    public static final int digiOutDoesQuarter = 8192;
    public static final int digiOutDoesSixteenth = 16384;
    public static final int digiOutDoesRotate = 32768;
    public static final int digiOutDoesHorizFlip = 0x10000;
    public static final int digiOutDoesVertFlip = 0x20000;
    public static final int digiOutDoesSkew = 0x40000;
    public static final int digiOutDoesBlend = 0x80000;
    public static final int digiOutDoesWarp = 0x100000;
    public static final int digiOutDoesHW_DMA = 0x200000;
    public static final int digiOutDoesHWPlayThru = 0x400000;
    public static final int digiOutDoesILUT = 0x800000;
    public static final int digiOutDoesKeyColor = 0x1000000;
    public static final int digiOutDoesAsyncGrabs = 0x2000000;
    public static final int digiOutDoesUnreadableScreenBits = 0x4000000;
    public static final int digiOutDoesCompress = 0x8000000;
    public static final int digiOutDoesCompressOnly = 0x10000000;
    public static final int digiOutDoesPlayThruDuringCompress = 0x20000000;
    public static final int digiOutDoesCompressPartiallyVisible = 0x40000000;
    public static final int dmaDepth1 = 1;
    public static final int dmaDepth2 = 2;
    public static final int dmaDepth4 = 4;
    public static final int dmaDepth8 = 8;
    public static final int dmaDepth16 = 16;
    public static final int dmaDepth32 = 32;
    public static final int dmaDepth2Gray = 64;
    public static final int dmaDepth4Gray = 128;
    public static final int dmaDepth8Gray = 256;
    public static final int kVDIGControlledFrameRate = -1;
    public static final int sgChannelAtom = 0x6368616e;
    public static final int sgChannelSettingsAtom = 0x63746f6d;
    public static final int sgChannelDescription = 0x63647363;
    public static final int sgChannelSettings = 0x63736574;
    public static final int sgDeviceNameType = 0x6e616d65;
    public static final int sgUsageType = 0x75736520;
    public static final int sgPlayFlagsType = 0x706c7966;
    public static final int sgClipType = 0x636c6970;
    public static final int sgMatrixType = 0x6d747278;
    public static final int sgVolumeType = 0x766f6c75;
    public static final int sgPanelSettingsAtom = 0x70746f6d;
    public static final int sgPanelDescription = 0x70647363;
    public static final int sgPanelSettings = 0x70736574;
    public static final int sgcSoundCompressionType = 0x73636d70;
    public static final int sgcSoundSampleRateType = 0x73726174;
    public static final int sgcSoundChannelCountType = 0x7363686e;
    public static final int sgcSoundSampleSizeType = 0x7373697a;
    public static final int sgcSoundInputType = 0x73696e70;
    public static final int sgcSoundGainType = 0x6761696e;
    public static final int sgcVideoHueType = 0x68756520;
    public static final int sgcVideoSaturationType = 0x73617472;
    public static final int sgcVideoContrastType = 0x74727374;
    public static final int sgcVideoSharpnessType = 0x73687270;
    public static final int sgcVideoBrigtnessType = 0x62726974;
    public static final int sgcVideoBlackLevelType = 0x626c6b6c;
    public static final int sgcVideoWhiteLevelType = 0x7768746c;
    public static final int sgcVideoInputType = 0x76696e70;
    public static final int sgcVideoFormatType = 0x76737464;
    public static final int sgcVideoFilterType = 0x76666c74;
    public static final int sgcVideoRectType = 0x76726374;
    public static final int sgcVideoDigitizerType = 0x76646967;
    public static final int kQTVODisplayModeItem = 0x71646d69;
    public static final int kQTVODimensions = 0x64696d6e;
    public static final int kQTVOResolution = 0x7265736c;
    public static final int kQTVORefreshRate = 0x72656672;
    public static final int kQTVOPixelType = 0x7069786c;
    public static final int kQTVOName = 0x6e616d65;
    public static final int kQTVODecompressors = 0x6465636f;
    public static final int kQTVODecompressorType = 0x64657479;
    public static final int kQTVODecompressorContinuous = 0x636f6e74;
    public static final int kQTVODecompressorComponent = 0x636d7074;
    public static final int canMovieImportHandles = 1;
    public static final int canMovieImportFiles = 2;
    public static final int hasMovieImportUserInterface = 4;
    public static final int canMovieExportHandles = 8;
    public static final int canMovieExportFiles = 16;
    public static final int hasMovieExportUserInterface = 32;
    public static final int dontAutoFileMovieImport = 64;
    public static final int canMovieExportAuxDataHandle = 128;
    public static final int canMovieImportValidateHandles = 256;
    public static final int canMovieImportValidateFile = 512;
    public static final int dontRegisterWithEasyOpen = 1024;
    public static final int canMovieImportInPlace = 2048;
    public static final int movieImportSubTypeIsFileExtension = 4096;
    public static final int canMovieImportPartial = 8192;
    public static final int hasMovieImportMIMEList = 16384;
    public static final int canMovieExportFromProcedures = 32768;
    public static final int canMovieExportValidateMovie = 0x10000;
    public static final int movieExportNeedsResourceFork = 0x20000;
    public static final int canMovieImportDataReferences = 0x40000;
    public static final int movieExportMustGetSourceMediaType = 0x80000;
    public static final int reservedForUseByGraphicsImporters = 0x800000;
    public static final int scPositionRect = 2;
    public static final int scPositionDialog = 3;
    public static final int scSetTestImagePictHandle = 4;
    public static final int scSetTestImagePictFile = 5;
    public static final int scSetTestImagePixMap = 6;
    public static final int scGetBestDeviceRect = 7;
    public static final int scRequestImageSettings = 10;
    public static final int scCompressImage = 11;
    public static final int scCompressPicture = 12;
    public static final int scCompressPictureFile = 13;
    public static final int scRequestSequenceSettings = 14;
    public static final int scCompressSequenceBegin = 15;
    public static final int scCompressSequenceFrame = 16;
    public static final int scCompressSequenceEnd = 17;
    public static final int scDefaultPictHandleSettings = 18;
    public static final int scDefaultPictFileSettings = 19;
    public static final int scDefaultPixMapSettings = 20;
    public static final int scGetInfo = 21;
    public static final int scSetInfo = 22;
    public static final int scNewGWorld = 23;
}
