/*
 * File    : ReportServerSettingsDlg.java
 * Created : 21-feb-2003 09:57
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

import edu.xtec.jclic.ReportServerConstants;
import edu.xtec.jclic.report.BasicJDBCBridge;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.09.09
 */
public class ReportServerSettingsDlg extends JDialog implements ReportServerConstants{
    
    Options options;
    Messages msg;
    public boolean result;
    
    /** Creates new form ReportServerSettingsDlg */
    public ReportServerSettingsDlg(Frame parent, boolean modal, Options options) {
        super(parent, modal);
        this.options=options;
        msg=options.getMessages();
        initComponents();
        result=false;
        Point p=parent.getLocationOnScreen();
        setLocation(p.x+80, p.y+30);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    javax.swing.JTabbedPane mainPanel = new javax.swing.JTabbedPane();
    javax.swing.JPanel optionsPanel = new javax.swing.JPanel();
    langLb = new javax.swing.JLabel();
    langCombo = new javax.swing.JComboBox<Object>(Messages.getDescriptiveLanguageCodes(msg.getLocale()));
    javax.swing.JLabel lookLb = new javax.swing.JLabel();
    lookCombo = new javax.swing.JComboBox<Object>(edu.xtec.util.LFUtil.VALUES);
    tooltipChk = new javax.swing.JCheckBox();
    javax.swing.JLabel browserLb = new javax.swing.JLabel();
    browserField = new javax.swing.JTextField();
    dbPanel = new javax.swing.JPanel();
    driverLb = new javax.swing.JLabel();
    driverField = new javax.swing.JTextField();
    urlLb = new javax.swing.JLabel();
    urlField = new javax.swing.JTextField();
    usrLb = new javax.swing.JLabel();
    usrField = new javax.swing.JTextField();
    pwdLb = new javax.swing.JLabel();
    pwdField = new javax.swing.JPasswordField(options.getString(ConnectionBeanProvider.DB_PASSWORD, ""), 20);
    prefixLb = new javax.swing.JLabel();
    prefixFld = new javax.swing.JTextField();
    createChk = new javax.swing.JCheckBox();
    webPanel = new javax.swing.JPanel();
    webAutostartChk = new javax.swing.JCheckBox();
    webPortLb = new javax.swing.JLabel();
    webPortField = new javax.swing.JTextField();
    webTimeoutLb = new javax.swing.JLabel();
    webTimeoutField = new javax.swing.JTextField();
    sessionLifetimeLb = new javax.swing.JLabel();
    sessionLifetimeField = new javax.swing.JTextField();
    webLogLb = new javax.swing.JLabel();
    webLogField = new javax.swing.JTextField();
    logFileWebBtn = new javax.swing.JButton();
    javax.swing.JPanel btPanel = new javax.swing.JPanel();
    javax.swing.JButton btOk = new javax.swing.JButton();
    javax.swing.JButton btCancel = new javax.swing.JButton();

    setTitle(msg.get("settings_title"));
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        closeDialog(evt);
      }
    });

    optionsPanel.setLayout(new java.awt.GridBagLayout());

    langLb.setText(msg.get("settings_options_language"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(langLb, gridBagConstraints);

    langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(msg.getLocale().getLanguage()));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(langCombo, gridBagConstraints);

    lookLb.setText(msg.get("settings_options_look"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(lookLb, gridBagConstraints);

    lookCombo.setSelectedItem(options.getString(LOOK, LFUtil.DEFAULT));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(lookCombo, gridBagConstraints);

    tooltipChk.setSelected(options.getBoolean(TOOLTIPS, true));
    tooltipChk.setText(msg.get("settings_options_tooltips"));
    tooltipChk.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        tooltipChkActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(tooltipChk, gridBagConstraints);

    browserLb.setLabelFor(browserField);
    browserLb.setText(msg.get("settings_browser"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(browserLb, gridBagConstraints);

    browserField.setText(options.getString(edu.xtec.util.BrowserLauncher.BROWSER, ""));
    browserField.setToolTipText("msg.get(\"settings_browser_tooltip\")");
    browserField.setMinimumSize(new java.awt.Dimension(75, 21));
    browserField.setPreferredSize(new java.awt.Dimension(200, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    optionsPanel.add(browserField, gridBagConstraints);

    mainPanel.addTab(msg.get("settings_options_title"), optionsPanel);

    dbPanel.setPreferredSize(new java.awt.Dimension(440, 200));
    dbPanel.setLayout(new java.awt.GridBagLayout());

    driverLb.setText(msg.get("settings_db_driver"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(driverLb, gridBagConstraints);

    driverField.setText(options.getString(ConnectionBeanProvider.DB_DRIVER, ""));
    driverField.setMinimumSize(new java.awt.Dimension(75, 21));
    driverField.setPreferredSize(new java.awt.Dimension(200, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(driverField, gridBagConstraints);

    urlLb.setText(msg.get("settings_db_url"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(urlLb, gridBagConstraints);

    urlField.setText(options.getString(ConnectionBeanProvider.DB_SERVER, ""));
    urlField.setMinimumSize(new java.awt.Dimension(75, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(urlField, gridBagConstraints);

    usrLb.setText(msg.get("settings_db_usr"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(usrLb, gridBagConstraints);

    usrField.setText(options.getString(ConnectionBeanProvider.DB_LOGIN, ""));
    usrField.setMinimumSize(new java.awt.Dimension(75, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(usrField, gridBagConstraints);

    pwdLb.setText(msg.get("settings_db_pwd"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(pwdLb, gridBagConstraints);

    pwdField.setMinimumSize(new java.awt.Dimension(75, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(pwdField, gridBagConstraints);

    prefixLb.setText(msg.get("settings_tablePrefix"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(prefixLb, gridBagConstraints);

    prefixFld.setText(options.getString(BasicJDBCBridge.TABLE_PREFIX_KEY, ""));
    prefixFld.setMinimumSize(new java.awt.Dimension(75, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(prefixFld, gridBagConstraints);

    createChk.setSelected(options.getBoolean(BasicJDBCBridge.CREATE_TABLES_KEY, true));
    createChk.setText(options.getMsg("settings_createTables"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    dbPanel.add(createChk, gridBagConstraints);

    mainPanel.addTab(msg.get("settings_db_title"), dbPanel);

    webPanel.setPreferredSize(new java.awt.Dimension(300, 112));
    webPanel.setLayout(new java.awt.GridBagLayout());

    webAutostartChk.setSelected(options.getBoolean(HTTP_AUTOSTART, false));
    webAutostartChk.setText(msg.get("settings_server_autostart"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webAutostartChk, gridBagConstraints);

    webPortLb.setLabelFor(webPortField);
    webPortLb.setText(msg.get("settings_server_port"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webPortLb, gridBagConstraints);

    webPortField.setText(options.getString(HTTP_PORT, ""));
    webPortField.setMinimumSize(new java.awt.Dimension(70, 21));
    webPortField.setPreferredSize(new java.awt.Dimension(80, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webPortField, gridBagConstraints);

    webTimeoutLb.setLabelFor(webTimeoutField);
    webTimeoutLb.setText(msg.get("settings_server_timeout"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webTimeoutLb, gridBagConstraints);

    webTimeoutField.setText(options.getString(HTTP_TIMEOUT, ""));
    webTimeoutField.setMinimumSize(new java.awt.Dimension(70, 21));
    webTimeoutField.setPreferredSize(new java.awt.Dimension(80, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webTimeoutField, gridBagConstraints);

    sessionLifetimeLb.setLabelFor(sessionLifetimeField);
    sessionLifetimeLb.setText(msg.get("settings_session_lifetime"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(sessionLifetimeLb, gridBagConstraints);

    sessionLifetimeField.setText(options.getString(SESSION_LIFETIME, ""));
    sessionLifetimeField.setMinimumSize(new java.awt.Dimension(70, 21));
    sessionLifetimeField.setPreferredSize(new java.awt.Dimension(80, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(sessionLifetimeField, gridBagConstraints);

    webLogLb.setLabelFor(webLogField);
    webLogLb.setText(msg.get("settings_server_logFile"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webLogLb, gridBagConstraints);

    webLogField.setText(options.getString(HTTP_LOGFILE, ""));
    webLogField.setMinimumSize(new java.awt.Dimension(70, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(webLogField, gridBagConstraints);

    logFileWebBtn.setText(msg.get("settings_file"));
    logFileWebBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        logFileWebBtnActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    webPanel.add(logFileWebBtn, gridBagConstraints);

    mainPanel.addTab(msg.get("settings_web_title"), webPanel);

    getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);

    btOk.setText(msg.get("OK"));
    btOk.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        btOkActionPerformed(evt);
      }
    });
    btPanel.add(btOk);

    btCancel.setText(msg.get("CANCEL"));
    btCancel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        btCancelActionPerformed(evt);
      }
    });
    btPanel.add(btCancel);

    getContentPane().add(btPanel, java.awt.BorderLayout.SOUTH);

    pack();
  }// </editor-fold>//GEN-END:initComponents

    private void logFileWebBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_logFileWebBtnActionPerformed

        JFileChooser chooser;
        String s=webLogField.getText();
        if(s!=null && s.length()>0){
            File f=new File(s);
            chooser=new JFileChooser(f.getParent());
            chooser.setSelectedFile(f);
        }
        else{
            chooser=new JFileChooser();
            chooser.setSelectedFile(new File("jclic_webserver.log"));
        }
        
        int b=chooser.showSaveDialog(this);
        if(b==JFileChooser.APPROVE_OPTION){
            webLogField.setText(chooser.getSelectedFile().getAbsolutePath());
        }

    }//GEN-LAST:event_logFileWebBtnActionPerformed

    private void tooltipChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tooltipChkActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_tooltipChkActionPerformed

    private void btCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btCancelActionPerformed

        closeDialog(null);
        
    }//GEN-LAST:event_btCancelActionPerformed

    private void btOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btOkActionPerformed
     
        readValues();
        result=true;
        closeDialog(null);
        
    }//GEN-LAST:event_btOkActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    protected void readValues(){
        options.put(Messages.LANGUAGE, 
        Messages.getLanguageFromDescriptive(langCombo.getSelectedItem().toString()));
        options.put(LOOK, lookCombo.getSelectedItem().toString());
        options.put(TOOLTIPS, tooltipChk.isSelected() ? TRUE : FALSE);
        
        options.put(ConnectionBeanProvider.DB_DRIVER, driverField.getText());
        options.put(ConnectionBeanProvider.DB_SERVER, urlField.getText());
        options.put(ConnectionBeanProvider.DB_LOGIN, usrField.getText());
        options.put(ConnectionBeanProvider.DB_PASSWORD, new String(pwdField.getPassword()));
        
        options.put(BasicJDBCBridge.TABLE_PREFIX_KEY, prefixFld.getText());
        options.put(BasicJDBCBridge.CREATE_TABLES_KEY, createChk.isSelected() ? "true" : "false");
        
        options.put(HTTP_PORT, webPortField.getText());
        options.put(HTTP_TIMEOUT, webTimeoutField.getText());
        options.put(SESSION_LIFETIME, sessionLifetimeField.getText());
        options.put(HTTP_AUTOSTART, webAutostartChk.isSelected() ? TRUE : FALSE);
        options.put(HTTP_LOGFILE, webLogField.getText());
        
        options.put(BrowserLauncher.BROWSER, browserField.getText());        
    }
    
        
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField browserField;
  private javax.swing.JCheckBox createChk;
  private javax.swing.JPanel dbPanel;
  private javax.swing.JTextField driverField;
  private javax.swing.JLabel driverLb;
  private javax.swing.JComboBox<Object> langCombo;
  private javax.swing.JLabel langLb;
  private javax.swing.JButton logFileWebBtn;
  private javax.swing.JComboBox<Object> lookCombo;
  private javax.swing.JTextField prefixFld;
  private javax.swing.JLabel prefixLb;
  private javax.swing.JPasswordField pwdField;
  private javax.swing.JLabel pwdLb;
  private javax.swing.JTextField sessionLifetimeField;
  private javax.swing.JLabel sessionLifetimeLb;
  private javax.swing.JCheckBox tooltipChk;
  private javax.swing.JTextField urlField;
  private javax.swing.JLabel urlLb;
  private javax.swing.JTextField usrField;
  private javax.swing.JLabel usrLb;
  private javax.swing.JCheckBox webAutostartChk;
  private javax.swing.JTextField webLogField;
  private javax.swing.JLabel webLogLb;
  private javax.swing.JPanel webPanel;
  private javax.swing.JTextField webPortField;
  private javax.swing.JLabel webPortLb;
  private javax.swing.JTextField webTimeoutField;
  private javax.swing.JLabel webTimeoutLb;
  // End of variables declaration//GEN-END:variables
    
}
