/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.jcodings.unicode;

import org.jcodings.unicode.UnicodeEncoding.CodeRangeEntry;

public class UnicodeProperties {
    static final CodeRangeEntry[]CodeRangeTable = new CodeRangeEntry[] {
        new CodeRangeEntry("newline", "CR_NEWLINE"),
        new CodeRangeEntry("alpha", "CR_Alpha"),
        new CodeRangeEntry("blank", "CR_Blank"),
        new CodeRangeEntry("cntrl", "CR_Cntrl"),
        new CodeRangeEntry("digit", "CR_Digit"),
        new CodeRangeEntry("graph", "CR_Graph"),
        new CodeRangeEntry("lower", "CR_Lower"),
        new CodeRangeEntry("print", "CR_Print"),
        new CodeRangeEntry("xposixpunct", "CR_XPosixPunct"),
        new CodeRangeEntry("space", "CR_Space"),
        new CodeRangeEntry("upper", "CR_Upper"),
        new CodeRangeEntry("xdigit", "CR_XDigit"),
        new CodeRangeEntry("word", "CR_Word"),
        new CodeRangeEntry("alnum", "CR_Alnum"),
        new CodeRangeEntry("ascii", "CR_ASCII"),
        new CodeRangeEntry("punct", "CR_Punct"),
        new CodeRangeEntry("any", "CR_Any"),
        new CodeRangeEntry("assigned", "CR_Assigned"),
        new CodeRangeEntry("c", "CR_C"),
        new CodeRangeEntry("other", "CR_C"),
        new CodeRangeEntry("cc", "CR_Cntrl"),
        new CodeRangeEntry("control", "CR_Cntrl"),
        new CodeRangeEntry("cf", "CR_Cf"),
        new CodeRangeEntry("format", "CR_Cf"),
        new CodeRangeEntry("cn", "CR_Cn"),
        new CodeRangeEntry("unassigned", "CR_Cn"),
        new CodeRangeEntry("co", "CR_Co"),
        new CodeRangeEntry("privateuse", "CR_Co"),
        new CodeRangeEntry("cs", "CR_Cs"),
        new CodeRangeEntry("surrogate", "CR_Cs"),
        new CodeRangeEntry("l", "CR_L"),
        new CodeRangeEntry("letter", "CR_L"),
        new CodeRangeEntry("lc", "CR_LC"),
        new CodeRangeEntry("casedletter", "CR_LC"),
        new CodeRangeEntry("ll", "CR_Ll"),
        new CodeRangeEntry("lowercaseletter", "CR_Ll"),
        new CodeRangeEntry("lm", "CR_Lm"),
        new CodeRangeEntry("modifierletter", "CR_Lm"),
        new CodeRangeEntry("lo", "CR_Lo"),
        new CodeRangeEntry("otherletter", "CR_Lo"),
        new CodeRangeEntry("lt", "CR_Lt"),
        new CodeRangeEntry("titlecaseletter", "CR_Lt"),
        new CodeRangeEntry("lu", "CR_Lu"),
        new CodeRangeEntry("uppercaseletter", "CR_Lu"),
        new CodeRangeEntry("m", "CR_M"),
        new CodeRangeEntry("mark", "CR_M"),
        new CodeRangeEntry("combiningmark", "CR_M"),
        new CodeRangeEntry("mc", "CR_Mc"),
        new CodeRangeEntry("spacingmark", "CR_Mc"),
        new CodeRangeEntry("me", "CR_Me"),
        new CodeRangeEntry("enclosingmark", "CR_Me"),
        new CodeRangeEntry("mn", "CR_Mn"),
        new CodeRangeEntry("nonspacingmark", "CR_Mn"),
        new CodeRangeEntry("n", "CR_N"),
        new CodeRangeEntry("number", "CR_N"),
        new CodeRangeEntry("nd", "CR_Digit"),
        new CodeRangeEntry("decimalnumber", "CR_Digit"),
        new CodeRangeEntry("nl", "CR_Nl"),
        new CodeRangeEntry("letternumber", "CR_Nl"),
        new CodeRangeEntry("no", "CR_No"),
        new CodeRangeEntry("othernumber", "CR_No"),
        new CodeRangeEntry("p", "CR_Punct"),
        new CodeRangeEntry("punctuation", "CR_Punct"),
        new CodeRangeEntry("pc", "CR_Pc"),
        new CodeRangeEntry("connectorpunctuation", "CR_Pc"),
        new CodeRangeEntry("pd", "CR_Pd"),
        new CodeRangeEntry("dashpunctuation", "CR_Pd"),
        new CodeRangeEntry("pe", "CR_Pe"),
        new CodeRangeEntry("closepunctuation", "CR_Pe"),
        new CodeRangeEntry("pf", "CR_Pf"),
        new CodeRangeEntry("finalpunctuation", "CR_Pf"),
        new CodeRangeEntry("pi", "CR_Pi"),
        new CodeRangeEntry("initialpunctuation", "CR_Pi"),
        new CodeRangeEntry("po", "CR_Po"),
        new CodeRangeEntry("otherpunctuation", "CR_Po"),
        new CodeRangeEntry("ps", "CR_Ps"),
        new CodeRangeEntry("openpunctuation", "CR_Ps"),
        new CodeRangeEntry("s", "CR_S"),
        new CodeRangeEntry("symbol", "CR_S"),
        new CodeRangeEntry("sc", "CR_Sc"),
        new CodeRangeEntry("currencysymbol", "CR_Sc"),
        new CodeRangeEntry("sk", "CR_Sk"),
        new CodeRangeEntry("modifiersymbol", "CR_Sk"),
        new CodeRangeEntry("sm", "CR_Sm"),
        new CodeRangeEntry("mathsymbol", "CR_Sm"),
        new CodeRangeEntry("so", "CR_So"),
        new CodeRangeEntry("othersymbol", "CR_So"),
        new CodeRangeEntry("z", "CR_Z"),
        new CodeRangeEntry("separator", "CR_Z"),
        new CodeRangeEntry("zl", "CR_Zl"),
        new CodeRangeEntry("lineseparator", "CR_Zl"),
        new CodeRangeEntry("zp", "CR_Zp"),
        new CodeRangeEntry("paragraphseparator", "CR_Zp"),
        new CodeRangeEntry("zs", "CR_Zs"),
        new CodeRangeEntry("spaceseparator", "CR_Zs"),
        new CodeRangeEntry("math", "CR_Math"),
        new CodeRangeEntry("alphabetic", "CR_Alpha"),
        new CodeRangeEntry("lowercase", "CR_Lower"),
        new CodeRangeEntry("uppercase", "CR_Upper"),
        new CodeRangeEntry("cased", "CR_Cased"),
        new CodeRangeEntry("caseignorable", "CR_Case_Ignorable"),
        new CodeRangeEntry("ci", "CR_Case_Ignorable"),
        new CodeRangeEntry("changeswhenlowercased", "CR_Changes_When_Lowercased"),
        new CodeRangeEntry("cwl", "CR_Changes_When_Lowercased"),
        new CodeRangeEntry("changeswhenuppercased", "CR_Changes_When_Uppercased"),
        new CodeRangeEntry("cwu", "CR_Changes_When_Uppercased"),
        new CodeRangeEntry("changeswhentitlecased", "CR_Changes_When_Titlecased"),
        new CodeRangeEntry("cwt", "CR_Changes_When_Titlecased"),
        new CodeRangeEntry("changeswhencasefolded", "CR_Changes_When_Casefolded"),
        new CodeRangeEntry("cwcf", "CR_Changes_When_Casefolded"),
        new CodeRangeEntry("changeswhencasemapped", "CR_Changes_When_Casemapped"),
        new CodeRangeEntry("cwcm", "CR_Changes_When_Casemapped"),
        new CodeRangeEntry("idstart", "CR_ID_Start"),
        new CodeRangeEntry("ids", "CR_ID_Start"),
        new CodeRangeEntry("idcontinue", "CR_ID_Continue"),
        new CodeRangeEntry("idc", "CR_ID_Continue"),
        new CodeRangeEntry("xidstart", "CR_XID_Start"),
        new CodeRangeEntry("xids", "CR_XID_Start"),
        new CodeRangeEntry("xidcontinue", "CR_XID_Continue"),
        new CodeRangeEntry("xidc", "CR_XID_Continue"),
        new CodeRangeEntry("defaultignorablecodepoint", "CR_Default_Ignorable_Code_Point"),
        new CodeRangeEntry("di", "CR_Default_Ignorable_Code_Point"),
        new CodeRangeEntry("graphemeextend", "CR_Grapheme_Extend"),
        new CodeRangeEntry("grext", "CR_Grapheme_Extend"),
        new CodeRangeEntry("graphemebase", "CR_Grapheme_Base"),
        new CodeRangeEntry("grbase", "CR_Grapheme_Base"),
        new CodeRangeEntry("graphemelink", "CR_Grapheme_Link"),
        new CodeRangeEntry("grlink", "CR_Grapheme_Link"),
        new CodeRangeEntry("common", "CR_Common"),
        new CodeRangeEntry("zyyy", "CR_Common"),
        new CodeRangeEntry("latin", "CR_Latin"),
        new CodeRangeEntry("latn", "CR_Latin"),
        new CodeRangeEntry("greek", "CR_Greek"),
        new CodeRangeEntry("grek", "CR_Greek"),
        new CodeRangeEntry("cyrillic", "CR_Cyrillic"),
        new CodeRangeEntry("cyrl", "CR_Cyrillic"),
        new CodeRangeEntry("armenian", "CR_Armenian"),
        new CodeRangeEntry("armn", "CR_Armenian"),
        new CodeRangeEntry("hebrew", "CR_Hebrew"),
        new CodeRangeEntry("hebr", "CR_Hebrew"),
        new CodeRangeEntry("arabic", "CR_Arabic"),
        new CodeRangeEntry("arab", "CR_Arabic"),
        new CodeRangeEntry("syriac", "CR_Syriac"),
        new CodeRangeEntry("syrc", "CR_Syriac"),
        new CodeRangeEntry("thaana", "CR_Thaana"),
        new CodeRangeEntry("thaa", "CR_Thaana"),
        new CodeRangeEntry("devanagari", "CR_Devanagari"),
        new CodeRangeEntry("deva", "CR_Devanagari"),
        new CodeRangeEntry("bengali", "CR_Bengali"),
        new CodeRangeEntry("beng", "CR_Bengali"),
        new CodeRangeEntry("gurmukhi", "CR_Gurmukhi"),
        new CodeRangeEntry("guru", "CR_Gurmukhi"),
        new CodeRangeEntry("gujarati", "CR_Gujarati"),
        new CodeRangeEntry("gujr", "CR_Gujarati"),
        new CodeRangeEntry("oriya", "CR_Oriya"),
        new CodeRangeEntry("orya", "CR_Oriya"),
        new CodeRangeEntry("tamil", "CR_Tamil"),
        new CodeRangeEntry("taml", "CR_Tamil"),
        new CodeRangeEntry("telugu", "CR_Telugu"),
        new CodeRangeEntry("telu", "CR_Telugu"),
        new CodeRangeEntry("kannada", "CR_Kannada"),
        new CodeRangeEntry("knda", "CR_Kannada"),
        new CodeRangeEntry("malayalam", "CR_Malayalam"),
        new CodeRangeEntry("mlym", "CR_Malayalam"),
        new CodeRangeEntry("sinhala", "CR_Sinhala"),
        new CodeRangeEntry("sinh", "CR_Sinhala"),
        new CodeRangeEntry("thai", "CR_Thai"),
        new CodeRangeEntry("lao", "CR_Lao"),
        new CodeRangeEntry("laoo", "CR_Lao"),
        new CodeRangeEntry("tibetan", "CR_Tibetan"),
        new CodeRangeEntry("tibt", "CR_Tibetan"),
        new CodeRangeEntry("myanmar", "CR_Myanmar"),
        new CodeRangeEntry("mymr", "CR_Myanmar"),
        new CodeRangeEntry("georgian", "CR_Georgian"),
        new CodeRangeEntry("geor", "CR_Georgian"),
        new CodeRangeEntry("hangul", "CR_Hangul"),
        new CodeRangeEntry("hang", "CR_Hangul"),
        new CodeRangeEntry("ethiopic", "CR_Ethiopic"),
        new CodeRangeEntry("ethi", "CR_Ethiopic"),
        new CodeRangeEntry("cherokee", "CR_Cherokee"),
        new CodeRangeEntry("cher", "CR_Cherokee"),
        new CodeRangeEntry("canadianaboriginal", "CR_Canadian_Aboriginal"),
        new CodeRangeEntry("cans", "CR_Canadian_Aboriginal"),
        new CodeRangeEntry("ogham", "CR_Ogham"),
        new CodeRangeEntry("ogam", "CR_Ogham"),
        new CodeRangeEntry("runic", "CR_Runic"),
        new CodeRangeEntry("runr", "CR_Runic"),
        new CodeRangeEntry("khmer", "CR_Khmer"),
        new CodeRangeEntry("khmr", "CR_Khmer"),
        new CodeRangeEntry("mongolian", "CR_Mongolian"),
        new CodeRangeEntry("mong", "CR_Mongolian"),
        new CodeRangeEntry("hiragana", "CR_Hiragana"),
        new CodeRangeEntry("hira", "CR_Hiragana"),
        new CodeRangeEntry("katakana", "CR_Katakana"),
        new CodeRangeEntry("kana", "CR_Katakana"),
        new CodeRangeEntry("bopomofo", "CR_Bopomofo"),
        new CodeRangeEntry("bopo", "CR_Bopomofo"),
        new CodeRangeEntry("han", "CR_Han"),
        new CodeRangeEntry("hani", "CR_Han"),
        new CodeRangeEntry("yi", "CR_Yi"),
        new CodeRangeEntry("yiii", "CR_Yi"),
        new CodeRangeEntry("olditalic", "CR_Old_Italic"),
        new CodeRangeEntry("ital", "CR_Old_Italic"),
        new CodeRangeEntry("gothic", "CR_Gothic"),
        new CodeRangeEntry("goth", "CR_Gothic"),
        new CodeRangeEntry("indeseret", "CR_Deseret"),
        new CodeRangeEntry("inherited", "CR_Inherited"),
        new CodeRangeEntry("qaai", "CR_Inherited"),
        new CodeRangeEntry("zinh", "CR_Inherited"),
        new CodeRangeEntry("tagalog", "CR_Tagalog"),
        new CodeRangeEntry("tglg", "CR_Tagalog"),
        new CodeRangeEntry("hanunoo", "CR_Hanunoo"),
        new CodeRangeEntry("hano", "CR_Hanunoo"),
        new CodeRangeEntry("buhid", "CR_Buhid"),
        new CodeRangeEntry("buhd", "CR_Buhid"),
        new CodeRangeEntry("tagbanwa", "CR_Tagbanwa"),
        new CodeRangeEntry("tagb", "CR_Tagbanwa"),
        new CodeRangeEntry("limbu", "CR_Limbu"),
        new CodeRangeEntry("limb", "CR_Limbu"),
        new CodeRangeEntry("taile", "CR_Tai_Le"),
        new CodeRangeEntry("tale", "CR_Tai_Le"),
        new CodeRangeEntry("linearb", "CR_Linear_B"),
        new CodeRangeEntry("linb", "CR_Linear_B"),
        new CodeRangeEntry("ugaritic", "CR_Ugaritic"),
        new CodeRangeEntry("ugar", "CR_Ugaritic"),
        new CodeRangeEntry("inshavian", "CR_Shavian"),
        new CodeRangeEntry("osmanya", "CR_Osmanya"),
        new CodeRangeEntry("osma", "CR_Osmanya"),
        new CodeRangeEntry("cypriot", "CR_Cypriot"),
        new CodeRangeEntry("cprt", "CR_Cypriot"),
        new CodeRangeEntry("inbraillepatterns", "CR_Braille"),
        new CodeRangeEntry("buginese", "CR_Buginese"),
        new CodeRangeEntry("bugi", "CR_Buginese"),
        new CodeRangeEntry("coptic", "CR_Coptic"),
        new CodeRangeEntry("qaac", "CR_Coptic"),
        new CodeRangeEntry("copt", "CR_Coptic"),
        new CodeRangeEntry("newtailue", "CR_New_Tai_Lue"),
        new CodeRangeEntry("talu", "CR_New_Tai_Lue"),
        new CodeRangeEntry("glagolitic", "CR_Glagolitic"),
        new CodeRangeEntry("glag", "CR_Glagolitic"),
        new CodeRangeEntry("tifinagh", "CR_Tifinagh"),
        new CodeRangeEntry("tfng", "CR_Tifinagh"),
        new CodeRangeEntry("sylotinagri", "CR_Syloti_Nagri"),
        new CodeRangeEntry("sylo", "CR_Syloti_Nagri"),
        new CodeRangeEntry("oldpersian", "CR_Old_Persian"),
        new CodeRangeEntry("xpeo", "CR_Old_Persian"),
        new CodeRangeEntry("kharoshthi", "CR_Kharoshthi"),
        new CodeRangeEntry("khar", "CR_Kharoshthi"),
        new CodeRangeEntry("balinese", "CR_Balinese"),
        new CodeRangeEntry("bali", "CR_Balinese"),
        new CodeRangeEntry("cuneiform", "CR_Cuneiform"),
        new CodeRangeEntry("xsux", "CR_Cuneiform"),
        new CodeRangeEntry("phoenician", "CR_Phoenician"),
        new CodeRangeEntry("phnx", "CR_Phoenician"),
        new CodeRangeEntry("phagspa", "CR_Phags_Pa"),
        new CodeRangeEntry("phag", "CR_Phags_Pa"),
        new CodeRangeEntry("nko", "CR_Nko"),
        new CodeRangeEntry("nkoo", "CR_Nko"),
        new CodeRangeEntry("sundanese", "CR_Sundanese"),
        new CodeRangeEntry("sund", "CR_Sundanese"),
        new CodeRangeEntry("lepcha", "CR_Lepcha"),
        new CodeRangeEntry("lepc", "CR_Lepcha"),
        new CodeRangeEntry("inolchiki", "CR_Ol_Chiki"),
        new CodeRangeEntry("vai", "CR_Vai"),
        new CodeRangeEntry("vaii", "CR_Vai"),
        new CodeRangeEntry("saurashtra", "CR_Saurashtra"),
        new CodeRangeEntry("saur", "CR_Saurashtra"),
        new CodeRangeEntry("kayahli", "CR_Kayah_Li"),
        new CodeRangeEntry("kali", "CR_Kayah_Li"),
        new CodeRangeEntry("rejang", "CR_Rejang"),
        new CodeRangeEntry("rjng", "CR_Rejang"),
        new CodeRangeEntry("lycian", "CR_Lycian"),
        new CodeRangeEntry("lyci", "CR_Lycian"),
        new CodeRangeEntry("carian", "CR_Carian"),
        new CodeRangeEntry("cari", "CR_Carian"),
        new CodeRangeEntry("lydian", "CR_Lydian"),
        new CodeRangeEntry("lydi", "CR_Lydian"),
        new CodeRangeEntry("cham", "CR_Cham"),
        new CodeRangeEntry("taitham", "CR_Tai_Tham"),
        new CodeRangeEntry("lana", "CR_Tai_Tham"),
        new CodeRangeEntry("taiviet", "CR_Tai_Viet"),
        new CodeRangeEntry("tavt", "CR_Tai_Viet"),
        new CodeRangeEntry("avestan", "CR_Avestan"),
        new CodeRangeEntry("avst", "CR_Avestan"),
        new CodeRangeEntry("egyptianhieroglyphs", "CR_Egyptian_Hieroglyphs"),
        new CodeRangeEntry("egyp", "CR_Egyptian_Hieroglyphs"),
        new CodeRangeEntry("samaritan", "CR_Samaritan"),
        new CodeRangeEntry("samr", "CR_Samaritan"),
        new CodeRangeEntry("inlisu", "CR_Lisu"),
        new CodeRangeEntry("bamum", "CR_Bamum"),
        new CodeRangeEntry("bamu", "CR_Bamum"),
        new CodeRangeEntry("javanese", "CR_Javanese"),
        new CodeRangeEntry("java", "CR_Javanese"),
        new CodeRangeEntry("meeteimayek", "CR_Meetei_Mayek"),
        new CodeRangeEntry("mtei", "CR_Meetei_Mayek"),
        new CodeRangeEntry("imperialaramaic", "CR_Imperial_Aramaic"),
        new CodeRangeEntry("armi", "CR_Imperial_Aramaic"),
        new CodeRangeEntry("inoldsoutharabian", "CR_Old_South_Arabian"),
        new CodeRangeEntry("inscriptionalparthian", "CR_Inscriptional_Parthian"),
        new CodeRangeEntry("prti", "CR_Inscriptional_Parthian"),
        new CodeRangeEntry("inscriptionalpahlavi", "CR_Inscriptional_Pahlavi"),
        new CodeRangeEntry("phli", "CR_Inscriptional_Pahlavi"),
        new CodeRangeEntry("oldturkic", "CR_Old_Turkic"),
        new CodeRangeEntry("orkh", "CR_Old_Turkic"),
        new CodeRangeEntry("kaithi", "CR_Kaithi"),
        new CodeRangeEntry("kthi", "CR_Kaithi"),
        new CodeRangeEntry("batak", "CR_Batak"),
        new CodeRangeEntry("batk", "CR_Batak"),
        new CodeRangeEntry("brahmi", "CR_Brahmi"),
        new CodeRangeEntry("brah", "CR_Brahmi"),
        new CodeRangeEntry("mandaic", "CR_Mandaic"),
        new CodeRangeEntry("mand", "CR_Mandaic"),
        new CodeRangeEntry("chakma", "CR_Chakma"),
        new CodeRangeEntry("cakm", "CR_Chakma"),
        new CodeRangeEntry("meroiticcursive", "CR_Meroitic_Cursive"),
        new CodeRangeEntry("merc", "CR_Meroitic_Cursive"),
        new CodeRangeEntry("inmeroitichieroglyphs", "CR_Meroitic_Hieroglyphs"),
        new CodeRangeEntry("miao", "CR_Miao"),
        new CodeRangeEntry("plrd", "CR_Miao"),
        new CodeRangeEntry("sharada", "CR_Sharada"),
        new CodeRangeEntry("shrd", "CR_Sharada"),
        new CodeRangeEntry("sorasompeng", "CR_Sora_Sompeng"),
        new CodeRangeEntry("sora", "CR_Sora_Sompeng"),
        new CodeRangeEntry("takri", "CR_Takri"),
        new CodeRangeEntry("takr", "CR_Takri"),
        new CodeRangeEntry("caucasianalbanian", "CR_Caucasian_Albanian"),
        new CodeRangeEntry("aghb", "CR_Caucasian_Albanian"),
        new CodeRangeEntry("bassavah", "CR_Bassa_Vah"),
        new CodeRangeEntry("bass", "CR_Bassa_Vah"),
        new CodeRangeEntry("duployan", "CR_Duployan"),
        new CodeRangeEntry("dupl", "CR_Duployan"),
        new CodeRangeEntry("elbasan", "CR_Elbasan"),
        new CodeRangeEntry("elba", "CR_Elbasan"),
        new CodeRangeEntry("grantha", "CR_Grantha"),
        new CodeRangeEntry("gran", "CR_Grantha"),
        new CodeRangeEntry("pahawhhmong", "CR_Pahawh_Hmong"),
        new CodeRangeEntry("hmng", "CR_Pahawh_Hmong"),
        new CodeRangeEntry("khojki", "CR_Khojki"),
        new CodeRangeEntry("khoj", "CR_Khojki"),
        new CodeRangeEntry("lineara", "CR_Linear_A"),
        new CodeRangeEntry("lina", "CR_Linear_A"),
        new CodeRangeEntry("mahajani", "CR_Mahajani"),
        new CodeRangeEntry("mahj", "CR_Mahajani"),
        new CodeRangeEntry("manichaean", "CR_Manichaean"),
        new CodeRangeEntry("mani", "CR_Manichaean"),
        new CodeRangeEntry("mendekikakui", "CR_Mende_Kikakui"),
        new CodeRangeEntry("mend", "CR_Mende_Kikakui"),
        new CodeRangeEntry("modi", "CR_Modi"),
        new CodeRangeEntry("mro", "CR_Mro"),
        new CodeRangeEntry("mroo", "CR_Mro"),
        new CodeRangeEntry("inoldnortharabian", "CR_Old_North_Arabian"),
        new CodeRangeEntry("nabataean", "CR_Nabataean"),
        new CodeRangeEntry("nbat", "CR_Nabataean"),
        new CodeRangeEntry("inpalmyrene", "CR_Palmyrene"),
        new CodeRangeEntry("paucinhau", "CR_Pau_Cin_Hau"),
        new CodeRangeEntry("pauc", "CR_Pau_Cin_Hau"),
        new CodeRangeEntry("oldpermic", "CR_Old_Permic"),
        new CodeRangeEntry("perm", "CR_Old_Permic"),
        new CodeRangeEntry("psalterpahlavi", "CR_Psalter_Pahlavi"),
        new CodeRangeEntry("phlp", "CR_Psalter_Pahlavi"),
        new CodeRangeEntry("siddham", "CR_Siddham"),
        new CodeRangeEntry("sidd", "CR_Siddham"),
        new CodeRangeEntry("khudawadi", "CR_Khudawadi"),
        new CodeRangeEntry("sind", "CR_Khudawadi"),
        new CodeRangeEntry("tirhuta", "CR_Tirhuta"),
        new CodeRangeEntry("tirh", "CR_Tirhuta"),
        new CodeRangeEntry("warangciti", "CR_Warang_Citi"),
        new CodeRangeEntry("wara", "CR_Warang_Citi"),
        new CodeRangeEntry("ahom", "CR_Ahom"),
        new CodeRangeEntry("anatolianhieroglyphs", "CR_Anatolian_Hieroglyphs"),
        new CodeRangeEntry("hluw", "CR_Anatolian_Hieroglyphs"),
        new CodeRangeEntry("hatran", "CR_Hatran"),
        new CodeRangeEntry("hatr", "CR_Hatran"),
        new CodeRangeEntry("multani", "CR_Multani"),
        new CodeRangeEntry("mult", "CR_Multani"),
        new CodeRangeEntry("oldhungarian", "CR_Old_Hungarian"),
        new CodeRangeEntry("hung", "CR_Old_Hungarian"),
        new CodeRangeEntry("signwriting", "CR_SignWriting"),
        new CodeRangeEntry("sgnw", "CR_SignWriting"),
        new CodeRangeEntry("adlam", "CR_Adlam"),
        new CodeRangeEntry("adlm", "CR_Adlam"),
        new CodeRangeEntry("bhaiksuki", "CR_Bhaiksuki"),
        new CodeRangeEntry("bhks", "CR_Bhaiksuki"),
        new CodeRangeEntry("marchen", "CR_Marchen"),
        new CodeRangeEntry("marc", "CR_Marchen"),
        new CodeRangeEntry("newa", "CR_Newa"),
        new CodeRangeEntry("osage", "CR_Osage"),
        new CodeRangeEntry("osge", "CR_Osage"),
        new CodeRangeEntry("tangut", "CR_Tangut"),
        new CodeRangeEntry("tang", "CR_Tangut"),
        new CodeRangeEntry("masaramgondi", "CR_Masaram_Gondi"),
        new CodeRangeEntry("gonm", "CR_Masaram_Gondi"),
        new CodeRangeEntry("nushu", "CR_Nushu"),
        new CodeRangeEntry("nshu", "CR_Nushu"),
        new CodeRangeEntry("soyombo", "CR_Soyombo"),
        new CodeRangeEntry("soyo", "CR_Soyombo"),
        new CodeRangeEntry("zanabazarsquare", "CR_Zanabazar_Square"),
        new CodeRangeEntry("zanb", "CR_Zanabazar_Square"),
        new CodeRangeEntry("dogra", "CR_Dogra"),
        new CodeRangeEntry("dogr", "CR_Dogra"),
        new CodeRangeEntry("gunjalagondi", "CR_Gunjala_Gondi"),
        new CodeRangeEntry("gong", "CR_Gunjala_Gondi"),
        new CodeRangeEntry("makasar", "CR_Makasar"),
        new CodeRangeEntry("maka", "CR_Makasar"),
        new CodeRangeEntry("medefaidrin", "CR_Medefaidrin"),
        new CodeRangeEntry("medf", "CR_Medefaidrin"),
        new CodeRangeEntry("hanifirohingya", "CR_Hanifi_Rohingya"),
        new CodeRangeEntry("rohg", "CR_Hanifi_Rohingya"),
        new CodeRangeEntry("sogdian", "CR_Sogdian"),
        new CodeRangeEntry("sogd", "CR_Sogdian"),
        new CodeRangeEntry("oldsogdian", "CR_Old_Sogdian"),
        new CodeRangeEntry("sogo", "CR_Old_Sogdian"),
        new CodeRangeEntry("elymaic", "CR_Elymaic"),
        new CodeRangeEntry("elym", "CR_Elymaic"),
        new CodeRangeEntry("nandinagari", "CR_Nandinagari"),
        new CodeRangeEntry("nand", "CR_Nandinagari"),
        new CodeRangeEntry("nyiakengpuachuehmong", "CR_Nyiakeng_Puachue_Hmong"),
        new CodeRangeEntry("hmnp", "CR_Nyiakeng_Puachue_Hmong"),
        new CodeRangeEntry("wancho", "CR_Wancho"),
        new CodeRangeEntry("wcho", "CR_Wancho"),
        new CodeRangeEntry("whitespace", "CR_Space"),
        new CodeRangeEntry("wspace", "CR_Space"),
        new CodeRangeEntry("bidicontrol", "CR_Bidi_Control"),
        new CodeRangeEntry("bidic", "CR_Bidi_Control"),
        new CodeRangeEntry("joincontrol", "CR_Join_Control"),
        new CodeRangeEntry("joinc", "CR_Join_Control"),
        new CodeRangeEntry("dash", "CR_Dash"),
        new CodeRangeEntry("hyphen", "CR_Hyphen"),
        new CodeRangeEntry("quotationmark", "CR_Quotation_Mark"),
        new CodeRangeEntry("qmark", "CR_Quotation_Mark"),
        new CodeRangeEntry("terminalpunctuation", "CR_Terminal_Punctuation"),
        new CodeRangeEntry("term", "CR_Terminal_Punctuation"),
        new CodeRangeEntry("othermath", "CR_Other_Math"),
        new CodeRangeEntry("omath", "CR_Other_Math"),
        new CodeRangeEntry("hexdigit", "CR_Hex_Digit"),
        new CodeRangeEntry("hex", "CR_Hex_Digit"),
        new CodeRangeEntry("asciihexdigit", "CR_XDigit"),
        new CodeRangeEntry("ahex", "CR_XDigit"),
        new CodeRangeEntry("otheralphabetic", "CR_Other_Alphabetic"),
        new CodeRangeEntry("oalpha", "CR_Other_Alphabetic"),
        new CodeRangeEntry("ideographic", "CR_Ideographic"),
        new CodeRangeEntry("ideo", "CR_Ideographic"),
        new CodeRangeEntry("diacritic", "CR_Diacritic"),
        new CodeRangeEntry("dia", "CR_Diacritic"),
        new CodeRangeEntry("extender", "CR_Extender"),
        new CodeRangeEntry("ext", "CR_Extender"),
        new CodeRangeEntry("otherlowercase", "CR_Other_Lowercase"),
        new CodeRangeEntry("olower", "CR_Other_Lowercase"),
        new CodeRangeEntry("otheruppercase", "CR_Other_Uppercase"),
        new CodeRangeEntry("oupper", "CR_Other_Uppercase"),
        new CodeRangeEntry("noncharactercodepoint", "CR_Noncharacter_Code_Point"),
        new CodeRangeEntry("nchar", "CR_Noncharacter_Code_Point"),
        new CodeRangeEntry("othergraphemeextend", "CR_Other_Grapheme_Extend"),
        new CodeRangeEntry("ogrext", "CR_Other_Grapheme_Extend"),
        new CodeRangeEntry("idsbinaryoperator", "CR_IDS_Binary_Operator"),
        new CodeRangeEntry("idsb", "CR_IDS_Binary_Operator"),
        new CodeRangeEntry("idstrinaryoperator", "CR_IDS_Trinary_Operator"),
        new CodeRangeEntry("idst", "CR_IDS_Trinary_Operator"),
        new CodeRangeEntry("radical", "CR_Radical"),
        new CodeRangeEntry("unifiedideograph", "CR_Unified_Ideograph"),
        new CodeRangeEntry("uideo", "CR_Unified_Ideograph"),
        new CodeRangeEntry("otherdefaultignorablecodepoint", "CR_Other_Default_Ignorable_Code_Point"),
        new CodeRangeEntry("odi", "CR_Other_Default_Ignorable_Code_Point"),
        new CodeRangeEntry("deprecated", "CR_Deprecated"),
        new CodeRangeEntry("dep", "CR_Deprecated"),
        new CodeRangeEntry("softdotted", "CR_Soft_Dotted"),
        new CodeRangeEntry("sd", "CR_Soft_Dotted"),
        new CodeRangeEntry("logicalorderexception", "CR_Logical_Order_Exception"),
        new CodeRangeEntry("loe", "CR_Logical_Order_Exception"),
        new CodeRangeEntry("otheridstart", "CR_Other_ID_Start"),
        new CodeRangeEntry("oids", "CR_Other_ID_Start"),
        new CodeRangeEntry("otheridcontinue", "CR_Other_ID_Continue"),
        new CodeRangeEntry("oidc", "CR_Other_ID_Continue"),
        new CodeRangeEntry("sentenceterminal", "CR_Sentence_Terminal"),
        new CodeRangeEntry("sterm", "CR_Sentence_Terminal"),
        new CodeRangeEntry("variationselector", "CR_Variation_Selector"),
        new CodeRangeEntry("vs", "CR_Variation_Selector"),
        new CodeRangeEntry("patternwhitespace", "CR_Pattern_White_Space"),
        new CodeRangeEntry("patws", "CR_Pattern_White_Space"),
        new CodeRangeEntry("patternsyntax", "CR_Pattern_Syntax"),
        new CodeRangeEntry("patsyn", "CR_Pattern_Syntax"),
        new CodeRangeEntry("prependedconcatenationmark", "CR_Prepended_Concatenation_Mark"),
        new CodeRangeEntry("pcm", "CR_Prepended_Concatenation_Mark"),
        new CodeRangeEntry("graphemeclusterbreak=regionalindicator", "CR_Regional_Indicator"),
        new CodeRangeEntry("emoji", "CR_Emoji"),
        new CodeRangeEntry("emojipresentation", "CR_Emoji_Presentation"),
        new CodeRangeEntry("emojimodifier", "CR_Emoji_Modifier"),
        new CodeRangeEntry("emojimodifierbase", "CR_Emoji_Modifier_Base"),
        new CodeRangeEntry("emojicomponent", "CR_Emoji_Component"),
        new CodeRangeEntry("extendedpictographic", "CR_Extended_Pictographic"),
        new CodeRangeEntry("unknown", "CR_Unknown"),
        new CodeRangeEntry("zzzz", "CR_Unknown"),
        new CodeRangeEntry("age=1.1", "CR_Age_1_1"),
        new CodeRangeEntry("age=2.0", "CR_Age_2_0"),
        new CodeRangeEntry("age=2.1", "CR_Age_2_1"),
        new CodeRangeEntry("age=3.0", "CR_Age_3_0"),
        new CodeRangeEntry("age=3.1", "CR_Age_3_1"),
        new CodeRangeEntry("age=3.2", "CR_Age_3_2"),
        new CodeRangeEntry("age=4.0", "CR_Age_4_0"),
        new CodeRangeEntry("age=4.1", "CR_Age_4_1"),
        new CodeRangeEntry("age=5.0", "CR_Age_5_0"),
        new CodeRangeEntry("age=5.1", "CR_Age_5_1"),
        new CodeRangeEntry("age=5.2", "CR_Age_5_2"),
        new CodeRangeEntry("age=6.0", "CR_Age_6_0"),
        new CodeRangeEntry("age=6.1", "CR_Age_6_1"),
        new CodeRangeEntry("age=6.2", "CR_Age_6_2"),
        new CodeRangeEntry("age=6.3", "CR_Age_6_3"),
        new CodeRangeEntry("age=7.0", "CR_Age_7_0"),
        new CodeRangeEntry("age=8.0", "CR_Age_8_0"),
        new CodeRangeEntry("age=9.0", "CR_Age_9_0"),
        new CodeRangeEntry("age=10.0", "CR_Age_10_0"),
        new CodeRangeEntry("age=11.0", "CR_Age_11_0"),
        new CodeRangeEntry("age=12.0", "CR_Age_12_0"),
        new CodeRangeEntry("graphemeclusterbreak=prepend", "CR_Grapheme_Cluster_Break_Prepend"),
        new CodeRangeEntry("graphemeclusterbreak=cr", "CR_Grapheme_Cluster_Break_CR"),
        new CodeRangeEntry("graphemeclusterbreak=lf", "CR_NEWLINE"),
        new CodeRangeEntry("graphemeclusterbreak=control", "CR_Grapheme_Cluster_Break_Control"),
        new CodeRangeEntry("graphemeclusterbreak=extend", "CR_Grapheme_Cluster_Break_Extend"),
        new CodeRangeEntry("regionalindicator", "CR_Regional_Indicator"),
        new CodeRangeEntry("ri", "CR_Regional_Indicator"),
        new CodeRangeEntry("graphemeclusterbreak=spacingmark", "CR_Grapheme_Cluster_Break_SpacingMark"),
        new CodeRangeEntry("graphemeclusterbreak=l", "CR_Grapheme_Cluster_Break_L"),
        new CodeRangeEntry("graphemeclusterbreak=v", "CR_Grapheme_Cluster_Break_V"),
        new CodeRangeEntry("graphemeclusterbreak=t", "CR_Grapheme_Cluster_Break_T"),
        new CodeRangeEntry("graphemeclusterbreak=lv", "CR_Grapheme_Cluster_Break_LV"),
        new CodeRangeEntry("graphemeclusterbreak=lvt", "CR_Grapheme_Cluster_Break_LVT"),
        new CodeRangeEntry("graphemeclusterbreak=zwj", "CR_Grapheme_Cluster_Break_ZWJ"),
        new CodeRangeEntry("inbasiclatin", "CR_ASCII"),
        new CodeRangeEntry("inlatin1supplement", "CR_In_Latin_1_Supplement"),
        new CodeRangeEntry("inlatinextendeda", "CR_In_Latin_Extended_A"),
        new CodeRangeEntry("inlatinextendedb", "CR_In_Latin_Extended_B"),
        new CodeRangeEntry("inipaextensions", "CR_In_IPA_Extensions"),
        new CodeRangeEntry("inspacingmodifierletters", "CR_In_Spacing_Modifier_Letters"),
        new CodeRangeEntry("incombiningdiacriticalmarks", "CR_In_Combining_Diacritical_Marks"),
        new CodeRangeEntry("ingreekandcoptic", "CR_In_Greek_and_Coptic"),
        new CodeRangeEntry("incyrillic", "CR_In_Cyrillic"),
        new CodeRangeEntry("incyrillicsupplement", "CR_In_Cyrillic_Supplement"),
        new CodeRangeEntry("inarmenian", "CR_In_Armenian"),
        new CodeRangeEntry("inhebrew", "CR_In_Hebrew"),
        new CodeRangeEntry("inarabic", "CR_In_Arabic"),
        new CodeRangeEntry("insyriac", "CR_In_Syriac"),
        new CodeRangeEntry("inarabicsupplement", "CR_In_Arabic_Supplement"),
        new CodeRangeEntry("inthaana", "CR_In_Thaana"),
        new CodeRangeEntry("innko", "CR_In_NKo"),
        new CodeRangeEntry("insamaritan", "CR_In_Samaritan"),
        new CodeRangeEntry("inmandaic", "CR_In_Mandaic"),
        new CodeRangeEntry("insyriacsupplement", "CR_In_Syriac_Supplement"),
        new CodeRangeEntry("inarabicextendeda", "CR_In_Arabic_Extended_A"),
        new CodeRangeEntry("indevanagari", "CR_In_Devanagari"),
        new CodeRangeEntry("inbengali", "CR_In_Bengali"),
        new CodeRangeEntry("ingurmukhi", "CR_In_Gurmukhi"),
        new CodeRangeEntry("ingujarati", "CR_In_Gujarati"),
        new CodeRangeEntry("inoriya", "CR_In_Oriya"),
        new CodeRangeEntry("intamil", "CR_In_Tamil"),
        new CodeRangeEntry("intelugu", "CR_In_Telugu"),
        new CodeRangeEntry("inkannada", "CR_In_Kannada"),
        new CodeRangeEntry("inmalayalam", "CR_In_Malayalam"),
        new CodeRangeEntry("insinhala", "CR_In_Sinhala"),
        new CodeRangeEntry("inthai", "CR_In_Thai"),
        new CodeRangeEntry("inlao", "CR_In_Lao"),
        new CodeRangeEntry("intibetan", "CR_In_Tibetan"),
        new CodeRangeEntry("inmyanmar", "CR_In_Myanmar"),
        new CodeRangeEntry("ingeorgian", "CR_In_Georgian"),
        new CodeRangeEntry("inhanguljamo", "CR_In_Hangul_Jamo"),
        new CodeRangeEntry("inethiopic", "CR_In_Ethiopic"),
        new CodeRangeEntry("inethiopicsupplement", "CR_In_Ethiopic_Supplement"),
        new CodeRangeEntry("incherokee", "CR_In_Cherokee"),
        new CodeRangeEntry("inunifiedcanadianaboriginalsyllabics", "CR_In_Unified_Canadian_Aboriginal_Syllabics"),
        new CodeRangeEntry("inogham", "CR_In_Ogham"),
        new CodeRangeEntry("inrunic", "CR_In_Runic"),
        new CodeRangeEntry("intagalog", "CR_In_Tagalog"),
        new CodeRangeEntry("inhanunoo", "CR_In_Hanunoo"),
        new CodeRangeEntry("inbuhid", "CR_In_Buhid"),
        new CodeRangeEntry("intagbanwa", "CR_In_Tagbanwa"),
        new CodeRangeEntry("inkhmer", "CR_In_Khmer"),
        new CodeRangeEntry("inmongolian", "CR_In_Mongolian"),
        new CodeRangeEntry("inunifiedcanadianaboriginalsyllabicsextended", "CR_In_Unified_Canadian_Aboriginal_Syllabics_Extended"),
        new CodeRangeEntry("inlimbu", "CR_In_Limbu"),
        new CodeRangeEntry("intaile", "CR_In_Tai_Le"),
        new CodeRangeEntry("innewtailue", "CR_In_New_Tai_Lue"),
        new CodeRangeEntry("inkhmersymbols", "CR_In_Khmer_Symbols"),
        new CodeRangeEntry("inbuginese", "CR_In_Buginese"),
        new CodeRangeEntry("intaitham", "CR_In_Tai_Tham"),
        new CodeRangeEntry("incombiningdiacriticalmarksextended", "CR_In_Combining_Diacritical_Marks_Extended"),
        new CodeRangeEntry("inbalinese", "CR_In_Balinese"),
        new CodeRangeEntry("insundanese", "CR_In_Sundanese"),
        new CodeRangeEntry("inbatak", "CR_In_Batak"),
        new CodeRangeEntry("inlepcha", "CR_In_Lepcha"),
        new CodeRangeEntry("olchiki", "CR_Ol_Chiki"),
        new CodeRangeEntry("olck", "CR_Ol_Chiki"),
        new CodeRangeEntry("incyrillicextendedc", "CR_In_Cyrillic_Extended_C"),
        new CodeRangeEntry("ingeorgianextended", "CR_In_Georgian_Extended"),
        new CodeRangeEntry("insundanesesupplement", "CR_In_Sundanese_Supplement"),
        new CodeRangeEntry("invedicextensions", "CR_In_Vedic_Extensions"),
        new CodeRangeEntry("inphoneticextensions", "CR_In_Phonetic_Extensions"),
        new CodeRangeEntry("inphoneticextensionssupplement", "CR_In_Phonetic_Extensions_Supplement"),
        new CodeRangeEntry("incombiningdiacriticalmarkssupplement", "CR_In_Combining_Diacritical_Marks_Supplement"),
        new CodeRangeEntry("inlatinextendedadditional", "CR_In_Latin_Extended_Additional"),
        new CodeRangeEntry("ingreekextended", "CR_In_Greek_Extended"),
        new CodeRangeEntry("ingeneralpunctuation", "CR_In_General_Punctuation"),
        new CodeRangeEntry("insuperscriptsandsubscripts", "CR_In_Superscripts_and_Subscripts"),
        new CodeRangeEntry("incurrencysymbols", "CR_In_Currency_Symbols"),
        new CodeRangeEntry("incombiningdiacriticalmarksforsymbols", "CR_In_Combining_Diacritical_Marks_for_Symbols"),
        new CodeRangeEntry("inletterlikesymbols", "CR_In_Letterlike_Symbols"),
        new CodeRangeEntry("innumberforms", "CR_In_Number_Forms"),
        new CodeRangeEntry("inarrows", "CR_In_Arrows"),
        new CodeRangeEntry("inmathematicaloperators", "CR_In_Mathematical_Operators"),
        new CodeRangeEntry("inmiscellaneoustechnical", "CR_In_Miscellaneous_Technical"),
        new CodeRangeEntry("incontrolpictures", "CR_In_Control_Pictures"),
        new CodeRangeEntry("inopticalcharacterrecognition", "CR_In_Optical_Character_Recognition"),
        new CodeRangeEntry("inenclosedalphanumerics", "CR_In_Enclosed_Alphanumerics"),
        new CodeRangeEntry("inboxdrawing", "CR_In_Box_Drawing"),
        new CodeRangeEntry("inblockelements", "CR_In_Block_Elements"),
        new CodeRangeEntry("ingeometricshapes", "CR_In_Geometric_Shapes"),
        new CodeRangeEntry("inmiscellaneoussymbols", "CR_In_Miscellaneous_Symbols"),
        new CodeRangeEntry("indingbats", "CR_In_Dingbats"),
        new CodeRangeEntry("inmiscellaneousmathematicalsymbolsa", "CR_In_Miscellaneous_Mathematical_Symbols_A"),
        new CodeRangeEntry("insupplementalarrowsa", "CR_In_Supplemental_Arrows_A"),
        new CodeRangeEntry("braille", "CR_Braille"),
        new CodeRangeEntry("brai", "CR_Braille"),
        new CodeRangeEntry("insupplementalarrowsb", "CR_In_Supplemental_Arrows_B"),
        new CodeRangeEntry("inmiscellaneousmathematicalsymbolsb", "CR_In_Miscellaneous_Mathematical_Symbols_B"),
        new CodeRangeEntry("insupplementalmathematicaloperators", "CR_In_Supplemental_Mathematical_Operators"),
        new CodeRangeEntry("inmiscellaneoussymbolsandarrows", "CR_In_Miscellaneous_Symbols_and_Arrows"),
        new CodeRangeEntry("inglagolitic", "CR_In_Glagolitic"),
        new CodeRangeEntry("inlatinextendedc", "CR_In_Latin_Extended_C"),
        new CodeRangeEntry("incoptic", "CR_In_Coptic"),
        new CodeRangeEntry("ingeorgiansupplement", "CR_In_Georgian_Supplement"),
        new CodeRangeEntry("intifinagh", "CR_In_Tifinagh"),
        new CodeRangeEntry("inethiopicextended", "CR_In_Ethiopic_Extended"),
        new CodeRangeEntry("incyrillicextendeda", "CR_In_Cyrillic_Extended_A"),
        new CodeRangeEntry("insupplementalpunctuation", "CR_In_Supplemental_Punctuation"),
        new CodeRangeEntry("incjkradicalssupplement", "CR_In_CJK_Radicals_Supplement"),
        new CodeRangeEntry("inkangxiradicals", "CR_In_Kangxi_Radicals"),
        new CodeRangeEntry("inideographicdescriptioncharacters", "CR_In_Ideographic_Description_Characters"),
        new CodeRangeEntry("incjksymbolsandpunctuation", "CR_In_CJK_Symbols_and_Punctuation"),
        new CodeRangeEntry("inhiragana", "CR_In_Hiragana"),
        new CodeRangeEntry("inkatakana", "CR_In_Katakana"),
        new CodeRangeEntry("inbopomofo", "CR_In_Bopomofo"),
        new CodeRangeEntry("inhangulcompatibilityjamo", "CR_In_Hangul_Compatibility_Jamo"),
        new CodeRangeEntry("inkanbun", "CR_In_Kanbun"),
        new CodeRangeEntry("inbopomofoextended", "CR_In_Bopomofo_Extended"),
        new CodeRangeEntry("incjkstrokes", "CR_In_CJK_Strokes"),
        new CodeRangeEntry("inkatakanaphoneticextensions", "CR_In_Katakana_Phonetic_Extensions"),
        new CodeRangeEntry("inenclosedcjklettersandmonths", "CR_In_Enclosed_CJK_Letters_and_Months"),
        new CodeRangeEntry("incjkcompatibility", "CR_In_CJK_Compatibility"),
        new CodeRangeEntry("incjkunifiedideographsextensiona", "CR_In_CJK_Unified_Ideographs_Extension_A"),
        new CodeRangeEntry("inyijinghexagramsymbols", "CR_In_Yijing_Hexagram_Symbols"),
        new CodeRangeEntry("incjkunifiedideographs", "CR_In_CJK_Unified_Ideographs"),
        new CodeRangeEntry("inyisyllables", "CR_In_Yi_Syllables"),
        new CodeRangeEntry("inyiradicals", "CR_In_Yi_Radicals"),
        new CodeRangeEntry("lisu", "CR_Lisu"),
        new CodeRangeEntry("invai", "CR_In_Vai"),
        new CodeRangeEntry("incyrillicextendedb", "CR_In_Cyrillic_Extended_B"),
        new CodeRangeEntry("inbamum", "CR_In_Bamum"),
        new CodeRangeEntry("inmodifiertoneletters", "CR_In_Modifier_Tone_Letters"),
        new CodeRangeEntry("inlatinextendedd", "CR_In_Latin_Extended_D"),
        new CodeRangeEntry("insylotinagri", "CR_In_Syloti_Nagri"),
        new CodeRangeEntry("incommonindicnumberforms", "CR_In_Common_Indic_Number_Forms"),
        new CodeRangeEntry("inphagspa", "CR_In_Phags_pa"),
        new CodeRangeEntry("insaurashtra", "CR_In_Saurashtra"),
        new CodeRangeEntry("indevanagariextended", "CR_In_Devanagari_Extended"),
        new CodeRangeEntry("inkayahli", "CR_In_Kayah_Li"),
        new CodeRangeEntry("inrejang", "CR_In_Rejang"),
        new CodeRangeEntry("inhanguljamoextendeda", "CR_In_Hangul_Jamo_Extended_A"),
        new CodeRangeEntry("injavanese", "CR_In_Javanese"),
        new CodeRangeEntry("inmyanmarextendedb", "CR_In_Myanmar_Extended_B"),
        new CodeRangeEntry("incham", "CR_In_Cham"),
        new CodeRangeEntry("inmyanmarextendeda", "CR_In_Myanmar_Extended_A"),
        new CodeRangeEntry("intaiviet", "CR_In_Tai_Viet"),
        new CodeRangeEntry("inmeeteimayekextensions", "CR_In_Meetei_Mayek_Extensions"),
        new CodeRangeEntry("inethiopicextendeda", "CR_In_Ethiopic_Extended_A"),
        new CodeRangeEntry("inlatinextendede", "CR_In_Latin_Extended_E"),
        new CodeRangeEntry("incherokeesupplement", "CR_In_Cherokee_Supplement"),
        new CodeRangeEntry("inmeeteimayek", "CR_In_Meetei_Mayek"),
        new CodeRangeEntry("inhangulsyllables", "CR_In_Hangul_Syllables"),
        new CodeRangeEntry("inhanguljamoextendedb", "CR_In_Hangul_Jamo_Extended_B"),
        new CodeRangeEntry("inhighsurrogates", "CR_In_High_Surrogates"),
        new CodeRangeEntry("inhighprivateusesurrogates", "CR_In_High_Private_Use_Surrogates"),
        new CodeRangeEntry("inlowsurrogates", "CR_In_Low_Surrogates"),
        new CodeRangeEntry("inprivateusearea", "CR_In_Private_Use_Area"),
        new CodeRangeEntry("incjkcompatibilityideographs", "CR_In_CJK_Compatibility_Ideographs"),
        new CodeRangeEntry("inalphabeticpresentationforms", "CR_In_Alphabetic_Presentation_Forms"),
        new CodeRangeEntry("inarabicpresentationformsa", "CR_In_Arabic_Presentation_Forms_A"),
        new CodeRangeEntry("invariationselectors", "CR_In_Variation_Selectors"),
        new CodeRangeEntry("inverticalforms", "CR_In_Vertical_Forms"),
        new CodeRangeEntry("incombininghalfmarks", "CR_In_Combining_Half_Marks"),
        new CodeRangeEntry("incjkcompatibilityforms", "CR_In_CJK_Compatibility_Forms"),
        new CodeRangeEntry("insmallformvariants", "CR_In_Small_Form_Variants"),
        new CodeRangeEntry("inarabicpresentationformsb", "CR_In_Arabic_Presentation_Forms_B"),
        new CodeRangeEntry("inhalfwidthandfullwidthforms", "CR_In_Halfwidth_and_Fullwidth_Forms"),
        new CodeRangeEntry("inspecials", "CR_In_Specials"),
        new CodeRangeEntry("inlinearbsyllabary", "CR_In_Linear_B_Syllabary"),
        new CodeRangeEntry("inlinearbideograms", "CR_In_Linear_B_Ideograms"),
        new CodeRangeEntry("inaegeannumbers", "CR_In_Aegean_Numbers"),
        new CodeRangeEntry("inancientgreeknumbers", "CR_In_Ancient_Greek_Numbers"),
        new CodeRangeEntry("inancientsymbols", "CR_In_Ancient_Symbols"),
        new CodeRangeEntry("inphaistosdisc", "CR_In_Phaistos_Disc"),
        new CodeRangeEntry("inlycian", "CR_In_Lycian"),
        new CodeRangeEntry("incarian", "CR_In_Carian"),
        new CodeRangeEntry("incopticepactnumbers", "CR_In_Coptic_Epact_Numbers"),
        new CodeRangeEntry("inolditalic", "CR_In_Old_Italic"),
        new CodeRangeEntry("ingothic", "CR_In_Gothic"),
        new CodeRangeEntry("inoldpermic", "CR_In_Old_Permic"),
        new CodeRangeEntry("inugaritic", "CR_In_Ugaritic"),
        new CodeRangeEntry("inoldpersian", "CR_In_Old_Persian"),
        new CodeRangeEntry("deseret", "CR_Deseret"),
        new CodeRangeEntry("dsrt", "CR_Deseret"),
        new CodeRangeEntry("shavian", "CR_Shavian"),
        new CodeRangeEntry("shaw", "CR_Shavian"),
        new CodeRangeEntry("inosmanya", "CR_In_Osmanya"),
        new CodeRangeEntry("inosage", "CR_In_Osage"),
        new CodeRangeEntry("inelbasan", "CR_In_Elbasan"),
        new CodeRangeEntry("incaucasianalbanian", "CR_In_Caucasian_Albanian"),
        new CodeRangeEntry("inlineara", "CR_In_Linear_A"),
        new CodeRangeEntry("incypriotsyllabary", "CR_In_Cypriot_Syllabary"),
        new CodeRangeEntry("inimperialaramaic", "CR_In_Imperial_Aramaic"),
        new CodeRangeEntry("palmyrene", "CR_Palmyrene"),
        new CodeRangeEntry("palm", "CR_Palmyrene"),
        new CodeRangeEntry("innabataean", "CR_In_Nabataean"),
        new CodeRangeEntry("inhatran", "CR_In_Hatran"),
        new CodeRangeEntry("inphoenician", "CR_In_Phoenician"),
        new CodeRangeEntry("inlydian", "CR_In_Lydian"),
        new CodeRangeEntry("meroitichieroglyphs", "CR_Meroitic_Hieroglyphs"),
        new CodeRangeEntry("mero", "CR_Meroitic_Hieroglyphs"),
        new CodeRangeEntry("inmeroiticcursive", "CR_In_Meroitic_Cursive"),
        new CodeRangeEntry("inkharoshthi", "CR_In_Kharoshthi"),
        new CodeRangeEntry("oldsoutharabian", "CR_Old_South_Arabian"),
        new CodeRangeEntry("sarb", "CR_Old_South_Arabian"),
        new CodeRangeEntry("oldnortharabian", "CR_Old_North_Arabian"),
        new CodeRangeEntry("narb", "CR_Old_North_Arabian"),
        new CodeRangeEntry("inmanichaean", "CR_In_Manichaean"),
        new CodeRangeEntry("inavestan", "CR_In_Avestan"),
        new CodeRangeEntry("ininscriptionalparthian", "CR_In_Inscriptional_Parthian"),
        new CodeRangeEntry("ininscriptionalpahlavi", "CR_In_Inscriptional_Pahlavi"),
        new CodeRangeEntry("inpsalterpahlavi", "CR_In_Psalter_Pahlavi"),
        new CodeRangeEntry("inoldturkic", "CR_In_Old_Turkic"),
        new CodeRangeEntry("inoldhungarian", "CR_In_Old_Hungarian"),
        new CodeRangeEntry("inhanifirohingya", "CR_In_Hanifi_Rohingya"),
        new CodeRangeEntry("inruminumeralsymbols", "CR_In_Rumi_Numeral_Symbols"),
        new CodeRangeEntry("inoldsogdian", "CR_In_Old_Sogdian"),
        new CodeRangeEntry("insogdian", "CR_In_Sogdian"),
        new CodeRangeEntry("inelymaic", "CR_In_Elymaic"),
        new CodeRangeEntry("inbrahmi", "CR_In_Brahmi"),
        new CodeRangeEntry("inkaithi", "CR_In_Kaithi"),
        new CodeRangeEntry("insorasompeng", "CR_In_Sora_Sompeng"),
        new CodeRangeEntry("inchakma", "CR_In_Chakma"),
        new CodeRangeEntry("inmahajani", "CR_In_Mahajani"),
        new CodeRangeEntry("insharada", "CR_In_Sharada"),
        new CodeRangeEntry("insinhalaarchaicnumbers", "CR_In_Sinhala_Archaic_Numbers"),
        new CodeRangeEntry("inkhojki", "CR_In_Khojki"),
        new CodeRangeEntry("inmultani", "CR_In_Multani"),
        new CodeRangeEntry("inkhudawadi", "CR_In_Khudawadi"),
        new CodeRangeEntry("ingrantha", "CR_In_Grantha"),
        new CodeRangeEntry("innewa", "CR_In_Newa"),
        new CodeRangeEntry("intirhuta", "CR_In_Tirhuta"),
        new CodeRangeEntry("insiddham", "CR_In_Siddham"),
        new CodeRangeEntry("inmodi", "CR_In_Modi"),
        new CodeRangeEntry("inmongoliansupplement", "CR_In_Mongolian_Supplement"),
        new CodeRangeEntry("intakri", "CR_In_Takri"),
        new CodeRangeEntry("inahom", "CR_In_Ahom"),
        new CodeRangeEntry("indogra", "CR_In_Dogra"),
        new CodeRangeEntry("inwarangciti", "CR_In_Warang_Citi"),
        new CodeRangeEntry("innandinagari", "CR_In_Nandinagari"),
        new CodeRangeEntry("inzanabazarsquare", "CR_In_Zanabazar_Square"),
        new CodeRangeEntry("insoyombo", "CR_In_Soyombo"),
        new CodeRangeEntry("inpaucinhau", "CR_In_Pau_Cin_Hau"),
        new CodeRangeEntry("inbhaiksuki", "CR_In_Bhaiksuki"),
        new CodeRangeEntry("inmarchen", "CR_In_Marchen"),
        new CodeRangeEntry("inmasaramgondi", "CR_In_Masaram_Gondi"),
        new CodeRangeEntry("ingunjalagondi", "CR_In_Gunjala_Gondi"),
        new CodeRangeEntry("inmakasar", "CR_In_Makasar"),
        new CodeRangeEntry("intamilsupplement", "CR_In_Tamil_Supplement"),
        new CodeRangeEntry("incuneiform", "CR_In_Cuneiform"),
        new CodeRangeEntry("incuneiformnumbersandpunctuation", "CR_In_Cuneiform_Numbers_and_Punctuation"),
        new CodeRangeEntry("inearlydynasticcuneiform", "CR_In_Early_Dynastic_Cuneiform"),
        new CodeRangeEntry("inegyptianhieroglyphs", "CR_In_Egyptian_Hieroglyphs"),
        new CodeRangeEntry("inegyptianhieroglyphformatcontrols", "CR_In_Egyptian_Hieroglyph_Format_Controls"),
        new CodeRangeEntry("inanatolianhieroglyphs", "CR_In_Anatolian_Hieroglyphs"),
        new CodeRangeEntry("inbamumsupplement", "CR_In_Bamum_Supplement"),
        new CodeRangeEntry("inmro", "CR_In_Mro"),
        new CodeRangeEntry("inbassavah", "CR_In_Bassa_Vah"),
        new CodeRangeEntry("inpahawhhmong", "CR_In_Pahawh_Hmong"),
        new CodeRangeEntry("inmedefaidrin", "CR_In_Medefaidrin"),
        new CodeRangeEntry("inmiao", "CR_In_Miao"),
        new CodeRangeEntry("inideographicsymbolsandpunctuation", "CR_In_Ideographic_Symbols_and_Punctuation"),
        new CodeRangeEntry("intangut", "CR_In_Tangut"),
        new CodeRangeEntry("intangutcomponents", "CR_In_Tangut_Components"),
        new CodeRangeEntry("inkanasupplement", "CR_In_Kana_Supplement"),
        new CodeRangeEntry("inkanaextendeda", "CR_In_Kana_Extended_A"),
        new CodeRangeEntry("insmallkanaextension", "CR_In_Small_Kana_Extension"),
        new CodeRangeEntry("innushu", "CR_In_Nushu"),
        new CodeRangeEntry("induployan", "CR_In_Duployan"),
        new CodeRangeEntry("inshorthandformatcontrols", "CR_In_Shorthand_Format_Controls"),
        new CodeRangeEntry("inbyzantinemusicalsymbols", "CR_In_Byzantine_Musical_Symbols"),
        new CodeRangeEntry("inmusicalsymbols", "CR_In_Musical_Symbols"),
        new CodeRangeEntry("inancientgreekmusicalnotation", "CR_In_Ancient_Greek_Musical_Notation"),
        new CodeRangeEntry("inmayannumerals", "CR_In_Mayan_Numerals"),
        new CodeRangeEntry("intaixuanjingsymbols", "CR_In_Tai_Xuan_Jing_Symbols"),
        new CodeRangeEntry("incountingrodnumerals", "CR_In_Counting_Rod_Numerals"),
        new CodeRangeEntry("inmathematicalalphanumericsymbols", "CR_In_Mathematical_Alphanumeric_Symbols"),
        new CodeRangeEntry("insuttonsignwriting", "CR_In_Sutton_SignWriting"),
        new CodeRangeEntry("inglagoliticsupplement", "CR_In_Glagolitic_Supplement"),
        new CodeRangeEntry("innyiakengpuachuehmong", "CR_In_Nyiakeng_Puachue_Hmong"),
        new CodeRangeEntry("inwancho", "CR_In_Wancho"),
        new CodeRangeEntry("inmendekikakui", "CR_In_Mende_Kikakui"),
        new CodeRangeEntry("inadlam", "CR_In_Adlam"),
        new CodeRangeEntry("inindicsiyaqnumbers", "CR_In_Indic_Siyaq_Numbers"),
        new CodeRangeEntry("inottomansiyaqnumbers", "CR_In_Ottoman_Siyaq_Numbers"),
        new CodeRangeEntry("inarabicmathematicalalphabeticsymbols", "CR_In_Arabic_Mathematical_Alphabetic_Symbols"),
        new CodeRangeEntry("inmahjongtiles", "CR_In_Mahjong_Tiles"),
        new CodeRangeEntry("indominotiles", "CR_In_Domino_Tiles"),
        new CodeRangeEntry("inplayingcards", "CR_In_Playing_Cards"),
        new CodeRangeEntry("inenclosedalphanumericsupplement", "CR_In_Enclosed_Alphanumeric_Supplement"),
        new CodeRangeEntry("inenclosedideographicsupplement", "CR_In_Enclosed_Ideographic_Supplement"),
        new CodeRangeEntry("inmiscellaneoussymbolsandpictographs", "CR_In_Miscellaneous_Symbols_and_Pictographs"),
        new CodeRangeEntry("inemoticons", "CR_In_Emoticons"),
        new CodeRangeEntry("inornamentaldingbats", "CR_In_Ornamental_Dingbats"),
        new CodeRangeEntry("intransportandmapsymbols", "CR_In_Transport_and_Map_Symbols"),
        new CodeRangeEntry("inalchemicalsymbols", "CR_In_Alchemical_Symbols"),
        new CodeRangeEntry("ingeometricshapesextended", "CR_In_Geometric_Shapes_Extended"),
        new CodeRangeEntry("insupplementalarrowsc", "CR_In_Supplemental_Arrows_C"),
        new CodeRangeEntry("insupplementalsymbolsandpictographs", "CR_In_Supplemental_Symbols_and_Pictographs"),
        new CodeRangeEntry("inchesssymbols", "CR_In_Chess_Symbols"),
        new CodeRangeEntry("insymbolsandpictographsextendeda", "CR_In_Symbols_and_Pictographs_Extended_A"),
        new CodeRangeEntry("incjkunifiedideographsextensionb", "CR_In_CJK_Unified_Ideographs_Extension_B"),
        new CodeRangeEntry("incjkunifiedideographsextensionc", "CR_In_CJK_Unified_Ideographs_Extension_C"),
        new CodeRangeEntry("incjkunifiedideographsextensiond", "CR_In_CJK_Unified_Ideographs_Extension_D"),
        new CodeRangeEntry("incjkunifiedideographsextensione", "CR_In_CJK_Unified_Ideographs_Extension_E"),
        new CodeRangeEntry("incjkunifiedideographsextensionf", "CR_In_CJK_Unified_Ideographs_Extension_F"),
        new CodeRangeEntry("incjkcompatibilityideographssupplement", "CR_In_CJK_Compatibility_Ideographs_Supplement"),
        new CodeRangeEntry("intags", "CR_In_Tags"),
        new CodeRangeEntry("invariationselectorssupplement", "CR_In_Variation_Selectors_Supplement"),
        new CodeRangeEntry("insupplementaryprivateuseareaa", "CR_In_Supplementary_Private_Use_Area_A"),
        new CodeRangeEntry("insupplementaryprivateuseareab", "CR_In_Supplementary_Private_Use_Area_B"),
        new CodeRangeEntry("innoblock", "CR_In_No_Block")
    };

    static final int MAX_WORD_LENGTH = 44;
}
