// ライセンス: GPL2

// 設定ダイアログの基底クラス

#ifndef _PREFDIAG_H
#define _PREFDIAG_H

#include <gtkmm.h>

namespace SKELETON
{
    class PrefDiag : public Gtk::Dialog
    {
        std::string m_url;

        Gtk::Button* m_bt_ok;
        Gtk::Button m_bt_apply;

        sigc::connection m_conn_timer;

      public:

        // parent == NULL のときはメインウィンドウをparentにする
        PrefDiag( Gtk::Window* parent, const std::string& url, const bool add_cancel = true, const bool add_apply = false );

        virtual ~PrefDiag();

        const std::string& get_url() const { return m_url; }

        // okボタンをフォーカス
        void grab_ok();

        virtual int run();

      protected:

        virtual void slot_ok_clicked(){}
        virtual void slot_cancel_clicked(){}
        virtual void slot_apply_clicked(){}

      private:

        // タイマーのslot関数
        bool slot_timeout( int timer_number );

        // 各設定ダイアログ別のタイムアウト処理 ( slot_timeout()から呼び出される )
        virtual void timeout(){}
    };
}

#endif
