---
title: 操作方法について
layout: default
---

&gt; [Top](../) &gt; {{ page.title }}

## {{ page.title }}

- [共通の操作](#common)
- [サイドバー(板一覧、外部板、お気に入り、各履歴)の操作](#sidebar)
- [スレ一覧の操作](#threadlist)
- [スレビューの操作](#threadview)
- [書き込みビューの操作](#messageview)
- [画像ビューの操作](#imageview)
- [2ペーン表示時のスレ一覧とスレビュー の切り替え方法](#2pane)
- [ログ検索](#searchlog)
- [スレタイ検索](#searchtitle)
- [更新チェック](#checkupdate)
- [カスタマイズ方法](#customize)


<a name="common"></a>
### 共通の操作

#### タブ操作
<dl>
  <dt>タブをドラッグ → タブにドロップ</dt><dd>タブの入れ替え</dd>
  <dt>タブをドラッグ → お気に入りにドロップ</dt><dd>お気に入り登録</dd>
  <dt>タブをダブルクリック</dt><dd>タブの再読み込み</dd>
  <dt>タブを中クリック</dt><dd>タブを閉じる</dd>

  <dt>Q,&ensp;Ctrl+W</dt>
  <dd>タブを閉じる</dd>

  <dt>Ctrl+L,&ensp;Ctrl+&#x1f872;,&ensp;Ctrl+PageDown,&ensp;Ctrl+Tab</dt>
  <dd>右のタブへ移動</dd>
  <dt>Ctrl+H,&ensp;Ctrl+&#x1f870;,&ensp;Ctrl+PageUp,&ensp;Ctrl+Shift+Tab</dt>
  <dd>左のタブへ移動</dd>

  <dt>Ctrl+Shift+L,&ensp;Ctrl+Shift+&#x1f872;,&ensp;Ctrl+Shift+PageDown,&ensp;]</dt>
  <dd>右の更新済みタブへ移動</dd>
  <dt>Ctrl+Shift+H,&ensp;Ctrl+Shift+&#x1f870;,&ensp;Ctrl+Shift+PageUp,&ensp;[</dt>
  <dd>左の更新済みタブへ移動</dd>

  <dt>Alt+1 〜 Alt+9</dt>
  <dd>左からn番目(1〜9)のタブへ移動</dd>
  <dt>Alt+&#x1f870;</dt>
  <dd>同じタブで直前に開いていた内容に戻る</dd>
  <dt>Alt+&#x1f872;</dt>
  <dd>Alt+&#x1f870;で戻る前に開いていた内容に進む</dd>

  <dt>Ctrl+Shift+T</dt>
  <dd>最後に閉じたタブを復元</dd>
</dl>

#### 基本操作
<dl>
  <dt>L,&ensp;&#x1f872;</dt>
  <dd>次のビューに進む(例えばスレ一覧ならスレビューに進む)</dd>
  <dt>H,&ensp;&#x1f870;</dt>
  <dd>前のビューに戻る(例えばスレビューならスレ一覧に戻る)</dd>

  <dt>Shift+F10,&ensp;Ctrl+M,&ensp;Menu</dt>
  <dd>ポップアップメニュー表示</dd>

  <dt>F8</dt>
  <dd>メニューバー表示切り替え</dd>
  <dt>(デフォルト無し)</dt>
  <dd>メインツールバー表示切り替え</dd>
  <dt>F9</dt>
  <dd>サイドバー表示切り替え</dd>

  <dt>Ctrl+O</dt>
  <dd>URLを開く</dd>
  <dt>Ctrl+C</dt>
  <dd>コピー</dd>
  <dt>Ctrl+A</dt>
  <dd>全て選択</dd>
  <dt>Ctrl+D</dt>
  <dd>お気に入りに追加</dd>

  <dt>S,&ensp;F5,&ensp;マウスのボタン4</dt>
  <dd>再読み込み</dd>
  <dt>Esc</dt>
  <dd>読み込み中止</dd>

  <dt>Ctrl+T</dt>
  <dd>スレタイ検索画面を開く</dd>
  <dt>Ctrl+Shift+P</dt>
  <dd>表示中のビューのプロパティを開く</dd>

  <dt>(デフォルト無し)</dt>
  <dd>サイドバー更新チェック</dd>
  <dt>(デフォルト無し)</dt>
  <dd>サイドバー更新チェックして更新された板やスレを開く</dd>
</dl>

#### スレ一覧、スレビュー内での検索操作
スレ一覧、スレビューの検索やキーワード抽出ではデフォルトで正規表現による検索が有効になっているので、
(や\*を検索する場合は前に\を付ける必要がある。

スレ一覧、スレビューの検索やキーワード抽出では英数字やカナの全角半角を区別しない。

スレビューの検索では単語をスペースで分けて検索すると全ての単語を検索する。

<dl>
  <dt>Ctrl+F,&ensp;/</dt>
  <dd>検索ボックスにフォーカスを移して後方検索開始</dd>
  <dt>?</dt>
  <dd>検索ボックスにフォーカスを移して前方検索開始</dd>

  <dt>検索ボックスに検索文字列を入れてEnter</dt>
  <dd>検索開始</dd>
  <dt>( スレビューのみ )検索ボックスに検索文字列入れてCtrl+Enter</dt>
  <dd>レスの抽出</dd>

  <dt>Esc</dt>
  <dd>検索中止</dd>

  <dt>Enter,&ensp;F3,&ensp;Ctrl+G</dt>
  <dd>次検索</dd>
  <dt>Shift+Enter,&ensp;Ctrl+F3,&ensp;Ctrl+Shift+G,&ensp;N</dt>
  <dd>前検索</dd>
</dl>


<a name="sidebar"></a>
### サイドバー(板一覧、外部板、お気に入り、各履歴)の操作
共通操作に加えて以下の操作をおこなえる。

<dl>
  <dt>ツールバー上のタイトルクリック</dt>
  <dd>表示内容切り替え</dd>
  <dt>ツールバー上のタイトル上でマウス回転</dt>
  <dd>表示内容切り替え</dd>

  <dt>サイドバーとスレ一覧/スレビューの間のしきいをクリック</dt>
  <dd>サイドバーの折り畳み/展開</dd>
  <dt>ディレクトリをクリック</dt>
  <dd>ディレクトリを開閉する</dd>

  <dt>ディレクトリ以外の行をクリック</dt>
  <dd>板やスレなどを開く</dd>
  <dt>ディレクトリ以外の行を中ボタンクリック</dt>
  <dd>板やスレなどをタブで開く</dd>

  <dt>右クリック</dt>
  <dd>メニュー表示</dd>

  <dt>Ctrl+クリック</dt>
  <dd>複数行選択</dd>
  <dt>Shift+クリック</dt>
  <dd>複数行を範囲選択</dd>
  <dt>中ボタンドラッグ</dt>
  <dd>複数行を範囲選択</dd>

  <dt>複数行選択中に任意の行をクリック</dt>
  <dd>選択解除</dd>

  <dt>Ctrl+L,&ensp;Ctrl+&#x1f872;,&ensp;Ctrl+PageDown,&ensp;Ctrl+Tab</dt>
  <dd>次の内容を表示</dd>
  <dt>Ctrl+H,&ensp;Ctrl+&#x1f870;,&ensp;Ctrl+PageUp,&ensp;Ctrl+Shift+Tab</dt>
  <dd>前の内容を表示</dd>

  <dt>J,&ensp;&#x1f873;</dt>
  <dd>１行下</dd>
  <dt>K,&ensp;&#x1f871;</dt>
  <dd>１行上</dd>

  <dt>(ディレクトリ上で) H,&ensp;&#x1f870;</dt>
  <dd>ディレクトリ閉じる</dd>
  <dt>(ディレクトリ上で) L,&ensp;&#x1f872;</dt>
  <dd>ディレクトリを開く</dd>

  <dt>PageUp</dt>
  <dd>上のページに移動</dd>
  <dt>PageDown</dt>
  <dd>下のページに移動</dd>

  <dt>{</dt>
  <dd>前のディレクトリに移動</dd>
  <dt>}</dt>
  <dd>次のディレクトリに移動</dd>

  <dt>Home,&ensp;G,&ensp;&lt;</dt>
  <dd>先頭へ移動</dd>
  <dt>End,&ensp;Shift+G,&ensp;&gt;</dt>
  <dd>最後へ移動</dd>

  <dt>(ディレクトリ上で) Space</dt>
  <dd>ディレクトリの開閉</dd>

  <dt>(ディレクトリ以外で) Space</dt>
  <dd>板やスレを開く</dd>
  <dt>(ディレクトリ以外で) Ctrl+Space</dt>
  <dd>板やスレをタブで開く</dd>
  <dt>(板一覧以外で) Delete</dt>
  <dd>選択行削除</dd>

  <dt>(お気に入りで編集後に) Ctrl+Z,&ensp;Ctrl+/</dt>
  <dd>元に戻す(Undo)</dd>
  <dt>(お気に入りでUndo後に) Ctrl+Shift+Z</dt>
  <dd>やり直し(Redo)</dd>
</dl>


<a name="threadlist"></a>
### スレ一覧の操作

#### 基本操作
共通操作に加えて以下の操作をおこなえる。

<dl>
  <dt>列名クリック</dt>
  <dd>ソートの優先順を変更</dd>

  <dt>クリック</dt>
  <dd>スレを開く</dd>
  <dt>中ボタンクリック</dt>
  <dd>スレをタブで開く</dd>
  <dt>右クリック</dt>
  <dd>メニュー表示</dd>

  <dt>Ctrl+クリック</dt>
  <dd>複数行選択</dd>
  <dt>Shift+クリック</dt>
  <dd>複数行を範囲選択</dd>

  <dt>中ボタンドラッグ</dt>
  <dd>複数行を範囲選択</dd>
  <dt>複数行選択中に任意の行をクリック</dt>
  <dd>選択解除</dd>

  <dt>J,&ensp;&#x1f873;</dt>
  <dd>１行下</dd>
  <dt>K,&ensp;&#x1f871;</dt>
  <dd>１行上</dd>
  <dt>PageUp</dt>
  <dd>上のページに移動</dd>
  <dt>PageDown</dt>
  <dd>下のページに移動</dd>
  <dt>Home,&ensp;G,&ensp;&lt;</dt>
  <dd>先頭へ移動</dd>
  <dt>End,&ensp;Shift+G,&ensp;&gt;</dt>
  <dd>最後へ移動</dd>

  <dt>Space</dt>
  <dd>スレを開く</dd>
  <dt>Ctrl+Space</dt>
  <dd>スレをタブで開く</dd>
  <dt>Delete</dt>
  <dd>選択したスレのキャッシュ削除</dd>
  <dt>選択スレをドラッグ → お気に入りにドロップ</dt>
  <dd>選択したスレをお気に入りに登録</dd>

  <dt>マウスのチルトボタン左,&ensp;Shift+H,&ensp;Shift+&#x1f870;</dt>
  <dd>(スクロールバーが表示されているとき)左にスクロール</dd>
  <dt>マウスのチルトボタン右,&ensp;Shift+L,&ensp;Shift+&#x1f872;</dt>
  <dd>(スクロールバーが表示されているとき)左にスクロール</dd>

  <dt>キーボードで数字を入力</dt>
  <dd>入力した番号のスレにジャンプする</dd>
</dl>

#### 表示されるマークについて
マーク行の列名「!」をクリックするとマーク別にソートする。

| | マークの意味 |
| --- | --- |
| ![][bkmark_update] | しおりを付けたスレ(更新あり) |
| ![][bkmark_broken_subject] | しおりを付けたスレ(エラー(下の注を参照)) |
| ![][bkmark] | しおりを付けたスレ(更新無し) |
| ![][update] | キャッシュにあるスレ(更新あり) |
| ![][broken_subject] | キャッシュにあるスレ(エラー(下の注を参照)) |
| ![][check] | キャッシュにあるスレ(更新無し) |
| ![][newthread] | 前回スレ一覧を開いた後に立てられた新着スレ
| ![][newthread_hour] | 24時間以内に立てられたスレ
| ![][info] | お知らせスレ(スレッド924)
| &#x2423; | &#x2460; キャッシュに無い通常スレ |
| &#x2423; | &#x2461;  既読スレ(1000まで読んだスレ) |
| ![][down] | キャッシュにあるDAT落ちしたスレ |

(注) まちBBSなどでスレ一覧(subject.txt)にあるレス数よりも、実際にスレを取得したときのスレ数が多い場合に表示される

「!」をクリックする度に以下の順にスレ一覧の並び替えモードを切り替える。

1. ![][bkmark_update] →![][bkmark_broken_subject] →![][bkmark] →![][update] →![][broken_subject]
   →![][check] →![][newthread] →![][newthread_hour] →![][info] →&#x2460; →&#x2461; →![][down]
2. ![][bkmark_update] →![][bkmark_broken_subject] →![][bkmark] →![][newthread] →![][update]
   →![][broken_subject] →![][check] →![][newthread_hour] →![][info] →&#x2460; →&#x2461; →![][down]
3. ![][newthread] →![][newthread_hour] →![][bkmark_update] →![][bkmark_broken_subject] →![][bkmark]
   →![][update] →![][broken_subject] →![][check] →![][info] →&#x2460; →&#x2461; →![][down]
4. ![][info] →![][newthread_hour] →![][newthread] →![][check] →![][broken_subject] →![][update]
   →![][bkmark] →![][bkmark_broken_subject] →![][bkmark_update] →&#x2460; →&#x2461; →![][down]

#### タブに表示されるアイコンについて

| | タブアイコンの意味 |
| --- | --- |
| ![][board] | 通常状態 |
| ![][board_update] | (更新チェックを行って) 更新可能 |
| ![][board_updated] | (全てのタブの再読み込みを行って) 更新済み |

#### その他
スレにしおりを付けるには右クリックメニューから「`しおりを設定/解除`」を選ぶ。

また、基本はA列でソートしたいが、A列の値が同じグループの中ではB列で
ソートしたいというときはB列をクリックしてソートしてからA列をクリックする。
例えば「マークでソートするが、新着スレなどのグループ内では
スレ立て時刻でソートしたい」という場合は「since」をクリックしてから「!」
をクリックする。

列幅変更の保存は、最後に閉じたスレ一覧の幅が記憶されるので他のスレ一覧を
全て閉じてからおこなうこと。


<a name="threadview"></a>
### スレビューの操作

#### 基本の操作
共通操作に加えて以下の操作をおこなえる。

<dl>
  <dt>本文中の数字を範囲選択してマウスポインタをその上に移動</dt>
  <dd>対応したレスをポップアップ表示</dd>
  <dt>本文中の&quot;ID:〜&quot;を範囲選択してマウスポインタを上に移動</dt>
  <dd>ID抽出してポップアップ表示</dd>

  <dt>何もないところで中クリック</dt>
  <dd>オートスクロール開始/解除</dd>
  <dt>何もないところで右クリック</dt>
  <dd>通常メニュー表示</dd>

  <dt>レスアンカーの上でクリック</dt>
  <dd>アンカーメニュー表示</dd>
  <dt>レスアンカーの上で中クリック</dt>
  <dd>対象の周辺のレスを抽出して別のタブに表示</dd>
  <dt>レスアンカーの上で右クリック</dt>
  <dd>アンカーメニュー表示</dd>

  <dt>レス番号の上でクリック</dt>
  <dd>レスメニュー表示</dd>
  <dt>レス番号の上で中クリック</dt>
  <dd>しおりの設定/解除</dd>
  <dt>レス番号の上で右クリック</dt>
  <dd>参照しているレスを抽出してポップアップ表示</dd>

  <dt>名前の文字の上でクリック</dt>
  <dd>名前メニュー表示</dd>
  <dt>名前の文字の上で中クリック</dt>
  <dd>名前抽出して別のタブに表示</dd>
  <dt>名前の文字の上で右クリック</dt>
  <dd>名前抽出してポップアップ表示</dd>

  <dt>IDの上でクリック</dt>
  <dd>IDメニュー表示</dd>
  <dt>IDの上で中クリック</dt>
  <dd>ID抽出して別のタブに表示</dd>
  <dt>IDの上で右クリック</dt>
  <dd>ID抽出してポップアップ表示</dd>

  <dt>リンクの上でクリック</dt>
  <dd>開く</dd>
  <dt>リンクの上で右クリック</dt>
  <dd>通常メニュー表示</dd>

  <dt>画像リンクの上でクリック</dt>
  <dd>開く</dd>
  <dt>画像リンクの上で中クリック,&ensp;Ctrl+クリック</dt>
  <dd>バックグラウンドで開く</dd>
  <dt>画像リンクの上で右クリック</dt>
  <dd>通常メニュー表示</dd>

  <dt>(ポップアップ表示時に) Esc</dt>
  <dd>ポップアップ表示を消す</dd>

  <dt>Space,&ensp;PageDown</dt>
  <dd>１ページ下</dd>
  <dt>D</dt>
  <dd>半ページ下</dd>
  <dt>J,&ensp;&#x1f873;</dt>
  <dd>１行下</dd>
  <dt>B,&ensp;PageUp</dt>
  <dd>１ページ上</dd>
  <dt>U</dt>
  <dd>半ページ上</dd>
  <dt>K,&ensp;&#x1f871;</dt>
  <dd>１行上</dd>
  <dt>P</dt>
  <dd>ひとつ前のレスに移動</dd>
  <dt>N</dt>
  <dd>ひとつ後のレスに移動</dd>

  <dt>F2</dt>
  <dd>次のしおりへ移動</dd>
  <dt>Ctrl+F2</dt>
  <dd>前のしおりへ移動</dd>
  <dt>Shift+F2</dt>
  <dd>次の書き込みに移動</dd>
  <dt>Shift+Ctrl+F2</dt>
  <dd>前の書き込みに移動</dd>

  <dt>W,&ensp;Alt+W</dt>
  <dd>書き込みウィンドウ表示</dd>

  <dt>Home,&ensp;G,&ensp;&lt;</dt>
  <dd>先頭へ移動</dd>
  <dt>End,&ensp;Shift+G,&ensp;&gt;</dt>
  <dd>最後へ移動</dd>
  <dt>F4</dt>
  <dd>新着へ移動</dd>

  <dt>F6</dt>
  <dd><a href="{{ site.baseurl }}/live/">実況開始、停止</a></dd>
  <dt>Ctrl+Space</dt>
  <dd><a href="{{ site.baseurl }}/next/">次スレ検索</a></dd>

  <dt>Ctrl+S</dt>
  <dd>datを保存</dd>

  <dt>(範囲選択してから) Ctrl+K</dt>
  <dd>Web検索(google)</dd>
  <dt>(範囲選択してから) Ctrl+T</dt>
  <dd>スレタイ検索</dd>
  <dt>(範囲選択してから) Ctrl+Enter</dt>
  <dd>スレが属する板内を対象ログ検索</dd>

  <dt>(デフォルト無し)</dt>
  <dd>全板内を対象としたログ検索</dd>

  <dt>BackSpace</dt>
  <dd>アンカーなどでジャンプした時にジャンプ元のレスに戻る</dd>
  <dt>数字入力</dt>
  <dd>対象のレスにジャンプする</dd>

  <dt>(範囲選択してから) (デフォルト無し)</dt>
  <dd>選択範囲のレスをあぼ〜ん</dd>
  <dt>(範囲選択してから) Ctrl+Shift+I</dt>
  <dd>選択範囲の画像を開く</dd>
  <dt>(範囲選択してから) (デフォルト無し)</dt>
  <dd>選択範囲の画像を削除</dd>
  <dt>(範囲選択してから) (デフォルト無し)</dt>
  <dd>選択範囲の画像をあぼ〜ん</dd>

  <dt>(IDや名前抽出したタブ上で) Shift+F5,&ensp;S</dt>
  <dd>元のスレを開く</dd>
</dl>

<a name="threadview_touch"></a>
#### タッチ操作 ( GTK+ 3.14以上 )

<dl>
  <dt>何もないところで2本指タップ</dt>
  <dd>通常メニュー表示</dd>

  <dt>レスアンカーの上でタップ</dt>
  <dd>アンカーメニュー表示</dd>
  <dt>レスアンカーの上で2本指タップ</dt>
  <dd>アンカーメニュー表示</dd>

  <dt>レス番号の上でタップ</dt>
  <dd>レスメニュー表示</dd>
  <dt>レス番号の上で2本指タップ</dt>
  <dd>参照しているレスを抽出してポップアップ表示</dd>

  <dt>名前の文字の上でタップ</dt>
  <dd>名前メニュー表示</dd>
  <dt>名前の文字の上で2本指タップ</dt>
  <dd>名前抽出してポップアップ表示</dd>

  <dt>IDの上でタップ</dt>
  <dd>IDメニュー表示</dd>
  <dt>IDの上で2本指タップ</dt>
  <dd>ID抽出してポップアップ表示</dd>

  <dt>リンクの上でタップ</dt>
  <dd>開く</dd>
  <dt>リンクの上で2本指タップ</dt>
  <dd>通常メニュー表示</dd>

  <dt>画像リンクの上でタップ</dt>
  <dd>開く</dd>
  <dt>画像リンクの上で2本指タップ</dt>
  <dd>通常メニュー表示</dd>

  <dt>本文の上でダブルタップ</dt>
  <dd>単語を範囲選択</dd>
  <dt>本文の上でドラッグ</dt>
  <dd>範囲選択＋スクロール</dd>
  <dt>縦スワイプ</dt>
  <dd>スクロール＋慣性スクロール</dd>
</dl>

#### タブに表示されるアイコンについて

| | タブアイコンの意味 |
| --- | --- |
| ![][thread] | 通常状態 |
| ![][thread_old] | dat落ち |
| ![][thread_update] | (更新チェックを行って) 更新可能 |
| ![][thread_updated] | (全てのタブの再読み込みを行って) 更新済み |

#### 多段ポップアップの方法
ポップアップ表示されている時にマウスの右ボタンをクリックし、
そのままボタンを離さずにカーソルを動かすと、
ポップアップが固定されて閉じなくなるのでカーソルを他のホップアップの上に移動できる。
ポップアップの外にカーソルが出ると閉じる。

#### 画像ポップアップ上での操作

<dl>
  <dt>Ctrl+W,&ensp;Q,&ensp;Esc,&ensp;クリック,&ensp;中ボタンクリック,&ensp;&#x1f807;&#x1f806;(マウスジェスチャ)</dt>
  <dd>閉じる</dd>
  <dt>右クリック</dt>
  <dd>コンテキストメニュー表示</dd>
  <dt>C,&ensp;&#x1f807;&#x1f805;(マウスジェスチャ)</dt>
  <dd>画像のモザイク解除</dd>
  <dt>Ctrl+S</dt>
  <dd>保存</dd>
  <dt>Delete</dt>
  <dd>削除</dd>
</dl>

※ 画像ポップアップの上にマウスポインタを移動しなくてもポップアップが表示されているならキーボード操作を行える。


<a name="messageview"></a>
### 書き込みビューの操作

#### 基本操作
<dl>
  <dt>Alt+A</dt>
  <dd><a href="{{ site.baseurl }}/asciiart/">アスキーアート入力</a>のメニューを表示</dd>
  <dt>Alt+Q</dt>
  <dd>ビューを閉じる</dd>
  <dt>Alt+W</dt>
  <dd>書き込む</dd>
  <dt>Tab</dt>
  <dd>書き込みボタンにフォーカスを移す</dd>
  <dt>Ctrl+Z,&ensp;Ctrl+/</dt>
  <dd>Undo</dd>
  <dt>Ctrl+H,&ensp;Ctrl+&#x1f870;,&ensp;Ctrl+PageUp,&ensp;Ctrl+Shift+Tab</dt>
  <dd>書き込み欄とプレビューの表示切り替え</dd>
  <dt>Ctrl+L,&ensp;Ctrl+&#x1f872;,&ensp;Ctrl+PageDown,&ensp;Ctrl+Tab</dt>
  <dd>書き込み欄とプレビューの表示切り替え</dd>
  <dt>Alt+S</dt>
  <dd>sageのON/OFF切り替え</dd>
</dl>

#### emacs風の操作
設定メニューのキーボード設定からキーボード操作をemacs風にすることが出来る。

<dl>
  <dt>Ctrl+P,&ensp;&#x1f871;</dt>
  <dd>カーソルを上に移動</dd>
  <dt>Ctrl+N,&ensp;&#x1f873;</dt>
  <dd>カーソルを下に移動</dd>
  <dt>Ctrl+F,&ensp;&#x1f872;</dt>
  <dd>カーソルを右に移動</dd>
  <dt>Ctrl+B,&ensp;&#x1f870;</dt>
  <dd>カーソルを左に移動</dd>
  <dt>Ctrl+A</dt>
  <dd>行の先頭に移動</dd>
  <dt>Ctrl+E</dt>
  <dd>行の最後に移動</dd>
  <dt>Ctrl+D</dt>
  <dd>一文字削除</dd>
</dl>

#### その他
コンテキストメニューから「`クリップボードから引用`」を選択すると、
クリップボードの内容に引用記号を付けて貼り付ける事ができる。

「<a href="{{ site.baseurl }}/environment/">JDimの動作環境を記入</a>」を選択する
と、不具合報告や質問時に書くテンプレートが記入される。


<a name="imageview"></a>
### 画像ビューの操作
共通操作に加えて以下の操作をおこなえる。

<dl>
  <dt>マウスでドラッグ</dt>
  <dd>画面スクロール</dd>
  <dt>クリック</dt>
  <dd>元の画像サイズ表示とウィンドウに合わせた画像サイズ表示の切り替え</dd>
  <dt>中クリック</dt>
  <dd>閉じる</dd>
  <dt>右クリック</dt>
  <dd>メニュー表示</dd>
  <dt>ダブルクリック</dt>
  <dd>画像再読み込み</dd>

  <dt>Shift+K,&ensp;K,&ensp;Shift+&#x1f871;,&ensp;&#x1f871;</dt>
  <dd>上にスクロール</dd>
  <dt>Shift+J,&ensp;J,&ensp;Shift+&#x1f873;,&ensp;&#x1f873;</dt>
  <dd>下にスクロール</dd>
  <dt>Shift+L,&ensp;Shift+&#x1f870;</dt>
  <dd>左にスクロール</dd>
  <dt>Shift+H,&ensp;Shift+&#x1f872;</dt>
  <dd>右にスクロール</dd>
  <dt>Z</dt>
  <dd>元の画像サイズ</dd>
  <dt>X</dt>
  <dd>画像サイズをウィンドウに合わせる(xを押す度に縦横を合わせるモードと横のみを合わせるモードを切り替える)</dd>
  <dt>+</dt>
  <dd>画像の拡大</dd>
  <dt>-</dt>
  <dd>画像の縮小</dd>
  <dt>C</dt>
  <dd>画像のモザイク解除</dd>
  <dt>Ctrl+S</dt>
  <dd>保存</dd>
  <dt>Delete</dt>
  <dd>削除</dd>
</dl>


<a name="2pane"></a>
### 2ペーン表示時のスレ一覧とスレビュー の切り替え方法
2ペーン表示時にスレ一覧とスレビューを切り替えたいときは以下のいずれかを行う。

1. マウスジェスチャ(マウス右ボタンを押しながら &#x1f807; に動かしてボタンを放す)を使う
2. &#x1f870;&#x1f872;キー、又は H, L キー又は Alt+X で切り替える
3. マウスのボタン5 を押す
4. ツールバーのアイコンで切り替える
5. 「`表示`」メニューで切り替える


<a name="searchlog"></a>
### ログ検索
キャッシュ内にある全ログの中からキーワードを検索する場合は「`ツール`」
メニューから「`キャッシュ内ログ検索`」→「`キャッシュ内の全ログ検索`」
を選択すると現れる検索ビューにキーワードを入力してEnterを押す。

「`しおり`」をチェックすると、しおりが付けられているスレ
(それ自体にしおりがついているスレ、又は含まれているレスに一つでもしおりがついているスレ)を対象に検索を行う。
キーワードに何も入れないで「`しおり`」だけチェックして検索するとしおりが付けられているスレを全て抽出する。

ある特定の板の中にあるログだけを対象にして検索をする場合は、スレ一覧を
開いてスレ一覧検索ボックスにキーワードを入力してからCtrl+Enterを押すか、
「`ツール`」メニューから「`キャッシュ内ログ検索`」→「`現在開いている板のログを検索`」
を選択すると現れる検索ビューにキーワードを入力してEnterを押す。

またスレビューで範囲選択をしてから Ctrl+Enter 又は右クリック→「`検索`」→「`ログ検索(対象: 板)`」
で板内のログを検索することもできる。
同様に、右クリック→「`検索`」→「`ログ検索(対象: 全ログ)`」でキャッシュ内の全てのログを検索することもできる。

検索ビューの操作方法はスレビューの操作方法と同じである。


<a name="searchtitle"></a>
### スレタイ検索
現行の全スレッドからタイトルを検索する場合は「`ツール`」メニューから
「`スレタイ検索`」を選択すると現れる検索ビューにキーワードを入力してEnterを押す。

またスレビューで範囲選択をしてから Ctrl+T 又は右クリック→「`検索`」→「`スレタイ検索`」で検索することもできる。

検索ビューの操作方法はスレビューの操作方法と同じである。


<a name="checkupdate"></a>
### 更新チェック
更新チェックをおこなって板やスレに更新があるときはサイドバーのアイコンやスレ一覧、
スレビューのタブに更新マークが表示される。

#### 操作方法
1. スレ一覧やスレビューのタブを右クリックしてメニューを開く→「`全てのタブの再読み込み`」→「`更新チェック`」
2. サイドバーのお気に入りや履歴で複数行選択→右クリックでメニューを開き「`更新チェック`」
3. サイドバーのお気に入りや履歴でディレクトリを右クリックしてメニューを開き「`更新チェック`」
4. サイドバーのお気に入りや履歴でディレクトリを中ボタンクリックするとディレクトリ内の更新チェックをし、
   さらに更新があった板やスレを開く
5. 「`ツール`」メニュー→「`サイドバーの更新チェック`」でサイドバーに表示中のお気に入りや
   履歴内の全ての板やスレに対して更新チェックをおこなう
6. 表示メニューの詳細設定からサイドバーのツールバーに更新チェックボタンを表示させて押す

#### 注意点

- 板の更新チェックを実行すると、その板に含まれる既読かつ新着数が0のスレを速度の速い順にチェックしていって、
  ひとつでも更新していれば残りのスレのチェックを打ちきってその板に更新マークを付ける。
- サイドバーのお気に入りや履歴での更新チェックはデフォルトでは板の更新をチェックしない。
  チェックしたい場合は `about:config`の「`更新チェック時に板の更新もチェックする`」を「はい」にする。
- したらばのスレはLast-Modifiedを取得できないため更新チェック出来ない(常にHTTPコード200が返る)。
- まちBBSのスレは`設定`メニューの`一般`から「`まちBBSでofflaw.cgiを使用する`」を有効にしないとチェックできない
  ( 常にHTTPコード 500 が返るため)。ただしこの設定を有効にするとリモートホストのIPが表示されなくなる。
- 複数のスレをチェックするときは、同時にチェックしないで前のスレのチェックが終わってから順次チェックするため
  若干時間がかる。従って、ある特定の板のスレがお気に入りに数多く登録されている場合はその板を直接開いた方が
  速くてサーバに対する負荷も小さい。
- 一度更新チェックやロードしたスレは300秒経過するまで再チェックできない。


<a name="customize"></a>
### カスタマイズ方法
ショートカットキーの割り当ては`設定`メニュー → `マウス／キーボード` → `ショートカットキー詳細設定`から変更できる。

ショートカットキー設定は操作が重複していても操作モードが異なれば同じ操作を登録できる。
例えば共通操作モードの上移動にUp(上カーソル)を割り当ている時に
同じ共通操作モードの下移動にUpを割り当てることは出来ないが、スレビュー操作モードの書き込みにUpを割り当てる事ができる。
この場合は、スレビューで上カーソルキーを押すと上スクロールせずに書き込みビューが表示される。

マウスボタンの割り当ては`設定`メニュー → `マウス／キーボード` → `マウスボタン詳細設定`から変更できる。

ボタン設定は操作が重複していても登録できるが、操作には優先順位があるので希望どおりに動作しない場合がある。
例えばスレ一覧でCtrl+クリックにスレを開くを割り当てても、ツリービューの行選択操作が優先されるため
スレを開くことが出来ない。

コンテキストメニューの項目は`表示`メニュー → `詳細設定` → `コンテキストメニュー項目設定`から編集できる。
項目設定ダイアログで非表示指定した項目はコンテキストメニューの「`その他`」に表示される。


[bkmark_update]: {{ site.baseurl }}/manual/image/bkmark_update.png
[bkmark_broken_subject]: {{ site.baseurl }}/manual/image/bkmark_broken_subject.png
[bkmark]: {{ site.baseurl }}/manual/image/bkmark.png
[update]: {{ site.baseurl }}/manual/image/update.png
[broken_subject]: {{ site.baseurl }}/manual/image/broken_subject.png
[check]: {{ site.baseurl }}/manual/image/check.png
[newthread]: {{ site.baseurl }}/manual/image/newthread.png
[newthread_hour]: {{ site.baseurl }}/manual/image/newthread_hour.png
[info]: {{ site.baseurl }}/manual/image/info.png
[down]: {{ site.baseurl }}/manual/image/down.png
[board]: {{ site.baseurl }}/manual/image/board.png
[board_update]: {{ site.baseurl }}/manual/image/board_update.png
[board_updated]: {{ site.baseurl }}/manual/image/board_updated.png
[thread]: {{ site.baseurl }}/manual/image/thread.png
[thread_old]: {{ site.baseurl }}/manual/image/thread_old.png
[thread_update]: {{ site.baseurl }}/manual/image/thread_update.png
[thread_updated]: {{ site.baseurl }}/manual/image/thread_updated.png
